/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.model;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.ILinkFactory;
import com.ibm.team.links.common.internal.registry.LinkTypeRegistry;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.links.internal.links.AuditableLink;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.workitem.common.internal.model.AttributeChangedNotifier;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public class WorkItemReferences
implements IWorkItemReferences {
    private final IWorkItem fWorkItem;
    private final Map<IEndPointDescriptor, List<IReference>> fReferences = new HashMap<IEndPointDescriptor, List<IReference>>();
    private final Set<String> fOriginalLinkTypeIds = new HashSet<String>();
    private final Set<ILink> fCreatedLinks;
    private final Set<ILink> fDeletedLinks;
    private Set<ILink> fOriginalLinks;
    private List<IAttachmentHandle> fDeletedAttachments;

    public WorkItemReferences(IWorkItem workItem) {
        this(workItem, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public WorkItemReferences(IWorkItem workItem, Collection<ILink> links) {
        this(workItem, null, links);
    }

    public WorkItemReferences(IWorkItem workItem, Collection<String> linkTypeIds, Collection<ILink> links) {
        this(workItem, linkTypeIds, links, Collections.emptyList(), Collections.emptyList());
    }

    public WorkItemReferences(IWorkItem workItem, Collection<ILink> originalLinks, Collection<ILink> createdLinks, Collection<ILink> deletedLinks) {
        this(workItem, null, originalLinks, createdLinks, deletedLinks);
    }

    public WorkItemReferences(IWorkItem workItem, Collection<String> linkTypeIds, Collection<ILink> originalLinks, Collection<ILink> createdLinks, Collection<ILink> deletedLinks) {
        this.fWorkItem = workItem;
        this.readLinkTypeIds(linkTypeIds, this.fOriginalLinkTypeIds);
        ItemHandleAwareHashSet<ILink> links = new ItemHandleAwareHashSet<ILink>(originalLinks);
        links.addAll(createdLinks);
        links.removeAll(deletedLinks);
        this.readReferences(links, this.fReferences);
        this.fOriginalLinks = new ItemHandleAwareHashSet<ILink>(originalLinks);
        this.fCreatedLinks = new ItemHandleAwareHashSet<ILink>(createdLinks);
        this.fDeletedLinks = new ItemHandleAwareHashSet<ILink>(deletedLinks);
    }

    @Override
    public List<IEndPointDescriptor> getTypes() {
        return new ArrayList<IEndPointDescriptor>(this.fReferences.keySet());
    }

    @Override
    public List<IReference> getReferences(IEndPointDescriptor referenceType) {
        List<IReference> references = this.fReferences.get(referenceType);
        if (references == null) {
            return Collections.emptyList();
        }
        return new ArrayList<IReference>(references);
    }

    @Override
    public boolean hasReferences(IEndPointDescriptor referenceType) {
        List<IReference> references = this.fReferences.get(referenceType);
        if (references == null) {
            return false;
        }
        return !references.isEmpty();
    }

    @Override
    public void add(IEndPointDescriptor referenceType, IReference reference) {
        if (referenceType.isSingleValued()) {
            this.set(referenceType, reference);
            return;
        }
        ReferencesChangeDetails changeDetails = new ReferencesChangeDetails((List)new ArrayList(), Collections.emptyList());
        this.localAdd(referenceType, reference, changeDetails);
        this.fireAttributeChanged(changeDetails);
    }

    private void localAdd(IEndPointDescriptor referenceType, IReference reference, ReferencesChangeDetails changeDetails) {
        if (reference.getLink() != null) {
            if (!this.fDeletedLinks.contains(reference.getLink())) {
                Assert.isTrue((reference.getLink() == null ? 1 : 0) != 0);
            }
        } else {
            IItemReference selfReference = WorkItemLinkTypes.createWorkItemReference(this.fWorkItem);
            if (referenceType.isTarget()) {
                ILink link = ILinkFactory.INSTANCE.createLink(referenceType.getLinkType().getLinkTypeId(), (IReference)selfReference, reference);
                ((AuditableLink)link).setTargetRef(reference);
            } else {
                ILink link = ILinkFactory.INSTANCE.createLink(referenceType.getLinkType().getLinkTypeId(), reference, (IReference)selfReference);
                ((AuditableLink)link).setSourceRef(reference);
            }
        }
        this.internalAdd(reference, true, changeDetails);
    }

    @Override
    public void remove(IReference reference) {
        ReferencesChangeDetails changeDetails = new ReferencesChangeDetails(Collections.emptyList(), (List)new ArrayList());
        this.localRemove(reference, changeDetails);
        this.fireAttributeChanged(changeDetails);
    }

    private void localRemove(IReference reference, ReferencesChangeDetails changeDetails) {
        this.internalRemove(reference, true, changeDetails);
    }

    @Override
    public void set(IEndPointDescriptor referenceType, IReference reference) {
        ReferencesChangeDetails changeDetails = new ReferencesChangeDetails((List)new ArrayList(), (List)new ArrayList());
        List<IReference> references = this.getReferences(referenceType);
        if (reference != null) {
            this.localAdd(referenceType, reference, changeDetails);
        }
        for (IReference remove : references) {
            this.localRemove(remove, changeDetails);
        }
        this.fireAttributeChanged(changeDetails);
    }

    public Collection<String> getOriginalLinkTypeIds() {
        return new HashSet<String>(this.fOriginalLinkTypeIds);
    }

    public List<ILink> getOriginalLinks() {
        return new ArrayList<ILink>(this.fOriginalLinks);
    }

    public List<ILink> getCreatedLinks() {
        return new ArrayList<ILink>(this.fCreatedLinks);
    }

    public List<ILink> getDeletedLinks() {
        return new ArrayList<ILink>(this.fDeletedLinks);
    }

    @Override
    public List<IReference> getCreatedReferences(IEndPointDescriptor descriptor) {
        return this.getReferences(this.getCreatedLinks(), descriptor);
    }

    @Override
    public List<IReference> getDeletedReferences(IEndPointDescriptor descriptor) {
        return this.getReferences(this.getDeletedLinks(), descriptor);
    }

    @Override
    public List<IEndPointDescriptor> getChangedReferenceTypes() {
        HashMap<IEndPointDescriptor, List<IReference>> referenceMap = new HashMap<IEndPointDescriptor, List<IReference>>();
        this.readReferences(this.getCreatedLinks(), referenceMap);
        this.readReferences(this.getDeletedLinks(), referenceMap);
        Set descriptors = referenceMap.keySet();
        ArrayList<IEndPointDescriptor> ret = new ArrayList<IEndPointDescriptor>();
        for (IEndPointDescriptor descriptor : descriptors) {
            ret.add(descriptor);
        }
        return ret;
    }

    private List<IReference> getReferences(List<ILink> links, IEndPointDescriptor referenceType) {
        ArrayList<IReference> references = new ArrayList<IReference>();
        for (ILink link : links) {
            IEndPointDescriptor currentType = this.getEndPointDescriptor(link);
            if (currentType == null || !referenceType.equals(currentType)) continue;
            references.add(this.hasSelfAsSource(link) ? link.getTargetRef() : link.getSourceRef());
        }
        return references;
    }

    public IReference[] getCreatedReferences() {
        return this.getReferences(this.getCreatedLinks());
    }

    public IReference[] getDeletedReferences() {
        return this.getReferences(this.getDeletedLinks());
    }

    private IReference[] getReferences(List<ILink> links) {
        ArrayList<IReference> references = new ArrayList<IReference>();
        for (ILink link : links) {
            IReference reference = this.hasSelfAsSource(link) ? link.getTargetRef() : link.getSourceRef();
            references.add(reference);
        }
        return references.toArray(new IReference[references.size()]);
    }

    public void remoteUpdate(Collection<ILink> updatedLinks, boolean preserveChanges) {
        this.fOriginalLinks = new ItemHandleAwareHashSet<ILink>(updatedLinks);
        for (ILink link : updatedLinks) {
            this.fOriginalLinkTypeIds.add(link.getLinkTypeId());
        }
        if (preserveChanges) {
            ILink link;
            updatedLinks = new ItemHandleAwareHashSet<ILink>(updatedLinks);
            Iterator<ILink> iter = this.fDeletedLinks.iterator();
            while (iter.hasNext()) {
                link = iter.next();
                if (updatedLinks.contains(link)) {
                    updatedLinks.remove(link);
                    continue;
                }
                iter.remove();
            }
            iter = this.fCreatedLinks.iterator();
            while (iter.hasNext()) {
                link = iter.next();
                if (updatedLinks.contains(link)) {
                    iter.remove();
                    continue;
                }
                updatedLinks.add(link);
            }
        }
        ItemHandleAwareHashSet<ILink> added = new ItemHandleAwareHashSet<ILink>(updatedLinks);
        ItemHandleAwareHashSet<ILink> removed = new ItemHandleAwareHashSet<ILink>();
        for (List<IReference> references : this.fReferences.values()) {
            for (IReference reference : references) {
                ILink link = reference.getLink();
                Assert.isNotNull((Object)link);
                removed.add(link);
            }
        }
        added.removeAll(removed);
        removed.removeAll(updatedLinks);
        ReferencesChangeDetails changeDetails = new ReferencesChangeDetails((List)new ArrayList(), (List)new ArrayList());
        for (ILink link : removed) {
            if (this.hasSelfAsSource(link)) {
                this.internalRemove(link.getTargetRef(), false, changeDetails);
                continue;
            }
            this.internalRemove(link.getSourceRef(), false, changeDetails);
        }
        for (ILink link : added) {
            if (this.hasSelfAsSource(link)) {
                this.internalAdd(link.getTargetRef(), false, changeDetails);
                continue;
            }
            this.internalAdd(link.getSourceRef(), false, changeDetails);
        }
        if (!preserveChanges) {
            this.fCreatedLinks.clear();
            this.fDeletedLinks.clear();
        }
        this.fireAttributeChanged(changeDetails);
    }

    public void remoteAdd(IReference reference) {
        ILink link = reference.getLink();
        Assert.isNotNull((Object)link);
        if (this.fOriginalLinks.contains(link) && !this.fDeletedLinks.contains(link) || this.fCreatedLinks.contains(link)) {
            return;
        }
        ReferencesChangeDetails changeDetails = new ReferencesChangeDetails((List)new ArrayList(), Collections.emptyList());
        this.internalAdd(reference, false, changeDetails);
        this.fOriginalLinks.add(link);
        this.fOriginalLinkTypeIds.add(link.getLinkTypeId());
        this.fireAttributeChanged(changeDetails);
    }

    private void internalAdd(IReference reference, boolean updateDelta, ReferencesChangeDetails changeDetails) {
        IEndPointDescriptor endPointDescriptor;
        ILink link = reference.getLink();
        if (link.getOrigin() == null && this.fWorkItem.getOrigin() != null) {
            ((ItemHandle)link).setOrigin(this.fWorkItem.getOrigin());
        }
        if ((endPointDescriptor = this.getEndPointDescriptor(link)) != null) {
            List<IReference> references = this.fReferences.get(endPointDescriptor);
            if (references == null) {
                references = new ArrayList<IReference>();
                this.fReferences.put(endPointDescriptor, references);
            }
            references.add(reference);
        }
        if (updateDelta && !this.fDeletedLinks.remove(link)) {
            this.fCreatedLinks.add(link);
        }
        if (changeDetails != null && endPointDescriptor != null) {
            changeDetails.getAdded().add(reference);
        }
    }

    public void remoteRemove(IReference reference) {
        ReferencesChangeDetails changeDetails = new ReferencesChangeDetails(Collections.emptyList(), (List)new ArrayList());
        this.internalRemove(reference, false, changeDetails);
        this.fOriginalLinks.remove(reference.getLink());
        this.fireAttributeChanged(changeDetails);
    }

    private void internalRemove(IReference reference, boolean updateDelta, ReferencesChangeDetails changeDetails) {
        IEndPointDescriptor referenceType;
        ILink link = reference.getLink();
        if (link == null) {
            return;
        }
        if (link.getOrigin() == null && this.fWorkItem.getOrigin() != null) {
            ((ItemHandle)link).setOrigin(this.fWorkItem.getOrigin());
        }
        if ((referenceType = this.getEndPointDescriptor(link)) != null) {
            List<IReference> references = this.fReferences.get(referenceType);
            if (references == null) {
                return;
            }
            if (!references.remove(reference)) {
                for (IReference existing : references) {
                    if (!link.sameItemId((IItemHandle)existing.getLink())) continue;
                    reference = existing;
                    break;
                }
                if (!references.remove(reference)) {
                    return;
                }
            }
            if (references.isEmpty()) {
                this.fReferences.remove(referenceType);
            }
        }
        if (updateDelta && !this.fCreatedLinks.remove(link)) {
            this.fDeletedLinks.add(link);
        }
        if (changeDetails != null && referenceType != null) {
            changeDetails.getRemoved().add(reference);
        }
    }

    private void fireAttributeChanged(ReferencesChangeDetails changeDetails) {
        AttributeChangedNotifier notifier = ((WorkItem)this.fWorkItem).getAttributeChangedNotifier();
        if (!(notifier == null || changeDetails.getAdded().isEmpty() && changeDetails.getRemoved().isEmpty())) {
            List<IReference> added = this.createUnmodifiableList(changeDetails.getAdded());
            List<IReference> removed = this.createUnmodifiableList(changeDetails.getRemoved());
            ReferencesChangeDetails sealedDetails = new ReferencesChangeDetails(added, removed);
            notifier.fireAttributeChanged(this.fWorkItem, "references", sealedDetails);
        }
    }

    private List<IReference> createUnmodifiableList(List<IReference> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return Collections.unmodifiableList(new ArrayList<IReference>(list));
    }

    private void readLinkTypeIds(Collection<String> linkTypeIds, Set<String> target) {
        if (linkTypeIds != null) {
            target.addAll(linkTypeIds);
        } else {
            for (Object linkType : LinkTypeRegistry.INSTANCE.allEntries()) {
                target.add(((ILinkType)linkType).getLinkTypeId());
            }
        }
    }

    private void readReferences(Collection<ILink> links, Map<IEndPointDescriptor, List<IReference>> referenceMap) {
        for (ILink link : links) {
            IEndPointDescriptor referenceType;
            if (link.getOrigin() == null && this.fWorkItem.getOrigin() != null) {
                ((ItemHandle)link).setOrigin(this.fWorkItem.getOrigin());
            }
            if ((referenceType = this.getEndPointDescriptor(link)) == null) continue;
            List<IReference> references = referenceMap.get(referenceType);
            if (references == null) {
                references = new ArrayList<IReference>();
                referenceMap.put(referenceType, references);
            }
            if (this.hasSelfAsSource(link)) {
                references.add(link.getTargetRef());
                continue;
            }
            references.add(link.getSourceRef());
        }
    }

    private IEndPointDescriptor getEndPointDescriptor(ILink link) {
        if (!ILinkTypeRegistry.INSTANCE.isRegistered(link.getLinkTypeId())) {
            return null;
        }
        if (WorkItemLinkTypes.isSymmetric(link.getLinkType())) {
            return link.getLinkType().getTargetEndPointDescriptor();
        }
        if (this.hasSelfAsSource(link)) {
            return link.getLinkType().getTargetEndPointDescriptor();
        }
        return link.getLinkType().getSourceEndPointDescriptor();
    }

    private boolean hasSelfAsSource(ILink link) {
        if (link.getSourceRef().isItemReference() && this.fWorkItem.sameItemId(((IItemReference)link.getSourceRef()).getReferencedItem())) {
            return true;
        }
        if (link.getTargetRef().isItemReference() && this.fWorkItem.sameItemId(((IItemReference)link.getTargetRef()).getReferencedItem())) {
            return false;
        }
        throw new IllegalArgumentException("Link does not reference work item");
    }

    @Override
    public void deleteAttachment(IAttachmentHandle attachment) {
        if (attachment == null) {
            return;
        }
        if (this.fDeletedAttachments == null) {
            this.fDeletedAttachments = new ArrayList<IAttachmentHandle>();
        }
        this.fDeletedAttachments.add(attachment);
    }

    @Override
    public List<IAttachmentHandle> getDeletedAttachments() {
        return this.fDeletedAttachments != null ? Collections.unmodifiableList(this.fDeletedAttachments) : Collections.emptyList();
    }
}

