/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.oslc.mappings;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.ItemTypeRegistry;
import com.ibm.team.repository.common.query.ast.IDynamicItemQueryModel;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.internal.expression.QueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableAttributeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.AttributeRegistry;
import com.ibm.team.workitem.common.internal.oslc.mappings.EMFAttributeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeTypeDescriptor;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;

public class GenericQueryAttributeFactory
implements IQueryableAttributeFactory,
IExecutableExtension {
    private IItemType fItemType;
    private String fAttributeType;
    private final Map<IItemType, Set<String>> fIdentifierMap = new HashMap<IItemType, Set<String>>();

    public GenericQueryAttributeFactory() {
    }

    public GenericQueryAttributeFactory(IItemType itemType, String attributeType) {
        this.fItemType = itemType;
        this.fAttributeType = attributeType;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fItemType = QueryableAttributes.readItemTypeElement(config);
        this.fAttributeType = QueryableAttributes.readAttributeType(config);
    }

    @Override
    public List<IQueryableAttribute> findAllAttributes(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findAllAttributesByType(this.fAttributeType);
    }

    private List<IQueryableAttribute> findAllAttributesByType(String attributeType) {
        ArrayList<IQueryableAttribute> queryableAttributes = new ArrayList<IQueryableAttribute>();
        for (IAttributeDescriptor attribute : AttributeRegistry.getInstance().getAttributeDescriptor(attributeType)) {
            IQueryableAttribute queryableAttribute = this.createQueryableAttribute(attribute, false);
            if (queryableAttribute == null) continue;
            queryableAttributes.add(queryableAttribute);
        }
        return queryableAttributes;
    }

    @Override
    public IQueryableAttribute findAttribute(IProjectAreaHandle projectArea, String attributeIdentifier, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttributeDescriptor attribute = AttributeRegistry.getInstance().getAttributeDescriptor(this.fAttributeType, attributeIdentifier);
        return attribute == null ? null : this.createQueryableAttribute(attribute, true);
    }

    private IQueryableAttribute createQueryableAttribute(IAttributeDescriptor attribute, boolean includeChildren) {
        QueryableAttribute queryAttribute = null;
        if (attribute instanceof EMFAttributeDescriptor) {
            String identifier;
            String emfPath = ((EMFAttributeDescriptor)attribute).getEMFPath();
            String string = identifier = emfPath == null ? attribute.getPublicIdentifier() : emfPath;
            if (this.isQueryable(identifier, attribute)) {
                queryAttribute = new QueryableAttribute(new QueryableAttributeDescriptor(identifier, attribute.getDisplayName(), attribute.getAttributeType()));
                if (includeChildren) {
                    queryAttribute.setChildAttributes(this.findAllAttributesByType(attribute.getAttributeType()));
                }
            }
        }
        return queryAttribute;
    }

    @Override
    public ItemProfile<? extends IAuditable> computeProfile(List<IQueryableAttribute> attributes) {
        return ItemProfile.createFullProfile(this.fItemType);
    }

    @Override
    public List<String> getDefaultAttributeSet(IQueryableAttributeFactory.AttributeSet set) {
        return Collections.emptyList();
    }

    private boolean isQueryable(String identifier, IAttributeDescriptor attribute) {
        IItemType itemType = this.getItemType(attribute);
        if (itemType != null) {
            Set<String> identifiers = this.getIdentifiers(itemType);
            return identifiers.contains(identifier);
        }
        return false;
    }

    private Set<String> getIdentifiers(IItemType itemType) {
        Set<String> identifiers = this.fIdentifierMap.get(itemType);
        if (identifiers == null) {
            identifiers = new HashSet<String>();
            IDynamicItemQueryModel queryModel = itemType.getQueryModel();
            identifiers.addAll(queryModel.getAllFields());
            identifiers.addAll(queryModel.getAllReferences());
            this.fIdentifierMap.put(itemType, identifiers);
        }
        return identifiers;
    }

    private IItemType getItemType(IAttributeDescriptor attribute) {
        int pos;
        String itemTypeId;
        IAttributeTypeDescriptor typeDescriptor = AttributeRegistry.getInstance().getTypeDescriptor(attribute.getDeclaringType());
        String string = itemTypeId = typeDescriptor != null ? typeDescriptor.getItemTypeId() : null;
        if (itemTypeId != null && (pos = itemTypeId.lastIndexOf(46)) > 0) {
            String ns = itemTypeId.substring(0, pos);
            String name = itemTypeId.substring(pos + 1);
            return ItemTypeRegistry.INSTANCE.getItemType(name, ns);
        }
        return null;
    }
}

