/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.oslc.mappings;

import com.ibm.team.calm.foundation.common.oslc.OSLCCoreIdentifiers;
import com.ibm.team.workitem.common.internal.oslc.mappings.AbstractVersionedDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.AttributeRegistry;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeDescriptor;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import org.eclipse.core.runtime.Assert;

public class WorkItemAttributeDescriptor
extends AbstractVersionedDescriptor
implements IAttributeDescriptor {
    private final IAttribute fAttribute;
    private final IAttributeDescriptor fAttributeDescriptor;
    private final boolean fReadOnly;
    private final boolean fRequired;

    public WorkItemAttributeDescriptor(IAttribute attribute, boolean isReadOnly, boolean isRequired) {
        Assert.isNotNull((Object)attribute);
        this.fAttribute = attribute;
        this.fAttributeDescriptor = AttributeRegistry.getInstance().getAttributeDescriptor("workItem", attribute.getIdentifier());
        if (this.fAttributeDescriptor != null) {
            this.initFrom((AbstractVersionedDescriptor)((Object)this.fAttributeDescriptor));
        } else {
            this.addPublicIdentifier(OSLCCoreIdentifiers.VERSION_DEFAULT, attribute.getIdentifier(), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
            this.addPublicIdentifier(OSLCCoreIdentifiers.VERSION_OSLC_CORE_20, attribute.getIdentifier(), "http://jazz.net/xmlns/prod/jazz/rtc/ext/1.0/");
        }
        this.fReadOnly = isReadOnly;
        this.fRequired = isRequired;
    }

    public IAttribute getAttribute() {
        return this.fAttribute;
    }

    @Override
    public String getDeclaringType() {
        return "workItem";
    }

    @Override
    public String getAttributeType() {
        if (this.fAttributeDescriptor != null) {
            return this.fAttributeDescriptor.getAttributeType();
        }
        return this.fAttribute.getAttributeType();
    }

    @Override
    public String getDisplayName() {
        return this.fAttribute.getDisplayName();
    }

    @Override
    public String getDescription() {
        if (this.fAttributeDescriptor != null) {
            return this.fAttributeDescriptor.getDescription();
        }
        return null;
    }

    @Override
    public String getInternalIdentifier() {
        return this.fAttribute.getIdentifier();
    }

    @Override
    public boolean isReadOnly() {
        return this.fReadOnly || this.fAttribute.isReadOnly();
    }

    @Override
    public int getMinOccurs() {
        return this.fRequired ? 1 : 0;
    }

    @Override
    public int getMaxOccurs() {
        if (this.fAttributeDescriptor != null) {
            return this.fAttributeDescriptor.getMaxOccurs();
        }
        return this.isCollection() ? -1 : 1;
    }

    @Override
    public boolean isCollection() {
        if (this.fAttributeDescriptor != null) {
            return this.fAttributeDescriptor.isCollection();
        }
        return AttributeTypes.isListAttributeType(this.fAttribute.getAttributeType());
    }

    @Override
    public boolean isInlined() {
        if (this.fAttributeDescriptor != null) {
            return this.fAttributeDescriptor.isInlined();
        }
        return false;
    }

    @Override
    public String getRepresentation() {
        if (this.fAttributeDescriptor != null) {
            return this.fAttributeDescriptor.getRepresentation();
        }
        return null;
    }

    @Override
    public Boolean getMemberProperty() {
        if (this.fAttributeDescriptor != null) {
            return this.fAttributeDescriptor.getMemberProperty();
        }
        return null;
    }
}

