/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class InCategoryOperation
extends AttributeOperation {
    private final boolean fInvert;

    public InCategoryOperation(String identifier, String displayName, boolean invert) {
        super(identifier, displayName);
        this.fInvert = invert;
    }

    @Override
    public boolean evaluate(Object left, Object right, IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean result = this.internalEvaluate(left, right, context, monitor);
        return this.fInvert ? !result : result;
    }

    private boolean internalEvaluate(Object left, Object right, IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (left instanceof ICategoryHandle && right instanceof ICategoryHandle) {
            if (!(left instanceof ICategory)) {
                left = context.getAuditableCommon().resolveAuditable((ICategoryHandle)left, ICategory.SMALL_PROFILE, monitor);
            }
            if (!(right instanceof ICategory)) {
                right = context.getAuditableCommon().resolveAuditable((ICategoryHandle)right, ICategory.SMALL_PROFILE, monitor);
            }
            String categoryId = ((ICategory)left).getCategoryId().getInternalRepresentation();
            return categoryId.startsWith(((ICategory)right).getCategoryId().getInternalRepresentation());
        }
        return false;
    }

    @Override
    public IPredicate getPredicate(ITransformationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        IPredicate predicate = null;
        CategoryId[] categoryIdArray = InCategoryOperation.normalizePaths(this.getCategories(context));
        int n = categoryIdArray.length;
        int n2 = 0;
        while (n2 < n) {
            CategoryId path = categoryIdArray[n2];
            IStringField categoryIdField = (IStringField)context.getReference(true).getField(ICategory.CATEGORY_ID);
            IPredicate subPredicate = categoryIdField._like((IString)context.getQuery().newStringArg());
            context.addParameter(path.getSubtreePattern());
            if (this.isNegation()) {
                subPredicate = subPredicate._not();
            }
            predicate = predicate != null ? (this.fInvert ? predicate._and(subPredicate) : predicate._or(subPredicate)) : subPredicate;
            ++n2;
        }
        if (predicate != null) {
            if (context.getAttribute().isStateExtension()) {
                predicate = context.createOldStateExtensionPredicate(predicate);
            }
            if (this.isNegation()) {
                predicate = predicate._or(context.getReference()._isNull());
            }
        }
        return predicate;
    }

    private List<ICategory> getCategories(ITransformationContext context) throws TeamRepositoryException {
        if (context.getValue() instanceof Collection) {
            Collection values = (Collection)context.getValue();
            ArrayList<ICategoryHandle> handles = new ArrayList<ICategoryHandle>(values.size());
            for (Object value : values) {
                handles.add((ICategoryHandle)value);
            }
            return context.getAuditableCommon().resolveAuditables(handles, ICategory.DEFAULT_PROFILE, null);
        }
        return Arrays.asList(context.getAuditableCommon().resolveAuditable((ICategoryHandle)context.getValue(), ICategory.DEFAULT_PROFILE, null));
    }

    @Override
    public boolean isNegation() {
        return this.fInvert;
    }

    @Override
    public boolean supportsMultiValuesPredicate(IQueryableAttribute attribute) {
        return true;
    }

    public static CategoryId[] normalizePaths(Collection<ICategory> categories) throws TeamRepositoryException {
        ArrayList<CategoryId> normalizedCategories = new ArrayList<CategoryId>();
        for (ICategory category : categories) {
            Iterator itr = normalizedCategories.iterator();
            boolean skip = false;
            CategoryId categoryId = category.getCategoryId();
            while (itr.hasNext()) {
                CategoryId normalized = (CategoryId)itr.next();
                if (normalized.contains(categoryId)) {
                    skip = true;
                    continue;
                }
                if (!categoryId.contains(normalized)) continue;
                itr.remove();
            }
            if (skip) continue;
            normalizedCategories.add(categoryId);
        }
        return normalizedCategories.toArray(new CategoryId[normalizedCategories.size()]);
    }
}

