/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.impl;

import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.internal.query.Association;
import com.ibm.team.workitem.common.internal.query.QueryFactory;
import com.ibm.team.workitem.common.query.IAssociation;
import com.ibm.team.workitem.common.query.IAssociations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Associations
implements IAssociations {
    private List<IAssociation> fAssociations;

    public Associations(List<IAssociation> internalAssociations) {
        this.fAssociations = internalAssociations;
        if (this.fAssociations == null) {
            this.fAssociations = Collections.emptyList();
        }
    }

    @Override
    public List<IAssociation> getContents() {
        return Collections.unmodifiableList(this.fAssociations);
    }

    @Override
    public List<IAssociation> getPublicContents() {
        ArrayList<IAssociation> publicAssociations = new ArrayList<IAssociation>();
        for (IAssociation association : this.getContents()) {
            if (!(association.getTarget() instanceof ITeamAreaHandle) && !(association.getTarget() instanceof IContributorHandle)) continue;
            publicAssociations.add(association);
        }
        return publicAssociations;
    }

    @Override
    public IAssociation createAssociation(IAuditableHandle handle) {
        return this.createAssociation(handle, null);
    }

    private IAssociation createAssociation(IAuditableHandle handle, String role) {
        Association association = QueryFactory.eINSTANCE.createAssociation();
        association.setTarget(handle);
        association.setRole(role);
        return association;
    }

    @Override
    public void associate(IAssociation association) {
        if (this.findAssociation(association) == null) {
            this.fAssociations.add(association);
        }
    }

    @Override
    public boolean disassociate(IAssociation association) {
        IAssociation existing = this.findAssociation(association);
        if (existing != null) {
            return this.fAssociations.remove(existing);
        }
        return false;
    }

    private IAssociation findAssociation(IAssociation association) {
        for (IAssociation existing : this.fAssociations) {
            if (!association.getTarget().sameItemId((IItemHandle)existing.getTarget()) || (association.getRole() == null || !association.getRole().equals(existing.getRole())) && association.getRole() != existing.getRole()) continue;
            return existing;
        }
        return null;
    }

    @Override
    public void disassociateAll() {
        this.fAssociations.clear();
    }

    @Override
    public <T> void disassociateAll(Class<T> clazz) {
        Iterator<IAssociation> iterator = this.fAssociations.iterator();
        while (iterator.hasNext()) {
            IAssociation association = iterator.next();
            if (!clazz.isAssignableFrom(association.getTarget().getClass())) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean containsTarget(IAuditableHandle target) {
        for (IAssociation association : this.fAssociations) {
            if (!association.getTarget().sameItemId((IItemHandle)target)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> List<IAssociation> filterTargets(Class<T> clazz) {
        ArrayList<IAssociation> filtered = new ArrayList<IAssociation>();
        for (IAssociation association : this.fAssociations) {
            if (!clazz.isAssignableFrom(association.getTarget().getClass())) continue;
            filtered.add(association);
        }
        return filtered;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Associations)) {
            return false;
        }
        Associations other = (Associations)obj;
        if (this.fAssociations.size() != other.fAssociations.size()) {
            return false;
        }
        List<String> set1 = this.createList(this.fAssociations);
        List<String> set2 = this.createList(other.fAssociations);
        return set1.containsAll(set2);
    }

    private List<String> createList(List<IAssociation> associations) {
        ArrayList<String> list = new ArrayList<String>(associations.size());
        for (IAssociation association : associations) {
            String role = association.getRole();
            String itemId = association.getTarget().getItemId().getUuidValue();
            list.add(role == null ? itemId : String.valueOf(itemId) + role);
        }
        return list;
    }
}

