/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.setup.builders;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.ContributorBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.setup.builders.ApprovalsBuilder;
import com.ibm.team.workitem.common.internal.setup.builders.WorkItemBuilderContext;
import com.ibm.team.workitem.common.internal.setup.builders.WorkItemTypeBuilder;
import com.ibm.team.workitem.common.internal.util.SequenceValue;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WorkItemBuilder
extends AbstractArtifactBuilder<IWorkItem> {
    protected static final ValueKey<IProjectArea> PROJECT_AREA = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".projectArea");
    protected static final ValueKey<UUID> CONTEXT = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".context");
    protected static final ValueKey<String> TYPE = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".stringType");
    protected static final ValueKey<Integer> ID = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".id");
    protected static final ValueKey<UUID> ITEM_ID = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".itemId");
    protected static final ValueKey<UUID> STATE_ID = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".stateId");
    protected static final ValueKey<Boolean> RESOLVED = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".resolved");
    protected static final ValueKey<Boolean> IN_PROGRESS = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".inProgress");
    protected static final ValueKey<XMLString> SUMMARY = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".summary");
    protected static final ValueKey<XMLString> DESCRIPTION = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".description");
    protected static final ValueKey<String> WORKFLOW_ACTION = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".workflowAction");
    protected static final ValueKey<Identifier<IState>> STATE = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".state");
    protected static final ValueKey<Identifier<IResolution>> RESOLUTION = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".resolution");
    protected static final ValueKey<ICategoryHandle> FILED_AGAINST = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".category");
    protected static final ValueKey<IContributorHandle> OWNER = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".owner");
    protected static final ValueKey<IContributorHandle> CREATOR = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".creator");
    protected static final ValueKey<List<IContributorHandle>> SUBSCRIBERS = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".subscribers");
    protected static final ValueKey<List<ContributorBuilder>> SUBSCRIBER_BUILDERS = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".subscriberBuilders");
    protected static final ValueKey<IIterationHandle> PLANNED_FOR = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".target");
    protected static final ValueKey<Timestamp> CREATION_DATE = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".creationDate");
    protected static final ValueKey<Timestamp> DUE_DATE = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".dueDate");
    protected static final ValueKey<Long> DURATION = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".duration");
    protected static final ValueKey<Identifier<IPriority>> PRIORITY = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".priority");
    protected static final ValueKey<Identifier<ISeverity>> SEVERITY = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".severity");
    protected static final ValueKey<List<String>> TAGS = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + ".tags");
    protected static final ValueKey<Double> SEQUENCE_VALUE = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + "sequence");
    protected static final ValueKey<List<CommentBuilderTuple>> COMMENTS = new ValueKey(String.valueOf(WorkItemBuilder.class.getName()) + "comments");
    protected Map<IEndPointDescriptor, List<IWorkItem>> fWorkItemLinks = new HashMap<IEndPointDescriptor, List<IWorkItem>>();
    protected Map<IEndPointDescriptor, List<WorkItemBuilder>> fWorkItemBuilderLinks = new HashMap<IEndPointDescriptor, List<WorkItemBuilder>>();
    protected Map<IAttribute, Object> fAttributesMap = new HashMap<IAttribute, Object>();

    public WorkItemBuilder(IArtifactBuilderContext context) {
        super(context);
        this.setBuilderValue(COMMENTS, new LinkedList());
    }

    public WorkItemBuilder projectArea(IProjectArea projectArea) {
        this.setBuilderValue(PROJECT_AREA, projectArea);
        return this;
    }

    public WorkItemBuilder context(IAccessGroup accessGroup) {
        this.setBuilderValue(CONTEXT, accessGroup.getGroupContextId());
        return this;
    }

    public WorkItemBuilder type(String type) {
        this.setBuilderValue(TYPE, type);
        return this;
    }

    public WorkItemBuilder type(IWorkItemType type) {
        this.setBuilderValue(TYPE, type.getIdentifier());
        return this;
    }

    public WorkItemBuilder type(WorkItemTypeBuilder typeBuilder) {
        this.setBuilderValue(TYPE, ((IWorkItemType)typeBuilder.build()).getIdentifier());
        return this;
    }

    public WorkItemBuilder id(int id) {
        this.setBuilderValue(ID, id);
        return this;
    }

    public WorkItemBuilder itemId(UUID itemId) {
        this.setBuilderValue(ITEM_ID, itemId != null ? itemId : UUID.generate());
        return this;
    }

    public WorkItemBuilder stateId(UUID stateId) {
        this.setBuilderValue(STATE_ID, stateId);
        return this;
    }

    public WorkItemBuilder summary(String summary) {
        return this.summary(XMLString.createFromPlainText((String)(summary != null ? summary : "")));
    }

    public WorkItemBuilder summary(XMLString summary) {
        this.setBuilderValue(SUMMARY, summary);
        return this;
    }

    public WorkItemBuilder description(String description) {
        return this.description(XMLString.createFromPlainText((String)(description != null ? description : "")));
    }

    public WorkItemBuilder description(XMLString description) {
        this.setBuilderValue(DESCRIPTION, description);
        return this;
    }

    public WorkItemBuilder comment(String commentText, IContributorHandle commentCreator) {
        ((List)this.getBuilderValue(COMMENTS)).add(new CommentBuilderTuple(XMLString.createFromPlainText((String)commentText), commentCreator));
        return this;
    }

    public WorkItemBuilder state(Identifier<IState> state) {
        this.setBuilderValue(STATE, state);
        return this;
    }

    public WorkItemBuilder workflowAction(String workflowAction) {
        this.setBuilderValue(WORKFLOW_ACTION, workflowAction);
        return this;
    }

    public WorkItemBuilder resolution(Identifier<IResolution> resolution) {
        this.setBuilderValue(RESOLUTION, resolution);
        return this;
    }

    public WorkItemBuilder filedAgainst(ICategoryHandle category) {
        this.setBuilderValue(FILED_AGAINST, category);
        return this;
    }

    public WorkItemBuilder owner(IContributorHandle owner) {
        this.setBuilderValue(OWNER, owner);
        return this;
    }

    public WorkItemBuilder subscribers(IContributorHandle ... subscribers) {
        this.setBuilderValue(SUBSCRIBERS, Arrays.asList(subscribers));
        return this;
    }

    public WorkItemBuilder subscribers(ContributorBuilder ... subscribers) {
        this.setBuilderValue(SUBSCRIBER_BUILDERS, Arrays.asList(subscribers));
        return this;
    }

    public WorkItemBuilder plannedFor(IIterationHandle target) {
        this.setBuilderValue(PLANNED_FOR, target);
        return this;
    }

    public WorkItemBuilder creator(IContributorHandle creator) {
        this.setBuilderValue(CREATOR, creator);
        return this;
    }

    public WorkItemBuilder creationDate(Timestamp creationDate) {
        this.setBuilderValue(CREATION_DATE, creationDate);
        return this;
    }

    public WorkItemBuilder dueDate(Timestamp dueDate) {
        this.setBuilderValue(DUE_DATE, dueDate);
        return this;
    }

    public WorkItemBuilder duration(long duration) {
        this.setBuilderValue(DURATION, duration);
        return this;
    }

    public WorkItemBuilder priority(IPriority priority) {
        this.setBuilderValue(PRIORITY, priority.getIdentifier2());
        return this;
    }

    public WorkItemBuilder priority(Identifier<IPriority> priority) {
        this.setBuilderValue(PRIORITY, priority);
        return this;
    }

    public WorkItemBuilder severity(ISeverity severity) {
        this.setBuilderValue(SEVERITY, severity.getIdentifier2());
        return this;
    }

    public WorkItemBuilder severity(Identifier<ISeverity> severity) {
        this.setBuilderValue(SEVERITY, severity);
        return this;
    }

    public WorkItemBuilder attribute(IAttribute attribute, Object value) {
        this.fAttributesMap.put(attribute, value);
        return this;
    }

    public WorkItemBuilder attributes(IAttribute[] attributes, Object[] values) {
        if (attributes == null || values == null || attributes.length != values.length) {
            throw new IllegalArgumentException("attributes and values must be non-null and of same length");
        }
        int i = 0;
        while (i < values.length) {
            this.attribute(attributes[i], values[i]);
            ++i;
        }
        return this;
    }

    public WorkItemBuilder tags(List<String> tags) {
        this.setBuilderValue(TAGS, tags);
        return this;
    }

    public WorkItemBuilder tags(String ... tags) {
        this.setBuilderValue(TAGS, Arrays.asList(tags));
        return this;
    }

    public WorkItemBuilder approvals(ApprovalsBuilder approvalsBuilder) {
        this.addChildBuilder(new IArtifactBuilder[]{approvalsBuilder});
        return this;
    }

    public WorkItemBuilder sequenceValue(double value) throws Exception {
        this.setBuilderValue(SEQUENCE_VALUE, value);
        return this;
    }

    public WorkItemBuilder resolved(boolean resolved) {
        this.setBuilderValue(RESOLVED, resolved);
        if (resolved) {
            this.setBuilderValue(IN_PROGRESS, false);
        }
        return this;
    }

    public WorkItemBuilder inProgress(boolean inProgress) {
        this.setBuilderValue(IN_PROGRESS, inProgress);
        if (inProgress) {
            this.setBuilderValue(RESOLVED, false);
        }
        return this;
    }

    public WorkItemBuilder child(IWorkItem workItem) {
        this.addWorkItemLink(workItem, WorkItemEndPoints.CHILD_WORK_ITEMS);
        return this;
    }

    public WorkItemBuilder parent(IWorkItem workItem) {
        this.addWorkItemLink(workItem, WorkItemEndPoints.PARENT_WORK_ITEM);
        return this;
    }

    public WorkItemBuilder related(IWorkItem workItem) {
        this.addWorkItemLink(workItem, WorkItemEndPoints.RELATED_WORK_ITEM);
        return this;
    }

    public WorkItemBuilder duplicate(IWorkItem workItem) {
        this.addWorkItemLink(workItem, WorkItemEndPoints.DUPLICATE_WORK_ITEM);
        return this;
    }

    public WorkItemBuilder blocks(IWorkItem workItem) {
        this.addWorkItemLink(workItem, WorkItemEndPoints.BLOCKS_WORK_ITEM);
        return this;
    }

    public WorkItemBuilder child(WorkItemBuilder workItem) {
        this.addWorkItemLink(workItem, WorkItemEndPoints.CHILD_WORK_ITEMS);
        return this;
    }

    public WorkItemBuilder parent(WorkItemBuilder workItem) {
        this.addWorkItemLink(workItem, WorkItemEndPoints.PARENT_WORK_ITEM);
        return this;
    }

    public WorkItemBuilder related(WorkItemBuilder workItem) {
        this.addWorkItemLink(workItem, WorkItemEndPoints.RELATED_WORK_ITEM);
        return this;
    }

    public WorkItemBuilder duplicate(WorkItemBuilder workItem) {
        this.addWorkItemLink(workItem, WorkItemEndPoints.DUPLICATE_WORK_ITEM);
        return this;
    }

    public WorkItemBuilder blocks(WorkItemBuilder workItem) {
        this.addWorkItemLink(workItem, WorkItemEndPoints.BLOCKS_WORK_ITEM);
        return this;
    }

    protected IWorkItem doSave(BuildContext saveContext) throws TeamRepositoryException {
        if (!(this.artifactExists() || this.isBuilderValueSet(PROJECT_AREA) || saveContext.isPropertySet(BuildContext.PROJECT_AREA))) {
            throw new IllegalArgumentException("Cannot create a work item without specifying the project area");
        }
        if (this.isBuilderValueSet(ITEM_ID)) {
            throw new IllegalArgumentException("Cannot specify itemId when item is saved in repository.");
        }
        if (this.isBuilderValueSet(STATE_ID)) {
            throw new IllegalArgumentException("Cannot specify stateId when item is saved in repository.");
        }
        if (!this.isBuilderValueSet(TYPE)) {
            this.setBuilderValue(TYPE, "defect");
        }
        if (!saveContext.isPropertySet(BuildContext.PROJECT_AREA)) {
            IAuditableCommon auditableCommon = (IAuditableCommon)this.getContext().getLibrary(IAuditableCommon.class);
            IProjectArea projectArea = null;
            if (this.artifactExists()) {
                projectArea = auditableCommon.resolveAuditable((IAuditableHandle)((IWorkItem)this.getExistingArtifact()).getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, null);
            }
            saveContext.setProperty(BuildContext.PROJECT_AREA, (Object)((IProjectArea)this.getBuilderValue(PROJECT_AREA, projectArea)));
        }
        if (this.isBuilderValueSet(SUBSCRIBER_BUILDERS)) {
            List subscribers = (List)this.chooseValue(SUBSCRIBERS, new LinkedList());
            for (ContributorBuilder cur : (List)this.chooseValue(SUBSCRIBER_BUILDERS, Collections.emptyList())) {
                subscribers.add((IContributorHandle)cur.save());
            }
            this.setBuilderValue(SUBSCRIBERS, subscribers);
        }
        return this.createWorkItem(saveContext);
    }

    protected IWorkItem doBuild(BuildContext buildContext) {
        WorkItem workItem = (WorkItem)this.artifact(IWorkItem.ITEM_TYPE);
        workItem.setProjectArea((IProjectAreaHandle)this.getBuilderValue(PROJECT_AREA, buildContext.isPropertySet(BuildContext.PROJECT_AREA) ? (IProjectArea)buildContext.getProperty(BuildContext.PROJECT_AREA) : (IProjectArea)workItem.getProjectArea()));
        workItem.setWorkItemType((String)this.chooseValue(TYPE, workItem.getWorkItemType(), "task"));
        workItem.setItemId((UUID)this.chooseValue(ITEM_ID, workItem.getItemId(), UUID.generate()));
        workItem.setStateId((UUID)this.chooseValue(STATE_ID, workItem.getStateId(), UUID.generate()));
        workItem.setId((Integer)this.chooseValue(ID, workItem.getId(), 1));
        workItem.setState2((Identifier)this.chooseValue(STATE, workItem.getState2()));
        workItem.setResolution2((Identifier)this.chooseValue(RESOLUTION, workItem.getResolution2()));
        for (IAttribute cur : this.fAttributesMap.keySet()) {
            if (workItem.hasAttribute(cur)) continue;
            workItem.addCustomAttribute(cur);
        }
        if (this.isBuilderValueSet(SUBSCRIBER_BUILDERS)) {
            List subscribers = (List)this.chooseValue(SUBSCRIBERS, new LinkedList());
            for (ContributorBuilder cur : (List)this.chooseValue(SUBSCRIBER_BUILDERS, Collections.emptyList())) {
                subscribers.add((IContributorHandle)cur.build());
            }
            this.setBuilderValue(SUBSCRIBERS, subscribers);
        }
        return this.setWorkItemFields(workItem, buildContext);
    }

    protected IWorkItemReferences addLinks(IWorkItemReferences workItemReferences, Map<IEndPointDescriptor, List<IWorkItem>> links) {
        for (IEndPointDescriptor desc : links.keySet()) {
            List<IWorkItem> list = links.get(desc);
            for (IWorkItem targetWorkItem : list) {
                workItemReferences.add(desc, (IReference)WorkItemLinkTypes.createWorkItemReference(targetWorkItem));
            }
        }
        return workItemReferences;
    }

    protected IWorkItem setWorkItemFields(IWorkItem workItem, BuildContext buildContext) {
        workItem.setHTMLSummary((XMLString)this.chooseValue(SUMMARY, workItem.getHTMLSummary(), XMLString.createFromPlainText((String)"default summary")));
        workItem.setHTMLDescription((XMLString)this.chooseValue(DESCRIPTION, workItem.getHTMLDescription()));
        workItem.setCategory((ICategoryHandle)this.chooseValue(buildContext, FILED_AGAINST, WorkItemBuilderContext.CATEGORY, workItem.getCategory()));
        workItem.setOwner((IContributorHandle)this.chooseValue(OWNER, workItem.getOwner()));
        for (IContributorHandle cur : (List)this.chooseValue(SUBSCRIBERS, Collections.emptyList())) {
            workItem.getSubscriptions().add(cur);
        }
        workItem.setCreator((IContributorHandle)this.chooseValue(CREATOR, workItem.getCreator()));
        workItem.setTarget((IIterationHandle)this.chooseValue(buildContext, PLANNED_FOR, BuildContext.ITERATION, workItem.getTarget()));
        workItem.setCreationDate((Timestamp)this.chooseValue(CREATION_DATE, workItem.getCreationDate(), new Timestamp(System.currentTimeMillis())));
        workItem.setDueDate((Timestamp)this.chooseValue(DUE_DATE, workItem.getDueDate()));
        workItem.setDuration((Long)this.chooseValue(DURATION, workItem.getDuration()));
        workItem.setPriority((Identifier)this.chooseValue(PRIORITY, workItem.getPriority()));
        workItem.setSeverity((Identifier)this.chooseValue(SEVERITY, workItem.getSeverity()));
        workItem.setTags2((List)this.chooseValue(TAGS, workItem.getTags2()));
        for (CommentBuilderTuple commentTuple : (List)this.getBuilderValue(COMMENTS)) {
            workItem.getComments().append(workItem.getComments().createComment(commentTuple.fCommentCreator, commentTuple.fCommentText));
        }
        if (this.isBuilderValueSet(CONTEXT)) {
            workItem.setContextId((UUID)this.getBuilderValue(CONTEXT));
        }
        if (this.isBuilderValueSet(SEQUENCE_VALUE)) {
            if (!this.isBuilderValueSet(OWNER)) {
                throw new IllegalArgumentException("Cannot set sequence value without specifying the owner");
            }
            String sequenceValue = SequenceValue.FACTORY.valueOf((Double)this.getBuilderValue(SEQUENCE_VALUE)).serializeSequenceValue((IItemHandle)this.getBuilderValue(OWNER));
            ((WorkItem)workItem).setInternalSequenceValue(sequenceValue);
        }
        for (IAttribute attribute : this.fAttributesMap.keySet()) {
            if (!workItem.hasAttribute(attribute)) {
                workItem.addCustomAttribute(attribute);
            }
            workItem.setValue(attribute, this.fAttributesMap.get(attribute));
        }
        for (IArtifactBuilder childBuilder : this.getChildBuilders()) {
            childBuilder.build(new BuildContext(buildContext).setProperty(WorkItemBuilderContext.WORKITEM, (Object)workItem));
        }
        return workItem;
    }

    protected IWorkItem fetchWorkItem(IWorkItemHandle workItemHandle) throws TeamRepositoryException {
        IAuditableCommon auditableCommon = (IAuditableCommon)this.getContext().getLibrary(IAuditableCommon.class);
        return auditableCommon.resolveAuditable(workItemHandle, IWorkItem.FULL_PROFILE, null);
    }

    protected IWorkItem createWorkItem(BuildContext saveContext) throws TeamRepositoryException {
        throw new UnsupportedOperationException();
    }

    protected HashMap<IEndPointDescriptor, List<IWorkItem>> buildLinks(BuildContext saveContext) throws TeamRepositoryException {
        HashMap<IEndPointDescriptor, List<IWorkItem>> map = new HashMap<IEndPointDescriptor, List<IWorkItem>>(this.fWorkItemLinks);
        for (Map.Entry<IEndPointDescriptor, List<WorkItemBuilder>> entry : this.fWorkItemBuilderLinks.entrySet()) {
            IEndPointDescriptor key = entry.getKey();
            List<IWorkItem> list = map.get(key);
            if (list == null) {
                list = new ArrayList<IWorkItem>();
                map.put(key, list);
            }
            for (WorkItemBuilder builder : entry.getValue()) {
                list.add((IWorkItem)builder.save(new BuildContext(saveContext)));
            }
        }
        return map;
    }

    private void addWorkItemLink(IWorkItem workItem, IEndPointDescriptor desc) {
        this.getList(this.fWorkItemLinks, desc).add(workItem);
    }

    private void addWorkItemLink(WorkItemBuilder workItem, IEndPointDescriptor desc) {
        this.getList(this.fWorkItemBuilderLinks, desc).add((Object)((Object)workItem));
    }

    private <T> List<T> getList(Map<IEndPointDescriptor, List<T>> links, IEndPointDescriptor desc) {
        List<T> value = links.get(desc);
        if (value == null) {
            value = new ArrayList<T>();
            links.put(desc, value);
        }
        return value;
    }

    private static class CommentBuilderTuple {
        private final XMLString fCommentText;
        private final IContributorHandle fCommentCreator;

        public CommentBuilderTuple(XMLString commentText, IContributorHandle commentCreator) {
            this.fCommentText = commentText;
            this.fCommentCreator = commentCreator;
        }
    }
}

