/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;

public class DecimalParser {
    public static final int MAXIMUM_FRACTION_LENGTH = 4;
    public static final int MAXIMUM_INTEGRAL_LENGTH = 24;
    private final NumberFormat fFormat;

    public DecimalParser() {
        this(null);
    }

    public DecimalParser(LocalizationContext localizationContext) {
        this.fFormat = LocalizationContext.createDecimalFormat(localizationContext);
    }

    public BigDecimal parse(String toParse) throws ParseException {
        if (toParse == null) {
            return BigDecimal.ZERO;
        }
        String text = toParse.trim();
        if (text.equals("")) {
            return BigDecimal.ZERO;
        }
        ParsePosition p = new ParsePosition(0);
        Object parseObject = this.fFormat.parseObject(text, p);
        if (p.getIndex() < text.length()) {
            throw new ParseException("", p.getErrorIndex());
        }
        BigDecimal decimal = new BigDecimal(parseObject.toString());
        this.check(decimal);
        return decimal;
    }

    private void check(BigDecimal decimal) throws ParseException {
        int scale = decimal.scale();
        if (scale > 4) {
            throw new ParseException("", scale);
        }
        int integrals = decimal.precision() - scale;
        if (integrals > 24) {
            throw new ParseException("", integrals);
        }
    }
}

