/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.internal.util.ILinkTypeFilter;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ProcessNatureSupport {
    private static final String CONFIGURATION_POINT_PROCESS_NATURE = "com.ibm.team.apt.configuration.processNature";
    private static final String PROPERTIES = "properties";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String PROCESS_TYPE = "processType";
    private static final String TRADITIONAL = "traditional";
    private IProjectAreaHandle fProjectArea;
    private IAuditableCommon fAuditableCommon;
    private boolean fShowPredecessorLinks;
    public static final ILinkTypeFilter NULL_FILTER = new ILinkTypeFilter(){

        @Override
        public boolean filters(ILinkType type) {
            return false;
        }
    };
    private static final ILinkTypeFilter PREDECESSOR_FILTER = new ILinkTypeFilter(){

        @Override
        public boolean filters(ILinkType type) {
            return "com.ibm.team.workitem.linktype.schedulePredecessor".equals(type.getLinkTypeId());
        }
    };

    public ProcessNatureSupport(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon) {
        this.fProjectArea = projectArea;
        this.fAuditableCommon = auditableCommon;
        this.fShowPredecessorLinks = false;
    }

    public ILinkTypeFilter getFilter() {
        if (this.fShowPredecessorLinks) {
            return NULL_FILTER;
        }
        return PREDECESSOR_FILTER;
    }

    public boolean filters(ILinkType type) {
        if (this.fShowPredecessorLinks) {
            return false;
        }
        return "com.ibm.team.workitem.linktype.schedulePredecessor".equals(type.getLinkTypeId());
    }

    public Set<String> getFilterSet() {
        HashSet<String> result = new HashSet<String>();
        if (!this.fShowPredecessorLinks) {
            result.add("com.ibm.team.workitem.linktype.schedulePredecessor");
        }
        return result;
    }

    public void initialize(IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IProcessConfigurationElement[] natures;
            monitor.beginTask("", 3);
            IAuditableCommonProcess process = this.fAuditableCommon.getProcess((IProcessAreaHandle)this.fProjectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IProcessConfigurationData configuration = process.findProcessConfiguration(CONFIGURATION_POINT_PROCESS_NATURE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (configuration == null) {
                this.fShowPredecessorLinks = false;
                return;
            }
            IProcessConfigurationElement[] iProcessConfigurationElementArray = natures = configuration.getElements();
            int n = natures.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement nature = iProcessConfigurationElementArray[n2];
                IProcessConfigurationElement[] iProcessConfigurationElementArray2 = nature.getChildren();
                int n3 = iProcessConfigurationElementArray2.length;
                int n4 = 0;
                block5: while (n4 < n3) {
                    IProcessConfigurationElement element = iProcessConfigurationElementArray2[n4];
                    if (PROPERTIES.equals(element.getName())) {
                        IProcessConfigurationElement[] properties;
                        IProcessConfigurationElement[] iProcessConfigurationElementArray3 = properties = element.getChildren();
                        int n5 = properties.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IProcessConfigurationElement property = iProcessConfigurationElementArray3[n6];
                            if (PROCESS_TYPE.equals(property.getAttribute(KEY))) {
                                String value = property.getAttribute(VALUE);
                                this.fShowPredecessorLinks = value.startsWith(TRADITIONAL);
                                break block5;
                            }
                            ++n6;
                        }
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean hidePredecessorLinks() {
        return !this.fShowPredecessorLinks;
    }
}

