/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.wiki.transformer;

import com.ibm.team.workitem.common.internal.wiki.transformer.Token;
import com.ibm.team.workitem.common.internal.wiki.transformer.Transformer;
import java.util.Arrays;
import java.util.List;

public enum TranslationScheme {
    HEADING_1("<h1>", "</h1>", Token.HEADING_1),
    HEADING_2("<h2>", "</h2>", Token.HEADING_2),
    HEADING_3("<h3>", "</h3>", Token.HEADING_3),
    HEADING_4("<h4>", "</h4>", Token.HEADING_4),
    HEADING_5("<h5>", "</h5>", Token.HEADING_5),
    HEADING_6("<h6>", "</h6>", Token.HEADING_6),
    ITALICS("<span style=\"font-style: italic; \">", "</span>", Token.ITALICS),
    BOLD("<span style=\"font-weight: bold;\">", "</span>", Token.BOLD),
    STRIKE_OUT("<span style=\"text-decoration: line-through; \">", "</span>", Token.STRIKE_OUT),
    UNDERLINE("<span style=\"text-decoration: underline; \">", "</span>", Token.UNDERLINE),
    HLINE("<hr />", "", Token.HORIZONTAL_LINE),
    LINE_BREAK("<br />", "", Token.LINE_BREAK),
    LINK("<a href=\"%\">", "</a>", Token.LINK_START, Token.LINK_END),
    IMAGE("<a href=\"%\">%", "</a>", Token.IMG_START, Token.IMG_END),
    FG_COLOR("<span style=\"color: %;\">", "</span>", Token.COLOR),
    BG_COLOR("<span style=\"background-color: %;\">", "</span>", Token.COLOR),
    FG_BG_COLOR("<span style=\"color: %; background-color: %;\">", "</span>", Token.COLOR),
    CODE("<pre>", "</pre>", Token.CODE_START, Token.CODE_END),
    TABLE("<table class=\"default_WTH\">", "</table>", new Token[0]),
    ROW("<tr class=\"%\">", "</tr>", new Token[0]),
    CELL("<td>", "</td>", new Token[0]),
    HCELL("<th>", "</th>", new Token[0]),
    PARAGRPH("<p>", "</p>", new Token[0]),
    BULLET("<ul>", "</ul>", new Token[0]),
    NUMBERED("<ol>", "</ol>", new Token[0]),
    ITEM("<li>", "</li>", Token.BULLET_1, Token.BULLET_2, Token.BULLET_3, Token.NUMBERED_1, Token.NUMBERED_2, Token.NUMBERED_3);

    public final List<Token> token;
    public final String start;
    public final String end;

    private TranslationScheme(String start, String end, Token ... token) {
        this.token = Arrays.asList(token);
        this.start = start;
        this.end = end;
    }

    public static String start(Token token) {
        return TranslationScheme.schemeForToken((Token)token).start;
    }

    public static String start(Token token, Object ... args) {
        String string = TranslationScheme.schemeForToken((Token)token).start;
        return Transformer.format(string, args);
    }

    public static String end(Token token) {
        return TranslationScheme.schemeForToken((Token)token).end;
    }

    private static TranslationScheme schemeForToken(Token token) {
        TranslationScheme[] translationSchemeArray = TranslationScheme.values();
        int n = translationSchemeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TranslationScheme element = translationSchemeArray[n2];
            if (element.token.contains((Object)token)) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

