/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class PathLocation
implements ILocation {
    public static final String STORAGE_ID = "com.ibm.team.filesystem.hfs";
    private IPath path;

    public PathLocation(String path) {
        this.path = new Path(path).makeAbsolute().removeTrailingSeparator();
    }

    public PathLocation(IPath path) {
        if (path == null) {
            path = Path.EMPTY;
        }
        this.path = path.makeAbsolute().removeTrailingSeparator();
        if (this.path.segmentCount() != path.segmentCount()) {
            throw new IllegalStateException(NLS.bind((String)"The provided path {0} was not absolute (became {1})", (Object)path.toString(), (Object)this.path.toString()));
        }
    }

    @Override
    public ILocation append(String name) {
        return new PathLocation(this.path.append(name));
    }

    @Override
    public ILocation append(IRelativeLocation location) {
        IPath anotherPath = location.toPath();
        if (this.path != null) {
            return new PathLocation(this.path.append(anotherPath));
        }
        return this;
    }

    @Override
    public String toOSString() {
        return this.path.toOSString();
    }

    @Override
    public String toString() {
        return this.path.toString();
    }

    @Override
    public String getName() {
        String result = this.path.lastSegment();
        if (result == null) {
            return "";
        }
        return result;
    }

    @Override
    public ILocation getParent() {
        return new PathLocation(this.path.removeLastSegments(1));
    }

    public boolean isHierarchical() {
        return true;
    }

    public Object getAdapter(Class adaptTo) {
        if (adaptTo.isAssignableFrom(IPath.class)) {
            return this.path;
        }
        if (adaptTo.isAssignableFrom(PathLocation.class)) {
            return this;
        }
        if (adaptTo.isAssignableFrom(File.class)) {
            return this.path.toFile();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.path == null ? 0 : this.path.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathLocation other = (PathLocation)obj;
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    @Override
    public ILocation getCanonicalForm() {
        try {
            return new PathLocation(new Path(this.path.toFile().getCanonicalPath()).removeTrailingSeparator());
        }
        catch (IOException iOException) {
            return this;
        }
    }

    @Override
    public ILocation getCanonicalForm(boolean isCaseSensitive, boolean convertCase) {
        if (isCaseSensitive || !convertCase) {
            return this;
        }
        Path p1 = new Path(this.path.toString().toUpperCase().toLowerCase());
        return new PathLocation((IPath)p1);
    }

    @Override
    public boolean isEmpty() {
        return this.path.segmentCount() == 0;
    }

    @Override
    public boolean isPrefixOf(ILocation anotherLocation) {
        IPath anotherPath = (IPath)anotherLocation.getAdapter(IPath.class);
        if (anotherPath == null) {
            return false;
        }
        if (this.path.getDevice() == null ? anotherPath.getDevice() != null : !this.path.getDevice().equalsIgnoreCase(anotherPath.getDevice())) {
            return false;
        }
        if (this.path.isEmpty() || this.path.isRoot() && anotherPath.isAbsolute()) {
            return true;
        }
        int len = this.path.segmentCount();
        if (len > anotherPath.segmentCount()) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!this.path.segment(i).equals(anotherPath.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isCaseSensitive() {
        return !this.path.append("a").toFile().equals(this.path.append("A").toFile());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean sameLocation(ILocation anotherLocation, boolean caseSensitive) {
        if (caseSensitive) {
            return this.equals(anotherLocation);
        }
        if (!(anotherLocation instanceof PathLocation)) {
            return false;
        }
        anotherPath = ((PathLocation)anotherLocation).path;
        if (this.path == null) {
            return anotherPath == null;
        }
        if (anotherPath == null) {
            return false;
        }
        targetSegments = anotherPath.segments();
        segments = this.path.segments();
        i = segments.length;
        if (i == targetSegments.length) ** GOTO lbl17
        return false;
lbl-1000:
        // 1 sources

        {
            if (!(caseSensitive != false ? segments[i].equals(targetSegments[i]) == false : segments[i].equalsIgnoreCase(targetSegments[i]) == false)) continue;
            return false;
lbl17:
            // 2 sources

            ** while (--i >= 0)
        }
lbl18:
        // 1 sources

        device = this.path.getDevice();
        targetDevice = anotherPath.getDevice();
        if (caseSensitive) {
            return device == targetDevice || device != null && device.equals(targetDevice) != false;
        }
        return device == targetDevice || device != null && device.equalsIgnoreCase(targetDevice) != false;
    }

    @Override
    public IRelativeLocation getLocationRelativeTo(ILocation location) {
        IPath anotherPath = (IPath)location.getAdapter(IPath.class);
        if (anotherPath == null || !anotherPath.isPrefixOf(this.path)) {
            throw new IllegalStateException("Location " + location.toString() + " is not a prefix of " + this.path.toString());
        }
        return new RelativeLocation(this.path.removeFirstSegments(anotherPath.segmentCount()).segments());
    }

    @Override
    public boolean isPrefixOf(ILocation anotherLocation, boolean isCaseSensitive) {
        IPath anotherPath = (IPath)anotherLocation.getAdapter(IPath.class);
        if (anotherPath == null) {
            return false;
        }
        if (this.path.getDevice() == null || this.path.getDevice().length() == 0 ? anotherPath.getDevice() != null && anotherPath.getDevice().length() != 0 : !this.path.getDevice().equalsIgnoreCase(anotherPath.getDevice())) {
            return false;
        }
        if (this.path.isEmpty() || this.path.isRoot() && anotherPath.isAbsolute()) {
            return true;
        }
        int len = this.path.segmentCount();
        if (len > anotherPath.segmentCount()) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (isCaseSensitive ? !this.path.segment(i).equals(anotherPath.segment(i)) : !this.path.segment(i).equalsIgnoreCase(anotherPath.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getStorageId() {
        return STORAGE_ID;
    }
}

