/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class Share
implements IShare {
    private ISharingDescriptor descriptor;
    private final IRelativeLocation sharePath;
    private final ILocation cfaRoot;
    private ISandbox sandbox;
    private boolean isCaseSensitive;

    public Share(ILocation cfaRoot, IRelativeLocation sharePath, boolean isCaseSensitive, ISharingDescriptor descriptor) {
        Assert.isNotNull((Object)descriptor, (String)"Sharing Descriptor is null");
        this.descriptor = descriptor;
        this.sharePath = sharePath;
        this.cfaRoot = cfaRoot;
        this.isCaseSensitive = isCaseSensitive;
        this.getTracker();
    }

    @Override
    public ISharingDescriptor getSharingDescriptor() {
        if (this.descriptor == null) {
            throw new IllegalStateException("Not shared anymore");
        }
        return this.descriptor;
    }

    @Override
    public ISandbox getSandbox() {
        if (this.sandbox == null) {
            this.sandbox = new Sandbox(this.cfaRoot);
        }
        return this.sandbox;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.cfaRoot == null ? 0 : this.cfaRoot.hashCode());
        result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        result = 31 * result + (this.sharePath == null ? 0 : this.sharePath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Share other = (Share)obj;
        if (!PathUtils.samePath(this.cfaRoot, this.isCaseSensitive, other.cfaRoot, other.isCaseSensitive)) {
            return false;
        }
        if (this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor)) {
            return false;
        }
        return PathUtils.sameRelativePath(this.sharePath, this.isCaseSensitive, other.sharePath, other.isCaseSensitive);
    }

    public LocalChangeTracker getTracker() {
        return LocalChangeManager.getInstance().getTracker(this.descriptor.getConnectionHandle(), this.descriptor.getComponent(), this.cfaRoot, SharingManager.getInstance().getTrackingRule(this.cfaRoot));
    }

    @Override
    public IRelativeLocation getPath() {
        return this.sharePath;
    }

    public Shareable getShareable(IRelativeLocation relativePath, ResourceType typeHint) {
        return new Shareable(this.cfaRoot, relativePath, typeHint);
    }

    public void refreshChanges(IShareable root, IProgressMonitor monitor) throws FileSystemException {
        LocalChangeManager.getInstance().refreshChanges(root, monitor);
    }

    public void syncChanges(IProgressMonitor monitor) {
        this.getTracker().syncChanges(monitor);
    }

    public String toString() {
        return this.sharePath + " @ " + this.cfaRoot;
    }

    @Override
    public IShareable getShareable() {
        return new Shareable(this.cfaRoot, this.sharePath, ResourceType.getResourceType(this.descriptor.getRootVersionable()));
    }

    public AbstractLock lock(IProgressMonitor monitor) {
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaRoot);
        return ((CopyFileArea)cfa).lock(this.descriptor.getComponent(), this.descriptor.getConnectionHandle(), monitor);
    }

    public void unlock(AbstractLock rule, IProgressMonitor monitor) throws FileSystemException {
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaRoot);
        ((CopyFileArea)cfa).release(rule, monitor);
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public boolean isLoadedWithAnotherName(IProgressMonitor monitor) throws FileSystemException {
        FileItemInfo info = ((Shareable)this.getShareable()).getFileItemInfo(monitor);
        if (info != null) {
            return info.isLoadedWithAnotherName();
        }
        return false;
    }
}

