/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.validator;

import com.ibm.team.filesystem.client.internal.copyfileareas.validator.BTreeContentValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.HeapValidator;
import com.ibm.team.internal.repository.rcp.dbhm.BTreeComparator;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import com.ibm.team.internal.repository.rcp.util.FileChannelUtil;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class BTreeValidator {
    protected static final int DATA_SIZE = 16;
    protected static final int NODE_HEADER_SIZE = 4;
    protected static final int PTR_SIZE = 8;
    protected HeapValidator hv;
    protected BTreeContentValidator btcv;
    protected StringBuilder log;
    protected BTreeComparator comparator;
    protected long keySize;
    protected File queueF;
    protected PersistentDiskBackedHashMap<Long, NodeInfo> queue;
    protected long nextId;

    public BTreeValidator(HeapValidator heapValidator, BTreeContentValidator btcValidator) throws IOException {
        this.hv = heapValidator;
        this.comparator = btcValidator.getComparator();
        this.btcv = btcValidator;
        this.queueF = File.createTempFile("nodeQueue", null);
        boolean success = false;
        try {
            this.queue = new PersistentDiskBackedHashMap<Long, NodeInfo>(this.queueF){

                protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                    return new ObjectInputStream(in).readObject();
                }
            };
            success = true;
        }
        finally {
            if (!success) {
                this.cleanUp();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beginValidation(RAFWrapper raf) {
        long root;
        int nodeSize;
        int keySize;
        this.nextId = 0L;
        this.keySize = 0L;
        this.log = this.hv.getLog();
        byte[] data = this.hv.getBTreeData();
        if (data == null) {
            this.log.append("B-Tree data is null\n");
            return;
        }
        if (data.length != 16) {
            this.log.append("B-Tree data length is " + data.length + "\n");
            return;
        }
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            keySize = in.readInt();
            nodeSize = in.readInt();
            root = in.readLong();
        }
        catch (IOException e) {
            this.logThrowable(e);
            return;
        }
        try {
            this.btcv.beginValidation();
            boolean doCheck = true;
            this.keySize = this.btcv.getKeySize();
            if ((long)keySize != this.keySize) {
                this.log.append("B-Tree key size " + keySize + " doesn't match known key size of " + this.keySize + "\n");
                doCheck = false;
            }
            int m = 0;
            if (nodeSize < 4) {
                this.log.append("B-Tree Node size " + nodeSize + " is invalid\n");
                doCheck = false;
            } else if (keySize > nodeSize) {
                this.log.append("B-Tree Node size " + nodeSize + " is is smaller than key size " + keySize + "\n");
                doCheck = false;
            } else if (keySize > 0) {
                m = (nodeSize - 4 + keySize) / (keySize + 8);
                if (m * (keySize + 8) - keySize + 4 != nodeSize) {
                    this.log.append("B-Tree Node size " + nodeSize + " is not a correct multiple of m(" + m + ") and keySize(" + keySize + ")\n");
                    doCheck = false;
                }
                if (m < 3) {
                    this.log.append("B-Tree Node size " + nodeSize + " is too small for key size of " + keySize + ", must have space for at least 3 children\n");
                    doCheck = false;
                }
            }
            if (root == -1L) {
                return;
            }
            if (root < 0L || root + (long)nodeSize > this.hv.getWorkingAreaSize()) {
                this.log.append("Root node is at an impossibly invalid position " + root + "\n");
                doCheck = false;
            }
            if (!doCheck) {
                return;
            }
            int minKeys = (m & 2) == 0 ? (m >> 1) - 1 : m >> 1;
            ByteBuffer buf = ByteBuffer.allocate(nodeSize);
            NodeInfo info = this.validateNode(root, -1L, -1, 0L, nodeSize, keySize, m, minKeys, raf, buf);
            long depth = -1L;
            long offset = -1L;
            byte[] lastKey = null;
            long keyOffset = -1L;
            int location = 0;
            while (true) {
                long[] children = info.getChildren();
                if (info.getChildren()[0] == -1L) {
                    if (depth != -1L && info.getLevel() != depth) {
                        this.log.append("Leaf node at offset " + info.getOffset() + " is at depth " + info.getLevel() + " while leaf node at offset " + offset + " is at depth " + depth + "\n");
                    }
                    depth = info.getLevel();
                    offset = info.getOffset();
                }
                if (location * keySize <= info.getKeys().length) {
                    if (location != 0) {
                        if (lastKey != null) {
                            if (keyOffset != info.getOffset() && this.comparator.compare(lastKey, info.getKeys(), location * keySize - keySize) > 0) {
                                this.logBadOrder(lastKey, keyOffset, info.getKeys(), location * keySize - keySize, info.getOffset());
                            }
                        } else {
                            lastKey = new byte[keySize];
                        }
                        System.arraycopy(info.getKeys(), location * keySize - keySize, lastKey, 0, keySize);
                        keyOffset = info.getOffset();
                    }
                    if (children[location] == -1L) {
                        ++location;
                        continue;
                    }
                    info = this.validateNode(children[location], info.getId(), location, info.getLevel() + 1L, nodeSize, keySize, m, minKeys, raf, buf);
                    location = 0;
                    continue;
                }
                if (info.getParentId() == -1L) {
                    return;
                }
                location = info.getNumInParent() + 1;
                info = (NodeInfo)this.queue.get((Object)info.getParentId());
            }
        }
        catch (IOException e) {
            this.logThrowable(e);
            return;
        }
        finally {
            this.btcv.endValidation();
        }
    }

    protected NodeInfo validateNode(long offset, long parentId, int numInParent, long level, int nodeSize, int keySize, int m, int minKeys, RAFWrapper raf, ByteBuffer buf) throws IOException {
        this.hv.claim(new HeapValidator.HeapClaimant(offset, nodeSize, "B-Tree node"));
        buf.rewind();
        FileChannelUtil.readFully((ByteBuffer)buf, (long)offset, (RAFWrapper)raf, (boolean)true);
        buf.rewind();
        int numKeys = buf.getInt();
        buf.position(buf.position() + (m - 1) * keySize);
        long[] children = new long[m];
        int numChildren = 0;
        while (numChildren < m) {
            long child = buf.getLong();
            if (child == -1L) {
                children[numChildren] = -1L;
                int i = numChildren + 1;
                while (i < m) {
                    child = buf.getLong();
                    if (child != -1L) {
                        this.log.append("Invalid child offset " + child + " was found following a non-child offset at node " + offset + "\n");
                    }
                    children[i] = -1L;
                    ++i;
                }
                break;
            }
            children[numChildren] = this.validateChild(child, nodeSize) ? child : -1L;
            ++numChildren;
        }
        if (this.nextId == 0L) {
            if (numKeys <= 0 || numKeys >= m) {
                this.log.append("Invalid number of keys " + numKeys + " at root node " + offset + "\n");
            }
        } else if (numKeys < minKeys || numKeys >= m) {
            this.log.append("Invalid number of keys " + numKeys + " at offset " + offset + "\n");
        }
        if (numChildren != 0 && numKeys + 1 != numChildren) {
            this.log.append("Invalid number of keys " + numKeys + " for " + numChildren + " children at node " + offset + "\n");
        } else if (numChildren == 1) {
            this.log.append("Invalid number of children 1 at node " + offset + "\n");
        }
        if (numKeys < 0) {
            numKeys = 0;
        }
        if (numKeys + 1 < numChildren) {
            numKeys = numChildren - 1;
        } else if (numKeys >= m) {
            numKeys = m - 1;
        }
        buf.position(4);
        byte[] keys = new byte[keySize * numKeys];
        buf.get(keys);
        byte[] key = new byte[keySize];
        int keyOffset = 0;
        int i = 1;
        while (i < numKeys) {
            System.arraycopy(keys, keyOffset, key, 0, keySize);
            if (this.comparator.compare(key, keys, keyOffset += keySize) > 0) {
                this.logBadOrder(key, keys, keyOffset, offset);
            }
            this.btcv.validateData(offset, key);
            ++i;
        }
        if (numKeys != 0) {
            System.arraycopy(keys, keys.length - keySize, key, 0, keySize);
            this.btcv.validateData(offset, key);
        }
        NodeInfo info = new NodeInfo(this.nextId++, offset, parentId, numInParent, level, keys, children);
        this.queue.put((Object)info.getId(), (Object)info);
        return info;
    }

    protected boolean validateChild(long offset, long nodeSize) {
        if (offset < 0L || offset + nodeSize > this.hv.getWorkingAreaSize()) {
            this.log.append("Child node is at an impossibly invalid position " + offset + "\n");
            return false;
        }
        return true;
    }

    protected void logBadOrder(byte[] pred, long predOff, byte[] succ, int off, long succOff) {
        this.log.append("The key ");
        this.logKey(pred, 0, pred.length);
        this.log.append(" at node " + predOff + " is greater than its successor ");
        this.logKey(succ, off, pred.length);
        this.log.append(" at node " + succOff + "\n");
    }

    protected void logBadOrder(byte[] pred, byte[] succ, int off, long offset) {
        this.log.append("The key ");
        this.logKey(pred, 0, pred.length);
        this.log.append(" is greater than its neighbour ");
        this.logKey(succ, off, pred.length);
        this.log.append(" at offset " + offset + "\n");
    }

    protected void logKey(byte[] key, int off, int len) {
        int i = off;
        while (i < off + len) {
            this.log.append(Integer.toHexString(key[i]));
            ++i;
        }
    }

    public void endValidation() {
        this.queue.clear();
    }

    public void cleanUp() throws IOException {
        if (this.queueF != null && this.queue != null) {
            try {
                this.queue.close();
                this.queue = null;
            }
            finally {
                this.queueF.delete();
            }
        }
    }

    protected void logThrowable(Throwable e) {
        CharArrayWriter out = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(out);
        e.printStackTrace(pw);
        pw.flush();
        this.log.append(out.toCharArray());
    }

    protected static class NodeInfo
    implements Serializable {
        private static final long serialVersionUID = -6234967042627651012L;
        protected long id;
        protected long offset;
        protected long parentId;
        protected int numInParent;
        protected long level;
        protected byte[] keys;
        protected long[] children;

        public NodeInfo(long id, long offset, long parentId, int numInParent, long level, byte[] keys, long[] children) {
            this.id = id;
            this.offset = offset;
            this.parentId = parentId;
            this.numInParent = numInParent;
            this.level = level;
            this.keys = keys;
            this.children = children;
        }

        public long getId() {
            return this.id;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getParentId() {
            return this.parentId;
        }

        public int getNumInParent() {
            return this.numInParent;
        }

        public long getLevel() {
            return this.level;
        }

        public long[] getChildren() {
            return this.children;
        }

        public byte[] getKeys() {
            return this.keys;
        }
    }
}

