/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.validator;

import com.ibm.team.filesystem.client.internal.copyfileareas.CaseInsensitiveString;
import com.ibm.team.filesystem.client.internal.copyfileareas.ForwardInfo;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.DiskBackedHashMapEntriesValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.HeapValidator;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IFolder;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ItemInfoMapValidator
extends DiskBackedHashMapEntriesValidator {
    private static final int METADATA_VERSION = 1;
    private static final int IS_FOLDER = 1;
    private static final int IS_CONTENT_CHANGED = 2;
    private static final int HAS_PARENT = 4;
    private static final int IS_REMOTE = 8;
    private static final int IS_ORIGINAL_EXECUTABLE = 16;
    private static final int HAS_LINE_DELIMITER = 32;
    private static final int HAS_CURRENT_PROPERTIES = 64;
    private static final int IS_EXECUTABLE = 128;
    private static final int HAS_PREDECESSOR_HINT_HASH = 256;
    private static final int HAS_ORIGINAL_ENCODING = 512;
    private static final int HAS_ORIGINAL_PROPERTIES = 1024;
    private static final int HAS_LAST_CONTENT_CHANGE_CHECK_STAMP = 2048;
    private static final int IS_LOADED_WITH_ANOTHER_NAME = 4096;
    private static final int IS_SYMBOLIC_LINK = 8192;
    protected boolean isCaseSensitive;
    protected File cfaRoot;
    protected IPath subPath;

    public ItemInfoMapValidator(File rootPath, boolean isCaseSensitive, HeapValidator hv, GlobalMetadataValidator gv) throws IOException {
        super(hv, gv);
        this.cfaRoot = rootPath;
        this.isCaseSensitive = isCaseSensitive;
    }

    @Override
    public void beginValidation() throws IOException {
        super.beginValidation();
        if (!this.hv.getHeapFile().getName().equals(".iteminfo.dat")) {
            this.log.append("Invalid item info map file name " + this.hv.getHeapFile() + "\n");
        }
        this.subPath = new Path(this.hv.getHeapFile().getCanonicalPath()).removeFirstSegments(new Path(this.cfaRoot.getCanonicalPath()).segmentCount()).removeLastSegments(1).setDevice(null).makeUNC(false).removeTrailingSeparator().makeAbsolute();
    }

    @Override
    public void validateEntry(long entryOffset, long keyOffset, boolean keyIsHeapADT, long valueOffset, boolean valueIsHeapADT, int hash, RAFWrapper raf) throws IOException {
        if (keyIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on item info key of entry at " + entryOffset + "\n");
        }
        if (valueIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on item info value of entry at " + entryOffset + "\n");
        }
        IPath path = this.validateKey(entryOffset, keyOffset, hash, raf);
        ForwardInfo info = this.validateValue(entryOffset, valueOffset, raf);
        if (path != null && info.getItemId() != null) {
            this.gv.addForwardInfo(path, info);
        }
    }

    protected IPath validateKey(long entryOffset, long keyOffset, int hashCode, RAFWrapper raf) throws IOException {
        if (keyOffset < 0L || keyOffset >= this.hv.getWorkingAreaSize()) {
            this.log.append("The item info key pointer is at an impossible location " + keyOffset + " at " + entryOffset + "\n");
            return null;
        }
        this.setPosition(keyOffset);
        IPath result = null;
        try {
            String name = this.validateString("item info key", keyOffset, "name", raf);
            if (name != null) {
                result = this.subPath.append(name);
                if (!Path.ROOT.isValidSegment(name)) {
                    this.log.append("The item name \"" + name + "\" at offset " + keyOffset + " is not valid\n");
                }
                String hashName = !this.isCaseSensitive ? name.toUpperCase().toLowerCase() : name;
                this.addKey(new CaseInsensitiveString(hashName, name), entryOffset, keyOffset, "item info");
                if (hashCode != hashName.hashCode()) {
                    this.log.append("The entry at " + entryOffset + " contains a hash code (" + hashCode + ") for item info key at " + keyOffset + " with name \"" + name + "\" and hash name \"" + hashName + "\" whose hash code is " + hashName.hashCode() + "\n");
                }
            }
        }
        finally {
            this.hv.claim(new HeapValidator.HeapClaimant(keyOffset, this.getPosition() - keyOffset, "Item Info Key"));
        }
        return result;
    }

    protected ForwardInfo validateValue(long entryOffset, long valueOffset, RAFWrapper raf) throws IOException {
        ForwardInfo result = new ForwardInfo();
        result.setLastContentChangeCheckStamp(-1L);
        result.setLocalSize(-1L);
        result.setRemoteSize(-1L);
        result.setNumLineDelimiters(-1L);
        if (valueOffset < 0L || valueOffset > this.hv.getWorkingAreaSize()) {
            this.log.append("The item info value pointer is at an impossible location " + valueOffset + " at " + entryOffset + "\n");
            return result;
        }
        this.setPosition(valueOffset);
        try {
            long fiFlagsLong = this.validateShort("item info value", valueOffset, "flags", raf);
            if (fiFlagsLong == -1L) {
                ForwardInfo forwardInfo = result;
                return forwardInfo;
            }
            int fiFlags = (int)fiFlagsLong;
            if ((fiFlags & 1) != 0) {
                result.setType(IFolder.ITEM_TYPE);
            } else if ((fiFlags & 0x2000) != 0) {
                result.setType(ISymbolicLink.ITEM_TYPE);
            } else {
                result.setType(IFileItem.ITEM_TYPE);
            }
            boolean isRemote = (fiFlags & 8) != 0;
            String itemId = this.validateUUID("item info value", valueOffset, "item id", raf);
            result.setItemId(itemId);
            if (isRemote) {
                String stateId = this.validateUUID("item info value", valueOffset, "state id", raf);
                result.setStateId(stateId);
            }
            if ((fiFlags & 4) != 0) {
                String parent = this.validateUUID("item info value", valueOffset, "parent folder", raf);
                result.setRemoteParentId(parent);
                String name = this.validateString("item info value", valueOffset, "parent folder name", raf);
                if (name != null && !Path.ROOT.isValidSegment(name)) {
                    this.log.append("The parent name \"" + name + "\" at offset " + valueOffset + " is not valid\n");
                }
                if (result.getStateId() == null) {
                    this.log.append("The item \"" + result.getItemId() + "\" has a remote parent, but no state id at offset " + valueOffset + "\n");
                }
                result.setRemoteName(name);
            } else if (result.getType() != 1 && result.getItemId() != null && result.getStateId() != null) {
                this.log.append("The " + result.getTypeString() + "\"" + result.getItemId() + "\" has a state id, but no remote parent at offset " + valueOffset + "\n");
            }
            boolean loadedWithAnotherName = (fiFlags & 0x1000) != 0;
            result.setLoadedWithAnotherName(loadedWithAnotherName);
            if (result.getType() == 0) {
                if ((fiFlags & 0x20) == 32) {
                    long lineDb = this.validateInt("item info value", valueOffset, "line dilimeter", raf);
                    if (lineDb == -1L) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    result.setLocalLineDelimiter(this.validateLineDelimeter((int)lineDb, "item info value", valueOffset, "line dilimeter"));
                }
                result.setContentChanged((fiFlags & 2) != 0);
                result.setLocalExecutable((fiFlags & 0x80) != 0);
                result.setRemoteExecutable((fiFlags & 0x10) != 0);
                String contentType = null;
                if ((fiFlags & 0x40) != 0) {
                    long numFileItemProperties = this.validateInt("item info value", valueOffset, "property count", raf);
                    if (numFileItemProperties == -1L) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    int i = 0;
                    while ((long)i < numFileItemProperties) {
                        String propertyName = this.validateString("item info value", valueOffset, "property name", raf);
                        String propertyValue = this.validateString("item info value", valueOffset, "property value", raf);
                        if (propertyName.equals("contentType")) {
                            contentType = propertyValue;
                        }
                        ++i;
                    }
                }
                result.setLocalContentType(contentType);
                if (isRemote) {
                    long[] scs;
                    if ((fiFlags & 0x800) != 0) {
                        long[] cs = this.validateLong("item info value", valueOffset, "change check stamp", raf);
                        if (cs[1] == -1L) {
                            ForwardInfo forwardInfo = result;
                            return forwardInfo;
                        }
                        result.setLastContentChangeCheckStamp(cs[0]);
                        if (result.getLastContentChangeCheckStamp() == -1L) {
                            this.log.append("File \"" + result.getItemId() + "\" has null check stamp " + " at " + valueOffset + "\n");
                        }
                    }
                    ContentHash hash = this.validateContentHash("item info value", valueOffset, "hash", raf);
                    result.setLocalHash(hash);
                    long[] length = this.validateLong("item info value", valueOffset, "content length", raf);
                    if (length[1] == -1L) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    result.setLocalSize(length[0]);
                    long db = this.validateInt("item info value", valueOffset, "original line dilimeter", raf);
                    if (db == -1L) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    result.setRemoteLineDelimiter(this.validateLineDelimeter((int)db, "item info value", valueOffset, "original line dilimeter"));
                    String originalContentType = null;
                    if ((fiFlags & 0x400) != 0) {
                        long numFileItemProperties = this.validateInt("item info value", valueOffset, "original property count", raf);
                        if (numFileItemProperties == -1L) {
                            ForwardInfo forwardInfo = result;
                            return forwardInfo;
                        }
                        int i = 0;
                        while ((long)i < numFileItemProperties) {
                            String propertyName = this.validateString("item info value", valueOffset, "property name", raf);
                            String propertyValue = this.validateString("item info value", valueOffset, "property value", raf);
                            if (propertyName.equals("contentType")) {
                                originalContentType = propertyValue;
                            }
                            ++i;
                        }
                    }
                    result.setRemoteContentType(originalContentType);
                    if ((fiFlags & 0x100) != 0) {
                        ContentHash predecessorHintHash = this.validateContentHash("item info value", valueOffset, "predecessor hint hash", raf);
                        result.setPredecessorHintHash(predecessorHintHash);
                    }
                    if ((scs = this.validateLong("item info value", valueOffset, "stored content size", raf))[1] == -1L) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    result.setRemoteSize(scs[0]);
                    if ((fiFlags & 0x200) != 0) {
                        String encoding = this.validateString("item info value", valueOffset, "original encoding", raf);
                        result.setRemoteEncoding(encoding);
                    }
                    ContentHash storedHash = this.validateContentHash("item info value", valueOffset, "stored hash", raf);
                    result.setRemoteHash(storedHash);
                    long originalContentPropertiesSize = this.validateInt("item info value", valueOffset, "original content property count", raf);
                    if (originalContentPropertiesSize == -1L) {
                        ForwardInfo forwardInfo = result;
                        return forwardInfo;
                    }
                    int i = 0;
                    while ((long)i < originalContentPropertiesSize) {
                        String propertyName = this.validateString("item info value", valueOffset, "property name", raf);
                        String propertyValue = this.validateString("item info value", valueOffset, "property value", raf);
                        if (propertyName.equals("numLineDelim")) {
                            result.setNumLineDelimiters(Long.parseLong(propertyValue));
                        }
                        ++i;
                    }
                }
            } else if (result.getType() == 2) {
                result.setContentChanged((fiFlags & 2) != 0);
                if (isRemote) {
                    ContentHash hash = this.validateContentHash("inverse item info value", valueOffset, "hash", raf);
                    result.setLocalHash(hash);
                    ContentHash storedHash = this.validateContentHash("inverse item info value", valueOffset, "stored hash", raf);
                    result.setRemoteHash(storedHash);
                }
            }
        }
        finally {
            this.hv.claim(new HeapValidator.HeapClaimant(valueOffset, this.getPosition() - valueOffset, "Item Info Value"));
        }
        return result;
    }

    @Override
    public boolean validateCustomMetadata(DataInputStream in) throws IOException {
        int v = in.readInt();
        if (v != 1) {
            this.log.append("Metadata version mismatch for item info map: " + v + " != " + 1);
            return false;
        }
        return true;
    }
}

