/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.era;

import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.scm.common.IChangeHistoryEntry;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class DeliveryInfo {
    private ItemId<IChangeSet> changeSet;
    private ItemId<IContributor> deliveredBy;
    private Date timestamp;

    public DeliveryInfo(IChangeHistoryEntryChange historyEntry) {
        this((ItemId<IChangeSet>)new ItemId((IItemHandle)historyEntry.changeSet()), (ItemId<IContributor>)(historyEntry.createdBy() != null ? new ItemId((IItemHandle)historyEntry.createdBy()) : ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE)), historyEntry.creationDate());
    }

    public DeliveryInfo(ItemId<IChangeSet> changeSet, ItemId<IContributor> deliveredBy, Date timestamp) {
        this.changeSet = changeSet;
        this.deliveredBy = deliveredBy;
        this.timestamp = timestamp;
    }

    public ItemId<IChangeSet> getChangeSet() {
        return this.changeSet;
    }

    public ItemId<IContributor> getDeliveredBy() {
        return this.deliveredBy;
    }

    public Date getDeliveryDate() {
        return this.timestamp;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.changeSet == null ? 0 : this.changeSet.hashCode());
        result = 31 * result + (this.deliveredBy == null ? 0 : this.deliveredBy.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeliveryInfo other = (DeliveryInfo)obj;
        if (this.changeSet == null ? other.changeSet != null : !this.changeSet.equals(other.changeSet)) {
            return false;
        }
        if (this.deliveredBy == null ? other.deliveredBy != null : !this.deliveredBy.equals(other.deliveredBy)) {
            return false;
        }
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
    }

    public static List<DeliveryInfo> createFromChangeHistory(List<? extends IChangeHistoryEntry> history) {
        ArrayList<DeliveryInfo> result = new ArrayList<DeliveryInfo>(history.size());
        for (IChangeHistoryEntry iChangeHistoryEntry : history) {
            if (!(iChangeHistoryEntry instanceof IChangeHistoryEntryChange)) continue;
            result.add(new DeliveryInfo((IChangeHistoryEntryChange)iChangeHistoryEntry));
        }
        return result;
    }

    public static List<ItemId<IChangeSet>> getChangeSetList(List<DeliveryInfo> info) {
        ArrayList changeSets = NewCollection.arrayList();
        for (DeliveryInfo next : info) {
            changeSets.add(next.getChangeSet());
        }
        return changeSets;
    }

    public String toString() {
        return "DeliveryInfo(" + this.changeSet.getItemUUID().getUuidValue() + ", " + this.timestamp.toLocaleString() + ")";
    }
}

