/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.era;

import com.ibm.team.filesystem.client.internal.era.EraSyncReportFragment;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EraSyncReport {
    private EraSyncReportFragment incoming;
    private EraSyncReportFragment outgoing;

    public EraSyncReport() {
        this.incoming = EraSyncReportFragment.emptyReport();
        this.outgoing = EraSyncReportFragment.emptyReport();
    }

    public EraSyncReport(EraSyncReportFragment incoming, EraSyncReportFragment outgoing) {
        this.incoming = incoming;
        this.outgoing = outgoing;
    }

    public EraSyncReport(List<ItemId<IChangeSet>> incoming, List<ItemId<IChangeSet>> outgoing) {
        this(new EraSyncReportFragment(incoming), new EraSyncReportFragment(outgoing));
    }

    public EraSyncReport(List<ItemId<IChangeSet>> incoming, List<ItemId<IChangeSet>> outgoing, Set<ItemId<IChangeSet>> incomingCloses, Set<ItemId<IChangeSet>> outgoingCloses, Map<ItemId<IChangeSet>, StateId<IChangeSet>> incomingActiveChanges, Map<ItemId<IChangeSet>, StateId<IChangeSet>> outgoingActiveChanges) {
        this(new EraSyncReportFragment(incoming, incomingActiveChanges, incomingCloses), new EraSyncReportFragment(outgoing, outgoingActiveChanges, outgoingCloses));
    }

    public EraSyncReportFragment getIncoming() {
        return this.incoming;
    }

    public EraSyncReportFragment getOutgoing() {
        return this.outgoing;
    }

    public List<ItemId<IChangeSet>> getIncomingIds() {
        return this.incoming.getChangeSets();
    }

    public List<ItemId<IChangeSet>> getOutgoingIds() {
        return this.outgoing.getChangeSets();
    }

    public EraSyncReport append(EraSyncReport other) {
        List allIncoming = EraSyncReport.append(this.incoming.getChangeSets(), other.getIncomingIds());
        List allOutgoing = EraSyncReport.append(this.outgoing.getChangeSets(), other.getOutgoingIds());
        List finalIncoming = EraSyncReport.filterDupes(allIncoming, allOutgoing);
        List finalOutgoing = EraSyncReport.filterDupes(allOutgoing, allIncoming);
        Set<ItemId<IChangeSet>> allIncomingClosed = EraSyncReport.union(this.incoming.getCloses(), other.getIncoming().getCloses());
        Set<ItemId<IChangeSet>> allOutgoingClosed = EraSyncReport.union(this.outgoing.getCloses(), other.getOutgoing().getCloses());
        Set finalIncomingClosed = this.filter(allIncomingClosed, allOutgoingClosed);
        Set finalOutgoingClosed = this.filter(allOutgoingClosed, allIncomingClosed);
        Set<ItemId<IChangeSet>> allClosed = EraSyncReport.union(allIncomingClosed, allOutgoingClosed);
        Map<ItemId<IChangeSet>, StateId<IChangeSet>> allIncomingChanges = this.computeChanges(this.getIncoming().getActiveChangeStates(), other.getIncoming().getActiveChangeStates(), allClosed);
        Map<ItemId<IChangeSet>, StateId<IChangeSet>> allOutgoingChanges = this.computeChanges(this.getOutgoing().getActiveChangeStates(), other.getOutgoing().getActiveChangeStates(), allClosed);
        return new EraSyncReport(finalIncoming, finalOutgoing, finalIncomingClosed, finalOutgoingClosed, allIncomingChanges, allOutgoingChanges);
    }

    private static List filterDupes(List source, Collection filter) {
        if (filter.isEmpty() || source.isEmpty()) {
            return source;
        }
        ArrayList result = new ArrayList();
        HashSet blocked = new HashSet(filter);
        blocked.addAll(filter);
        for (Object next : source) {
            if (blocked.contains(next)) continue;
            blocked.add(next);
            result.add(next);
        }
        return result;
    }

    private static List append(List list1, List list2) {
        if (list2.isEmpty()) {
            return list1;
        }
        if (list1.isEmpty()) {
            return list2;
        }
        ArrayList result = new ArrayList();
        result.addAll(list1);
        result.addAll(list2);
        return result;
    }

    private Set filter(Set input, Set toExclude) {
        if (toExclude.isEmpty()) {
            return input;
        }
        HashSet result = new HashSet();
        for (Object next : input) {
            if (toExclude.contains(next)) continue;
            result.add(next);
        }
        return result;
    }

    private static <T> Set<T> union(Set<T> set1, Set<T> set2) {
        if (set1.isEmpty()) {
            return set2;
        }
        if (set2.isEmpty()) {
            return set1;
        }
        HashSet result = NewCollection.hashSet();
        result.addAll(set1);
        result.addAll(set2);
        return result;
    }

    private Map<ItemId<IChangeSet>, StateId<IChangeSet>> computeChanges(Map<ItemId<IChangeSet>, StateId<IChangeSet>> firstInputSet, Map<ItemId<IChangeSet>, StateId<IChangeSet>> overrideInputSet, Set<ItemId<IChangeSet>> filterSet) {
        ItemId itemId;
        if (firstInputSet.isEmpty() && overrideInputSet.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap stateSelections = NewCollection.hashMap();
        for (StateId<IChangeSet> next : firstInputSet.values()) {
            itemId = next.getItemId();
            if (filterSet.contains(itemId)) continue;
            stateSelections.put(itemId, next);
        }
        for (StateId<IChangeSet> next : overrideInputSet.values()) {
            itemId = next.getItemId();
            if (filterSet.contains(itemId)) continue;
            stateSelections.put(itemId, next);
        }
        return stateSelections;
    }
}

