/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LoadOverlap
implements ILoadOverlap {
    private IConnection connection;
    private IComponentHandle component;
    private ArrayList<IAncestorReport> overlappingItems;
    private ArrayList<IShare> overlappingShares;
    private IAncestorReport overlappedItem;
    private ISandbox sandbox;

    public LoadOverlap(ISandbox sandbox, IConnection connection, IComponentHandle component, IAncestorReport overlappedAncestors) {
        this.sandbox = sandbox;
        this.connection = connection;
        this.component = component;
        this.overlappedItem = overlappedAncestors;
        this.overlappingItems = new ArrayList();
        this.overlappingShares = new ArrayList();
    }

    @Override
    public ISandbox getSandbox() {
        return this.sandbox;
    }

    @Override
    public IComponentHandle getComponent() {
        return this.component;
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    @Override
    public IVersionableHandle getItem() {
        return this.getVersionableRepresented(this.overlappedItem);
    }

    @Override
    public String[] getPath() {
        return this.getPathRepresented(this.overlappedItem);
    }

    @Override
    public Collection<IShare> getOverlappingShares() {
        return Collections.unmodifiableCollection(this.overlappingShares);
    }

    @Override
    public Map<IVersionableHandle, String[]> getOverlappingItems() {
        HashMap<IVersionableHandle, String[]> result = new HashMap<IVersionableHandle, String[]>();
        for (IAncestorReport overlapped : this.overlappingItems) {
            result.put(this.getVersionableRepresented(overlapped), this.getPathRepresented(overlapped));
        }
        return result;
    }

    public void addOverlappingItem(IAncestorReport item) {
        this.overlappingItems.add(item);
    }

    public void addOverlappingShare(IShare share) {
        this.overlappingShares.add(share);
    }

    private IVersionableHandle getVersionableRepresented(IAncestorReport report) {
        List pairs = report.getNameItemPairs();
        INameItemPair item = (INameItemPair)pairs.get(pairs.size() - 1);
        return item.getItem();
    }

    private String[] getPathRepresented(IAncestorReport report) {
        List pairs = report.getNameItemPairs();
        String[] result = new String[pairs.size() - 1];
        int i = 0;
        Iterator iPairs = pairs.iterator();
        iPairs.next();
        while (iPairs.hasNext()) {
            INameItemPair pair = (INameItemPair)iPairs.next();
            result[i] = pair.getName();
            ++i;
        }
        return result;
    }
}

