/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules.builders;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ILoadRuleBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.RuleBuilder;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import org.xml.sax.Attributes;

public class ComponentBuilder
implements ILoadRuleBuilder {
    private RuleBuilder ruleBuilder;
    private String componentName;
    private IComponentHandle componentHandle;

    public ComponentBuilder(RuleBuilder ruleBuilder) {
        this.ruleBuilder = ruleBuilder;
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws FileSystemException {
    }

    @Override
    public void endElement(String eName) throws TeamRepositoryException {
        if (eName.equals("component")) {
            if (this.componentName != null) {
                this.ruleBuilder.setComponentName(this.componentName);
            } else {
                this.ruleBuilder.setComponentHandle(this.componentHandle);
            }
        } else {
            throw new FileSystemException(NLS.bind((String)Messages.ComponentBuilder_2, (Object)eName, (Object[])new Object[0]));
        }
    }

    @Override
    public ILoadRuleBuilder startElement(String eName, Attributes attrs) throws FileSystemException {
        ComponentBuilder builder;
        if (eName.equals("component")) {
            builder = this;
            int i = 0;
            while (i < attrs.getLength()) {
                String attrName = attrs.getQName(i);
                String value = attrs.getValue(i);
                if ("itemId".equals(attrName)) {
                    UUID uuid;
                    try {
                        uuid = UUID.valueOf((String)value);
                    }
                    catch (IllegalArgumentException e) {
                        throw new FileSystemException(NLS.bind((String)Messages.ComponentBuilder_6, (Object)"itemId", (Object[])new Object[]{value, "component"}), e);
                    }
                    this.componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(uuid, null);
                } else if ("name".equals(attrName)) {
                    this.componentName = value;
                } else {
                    throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_6, (Object)attrName, (Object[])new Object[]{value}));
                }
                ++i;
            }
            if (this.componentHandle == null && this.componentName == null) {
                throw new FileSystemException(NLS.bind((String)Messages.ComponentBuilder_4, (Object)"name", (Object[])new Object[]{"itemId"}));
            }
            if (this.componentHandle != null && this.componentName != null) {
                throw new FileSystemException(NLS.bind((String)Messages.ComponentBuilder_5, (Object)"name", (Object[])new Object[]{"itemId"}));
            }
        } else {
            throw new FileSystemException(NLS.bind((String)Messages.ComponentBuilder_3, (Object)eName, (Object[])new Object[0]));
        }
        return builder;
    }
}

