/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeListener;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileOptions;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.Trace;
import com.ibm.team.filesystem.client.internal.api.storage.ContentMeta;
import com.ibm.team.filesystem.client.internal.content.DeletedContent;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNode;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.localchanges.LocalDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalModification;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveFrom;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveTo;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.client.internal.operations.IUpdateMutator;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.FilesystemFactory;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LocalChangeUndoReport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.scm.common.VersionedContentDeleted;
import com.ibm.team.scm.common.internal.dto.ComponentStateSummary;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.SynchronizationTime;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class LocalChangeManager
implements ILocalChangeManager {
    private static final String LOCAL_CHANGE_TRACING = "jazz.scm.localchange.trace";
    private Object avoidNotification = new Object();
    private int avoidNotificationCount = 0;
    public static final ILocalChange[] NO_CHANGES = new ILocalChange[0];
    private static volatile LocalChangeManager instance;
    public static String RECOMPUTE_PENDING_CHANGES_FAMILY;
    private static boolean tracingStateInitialized;
    private static PrintStream traceStream;
    private Set<RefreshRequest> toRefresh = new HashSet<RefreshRequest>();
    private Object refreshLock = new Object();
    private Map<LocalChangeContext, LocalChangeTracker> trackers = new HashMap<LocalChangeContext, LocalChangeTracker>();
    private LocalChangeNotifier notifier = new LocalChangeNotifier();
    private RecomputePendingChangesJob recomputeJob = new RecomputePendingChangesJob();
    private int refreshesRunning = 0;
    private static final String BACKUP_NAME = "#apo";

    static {
        RECOMPUTE_PENDING_CHANGES_FAMILY = RecomputePendingChangesJob.class.getName();
        tracingStateInitialized = false;
        traceStream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalChangeManager getInstance() {
        LocalChangeManager i = instance;
        if (i != null) return i;
        Class<LocalChangeManager> clazz = LocalChangeManager.class;
        synchronized (LocalChangeManager.class) {
            i = instance;
            if (i != null) return i;
            instance = i = new LocalChangeManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceLocalChangeInfo(String info) {
        String string = LOCAL_CHANGE_TRACING;
        synchronized (LOCAL_CHANGE_TRACING) {
            if (!tracingStateInitialized) {
                String toTrace = System.getProperty(LOCAL_CHANGE_TRACING);
                if ("true".equalsIgnoreCase(toTrace)) {
                    traceStream = System.out;
                } else if (toTrace != null) {
                    try {
                        traceStream = new PrintStream(new File(toTrace));
                    }
                    catch (FileNotFoundException e) {
                        LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                    }
                }
                tracingStateInitialized = true;
            }
            if (traceStream != null) {
                traceStream.println(String.valueOf(new Date().toString()) + " " + info);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private LocalChangeManager() {
    }

    @Override
    public void addLocalChangeListener(ILocalChangeListener listener) {
        this.notifier.addListener(listener);
    }

    public String getProgressDescription(ILocalChange change) {
        if ((change instanceof LocalModification || change instanceof LocalAddition) && change.getTarget() instanceof IFileItemHandle) {
            return NLS.bind((String)Messages.LocalChangeManager_3, (Object)change.getPath());
        }
        if (change instanceof LocalDeletion) {
            return NLS.bind((String)Messages.LocalChangeManager_4, (Object)change.getPath());
        }
        if (change instanceof LocalAddition) {
            return NLS.bind((String)Messages.LocalChangeManager_5, (Object)change.getPath());
        }
        if (change instanceof LocalMoveFrom) {
            return NLS.bind((String)Messages.LocalChangeManager_7, (Object)change.getPath());
        }
        if (change instanceof LocalMoveTo) {
            return NLS.bind((String)Messages.LocalChangeManager_8, (Object)change.getResultingPath());
        }
        LoggingHelper.log(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.LocalChangeManager_9, (Object)this.getClass().getName())));
        return Messages.LocalChangeManager_10;
    }

    public void cancelChanges(IShare share) {
        LocalChangeTracker tracker = this.findTracker(share);
        if (tracker != null) {
            tracker.cancelChanges(tracker.getPendingChanges(share.getPath(), false));
        }
    }

    private LocalChangeTracker findTracker(IShare share) {
        ISharingDescriptor desc = share.getSharingDescriptor();
        return this.findTracker(desc.getConnectionHandle(), desc.getComponent(), share.getSandbox().getRoot());
    }

    private Map<LocalChangeContext, List<ILocalChange>> getChangesMap(ILocalChange[] changes) {
        HashMap<LocalChangeContext, List<ILocalChange>> changesMap = new HashMap<LocalChangeContext, List<ILocalChange>>();
        ILocalChange[] iLocalChangeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange c = iLocalChangeArray[n2];
            LocalChangeContext ctx = ((LocalChange)c).context;
            if (ctx != null) {
                ArrayList<ILocalChange> changesList = (ArrayList<ILocalChange>)changesMap.get(ctx);
                if (changesList == null) {
                    changesList = new ArrayList<ILocalChange>();
                    changesMap.put(ctx, changesList);
                }
                changesList.add(c);
            }
            ++n2;
        }
        return changesMap;
    }

    public void cancelChanges(ILocalChange[] canceled) {
        for (Map.Entry<LocalChangeContext, List<ILocalChange>> entry : this.getChangesMap(canceled).entrySet()) {
            LocalChangeTracker tracker = this.findTracker(entry.getKey());
            tracker.cancelChanges(entry.getValue().toArray(new ILocalChange[entry.getValue().size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingChanges(IContextHandle connection, IComponentHandle component, ILocation cfaRoot) {
        LocalChangeTracker tracker = null;
        Map<LocalChangeContext, LocalChangeTracker> map = this.trackers;
        synchronized (map) {
            tracker = this.trackers.remove(new LocalChangeContext(component, connection, cfaRoot));
        }
        if (tracker != null) {
            tracker.cancelAllChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingChanges(ILocation cfaRoot) {
        ArrayList<LocalChangeTracker> removed = new ArrayList<LocalChangeTracker>();
        Map<LocalChangeContext, LocalChangeTracker> map = this.trackers;
        synchronized (map) {
            Iterator<Map.Entry<LocalChangeContext, LocalChangeTracker>> i = this.trackers.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<LocalChangeContext, LocalChangeTracker> entry = i.next();
                LocalChangeContext c = entry.getKey();
                if (!c.getRoot().equals(cfaRoot)) continue;
                removed.add(entry.getValue());
                i.remove();
            }
        }
        for (LocalChangeTracker lct : removed) {
            lct.shutdown();
        }
    }

    public void commitChanges(ILocalChange[] committed) {
        for (Map.Entry<LocalChangeContext, List<ILocalChange>> entry : this.getChangesMap(committed).entrySet()) {
            LocalChangeTracker tracker = this.findTracker(entry.getKey());
            tracker.confirmChanges(entry.getValue().toArray(new ILocalChange[entry.getValue().size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void refreshSynchronously(IShareable refreshRoot, ILocalChangeManager.RefreshType traversalType, IProgressMonitor progress) throws FileSystemException {
        LocalChangeContext context;
        ILocalChange[] newChanges;
        ILocalChange[] existingChanges;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        LocalChangeNotifier.disableChangeNotification();
        try {
            ISchedulingRule trackingRule = SharingManager.getInstance().getTrackingRule(refreshRoot.getSandbox().getRoot());
            try {
                Job.getJobManager().beginRule(trackingRule, (IProgressMonitor)monitor.newChild(1));
                AbstractLock rule = null;
                try {
                    rule = CFALockUtil.createAndLockForUpdate(refreshRoot.getSandbox().getRoot(), refreshRoot.getLocalPath(), true, (IProgressMonitor)monitor.newChild(1));
                }
                catch (IllegalStateException illegalStateException) {
                    this.addToRefresh(refreshRoot, traversalType);
                    Job.getJobManager().endRule(trackingRule);
                    LocalChangeNotifier.enableChangeNotification();
                    return;
                }
                if (rule == null) {
                    return;
                }
                try {
                    LocalChangeTracker tracker;
                    IShare share = refreshRoot.getShare((IProgressMonitor)monitor.newChild(1));
                    if (share == null) {
                        return;
                    }
                    LocalChangeTracker localChangeTracker = tracker = ((Share)share).getTracker();
                    synchronized (localChangeTracker) {
                        existingChanges = tracker.getPendingChanges(true);
                        LocalChangeTracker.computePendingChanges(refreshRoot, traversalType, (IProgressMonitor)monitor.newChild(93));
                        tracker.syncChanges((IProgressMonitor)monitor.newChild(5));
                        newChanges = tracker.getPendingChanges();
                    }
                    context = tracker.getContext();
                }
                finally {
                    if (rule != null) {
                        CFALockUtil.endBatching(rule, (IProgressMonitor)monitor.newChild(1));
                    }
                }
            }
            finally {
                Job.getJobManager().endRule(trackingRule);
            }
        }
        finally {
            LocalChangeNotifier.enableChangeNotification();
        }
        this.notifier.changesCanceled(context, existingChanges);
        this.notifier.changesOccurred(context, newChanges);
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void refreshSynchronously(ISandbox sandbox, Map<IShare, Collection<RefreshRequest>> toRefresh, IProgressMonitor progress) throws FileSystemException {
        monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(17 * toRefresh.size() + 1));
        existingChanges = new HashMap<LocalChangeContext, List<ILocalChange>>();
        newChanges = new HashMap<LocalChangeContext, List<ILocalChange>>();
        LocalChangeNotifier.disableChangeNotification();
        try {
            shareables = new HashSet<IShareable>();
            lockEntireIDE = false;
            block14: for (Map.Entry<IShare, Collection<RefreshRequest>> entry : toRefresh.entrySet()) {
                shareables.add(entry.getKey().getShareable());
                if (lockEntireIDE) continue;
                for (RefreshRequest refreshRequest : entry.getValue()) {
                    if (!RefreshRequest.access$0(refreshRequest)) continue;
                    lockEntireIDE = true;
                    continue block14;
                }
            }
            trackingRule = lockEntireIDE != false ? SharingManager.getInstance().makeSchedulingRuleForIDE() : SharingManager.getInstance().makeSchedulingRuleForIDE(shareables);
            try {
                Job.getJobManager().beginRule(trackingRule, (IProgressMonitor)monitor.newChild(1));
                block16: for (Map.Entry<IShare, Collection<RefreshRequest>> entry : toRefresh.entrySet()) {
                    block22: {
                        share = entry.getKey();
                        rule = null;
                        try {
                            rule = CFALockUtil.createAndLockForUpdate(sandbox.getRoot(), share.getShareable().getLocalPath(), true, (IProgressMonitor)monitor.newChild(1));
                            break block22;
                        }
                        catch (IllegalStateException v0) {
                            ** for (req : entry.getValue())
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.addToRefresh(req.getRootShareable(), req.getTraversalType());
                            continue;
lbl30:
                            // 1 sources

                            continue block16;
                        }
                    }
                    if (rule == null) continue;
                    try {
                        var17_18 = tracker = ((Share)share).getTracker();
                        synchronized (var17_18) {
                            ec = Arrays.asList(tracker.getPendingChanges(true));
                            monitor2 = SubMonitor.convert((IProgressMonitor)monitor.newChild(10), (int)entry.getValue().size());
                            for (RefreshRequest request : entry.getValue()) {
                                LocalChangeTracker.computePendingChanges(request.getRootShareable(), request.getTraversalType(), (IProgressMonitor)monitor2.newChild(1));
                            }
                            monitor2.done();
                            tracker.syncChanges((IProgressMonitor)monitor.newChild(5));
                            nc = Arrays.asList(tracker.getPendingChanges());
                        }
                        existingChanges.put(tracker.getContext(), ec);
                        newChanges.put(tracker.getContext(), nc);
                    }
                    finally {
                        if (rule != null) {
                            CFALockUtil.endBatching(rule, (IProgressMonitor)monitor.newChild(1));
                        }
                    }
                }
            }
            finally {
                Job.getJobManager().endRule(trackingRule);
            }
        }
        finally {
            LocalChangeNotifier.enableChangeNotification();
        }
        for (Map.Entry<K, V> entry : existingChanges.entrySet()) {
            this.notifier.changesCanceled((LocalChangeContext)entry.getKey(), ((List)entry.getValue()).toArray(new ILocalChange[0]));
        }
        for (Map.Entry<K, V> entry : newChanges.entrySet()) {
            this.notifier.changesOccurred((LocalChangeContext)entry.getKey(), ((List)entry.getValue()).toArray(new ILocalChange[0]));
        }
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doRefresh(IProgressMonitor monitor) throws FileSystemException {
        var3_2 = this.refreshLock;
        synchronized (var3_2) {
            ++this.refreshesRunning;
            if (!this.toRefresh.isEmpty()) ** break block23
            // MONITOREXIT @DISABLED, blocks:[0, 1, 8] lbl7 : MonitorExitStatement: MONITOREXIT : var3_2
            var13_3 = this.refreshLock;
        }
        synchronized (var13_3) {
            --this.refreshesRunning;
            this.refreshLock.notifyAll();
        }
        return;
        {
            try {
                snapshot = this.toRefresh;
                this.toRefresh = new HashSet<RefreshRequest>();
                // MONITOREXIT @DISABLED, blocks:[3, 4, 8] lbl23 : MonitorExitStatement: MONITOREXIT : var3_2
                {
                    catch (Throwable v1) {
                        throw v1;
                    }
                }
                progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LocalChangeManager_11, (int)(snapshot.size() * 2));
                organizedRequests = new HashMap<ISandbox, HashMap<K, V>>();
                for (RefreshRequest request : snapshot) {
                    shareable = request.getStartingPoint();
                    share = shareable.getShare((IProgressMonitor)progress.newChild(1));
                    if (share == null) continue;
                    sandbox = share.getSandbox();
                    requestsByShare = (HashMap<IShare, ArrayList<RefreshRequest>>)organizedRequests.get(sandbox);
                    if (requestsByShare == null) {
                        requestsByShare = new HashMap<IShare, ArrayList<RefreshRequest>>();
                        organizedRequests.put(sandbox, requestsByShare);
                    }
                    if ((requests = (ArrayList<RefreshRequest>)requestsByShare.get(share)) == null) {
                        requests = new ArrayList<RefreshRequest>();
                        requestsByShare.put(share, requests);
                    }
                    requests.add(request);
                }
                currentTime = System.currentTimeMillis();
                try {
                    for (Map.Entry<K, V> entry : organizedRequests.entrySet()) {
                        this.refreshSynchronously((ISandbox)entry.getKey(), (Map)entry.getValue(), (IProgressMonitor)progress.newChild(1));
                    }
                }
                finally {
                    progress.done();
                }
                LocalChangeManager.traceLocalChangeInfo("Finished recompute in " + (int)((System.currentTimeMillis() - currentTime) / 1000L) + " seconds.");
            }
            catch (Throwable var12_17) {
                var13_4 = this.refreshLock;
                synchronized (var13_4) {
                    --this.refreshesRunning;
                    this.refreshLock.notifyAll();
                }
                throw var12_17;
            }
        }
        var13_5 = this.refreshLock;
        synchronized (var13_5) {
            --this.refreshesRunning;
            this.refreshLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalChangeTracker findTracker(LocalChangeContext ctx) {
        Map<LocalChangeContext, LocalChangeTracker> map = this.trackers;
        synchronized (map) {
            block5: {
                LocalChangeTracker tracker = this.trackers.get(ctx);
                if (tracker != null) {
                    return tracker;
                }
                if (ICopyFileAreaManager.instance.copyFileAreaExists(ctx.getRoot(), 0)) break block5;
                return null;
            }
            return this.getTracker(ctx.getConnection(), ctx.getComponent(), ctx.getRoot(), SharingManager.getInstance().getTrackingRule(ctx.getRoot()));
        }
    }

    public LocalChangeTracker findTracker(IContextHandle connection, IComponentHandle component, ILocation cfaRoot) {
        return this.findTracker(new LocalChangeContext(component, connection, cfaRoot));
    }

    @Override
    public ILocalChange getPendingChange(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShare share = shareable.getShare((IProgressMonitor)progress.newChild(50));
        if (share == null) {
            return NoOpChange.NO_OP;
        }
        return this.getPendingChange(share, shareable.getVersionable((IProgressMonitor)progress.newChild(50)));
    }

    @Override
    public ILocalChange getPendingChange(IShare share, IVersionableHandle versionable) {
        LocalChangeTracker tracker = this.findTracker(share.getSharingDescriptor().getConnectionHandle(), share.getSharingDescriptor().getComponent(), share.getSandbox().getRoot());
        return tracker == null ? NoOpChange.NO_OP : tracker.getPendingChange(versionable);
    }

    @Override
    public void syncPendingChanges(IContextHandle connection, IComponentHandle component, ISandbox sandbox, IProgressMonitor monitor) {
        LocalChangeTracker tracker = this.findTracker(connection, component, sandbox.getRoot());
        if (tracker != null) {
            tracker.syncChanges(monitor);
        }
    }

    @Override
    public ILocalChange[] getPendingChanges(IContextHandle connection, IComponentHandle component, ISandbox sandbox) {
        LocalChangeTracker tracker = this.findTracker(connection, component, sandbox.getRoot());
        if (tracker == null) {
            return NO_CHANGES;
        }
        return tracker.getPendingChanges();
    }

    @Override
    public ILocalChange[] getPendingChanges(IShareable[] startingPoints, IProgressMonitor monitor) throws FileSystemException {
        HashMap<LocalChangeContext, ArrayList<IShareable>> shareableMap = new HashMap<LocalChangeContext, ArrayList<IShareable>>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)startingPoints.length);
        IShareable[] iShareableArray = startingPoints;
        int n = startingPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable s = iShareableArray[n2];
            IShare share = s.getShare((IProgressMonitor)progress.newChild(1));
            if (share != null) {
                ISharingDescriptor desc = share.getSharingDescriptor();
                LocalChangeContext ctx = new LocalChangeContext(desc.getComponent(), desc.getConnectionHandle(), s.getSandbox().getRoot());
                ArrayList<IShareable> shareables = (ArrayList<IShareable>)shareableMap.get(ctx);
                if (shareables == null) {
                    shareables = new ArrayList<IShareable>();
                    shareableMap.put(ctx, shareables);
                }
                shareables.add(s);
            }
            ++n2;
        }
        ArrayList<ILocalChange> result = new ArrayList<ILocalChange>();
        for (Map.Entry entry : shareableMap.entrySet()) {
            LocalChangeTracker tracker = this.findTracker((LocalChangeContext)entry.getKey());
            if (tracker == null) continue;
            for (IShareable s : (List)entry.getValue()) {
                result.addAll(Arrays.asList(tracker.getPendingChanges(s.getLocalPath(), false)));
            }
        }
        return result.toArray(new ILocalChange[result.size()]);
    }

    public IShareable getShareable(LocalChange change) {
        Assert.isNotNull((Object)change.path);
        Assert.isNotNull((Object)change.target);
        Assert.isNotNull((Object)change.context);
        IRelativeLocation path = change.isType(16) ? change.getResultingPath() : change.getPath();
        SharingManager sm = SharingManager.getInstance();
        ISandbox sandbox = sm.getSandbox(change.context.getRoot(), false);
        return sandbox.findShareable(path, ResourceType.getResourceType(change.getTarget()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeTracker getTracker(IContextHandle connection, IComponentHandle component, ILocation cfaRoot, ISchedulingRule schedulingRule) {
        Map<LocalChangeContext, LocalChangeTracker> map = this.trackers;
        synchronized (map) {
            LocalChangeContext context = new LocalChangeContext(component, connection, cfaRoot);
            LocalChangeTracker tracker = this.trackers.get(context);
            if (tracker == null) {
                tracker = new LocalChangeTracker(this.notifier, context, schedulingRule);
                this.trackers.put(context, tracker);
            }
            return tracker;
        }
    }

    public void loadChanges(IShare share, IProgressMonitor monitor) throws FileSystemException {
        IShareable rootShareable = share.getSandbox().findShareable(share.getPath(), ResourceType.getResourceType(share.getSharingDescriptor().getRootVersionable()));
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISchedulingRule trackingRule = SharingManager.getInstance().getTrackingRule(share.getSandbox().getRoot());
        try {
            Job.getJobManager().beginRule(trackingRule, (IProgressMonitor)progress.newChild(5));
            LocalChangeTracker.computePendingChanges(rootShareable, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, (IProgressMonitor)progress.newChild(95));
        }
        finally {
            Job.getJobManager().endRule(trackingRule);
            progress.done();
        }
    }

    public void refreshAllChanges(IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShare[] shares = SharingManager.getInstance().allShares((IProgressMonitor)progress.newChild(1));
        this.refreshChanges(shares, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, monitor);
        progress.done();
    }

    public void computeChanges(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        LocalChangeTracker.computePendingChanges(shareable, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, monitor);
    }

    public void refreshChanges(Collection<IShareable> shareables, IProgressMonitor progress) throws FileSystemException {
        this.refreshChanges(shareables, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, progress);
    }

    @Override
    public void refreshChanges(Collection<IShareable> shareables, ILocalChangeManager.RefreshType type, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        for (IShareable shareable : shareables) {
            this.addToRefresh(shareable, type);
        }
        this.doRefresh((IProgressMonitor)monitor);
    }

    @Override
    public void refreshChangesAsync(Collection<IShareable> shareables, ILocalChangeManager.RefreshType type) throws FileSystemException {
        for (IShareable shareable : shareables) {
            this.addToRefresh(shareable, type);
        }
    }

    public void refreshChanges(IShareable startingPoint, IProgressMonitor monitor) throws FileSystemException {
        this.addToRefresh(startingPoint, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN);
        this.doRefresh(monitor);
    }

    public void refreshChanges(IShareable shareable, ILocalChangeManager.RefreshType refreshType, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        long currentTime = System.currentTimeMillis();
        LocalChangeManager.traceLocalChangeInfo("Recomputing changes for individual shareable:" + shareable.getLocalPath());
        this.refreshSynchronously(shareable, refreshType, (IProgressMonitor)monitor);
        LocalChangeManager.traceLocalChangeInfo("Finished recompute in " + (int)((System.currentTimeMillis() - currentTime) / 1000L) + " seconds.");
    }

    private void refreshChanges(IShare[] shares, ILocalChangeManager.RefreshType traversalType, boolean lockEntireIDE, IProgressMonitor monitor) throws FileSystemException {
        int i = 0;
        while (i < shares.length) {
            SharingManager.getInstance().remindSandboxListener(shares[i]);
            this.addToRefresh(shares[i].getShareable(), traversalType, lockEntireIDE);
            ++i;
        }
        this.doRefresh(monitor);
    }

    public void refreshChanges(IShare[] shares, ILocalChangeManager.RefreshType traversalType, IProgressMonitor monitor) throws FileSystemException {
        this.refreshChanges(shares, traversalType, false, monitor);
    }

    public void refreshChangesAsync(IShare[] shares, ILocalChangeManager.RefreshType traversalType) {
        int i = 0;
        while (i < shares.length) {
            SharingManager.getInstance().remindSandboxListener(shares[i]);
            this.addToRefresh(shares[i].getShareable(), traversalType);
            ++i;
        }
    }

    public void refreshChanges(IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShare[] allShares = SharingManager.getInstance().allShares((IProgressMonitor)progress.newChild(1));
        int i = 0;
        while (i < allShares.length) {
            ISharingDescriptor sharingDescriptor = allShares[i].getSharingDescriptor();
            if (sharingDescriptor.getComponent().sameItemId((IItemHandle)component) && sharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)connection)) {
                this.addToRefresh(allShares[i].getShareable(), ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN);
            }
            ++i;
        }
        this.doRefresh((IProgressMonitor)progress.newChild(99));
        progress.done();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void undoChanges(final ILocalChange[] toUndo, IRepositoryResolver repositoryResolver, UndoDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        v0 = undoDilemmaHandler = problemHandler == null ? UndoDilemmaHandler.getDefault() : problemHandler;
        if (toUndo.length == 0) {
            return;
        }
        mgr = SharingManager.getInstance();
        resolver = repositoryResolver == null ? IRepositoryResolver.EXISTING_SHARED : repositoryResolver;
        changesMap = new HashMap<LocalChangeContext, Set<LocalChange>[]>();
        repoMap = new HashMap<LocalChangeContext, ITeamRepository>();
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subProgress = progress.newChild(1);
        subProgress.setWorkRemaining(toUndo.length);
        sharelessChanges = new HashMap<ILocation, ArrayList<LocalChange>>();
        affectedComponents = new HashMap<UUID, IComponentHandle>();
        var17_14 = toUndo;
        var16_15 = toUndo.length;
        var15_18 = 0;
        while (var15_18 < var16_15) {
            c = var17_14[var15_18];
            ch = (LocalChange)c;
            repo = (ITeamRepository)repoMap.get(ch.context);
            if (repo != null) ** GOTO lbl38
            share = (Share)mgr.getShare(ch.context.getRoot(), ch.getPath(), (IProgressMonitor)subProgress.newChild(1));
            if (share == null) {
                changes = (ArrayList<LocalChange>)sharelessChanges.get(ch.context.getRoot());
                if (changes == null) {
                    changes = new ArrayList<LocalChange>();
                    sharelessChanges.put(ch.context.getRoot(), changes);
                }
                changes.add(ch);
            } else {
                repo = resolver.getRepoFor(null, share.getSharingDescriptor().getRepositoryId());
                repoMap.put(ch.context, repo);
                component = share.getSharingDescriptor().getComponent();
                affectedComponents.put(component.getItemId(), component);
lbl38:
                // 2 sources

                if ((changes = (Set[])changesMap.get(ch.context)) == null) {
                    changes = new Set[]{new HashSet<E>(), new HashSet<E>(), new HashSet<E>()};
                    changesMap.put(ch.context, changes);
                }
                if (ch.isType(4)) {
                    changes[0].add(ch);
                } else if (ch.isType(2)) {
                    changes[2].add(ch);
                } else if (ch.isType(16)) {
                    changes[1].add((LocalChange)ch.getCounterpart());
                } else {
                    changes[1].add(ch);
                }
            }
            ++var15_18;
        }
        subProgress.done();
        affectedConfigurations = this.getConfigurationsAffected(changesMap, repoMap, repositoryResolver, progress.newChild(1));
        workspaceLock = WorkspaceLockUtil.acquireReadForConfigurations(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            try {
                mgr.runWithinFileSystemLock(new IRunnableWithProgress(){

                    @Override
                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(toUndo.length + 20));
                        Shed backupShed = new Shed(undoDilemmaHandler.getBackupDilemmaHandler());
                        try {
                            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(undoDilemmaHandler.getOutOfSyncDilemmaHandler());
                            for (ConfigurationFacade configurationFacade : affectedConfigurations) {
                                verifyOp.addToVerify(configurationFacade.getConnection((IProgressMonitor)progress.newChild(1)), configurationFacade.getComponentHandle());
                            }
                            verifyOp.run((IProgressMonitor)progress.newChild(4));
                            for (Map.Entry entry : changesMap.entrySet()) {
                                LocalChangeTracker tracker = LocalChangeManager.this.findTracker((LocalChangeContext)entry.getKey());
                                Set[] undoPerTracker = (Set[])entry.getValue();
                                ITeamRepository repo = (ITeamRepository)repoMap.get(entry.getKey());
                                LocalChangeManager.this.undoChanges(tracker, repo, (Set[])entry.getValue(), resolver, affectedComponents, undoDilemmaHandler, backupShed, (IProgressMonitor)progress.newChild(undoPerTracker[0].size() + undoPerTracker[1].size() + undoPerTracker[2].size()));
                            }
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }, null, (IProgressMonitor)progress.newChild(95));
            }
            catch (InvocationTargetException e) {
                cause = e.getCause();
                if (cause instanceof TeamRepositoryException) {
                    throw (TeamRepositoryException)cause;
                }
                if (cause instanceof FileSystemException) {
                    throw (FileSystemException)cause;
                }
                throw new TeamRepositoryException(Messages.LocalChangeManager_12, cause);
            }
            catch (InterruptedException v1) {
                throw new OperationCanceledException();
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        if (!sharelessChanges.isEmpty()) {
            progress.setWorkRemaining(sharelessChanges.size() * 10);
            for (Map.Entry entry : sharelessChanges.entrySet()) {
                lock = CFALockUtil.lockExistingForGlobalUpdate((ILocation)entry.getKey(), (IProgressMonitor)progress.newChild(1));
                inner = progress.newChild(8);
                inner.setWorkRemaining(((Collection)entry.getValue()).size());
                try {
                    for (LocalChange ch : (Collection)entry.getValue()) {
                        shareable = ch.getShareable();
                        if (shareable == null) continue;
                        try {
                            this.forget(shareable, (IProgressMonitor)inner.newChild(1));
                        }
                        catch (FileSystemException v2) {}
                    }
                }
                finally {
                    if (lock != null) {
                        CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    }
                }
            }
        }
        progress.done();
    }

    private HashSet<ConfigurationFacade> getConfigurationsAffected(Map<LocalChangeContext, Set<LocalChange>[]> changesMap, Map<LocalChangeContext, ITeamRepository> repoMap, IRepositoryResolver repositoryResolver, SubMonitor progress) throws TeamRepositoryException {
        HashSet<ConfigurationFacade> configurationsAffected = new HashSet<ConfigurationFacade>();
        for (Map.Entry<LocalChangeContext, Set<LocalChange>[]> e : changesMap.entrySet()) {
            LocalChangeContext context = e.getKey();
            ITeamRepository repo = repoMap.get(context);
            if (repo == null) continue;
            configurationsAffected.add(new ConfigurationFacade(repo, context.getConnection(), context.getComponent()));
        }
        return configurationsAffected;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void undoChanges(LocalChangeTracker tracker, ITeamRepository repo, Set<LocalChange>[] toUndo, IRepositoryResolver resolver, Map<UUID, IComponentHandle> affectedComponents, UpdateDilemmaHandler problemHandler, Shed backupShed, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        if (repo == null) {
            return;
        }
        if (tracker == null) {
            return;
        }
        rule = SharingManager.getInstance().getTrackingRule(tracker.getContext().getRoot());
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        sandbox = null;
        try {
            Job.getJobManager().beginRule(rule, (IProgressMonitor)progress.newChild(1));
            cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(tracker.getContext().getRoot());
            sandbox = SharingManager.getInstance().getSandbox(cfa.getRoot(), true);
            if (sandbox != null) {
                for (IComponentHandle component : affectedComponents.values()) {
                    SharingManager.getInstance().beginAvoidSandboxListening(sandbox, component);
                }
            }
            if ((cfaRule = this.hasShareRootMoveOrDelete(cfa, toUndo, progress.newChild(1)) != false ? CFALockUtil.lockExistingForGlobalUpdate(tracker.getContext().getRoot(), (IProgressMonitor)progress.newChild(1)) : CFALockUtil.lockExistingForUpdate(tracker.getContext().getRoot(), tracker.getContext().getConnection(), tracker.getContext().getComponent(), (IProgressMonitor)progress.newChild(1))) == null) {
            }
            try {
                contentsDeletedFromRepo = new ArrayList<IShareable>(0);
                inaccessible = new ArrayList<IShareable>(0);
                tracker.syncChanges((IProgressMonitor)progress.newChild(1));
                var19_25 = toUndo;
                var18_26 = toUndo.length;
                var17_28 = 0;
lbl25:
                // 2 sources

                while (true) {
                    if (var17_28 >= var18_26) {
                        this.validateUndoPrereq(tracker, cfa, toUndo[0], toUndo[1], toUndo[2], (IProgressMonitor)progress.newChild(1));
                        connection /* !! */  = tracker.getContext().getConnection() instanceof IBaselineHandle != false ? SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection((IBaselineHandle)tracker.getContext().getConnection(), (IProgressMonitor)progress.newChild(1)) : SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)tracker.getContext().getConnection(), (IProgressMonitor)progress.newChild(1));
                    }
                    changeList = var19_25[var17_28];
                    i = changeList.iterator();
                    if (true) ** GOTO lbl70
                    fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(repo)).getFileSystemService();
                    subProgress = progress.newChild(93);
                    subProgress.setWorkRemaining(toUndo[0].size() + toUndo[1].size() + toUndo[2].size());
                    this.undoDeletion(toUndo[0], tracker, cfa, (IConnection)connection /* !! */ , fileSystemService, problemHandler, inaccessible, (IProgressMonitor)subProgress.newChild(1));
                    remaining = toUndo[1].size() + toUndo[2].size();
                    while (true) {
                        block30: {
                            changesToUndo = new HashSet<LocalChange>();
                            var22_34 = toUndo[1].iterator();
                            while (true) {
                                block29: {
                                    if (var22_34.hasNext()) break block29;
                                    if (!changesToUndo.isEmpty()) break;
                                    var22_34 = toUndo[2].iterator();
                                    if (true) ** GOTO lbl90
                                }
                                c = var22_34.next();
                                if (!this.undoChange(c, tracker, cfa, (IConnection)connection /* !! */ , backupShed, contentsDeletedFromRepo, inaccessible, (IProgressMonitor)subProgress.newChild(1))) {
                                    changesToUndo.add(c);
                                    subProgress.setWorkRemaining(remaining);
                                    continue;
                                }
                                --remaining;
                            }
                            if (toUndo[1].size() != changesToUndo.size()) break block30;
                            str = new StringBuilder(Messages.LocalChangeManager_13);
                            first = true;
                            var24_36 = changesToUndo.iterator();
                            if (true) ** GOTO lbl85
                        }
                        toUndo[1] = changesToUndo;
                    }
                    break;
                }
            }
            catch (Throwable var25_38) {
                CFALockUtil.endBatching(cfaRule, (IProgressMonitor)progress.newChild(1));
                throw var25_38;
            }
            do {
                if (!(change = i.next()).isCanceled()) continue;
                i.remove();
lbl70:
                // 3 sources

            } while (i.hasNext());
            ++var17_28;
            ** continue;
            do {
                c = (LocalChange)var24_36.next();
                if (!first) {
                    str.append(", ");
                } else {
                    first = false;
                }
                str.append(c.toString());
                if (!c.isType(8)) continue;
                str.append(" - ").append(c.getCounterpart().toString());
lbl85:
                // 3 sources

            } while (var24_36.hasNext());
            throw new IllegalStateException(str.toString());
            do {
                c = var22_34.next();
                this.undoAddition(c, tracker, cfa, (IConnection)connection /* !! */ , backupShed, (IProgressMonitor)subProgress.newChild(1));
lbl90:
                // 2 sources

            } while (var22_34.hasNext());
            this.handleInaccessibleDeletedContent(contentsDeletedFromRepo, inaccessible, problemHandler);
            subProgress.done();
            CFALockUtil.endBatching(cfaRule, (IProgressMonitor)progress.newChild(1));
        }
        finally {
            try {
                if (sandbox == null) return;
                for (IComponentHandle component : affectedComponents.values()) {
                    SharingManager.getInstance().endAvoidSandboxListening(sandbox, component);
                }
                return;
            }
            finally {
                Job.getJobManager().endRule(rule);
                progress.done();
            }
        }
    }

    private void handleInaccessibleDeletedContent(List<IShareable> contentsDeletedFromRepo, List<IShareable> inaccessible, UpdateDilemmaHandler problemHandler) throws FileSystemStatusException {
        int instruction;
        if (!contentsDeletedFromRepo.isEmpty()) {
            instruction = problemHandler.deletedContent(contentsDeletedFromRepo);
            if (instruction == 1) {
                throw new OperationCanceledException();
            }
            if (instruction != 0) {
                if (contentsDeletedFromRepo.size() == 1) {
                    throw new FileSystemStatusException(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.LocalChangeManager_1, (Object)contentsDeletedFromRepo.get(0).getLocalPath().toString())));
                }
                IStatus[] errors = new IStatus[contentsDeletedFromRepo.size()];
                Iterator<IShareable> iter = contentsDeletedFromRepo.iterator();
                int j = 0;
                while (j < errors.length) {
                    errors[j] = FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.LocalChangeManager_2, (Object)iter.next().getLocalPath().toString()));
                    ++j;
                }
                MultiStatus status = new MultiStatus("com.ibm.team.filesystem.client", 0, errors, NLS.bind((String)Messages.LocalChangeManager_6, (Object)errors.length), null);
                throw new FileSystemStatusException((IStatus)status);
            }
        }
        if (!inaccessible.isEmpty()) {
            instruction = problemHandler.inaccessibleForUpdate(inaccessible);
            if (instruction == 1) {
                throw new OperationCanceledException();
            }
            if (instruction != 0) {
                IStatus[] errors = new IStatus[contentsDeletedFromRepo.size()];
                Iterator<IShareable> iter = contentsDeletedFromRepo.iterator();
                int j = 0;
                while (j < errors.length) {
                    errors[j] = FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.LocalChangeManager_14, (Object)iter.next().getLocalPath().toString()));
                    ++j;
                }
                MultiStatus status = new MultiStatus("com.ibm.team.filesystem.client", 0, errors, NLS.bind((String)Messages.LocalChangeManager_15, (Object)errors.length), null);
                throw new FileSystemStatusException((IStatus)status);
            }
        }
    }

    private boolean hasShareRootMoveOrDelete(CopyFileArea cfa, Set<LocalChange>[] toUndo, SubMonitor monitor) throws FileSystemException {
        monitor.setWorkRemaining(2);
        AbstractLock lock = CFALockUtil.lockExistingForRead(cfa.getRoot(), (IProgressMonitor)monitor.newChild(1));
        if (lock == null) {
            return false;
        }
        try {
            Set<LocalChange>[] setArray = toUndo;
            int n = toUndo.length;
            int n2 = 0;
            while (n2 < n) {
                Set<LocalChange> changes = setArray[n2];
                for (LocalChange localChange : changes) {
                    if (!localChange.isType(8) && !localChange.isType(4) || !cfa.isShareRoot(localChange.getTarget(), localChange.getComponent(), localChange.getConnection())) continue;
                    return true;
                }
                ++n2;
            }
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)monitor.newChild(1));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateUndoPrereq(LocalChangeTracker tracker, CopyFileAreaStore cfa, Set<LocalChange> deletions, final Set<LocalChange> changes, final Set<LocalChange> additions, IProgressMonitor monitor) throws FileSystemException {
        for (LocalChange c : deletions) {
            ILocalChange[] chg = tracker.getPendingChangesAt(c.getPath());
            ILocalChange[] iLocalChangeArray = chg;
            int n = chg.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalChange ch = iLocalChangeArray[n2];
                if (ch.isType(2)) {
                    if (!additions.contains(ch)) {
                        throw new FileSystemException(NLS.bind((String)Messages.LocalChangeManager_16, (Object)c.getPath(), (Object)ch.getResultingPath()));
                    }
                } else if (ch.isType(8)) {
                    if (!changes.contains(ch)) {
                        throw new FileSystemException(NLS.bind((String)Messages.LocalChangeManager_17, (Object)c.getPath(), (Object)ch.getResultingPath()));
                    }
                } else if (!ch.equals(c)) {
                    throw new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_18, (Object)ch, (Object)c));
                }
                ++n2;
            }
        }
        IComponentHandle component = tracker.getContext().getComponent();
        IContextHandle connection = tracker.getContext().getConnection();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)changes.size());
        block7: for (LocalChange c : changes) {
            IFolderHandle parent;
            IRelativeLocation targetPath;
            if (!c.isType(8)) {
                progress.worked(1);
                continue;
            }
            SubMonitor subProgress = progress.newChild(1);
            subProgress.setWorkRemaining(2);
            String name = c.getCounterpart().getPath().getName();
            if (cfa.isShareRoot(c.getTarget(), c.getComponent(), c.getConnection())) {
                targetPath = c.getPath().getParent().append(name);
            } else {
                parent = c.getCounterpart().getTargetParent();
                targetPath = cfa.getLocalPathFor((IVersionableHandle)parent, component, connection, (IProgressMonitor)subProgress.newChild(1));
                if (targetPath != null) {
                    targetPath = targetPath.append(name);
                }
            }
            if (targetPath != null) {
                ILocalChange[] chg;
                ILocalChange[] iLocalChangeArray = chg = tracker.getPendingChangesAt(targetPath);
                int n = chg.length;
                int n3 = 0;
                while (n3 < n) {
                    ILocalChange ch = iLocalChangeArray[n3];
                    if (ch.isType(2)) {
                        if (!additions.contains(ch)) {
                            throw new FileSystemException(NLS.bind((String)Messages.LocalChangeManager_19, (Object)c.getResultingPath(), (Object)ch.getResultingPath()));
                        }
                    } else if (ch.isType(8)) {
                        if (!changes.contains(ch)) {
                            throw new FileSystemException(NLS.bind((String)Messages.LocalChangeManager_20, (Object)c.getResultingPath(), (Object)ch.getResultingPath()));
                        }
                    } else {
                        throw new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_21, (Object)ch, (Object)c));
                    }
                    ++n3;
                }
            }
            if (!cfa.isShareRoot(c.getTarget(), c.getComponent(), c.getConnection())) {
                parent = c.getCounterpart().getTargetParent();
                ArrayList<IFolderHandle> parents = new ArrayList<IFolderHandle>();
                HashSet<UUID> seenItems = new HashSet<UUID>();
                seenItems.add(c.getTarget().getItemId());
                ILocalChange lastUndoMove = c;
                while (!cfa.isShareRoot((IVersionableHandle)parent, c.getComponent(), c.getConnection())) {
                    InverseFileItemInfo info;
                    parents.add(parent);
                    try {
                        info = cfa.getItemInfo((IVersionableHandle)parent, c.getComponent(), c.getConnection(), true);
                    }
                    catch (IllegalStateException e) {
                        throw new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_InverseMetadataMissing, (Object)c.getShareable().getLocalPath()), e);
                    }
                    ILocalChange parentChange = tracker.getPendingChange((IVersionableHandle)parent);
                    if (parentChange.isType(4)) {
                        if (!deletions.contains(parentChange)) {
                            throw new FileSystemException(NLS.bind((String)Messages.LocalChangeManager_22, (Object)lastUndoMove.getResultingPath(), (Object)parentChange.getPath()));
                        }
                        parent = info.getParent();
                    } else if (parentChange.isType(2)) {
                        if (additions.contains(parentChange)) continue block7;
                        parent = info.getLocalParent();
                    } else if (parentChange.isType(8)) {
                        if (changes.contains(parentChange)) {
                            parent = info.getParent();
                            lastUndoMove = parentChange;
                        } else {
                            parent = info.getLocalParent();
                        }
                    } else {
                        parent = info.getLocalParent();
                        if (parent == null) {
                            parent = info.getParent();
                        }
                    }
                    if (seenItems.contains(parent.getItemId())) {
                        parents.add(parent);
                        subProgress.setWorkRemaining(parents.size());
                        HashMap<UUID, IFolderHandle> parentSet = new HashMap<UUID, IFolderHandle>((int)((double)parents.size() / 0.75));
                        HashSet<UUID> seenParents = new HashSet<UUID>((int)((double)parents.size() / 0.75));
                        int i = 0;
                        while (i < parents.size()) {
                            IFolderHandle ancestor = (IFolderHandle)parents.get(i);
                            ILocalChange ancestorChange = tracker.getPendingChange((IVersionableHandle)ancestor);
                            seenParents.add(ancestor.getItemId());
                            if (ancestorChange.isType(8)) {
                                if (changes.contains(ancestorChange)) {
                                    UUID ancestorId;
                                    HashSet<UUID> toSearch = new HashSet<UUID>(parentSet.keySet());
                                    while ((ancestorId = cfa.getRemoteAncestor(toSearch, (IVersionableHandle)ancestor, c.getComponent(), c.getConnection(), (IProgressMonitor)subProgress.newChild(1))) != null) {
                                        ILocalChange depChange = tracker.getPendingChange((IVersionableHandle)parentSet.get(ancestorId));
                                        if (!seenParents.contains(depChange.getCounterpart().getTargetParent().getItemId())) {
                                            throw new FileSystemException(NLS.bind((String)Messages.LocalChangeManager_23, (Object)ancestorChange.getResultingPath(), (Object)depChange.getResultingPath()));
                                        }
                                        toSearch.remove(ancestorId);
                                    }
                                } else {
                                    parentSet.put(ancestor.getItemId(), ancestor);
                                }
                            }
                            ++i;
                        }
                        throw new IllegalStateException(Messages.LocalChangeManager_24);
                    }
                    seenItems.add(parent.getItemId());
                }
            }
            subProgress.done();
        }
        final FileSystemException[] ex = new FileSystemException[1];
        LocalChangeTracker localChangeTracker = tracker;
        synchronized (localChangeTracker) {
            for (final LocalChange c : additions) {
                c.getNode().basicAccept(new LocalChangeNode.IVisitor(){

                    @Override
                    public boolean visit(LocalChange toVisit) {
                        if (toVisit == c) {
                            return true;
                        }
                        if (toVisit.isType(2)) {
                            if (!additions.contains(toVisit)) {
                                ex[0] = new FileSystemException(NLS.bind((String)Messages.LocalChangeManager_25, (Object)c.getResultingPath(), (Object)toVisit.getResultingPath()));
                            }
                        } else if (toVisit.isType(8)) {
                            if (!changes.contains(toVisit)) {
                                ex[0] = new FileSystemException(NLS.bind((String)Messages.LocalChangeManager_26, (Object)c.getResultingPath(), (Object)toVisit.getResultingPath()));
                            }
                        } else if (!toVisit.isType(4)) {
                            throw new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_27, (Object)toVisit, (Object)c));
                        }
                        return false;
                    }
                });
                if (ex[0] == null) continue;
                throw ex[0];
            }
        }
        progress.done();
    }

    /*
     * WARNING - void declaration
     */
    private void undoDeletion(Set<LocalChange> toUndo, LocalChangeTracker tracker, CopyFileArea cfa, IConnection connection, FileSystemServiceProxy fileSystemService, UpdateDilemmaHandler updateDilemmaHandler, List<IShareable> inaccessible, IProgressMonitor mon) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        ArrayList<IVersionableHandle> versionablesToUndo = new ArrayList<IVersionableHandle>(toUndo.size());
        for (ILocalChange iLocalChange : toUndo) {
            boolean isShare = cfa.isShareRoot(iLocalChange.getTarget(), iLocalChange.getComponent(), iLocalChange.getConnection());
            IRelativeLocation parentPath = cfa.getLocalPathFor((IVersionableHandle)iLocalChange.getTargetParent(), iLocalChange.getComponent(), iLocalChange.getConnection(), (IProgressMonitor)progress.newChild(1));
            if (parentPath == null && !isShare) {
                this.forget(iLocalChange.getShareable(), (IProgressMonitor)progress.newChild(1));
                continue;
            }
            versionablesToUndo.add(iLocalChange.getTarget());
        }
        if (!versionablesToUndo.isEmpty()) {
            void var17_22;
            LocalChangeUndoReport localChangeUndoReport = fileSystemService.localChangeUndo(connection, tracker.getContext().getComponent(), versionablesToUndo.toArray(new IVersionableHandle[versionablesToUndo.size()]), null, (IProgressMonitor)progress);
            this.filterUpdates(toUndo, tracker, localChangeUndoReport);
            SharingManager mgr = SharingManager.getInstance();
            progress.worked(50);
            progress.setWorkRemaining(100);
            ComponentStateSummary stateSummary = ScmDtoFactory.eINSTANCE.createComponentStateSummary();
            stateSummary.setComponent(tracker.getContext().getComponent());
            stateSummary.setConfigurationState(((SynchronizationTime)localChangeUndoReport.getConfigurationState()).getTime());
            List<ComponentStateSummary> stateSummaries = Collections.singletonList(stateSummary);
            IUpdateMutator[] mutators = mgr.getUpdateMutator(connection, stateSummaries, stateSummaries, localChangeUndoReport.getUpdates(), Collections.EMPTY_LIST, Collections.singletonList(cfa), updateDilemmaHandler, null);
            progress.setWorkRemaining(mutators.length * 100 + localChangeUndoReport.getInaccessible().getRequests().size() * 2);
            IUpdateMutator[] iUpdateMutatorArray = mutators;
            int n = mutators.length;
            boolean bl = false;
            while (var17_22 < n) {
                IUpdateMutator mutator = iUpdateMutatorArray[var17_22];
                mutator.run((IProgressMonitor)progress.newChild(100));
                ++var17_22;
            }
            if (!localChangeUndoReport.getInaccessible().getRequests().isEmpty()) {
                HashMap<UUID, ILocalChange> inaccessibleLocalChanges = new HashMap<UUID, ILocalChange>();
                for (ILocalChange iLocalChange : toUndo) {
                    inaccessibleLocalChanges.put(iLocalChange.getTarget().getItemId(), iLocalChange);
                }
                for (IVersionableHandle iVersionableHandle : localChangeUndoReport.getInaccessible().getRequests()) {
                    ILocalChange change = (ILocalChange)inaccessibleLocalChanges.get(iVersionableHandle.getItemId());
                    inaccessible.add(change.getShareable());
                    this.forget(cfa, change, progress);
                }
            }
        }
        progress.done();
    }

    private void forget(CopyFileArea cfa, ILocalChange change, SubMonitor progress) throws FileSystemException {
        IFileStorage fileStorage;
        boolean unshared = cfa.forget(change.getConnection(), change.getComponent(), change.getTarget(), (IProgressMonitor)progress.newChild(1));
        if (unshared && (fileStorage = ((Shareable)change.getShareable()).getFileStorage()) != null) {
            fileStorage.deregisterRepositoryProvider((IProgressMonitor)progress.newChild(1));
        }
    }

    private void filterUpdates(Set<LocalChange> toUndo, LocalChangeTracker tracker, LocalChangeUndoReport updates) throws TeamRepositoryException {
        HashSet<UUID> undoItemIds = new HashSet<UUID>();
        for (LocalChange change : toUndo) {
            undoItemIds.add(change.getTarget().getItemId());
        }
        HashSet<UUID> excludedParents = new HashSet<UUID>();
        Iterator iUpdate = updates.getUpdates().getAdds().iterator();
        while (iUpdate.hasNext()) {
            FileAreaUpdate update = (FileAreaUpdate)iUpdate.next();
            if ((update.isChangeType(32) || !excludedParents.contains(update.getDestinationParent().getItemId())) && (undoItemIds.contains(update.getItem().getItemId()) || tracker.getPendingChange(update.getItem()).getType() == 0)) continue;
            excludedParents.add(update.getItem().getItemId());
            iUpdate.remove();
        }
    }

    private void preserve(IFileStorage storage, IProgressMonitor monitor) throws FileSystemException {
        IFileStorage parent = ((Shareable)storage.getShareable().getParent()).getFileStorage();
        String baseName = String.valueOf(storage.getName()) + BACKUP_NAME;
        int i = 2;
        String name = baseName;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        while (parent.getChild(name, (IProgressMonitor)progress.newChild(1)) != null) {
            name = String.valueOf(baseName) + Integer.toString(i++);
            progress.setWorkRemaining(100);
        }
        Share share = (Share)storage.getShareable().getShare((IProgressMonitor)progress.newChild(18));
        ResourceType hint = storage.getResourceType((IProgressMonitor)progress.newChild(1));
        if (hint == null) {
            hint = ResourceType.getResourceType(storage.getShareable().getVersionable((IProgressMonitor)progress.newChild(1)));
        }
        Shareable target = share.getShareable(parent.getShareable().getLocalPath().append(name), hint);
        storage.move(target.getSandbox(), target.getLocalPath(), (IProgressMonitor)progress.newChild(80));
        progress.done();
    }

    private boolean undoChange(LocalChange c, LocalChangeTracker tracker, CopyFileArea cfa, IConnection connection, Shed backupShed, List<IShareable> contentsDeletedFromRepo, List<IShareable> inaccessible, IProgressMonitor mon) throws FileSystemException, TeamRepositoryException {
        Object target;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        IRelativeLocation localPath = cfa.getLocalPathFor(c.getTarget(), c.getComponent(), c.getConnection(), (IProgressMonitor)progress.newChild(1));
        SharingManager sm = SharingManager.getInstance();
        ISandbox sandbox = sm.getSandbox(c.context.getRoot(), false);
        Shareable shareable = sm.findShareable(sandbox, localPath, ResourceType.getResourceType(c.getTarget()));
        if (c.isType(8)) {
            SubMonitor subProgress = progress.newChild(c.isType(1) ? 19 : 99);
            subProgress.setWorkRemaining(100);
            IRelativeLocation oldPath = cfa.isShareRoot(c.getTarget(), c.getComponent(), c.getConnection()) ? c.getCounterpart().getPath() : cfa.getLocalPathFor((IVersionableHandle)c.getCounterpart().getTargetParent(), c.getComponent(), c.getConnection(), (IProgressMonitor)subProgress.newChild(20)).append(c.getCounterpart().getPath().getName());
            if (localPath.isPrefixOf(oldPath)) {
                subProgress.done();
                progress.done();
                return false;
            }
            Shareable targetShareable = sm.findShareable(sandbox, oldPath, ResourceType.getResourceType(c.getTarget()));
            target = targetShareable.getFileStorage();
            IFileStorage existingChild = cfa.isShareRoot(c.getTarget(), c.getComponent(), c.getConnection()) ? (targetShareable.exists((IProgressMonitor)subProgress) ? targetShareable.getFileStorage() : null) : ((Shareable)targetShareable.getParent()).getFileStorage().getChild(target.getName(), (IProgressMonitor)subProgress.newChild(1));
            if (existingChild != null && (sandbox.isCaseSensitive() || !this.isSamePathWithCaseChangeInName(oldPath, localPath))) {
                this.preserve(existingChild, (IProgressMonitor)subProgress.newChild(19));
            }
            if (oldPath.isPrefixOf(localPath)) {
                localPath = cfa.getLocalPathFor(c.getTarget(), c.getComponent(), c.getConnection(), (IProgressMonitor)subProgress.newChild(20));
                shareable = sm.findShareable(sandbox, localPath, ResourceType.getResourceType(c.getTarget()));
            }
            subProgress.setWorkRemaining(40);
            shareable.getFileStorage().move(targetShareable.getSandbox(), targetShareable.getLocalPath(), (IProgressMonitor)subProgress.newChild(40));
            localPath = oldPath;
            shareable = targetShareable;
            subProgress.done();
        }
        FileItemInfo oldInfo = null;
        boolean forceContentReload = false;
        if (c.isType(32)) {
            progress.setWorkRemaining(1);
            if (oldInfo == null) {
                oldInfo = cfa.getItemInfo(localPath);
            }
            if (oldInfo != null) {
                IFileStorage storage;
                long modificationStamp;
                if (oldInfo.getVersionableHandle() instanceof IFolderHandle) {
                    modificationStamp = oldInfo.getLastContentChangeCheckStamp();
                } else if (oldInfo.getVersionableHandle() instanceof IFileItemHandle) {
                    storage = shareable.getFileStorage();
                    storage.setExecutable(oldInfo.isOriginalExecutable(), (IProgressMonitor)progress.newChild(1));
                    modificationStamp = storage.getModificationStamp();
                } else {
                    storage = shareable.getFileStorage();
                    modificationStamp = storage.getModificationStamp();
                    storage.setTarget(backupShed, storage.getLinkInfo((IProgressMonitor)progress.newChild(1)).getTarget(), oldInfo.isOriginalDirectoryLink(), (IProgressMonitor)progress.newChild(1));
                }
                FileItemInfo newInfo = new FileItemInfo(oldInfo.getVersionableHandle(), false, modificationStamp, oldInfo.getParent(), oldInfo.getName(), oldInfo.isLoadedWithAnotherName(), oldInfo.getHash(), oldInfo.getContentLength(), oldInfo.getOriginalLineDelimiter(), oldInfo.getOriginalLineDelimiter(), oldInfo.getOriginalContentType(), oldInfo.getOriginalContentType(), oldInfo.getStoredPredecessorHintHash(), oldInfo.getStoredSize(), oldInfo.getStoredEncoding(), oldInfo.getStoredHash(), oldInfo.getStoredNumLineDelimiters(), oldInfo.isOriginalExecutable(), oldInfo.isOriginalExecutable(), oldInfo.isOriginalDirectoryLink(), oldInfo.isOriginalDirectoryLink());
                cfa.setItemMetaData(shareable.getLocalPath(), newInfo, ICopyFileArea.PropertyUpdate.CANCEL_CHANGES, null, (IProgressMonitor)progress.newChild(1));
            }
            if (oldInfo != null && oldInfo.getVersionableHandle() instanceof IFileItemHandle && SharingManager.getInstance().transformsContentsSet(shareable.getSandbox())) {
                forceContentReload = true;
            }
        }
        if (c.isType(1) || forceContentReload) {
            progress.setWorkRemaining(100);
            oldInfo = cfa.getItemInfo(localPath);
            if (oldInfo == null) {
                return true;
            }
            if (oldInfo.getVersionableHandle() instanceof IFileItemHandle) {
                IFileStorage storage = shareable.getFileStorage();
                FileContent content = FilesystemFactory.eINSTANCE.createFileContent();
                ContentHash prev = oldInfo.getStoredPredecessorHintHash();
                content.setPredecessorHint(prev);
                content.setLineDelimiter(oldInfo.getOriginalLineDelimiter());
                content.setSize(oldInfo.getStoredSize());
                content.setCharacterEncoding(oldInfo.getStoredEncoding());
                content.setHash(oldInfo.getStoredHash());
                content.setLineDelimiterCount(oldInfo.getStoredNumLineDelimiters());
                boolean isExecutable = oldInfo.isExecutable();
                boolean isOriginalExecutable = oldInfo.isOriginalExecutable();
                String contentType = oldInfo.getContentType();
                String originalContentType = oldInfo.getOriginalContentType();
                IFileContentManager contentManager = FileSystemCore.getContentManager(connection.teamRepository());
                InverseFileItemInfo inverse = cfa.getItemInfo(c.getConnection(), c.getComponent(), oldInfo.getVersionableHandle(), true);
                FileOptions options = new FileOptions(false, content.getLineDelimiter(), content.getCharacterEncoding(), inverse.getOriginalProperties());
                try {
                    InputStream is = contentManager.retrieveContentStream((IFileItemHandle)c.getTarget(), (IFileContent)content, (IProgressMonitor)progress.newChild(68));
                    ContentMeta stats = storage.setContentsCalcMeta(options, is, backupShed, (IProgressMonitor)new CancellationMonitor((IProgressMonitor)progress));
                    boolean contentChanged = false;
                    FileItemInfo newInfo = new FileItemInfo(oldInfo.getVersionableHandle(), contentChanged, storage.getModificationStamp(), oldInfo.getParent(), oldInfo.getName(), oldInfo.isLoadedWithAnotherName(), stats.getHash(), stats.getLength(), content.getLineDelimiter(), content.getLineDelimiter(), originalContentType, contentType, content.getPredecessorHintHash(), content.getSize(), content.getCharacterEncoding(), content.getHash(), content.getLineDelimiterCount(), isExecutable, isOriginalExecutable, false, false);
                    cfa.setItemMetaData(shareable.getLocalPath(), newInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(1));
                    oldInfo = newInfo;
                }
                catch (VersionedContentDeleted versionedContentDeleted) {
                    InputStream is = DeletedContent.getDeletedContentInputStream(content.getCharacterEncoding());
                    storage.setContentsCalcMeta(options, is, backupShed, (IProgressMonitor)new CancellationMonitor((IProgressMonitor)progress));
                    ContentMeta stats = new ContentMeta(content.getHash(), content.getSize());
                    boolean contentChanged = true;
                    contentsDeletedFromRepo.add(shareable);
                    FileItemInfo newInfo = new FileItemInfo(oldInfo.getVersionableHandle(), contentChanged, storage.getModificationStamp(), oldInfo.getParent(), oldInfo.getName(), oldInfo.isLoadedWithAnotherName(), stats.getHash(), stats.getLength(), content.getLineDelimiter(), content.getLineDelimiter(), originalContentType, contentType, content.getPredecessorHintHash(), content.getSize(), content.getCharacterEncoding(), content.getHash(), content.getLineDelimiterCount(), isExecutable, isOriginalExecutable, false, false);
                    cfa.setItemMetaData(shareable.getLocalPath(), newInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(1));
                    oldInfo = newInfo;
                }
                catch (VersionablePermissionDeniedException versionablePermissionDeniedException) {
                    inaccessible.add(shareable);
                    if (localPath != null) {
                        shareable.getFileStorage().delete(backupShed, (IProgressMonitor)progress.newChild(1));
                    }
                    this.forget(cfa, c, progress.newChild(1));
                }
            } else if (oldInfo.getVersionableHandle() instanceof ISymbolicLinkHandle) {
                try {
                    ISymbolicLink item = (ISymbolicLink)SCMPlatform.getWorkspaceManager((ITeamRepository)connection.teamRepository()).versionableManager().fetchCompleteState(oldInfo.getVersionableHandle(), (IProgressMonitor)progress.newChild(1));
                    target = item.getTarget();
                    boolean isDirectory = item.isDirectoryLink();
                    IFileStorage storage = shareable.getFileStorage();
                    target = storage.convertTargetIntoLocalForm((String)target);
                    storage.setTarget(backupShed, (String)target, isDirectory, (IProgressMonitor)progress.newChild(1));
                    FileItemInfo newInfo = new FileItemInfo((ISymbolicLinkHandle)oldInfo.getVersionableHandle(), false, oldInfo.getParent(), oldInfo.getName(), oldInfo.isLoadedWithAnotherName(), oldInfo.getHash(), oldInfo.getStoredHash(), oldInfo.isDirectoryLink(), oldInfo.isOriginalDirectoryLink());
                    cfa.setItemMetaData(shareable.getLocalPath(), newInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(1));
                    oldInfo = newInfo;
                }
                catch (VersionablePermissionDeniedException versionablePermissionDeniedException) {
                    if (localPath != null) {
                        shareable.getFileStorage().delete(backupShed, (IProgressMonitor)progress.newChild(1));
                    }
                    this.forget(cfa, c, progress.newChild(1));
                }
            }
        }
        progress.done();
        return true;
    }

    private boolean isSamePathWithCaseChangeInName(IRelativeLocation oldPath, IRelativeLocation localPath) {
        return oldPath.segmentCount() == localPath.segmentCount() && oldPath.getParent().equals(localPath.getParent()) && oldPath.getName().toUpperCase().equals(localPath.getName().toUpperCase());
    }

    private void undoAddition(LocalChange c, LocalChangeTracker tracker, CopyFileAreaStore cfa, IConnection connection, Shed backupShed, IProgressMonitor mon) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        IRelativeLocation localPath = cfa.getLocalPathFor(c.getTarget(), c.getComponent(), c.getConnection(), (IProgressMonitor)progress.newChild(1));
        if (localPath != null) {
            SharingManager sm = SharingManager.getInstance();
            ISandbox sandbox = sm.getSandbox(c.context.getRoot(), false);
            Shareable shareable = sm.findShareable(sandbox, localPath, ResourceType.getResourceType(c.getTarget()));
            shareable.getFileStorage().delete(backupShed, (IProgressMonitor)progress.newChild(99));
        }
        progress.done();
    }

    @Override
    public void removeLocalChangeListener(ILocalChangeListener listener) {
        this.notifier.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToRefresh(IShareable root, ILocalChangeManager.RefreshType traversalType, boolean lockEntireIDE) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.toRefresh.add(new RefreshRequest(root, traversalType, lockEntireIDE));
            this.recomputeJob.schedule(500L);
        }
    }

    public void addToRefresh(IShareable root, ILocalChangeManager.RefreshType traversalType) {
        this.addToRefresh(root, traversalType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginAvoidNotify() {
        Object object = this.avoidNotification;
        synchronized (object) {
            ++this.avoidNotificationCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAvoidNotify() throws FileSystemException {
        Object object = this.avoidNotification;
        synchronized (object) {
            --this.avoidNotificationCount;
            Assert.isTrue((this.avoidNotificationCount >= 0 ? 1 : 0) != 0, (String)"Unmatched start/end notification");
            if (this.avoidNotificationCount < 0) {
                this.avoidNotificationCount = 0;
            }
            if (this.avoidNotificationCount == 0) {
                this.notifier.scheduleNotification();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotificationEnabled() {
        Object object = this.avoidNotification;
        synchronized (object) {
            return this.avoidNotificationCount == 0;
        }
    }

    @Override
    public ILocalChange[] getPendingChanges(IShare[] startingPoints) {
        HashMap<LocalChangeContext, ArrayList<IRelativeLocation>> pathMap = new HashMap<LocalChangeContext, ArrayList<IRelativeLocation>>();
        IShare[] iShareArray = startingPoints;
        int n = startingPoints.length;
        int n2 = 0;
        while (n2 < n) {
            ISharingDescriptor desc;
            IShare share = iShareArray[n2];
            if (share != null && (desc = share.getSharingDescriptor()) != null) {
                LocalChangeContext ctx = new LocalChangeContext(desc.getComponent(), desc.getConnectionHandle(), share.getSandbox().getRoot());
                ArrayList<IRelativeLocation> paths = (ArrayList<IRelativeLocation>)pathMap.get(ctx);
                if (paths == null) {
                    paths = new ArrayList<IRelativeLocation>();
                    pathMap.put(ctx, paths);
                }
                paths.add(share.getPath());
            }
            ++n2;
        }
        ArrayList<ILocalChange> result = new ArrayList<ILocalChange>();
        for (Map.Entry entry : pathMap.entrySet()) {
            LocalChangeTracker tracker = this.findTracker((LocalChangeContext)entry.getKey());
            if (tracker == null) continue;
            for (IRelativeLocation path : (List)entry.getValue()) {
                result.addAll(Arrays.asList(tracker.getPendingChanges(path, false)));
            }
        }
        return result.toArray(new ILocalChange[result.size()]);
    }

    @Override
    public boolean isContentDirty(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(shareable.getSandbox().getRoot(), (IProgressMonitor)progress.newChild(10));
        if (lock == null) {
            throw new IllegalArgumentException("The cfa must exist");
        }
        try {
            FileItemInfo itemInfo = CopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getSandbox().getRoot()).getItemInfo(shareable.getLocalPath());
            if (itemInfo != null && !itemInfo.isFolder()) {
                if (shareable.getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.FOLDER) {
                    return true;
                }
                boolean bl = itemInfo.isContentChanged();
                return bl;
            }
            return false;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(10));
        }
    }

    @Override
    public void combineDeleteAdd(IRepositoryResolver resolver, final ILocalChange deletion, final ILocalChange addition, IProgressMonitor monitor) throws TeamRepositoryException {
        if (deletion == null || !deletion.isType(4)) {
            throw new IllegalArgumentException();
        }
        if (addition == null || !addition.isType(2)) {
            throw new IllegalArgumentException();
        }
        if (!deletion.getConnection().sameItemId((IItemHandle)addition.getConnection())) {
            throw new IllegalArgumentException("Changes must be in the same workspace");
        }
        if (!deletion.getComponent().sameItemId((IItemHandle)addition.getComponent())) {
            throw new IllegalArgumentException("Changes must be in the same component");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SharingManager mgr = SharingManager.getInstance();
        IShareable del = deletion.getShareable();
        if (del == null) {
            throw new IllegalArgumentException();
        }
        IShareable add = addition.getShareable();
        if (add == null) {
            throw new IllegalArgumentException();
        }
        if (!del.getSandbox().getRoot().equals(add.getSandbox().getRoot())) {
            throw new IllegalArgumentException("Changes have different roots");
        }
        final IVersionableHandle item = deletion.getTarget();
        if (item == null) {
            throw new IllegalArgumentException("No versionable");
        }
        IShare share = del.getShare((IProgressMonitor)progress.newChild(1));
        if (share == null) {
            throw new IllegalArgumentException();
        }
        ITeamRepository repo = resolver.getRepoFor(null, share.getSharingDescriptor().getRepositoryId());
        final ISandbox sandbox = ((Share)share).getSandbox();
        ConfigurationFacade desc = new ConfigurationFacade(repo, addition.getConnection(), addition.getComponent());
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireReadForConfigurations(Collections.singleton(desc), (IProgressMonitor)progress.newChild(1));
        try {
            try {
                final FileSystemException[] ex = new FileSystemException[1];
                mgr.runWithinFileSystemLock(new IRunnableWithProgress(){

                    @Override
                    public void run(IProgressMonitor progress) throws InvocationTargetException, InterruptedException {
                        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)100);
                        try {
                            LocalChangeTracker tracker = LocalChangeManager.this.findTracker(((LocalChange)addition).context);
                            if (tracker == null) {
                                throw new FileSystemException("The tracker has been unregistered");
                            }
                            ISchedulingRule rule = SharingManager.getInstance().getTrackingRule(tracker.getContext().getRoot());
                            try {
                                Job.getJobManager().beginRule(rule, (IProgressMonitor)mon.newChild(1));
                                AbstractLock lock = CFALockUtil.lockExistingForUpdate(tracker.getContext().getRoot(), tracker.getContext().getConnection(), tracker.getContext().getComponent(), (IProgressMonitor)mon.newChild(1));
                                if (lock == null) {
                                    throw new FileSystemException("The CFA has been unregistered");
                                }
                                try {
                                    LocalChangeManager.this.syncPendingChanges(addition.getConnection(), addition.getComponent(), sandbox, (IProgressMonitor)mon.newChild(1));
                                    if (addition.isCanceled()) {
                                        throw new FileSystemException("addition cancelled");
                                    }
                                    if (deletion.isCanceled()) {
                                        throw new FileSystemException("deletion cancelled");
                                    }
                                    LocalChangeManager.this.combineDeleteAddInternal(CopyFileAreaManager.instance.getExistingCopyFileArea(tracker.getContext().getRoot()), item, deletion, addition, (IProgressMonitor)mon.newChild(96));
                                    LocalChangeManager.this.syncPendingChanges(addition.getConnection(), addition.getComponent(), sandbox, (IProgressMonitor)mon.newChild(1));
                                }
                                finally {
                                    CFALockUtil.endBatching(lock, (IProgressMonitor)mon.newChild(1));
                                }
                            }
                            finally {
                                Job.getJobManager().endRule(rule);
                            }
                        }
                        catch (FileSystemException e) {
                            ex[0] = e;
                        }
                        mon.done();
                    }
                }, null, (IProgressMonitor)progress.newChild(98));
                if (ex[0] != null) {
                    throw ex[0];
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                WorkspaceLockUtil.release(workspaceLock);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                WorkspaceLockUtil.release(workspaceLock);
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void combineDeleteAddInternal(CopyFileArea cfa, IVersionableHandle oldItem, ILocalChange deletion, ILocalChange addition, IProgressMonitor monitor) throws FileSystemException {
        IComponentHandle comp = deletion.getComponent();
        IContextHandle conn = deletion.getConnection();
        Shareable newRoot = (Shareable)((LocalChange)addition).getShareable();
        LinkedList<Shareable> resources = new LinkedList<Shareable>();
        LinkedList<IVersionableHandle> oldItems = new LinkedList<IVersionableHandle>();
        resources.add(newRoot);
        oldItems.add(oldItem);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        while (!resources.isEmpty()) {
            assert (!oldItems.isEmpty());
            progress.setWorkRemaining(resources.size() + 4);
            Shareable resource = (Shareable)resources.removeFirst();
            IVersionableHandle item = (IVersionableHandle)oldItems.removeFirst();
            InverseFileItemInfo itemInfo = cfa.getItemInfo(item, comp, conn, true);
            cfa.setItemMetaData(resource.getLocalPath(), itemInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(1));
            Map<String, IVersionableHandle> remoteChildren = itemInfo.getRemoteChildren();
            IFileStorage storage = resource.getFileStorage();
            Collection<IFileStorage> localChildren = storage.getChildren(true, (IProgressMonitor)progress.newChild(1));
            SubMonitor subProgress = progress.newChild(1);
            subProgress.setWorkRemaining(localChildren.size());
            for (IFileStorage childStorage : localChildren) {
                Shareable childShareable = childStorage.getShareable();
                assert (childShareable.exists((IProgressMonitor)subProgress.newChild(1)));
                IVersionableHandle childItem = remoteChildren.get(childStorage.getName());
                if (childItem == null) continue;
                resources.addFirst(childShareable);
                oldItems.addFirst(childItem);
            }
            if (resource.getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.FOLDER) continue;
            this.refreshChanges(resource, (IProgressMonitor)progress.newChild(10));
        }
        assert (oldItems.isEmpty());
        progress.done();
    }

    @Override
    public void refreshChanges(ISandbox[] sandboxes, ILocalChangeManager.RefreshType traversalType, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + sandboxes.length));
        ArrayList<IShare> allShares = new ArrayList<IShare>();
        ISandbox[] iSandboxArray = sandboxes;
        int n = sandboxes.length;
        int n2 = 0;
        while (n2 < n) {
            IShare[] shares;
            ISandbox sandbox = iSandboxArray[n2];
            IShare[] iShareArray = shares = sandbox.allShares((IProgressMonitor)progress.newChild(1));
            int n3 = shares.length;
            int n4 = 0;
            while (n4 < n3) {
                IShare share = iShareArray[n4];
                SharingManager.getInstance().remindSandboxListener(share);
                ++n4;
            }
            allShares.addAll(Arrays.asList(shares));
            ++n2;
        }
        if (!allShares.isEmpty()) {
            this.refreshChanges(allShares.toArray(new IShare[allShares.size()]), traversalType, true, (IProgressMonitor)progress.newChild(100));
        }
    }

    private void forget(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ILocation copyFileAreaRoot = shareable.getSandbox().getRoot();
        AbstractLock lock = CFALockUtil.lockExistingForGlobalUpdate(copyFileAreaRoot, (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            return;
        }
        try {
            CopyFileArea cfa = (CopyFileArea)ICopyFileAreaManager.instance.getExistingCopyFileArea(copyFileAreaRoot);
            cfa.deleteTreeInfo(shareable.getLocalPath(), true, (IProgressMonitor)progress.newChild(74));
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean joinRefresh(int millisToWait, IProgressMonitor prog) {
        long endTime = System.currentTimeMillis() + (long)millisToWait;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)prog, (int)(millisToWait / 200));
        Object object = this.refreshLock;
        synchronized (object) {
            while (true) {
                try {
                    while (this.toRefresh.size() > 0 || this.refreshesRunning > 0) {
                        if (endTime < System.currentTimeMillis() || monitor.isCanceled()) {
                            return false;
                        }
                        this.refreshLock.wait(200L);
                        monitor.worked(1);
                    }
                    return true;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                finally {
                    monitor.done();
                    continue;
                }
                break;
            }
        }
    }

    class RecomputePendingChangesJob
    extends Job {
        public RecomputePendingChangesJob() {
            super(Messages.LocalChangeManager_0);
        }

        public boolean belongsTo(Object family) {
            return RECOMPUTE_PENDING_CHANGES_FAMILY.equals(family);
        }

        protected IStatus run(IProgressMonitor monitor) {
            long start;
            long l = start = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                try {
                    LocalChangeManager.this.doRefresh(monitor);
                }
                catch (FileSystemException e) {
                    IStatus iStatus = FileSystemStatusUtil.getStatusFor((Throwable)((Object)e));
                    if (Trace.LOG_ELAPSED_TIME) {
                        Trace.endTrace(start, String.valueOf(((Object)((Object)this)).getClass().getName()) + ":" + this.getName());
                    }
                    return iStatus;
                }
            }
            finally {
                if (Trace.LOG_ELAPSED_TIME) {
                    Trace.endTrace(start, String.valueOf(((Object)((Object)this)).getClass().getName()) + ":" + this.getName());
                }
            }
            return Status.OK_STATUS;
        }
    }

    public static final class RefreshRequest {
        private final IShareable startingPoint;
        private final ILocalChangeManager.RefreshType traversalType;
        private final boolean lockEntireIDE;

        private RefreshRequest(IShareable startingPoint, ILocalChangeManager.RefreshType traversalType, boolean lockEntireIDE) {
            Assert.isNotNull((Object)startingPoint);
            this.startingPoint = startingPoint;
            this.traversalType = traversalType;
            this.lockEntireIDE = lockEntireIDE;
        }

        public IShareable getRootShareable() {
            return this.startingPoint;
        }

        public IShareable getStartingPoint() {
            return this.startingPoint;
        }

        public ILocalChangeManager.RefreshType getTraversalType() {
            return this.traversalType;
        }

        private boolean isLockEntireIDE() {
            return this.lockEntireIDE;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefreshRequest)) {
                return false;
            }
            RefreshRequest other = (RefreshRequest)o;
            return this.startingPoint.equals(other.startingPoint) && this.traversalType.equals((Object)other.traversalType) && this.lockEntireIDE == other.lockEntireIDE;
        }

        public int hashCode() {
            return 17 + 7 * this.startingPoint.hashCode() + 7 * this.traversalType.hashCode() + (this.lockEntireIDE ? 0 : 1);
        }

        static /* synthetic */ boolean access$0(RefreshRequest refreshRequest) {
            return refreshRequest.isLockEntireIDE();
        }
    }
}

