/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.AbstractCurrentPortOperation;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.IFailedAutoResolveRequest;
import com.ibm.team.filesystem.client.operations.IUpdateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.common.IContentChangeDetail;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILineDelimiterChangeDetail;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeDetail;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableChange;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class UpdateCurrentPortOperation
extends AbstractCurrentPortOperation
implements IUpdateCurrentPatchOperation {
    List<IWorkspaceConnection.ICurrentPatchOperation> operations = new ArrayList<IWorkspaceConnection.ICurrentPatchOperation>();

    public UpdateCurrentPortOperation(UpdateCurrentPatchDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? UpdateCurrentPatchDilemmaHandler.getDefault() : dilemmaHandler);
    }

    @Override
    protected String getOperationLabel() {
        return Messages.UpdateCurrentPortOperation_0;
    }

    private ClientAutoResolveOp getClientOp(IWorkspaceConnection.ICurrentPatchOperation op, IVersionableChange change, List<IWorkspaceConnection.ICurrentPatchOperation> operations) {
        if (!(op instanceof IWorkspaceConnection.IAutoResolveOp)) {
            return null;
        }
        if ((change.getFlags() & 0x20) != 0) {
            return null;
        }
        if (op.getChangeDetailId() == null) {
            IContentChangeDetail contentChange = null;
            ILineDelimiterChangeDetail lineChangeDetail = null;
            for (IChangeDetail changeDetail : change.getChanges()) {
                if (changeDetail.isResolved()) continue;
                if (changeDetail instanceof IContentChangeDetail) {
                    contentChange = (IContentChangeDetail)changeDetail;
                    continue;
                }
                if (!(changeDetail instanceof ILineDelimiterChangeDetail) || changeDetail.kind() != 0) continue;
                lineChangeDetail = (ILineDelimiterChangeDetail)changeDetail;
            }
            if (contentChange != null) {
                return new ClientAutoResolveOp(change, contentChange, lineChangeDetail, ((IWorkspaceConnection.IAutoResolveOp)op).isBestEffort());
            }
        } else {
            IChangeDetail changeDetail = change.getChangeDetail(op.getChangeDetailId());
            if (changeDetail instanceof IContentChangeDetail && !changeDetail.isResolved()) {
                ILineDelimiterChangeDetail lineChangeDetail = null;
                for (IWorkspaceConnection.ICurrentPatchOperation otherOp : operations) {
                    IChangeDetail otherChangeDetail;
                    if (!(otherOp instanceof IWorkspaceConnection.IAutoResolveOp) || !otherOp.getVersionable().sameItemId((IItemHandle)change.getVersionable()) || !((otherChangeDetail = change.getChangeDetail(otherOp.getChangeDetailId())) instanceof ILineDelimiterChangeDetail) || otherChangeDetail.isResolved() || otherChangeDetail.kind() != 0) continue;
                    lineChangeDetail = (ILineDelimiterChangeDetail)otherChangeDetail;
                    break;
                }
                return new ClientAutoResolveOp(change, (IContentChangeDetail)changeDetail, lineChangeDetail, ((IWorkspaceConnection.IAutoResolveOp)op).isBestEffort());
            }
        }
        return null;
    }

    @Override
    protected void doExecute(HashSet<ConfigurationFacade> configurationsToLock, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        if (configurationsToLock.size() > 0) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(configurationsToLock.size() * 3));
            for (ConfigurationFacade configurationFacade : configurationsToLock) {
                int result;
                IWorkspaceConnection wc = (IWorkspaceConnection)configurationFacade.getCachedConnection();
                IComponentHandle componentHandle = configurationFacade.getComponentHandle();
                IUpdateReport report = wc.applyCurrentPatchOperations(componentHandle, this.operations, (IProgressMonitor)progress.newChild(1));
                UpdateOperation updateOperation = new UpdateOperation(this.getConnection(), Collections.singletonList(report), 3, this.getUpdateDilemmaHandler(), null);
                this.disableVerifyInSync(updateOperation);
                updateOperation.run((IProgressMonitor)progress.newChild(1));
                if (!this.isLoaded(configurationFacade, (IProgressMonitor)progress.newChild(1))) continue;
                ICurrentPatch currentPort = this.getConnection().getCurrentPatch(this.getComponent());
                ArrayList<ClientAutoResolveOp> attemptToResolveOnClient = new ArrayList<ClientAutoResolveOp>();
                ArrayList<IVersionableHandle> nonExisting = new ArrayList<IVersionableHandle>();
                for (IWorkspaceConnection.ICurrentPatchOperation op : this.operations) {
                    IVersionableChange vc;
                    ClientAutoResolveOp clientOp = this.getClientOp(op, vc = currentPort.getVersionableChange(op.getVersionable().getItemId()), this.operations);
                    if (clientOp == null) {
                        if (vc.isResolved() || !(op instanceof IWorkspaceConnection.IAutoResolveOp) || op.getChangeDetailId() != null || vc.kind() != 3 && vc.kind() != 2 || (vc.getFlags() & 0x20) == 0 || (vc.getFlags() & 0x80) != 0 || (vc.getFlags() & 0x40) != 0) continue;
                        nonExisting.add(vc.getVersionable());
                        continue;
                    }
                    attemptToResolveOnClient.add(clientOp);
                }
                ArrayList<IWorkspaceConnection.ICurrentPatchOperation> subsequentOperations = new ArrayList<IWorkspaceConnection.ICurrentPatchOperation>();
                if (!nonExisting.isEmpty() && (result = ((UpdateCurrentPatchDilemmaHandler)this.getDilemmaHandler()).performAutoResolveForModificationsToMissing(this.getConnection(), this.getComponent(), nonExisting)) == 0) {
                    for (IVersionableHandle vh : nonExisting) {
                        IWorkspaceConnection.ICurrentPatchOperation markOperation = this.getConnection().getCurrentPatchOperationFactory().createResolveWithProposedOp(vh, false);
                        subsequentOperations.add(markOperation);
                    }
                }
                ArrayList<IShareable> toCommit = new ArrayList<IShareable>(attemptToResolveOnClient.size());
                ArrayList<IFailedAutoResolveRequest> failedResolveRequets = new ArrayList<IFailedAutoResolveRequest>();
                HashMap<UUID, IFileItem> fileItemMap = this.makeFileItemMap(configurationFacade.getTeamRepository(), attemptToResolveOnClient, progress.newChild(1));
                for (ClientAutoResolveOp clientOp : attemptToResolveOnClient) {
                    IStatus result2 = clientOp.run(configurationFacade, null, subsequentOperations, toCommit, failedResolveRequets, fileItemMap, (IProgressMonitor)progress.newChild(1));
                    if (result2.isOK()) continue;
                    this.collectStatus(result2);
                }
                if (!failedResolveRequets.isEmpty()) {
                    int decision = ((UpdateCurrentPatchDilemmaHandler)this.getUpdateDilemmaHandler()).missingStorageMerger(failedResolveRequets);
                    ArrayList<IFailedAutoResolveRequest> failedRetries = new ArrayList<IFailedAutoResolveRequest>(failedResolveRequets.size());
                    if (decision == 0) {
                        for (IFailedAutoResolveRequest retryResolveRequest : failedResolveRequets) {
                            ClientAutoResolveOp clientOp;
                            IStatus result3;
                            FailedAutoResolveRequest failedRequest = (FailedAutoResolveRequest)retryResolveRequest;
                            if (!failedRequest.isRetryMerge() || (result3 = (clientOp = failedRequest.getFailedOp()).run(configurationFacade, failedRequest.getDefaultContentTypeMerger(), subsequentOperations, toCommit, failedRetries, fileItemMap, (IProgressMonitor)progress.newChild(1))).isOK()) continue;
                            this.collectStatus(result3);
                        }
                    }
                }
                if (!subsequentOperations.isEmpty()) {
                    IUpdateReport report2 = wc.applyCurrentPatchOperations(componentHandle, subsequentOperations, (IProgressMonitor)progress.newChild(1));
                    UpdateOperation op = new UpdateOperation(this.getConnection(), Collections.singletonList(report2), 3, this.getUpdateDilemmaHandler(), null);
                    this.disableVerifyInSync(op);
                    op.run((IProgressMonitor)progress.newChild(1));
                }
                if (toCommit.size() <= 0) continue;
                ICheckinOperation commitOp = IOperationFactory.instance.getCheckinOperation(((UpdateCurrentPatchDilemmaHandler)this.getDilemmaHandler()).getCommitDilemmaHandler(), IRepositoryResolver.EXISTING_SHARED);
                commitOp.requestCheckin(toCommit.toArray(new IShareable[toCommit.size()]), currentPort.getTargetChangeSet(), null, (IProgressMonitor)progress.newChild(1));
                commitOp.run((IProgressMonitor)progress.newChild(1));
            }
        }
    }

    private HashMap<UUID, IFileItem> makeFileItemMap(ITeamRepository repository, List<ClientAutoResolveOp> attemptToResolveOnClient, SubMonitor monitor) throws TeamRepositoryException {
        int handleCount = attemptToResolveOnClient.size() * 2;
        ArrayList<IVersionableHandle> itemHandles = new ArrayList<IVersionableHandle>(handleCount);
        for (ClientAutoResolveOp clientOp : attemptToResolveOnClient) {
            IVersionableHandle beforeState = clientOp.versionableChange.getBeforeState();
            IVersionableHandle afterState = clientOp.versionableChange.getAfterState();
            if (beforeState == null || afterState == null) continue;
            itemHandles.add(beforeState);
            itemHandles.add(afterState);
        }
        IVersionableManager versionableeManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).versionableManager();
        List items = versionableeManager.fetchCompleteStates(itemHandles, (IProgressMonitor)monitor.newChild(handleCount));
        HashMap<UUID, IFileItem> fileItemMap = new HashMap<UUID, IFileItem>();
        for (Object item : items) {
            IFileItem fileItem = (IFileItem)item;
            fileItemMap.put(fileItem.getStateId(), fileItem);
        }
        return fileItemMap;
    }

    private boolean isLoaded(ConfigurationFacade configuration, IProgressMonitor monitor) throws FileSystemException {
        ICopyFileAreaManager copyFileAreaManager = ICopyFileAreaManager.instance;
        Collection<ICopyFileArea> copyFileAreas = copyFileAreaManager.getCopyFileAreasForConfiguration(configuration, monitor);
        return !copyFileAreas.isEmpty();
    }

    @Override
    public void setContext(IWorkspaceConnection connection, IComponentHandle component) {
        super.setContext(connection, component);
    }

    @Override
    public void autoResolve(IVersionableHandle versionable, Set<UUID> changeDetailIds, boolean bestEffort) {
        if (changeDetailIds == null || changeDetailIds.isEmpty()) {
            IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createAttemptAutoResolveOp(versionable, bestEffort);
            this.operations.add(op);
        } else {
            for (UUID changeDetailId : changeDetailIds) {
                IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createAttemptAutoResolveOp(versionable, changeDetailId, bestEffort);
                this.operations.add(op);
            }
        }
    }

    @Override
    public void markAsResolved(IVersionableHandle versionable, Set<UUID> changeDetailIds, boolean force) {
        if (changeDetailIds == null || changeDetailIds.isEmpty()) {
            IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createMarkAsResolvedOp(versionable, force);
            this.operations.add(op);
        } else {
            for (UUID changeDetailId : changeDetailIds) {
                IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createMarkAsResolvedOp(versionable, changeDetailId, force);
                this.operations.add(op);
            }
        }
    }

    @Override
    public void markAsUnresolved(IVersionableHandle versionable, Set<UUID> changeDetailIds) {
        if (changeDetailIds == null || changeDetailIds.isEmpty()) {
            IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createMarkAsUnresolvedOp(versionable);
            this.operations.add(op);
        } else {
            for (UUID changeDetailId : changeDetailIds) {
                IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createMarkAsUnresolvedOp(versionable, changeDetailId);
                this.operations.add(op);
            }
        }
    }

    @Override
    public void resolveWithProposed(IVersionableHandle versionable, Set<UUID> changeDetailIds, boolean force) {
        if (changeDetailIds == null || changeDetailIds.isEmpty()) {
            IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createResolveWithProposedOp(versionable, force);
            this.operations.add(op);
        } else {
            for (UUID changeDetailId : changeDetailIds) {
                IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createResolveWithProposedOp(versionable, changeDetailId, force);
                this.operations.add(op);
            }
        }
    }

    @Override
    public void undoChanges(IVersionableHandle versionable, Set<UUID> changeDetailIds, boolean force) {
        if (changeDetailIds == null || changeDetailIds.isEmpty()) {
            IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createUndoChangeOp(versionable, force);
            this.operations.add(op);
        } else {
            for (UUID changeDetailId : changeDetailIds) {
                IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createUndoChangeOp(versionable, changeDetailId, force);
                this.operations.add(op);
            }
        }
    }

    @Override
    public void reparentVersionable(IVersionableHandle versionable, IFolderHandle newParent) {
        IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createReparentVersionableOp(versionable, newParent);
        this.operations.add(op);
    }

    @Override
    protected void processLocalChanges(ChangeHistoryChangeSetsDilemmaHandler problemHandler, HashMap<ConfigurationFacade, Collection<ILocalChange>> checkin, SubMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (checkin.isEmpty()) {
            return;
        }
        ConfigurationFacade myFacade = new ConfigurationFacade((IConnection)this.getConnection(), this.getComponent());
        Collection<ILocalChange> localChangesForComponent = checkin.get((Object)myFacade);
        if (localChangesForComponent == null) {
            return;
        }
        Collection<ILocalChange> localChangesForOperationTargets = this.getLocalChangesForOperationTargets(this.getComponent(), localChangesForComponent);
        if (!localChangesForOperationTargets.isEmpty()) {
            HashMap<ConfigurationFacade, Collection<ILocalChange>> operationTargetMap = new HashMap<ConfigurationFacade, Collection<ILocalChange>>(1);
            operationTargetMap.put(myFacade, localChangesForOperationTargets);
            int result = problemHandler.uncheckedInChanges(operationTargetMap);
            switch (result) {
                case 1: {
                    throw new OperationCanceledException();
                }
                case 0: {
                    this.checkInLocalChanges(problemHandler, localChangesForOperationTargets, monitor);
                    break;
                }
                case 2: {
                    throw new FileSystemException(Messages.ChangeHistoryChangeSetsOperation_0);
                }
            }
        }
    }

    private Collection<ILocalChange> getLocalChangesForOperationTargets(IComponentHandle component, Collection<ILocalChange> localChanges) {
        HashMap<Object, ILocalChange> result = new HashMap<Object, ILocalChange>();
        ICurrentPatch currentPatch = this.getConnection().getCurrentPatch(component);
        HashMap<UUID, IVersionableChange> portChangeMap = new HashMap<UUID, IVersionableChange>();
        Collection changes = currentPatch.getVersionableChanges();
        for (IVersionableChange versionableChange : changes) {
            portChangeMap.put(versionableChange.getVersionable().getItemId(), versionableChange);
        }
        HashMap<IRelativeLocation, ILocalChange> localChangePathMap = new HashMap<IRelativeLocation, ILocalChange>();
        HashMap<UUID, ILocalChange> localChangeIDMap = new HashMap<UUID, ILocalChange>();
        for (ILocalChange localChange : localChanges) {
            localChangePathMap.put(localChange.getPath(), localChange);
            localChangeIDMap.put(localChange.getTarget().getItemId(), localChange);
        }
        for (IWorkspaceConnection.ICurrentPatchOperation operation : this.operations) {
            IRelativeLocation location;
            ILocalChange localChange;
            IVersionableChange versionableChange;
            if (!(operation instanceof IWorkspaceConnection.IMarkAsResolvedOp) && !(operation instanceof IWorkspaceConnection.IAutoResolveOp) && !(operation instanceof IWorkspaceConnection.IResolveWithProposedOp) || (versionableChange = (IVersionableChange)portChangeMap.get(operation.getVersionable().getItemId())) == null) continue;
            String[] parentPathHint = versionableChange.getParentPathHint();
            if (parentPathHint == null) {
                parentPathHint = new String[]{};
            }
            if ((localChange = (ILocalChange)localChangePathMap.get(location = new RelativeLocation(parentPathHint))) != null && localChange.getTarget() != null) {
                result.put(localChange.getTarget().getItemId(), localChange);
            } else if (localChange != null) {
                result.put(location, localChange);
            }
            location = location.append(versionableChange.getName());
            localChange = (ILocalChange)localChangePathMap.get(location);
            if (localChange != null && localChange.getTarget() != null) {
                result.put(localChange.getTarget().getItemId(), localChange);
            } else if (localChange != null) {
                result.put(location, localChange);
            }
            if (versionableChange.getParent() != null && (localChange = (ILocalChange)localChangeIDMap.get(versionableChange.getParent().getItemId())) != null) {
                result.put(versionableChange.getParent().getItemId(), localChange);
            }
            if ((localChange = (ILocalChange)localChangeIDMap.get(versionableChange.getVersionable().getItemId())) == null) continue;
            result.put(versionableChange.getVersionable().getItemId(), localChange);
        }
        return result.values();
    }

    private void checkInLocalChanges(ChangeHistoryChangeSetsDilemmaHandler problemHandler, Collection<ILocalChange> changesToCheckIn, SubMonitor monitor) throws TeamRepositoryException {
        SubMonitor subProgress = monitor.newChild(10).setWorkRemaining(changesToCheckIn.size() * 2);
        ICheckinOperation op = IOperationFactory.instance.getCheckinOperation(problemHandler.getCommitDilemmaHandler(), IRepositoryResolver.EXISTING_SHARED);
        if (this.nonAtomicCommitIsAnOption) {
            op.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
        } else {
            op.disableNonAtomicCommit();
        }
        op.setRefreshBeforeRun(false);
        ILocalChange[] changes = changesToCheckIn.toArray(new ILocalChange[changesToCheckIn.size()]);
        op.requestCheckin(changes, null, "", (IProgressMonitor)subProgress.newChild(1));
        this.disableVerifyInSync(op);
        op.run((IProgressMonitor)monitor.newChild(84));
    }

    protected boolean autoResolveChanges(Class<?> filterOnDetail, boolean bestEffort) {
        ICurrentPatch currentPort = this.getConnection().getCurrentPatch(this.getComponent());
        if (currentPort == null) {
            return false;
        }
        boolean hasChanges = false;
        Collection changes = currentPort.getVersionableChanges();
        for (IVersionableChange change : changes) {
            IVersionableHandle versionable = change.getVersionable();
            HashSet<UUID> filteredChanges = new HashSet<UUID>();
            Collection changeDetails = change.getChanges();
            for (IChangeDetail changeDetail : changeDetails) {
                if (!filterOnDetail.isAssignableFrom(changeDetail.getClass()) || changeDetail.isResolved()) continue;
                filteredChanges.add(changeDetail.getId());
            }
            if (filteredChanges.isEmpty()) continue;
            this.autoResolve(versionable, filteredChanges, bestEffort);
            hasChanges = true;
        }
        return hasChanges;
    }

    private class ClientAutoResolveOp {
        private final IVersionableChange versionableChange;
        private IContentChangeDetail contentChangeDetail;
        private ILineDelimiterChangeDetail lineDelimiterChangeDetail;
        private final boolean bestEffort;

        public ClientAutoResolveOp(IVersionableChange versionableChange, IContentChangeDetail contentChangeDetail, ILineDelimiterChangeDetail lineDelimitierChangeDetail, boolean bestEffort) {
            this.versionableChange = versionableChange;
            this.contentChangeDetail = contentChangeDetail;
            this.lineDelimiterChangeDetail = lineDelimitierChangeDetail;
            this.bestEffort = bestEffort;
        }

        public boolean isBestEffort() {
            return this.bestEffort;
        }

        public IStatus run(ConfigurationFacade configurationFacade, String contentTypeForMerge, List<IWorkspaceConnection.ICurrentPatchOperation> subsequentOperations, List<IShareable> toCommit, List<IFailedAutoResolveRequest> failedRequests, HashMap<UUID, IFileItem> fileItemMap, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
            IFileContentMerger merger = SharingManager.getInstance().getFileContentMerger();
            IVersionableHandle commonAncestorHandle = this.versionableChange.getBeforeState();
            IVersionableHandle proposedHandle = this.versionableChange.getAfterState();
            if (commonAncestorHandle == null || proposedHandle == null) {
                return Status.OK_STATUS;
            }
            if (!(commonAncestorHandle instanceof IFileItemHandle) || !(commonAncestorHandle instanceof IFileItemHandle)) {
                return Status.OK_STATUS;
            }
            IFileItem commonAncestor = fileItemMap.get(commonAncestorHandle.getStateId());
            IFileItem proposed = fileItemMap.get(proposedHandle.getStateId());
            if (commonAncestor == null || proposed == null) {
                return Status.OK_STATUS;
            }
            IShareable shareable = UpdateCurrentPortOperation.this.findShareable(configurationFacade, this.versionableChange.getVersionable(), (IProgressMonitor)progress.newChild(1));
            if (shareable != null && !shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(1))) {
                try {
                    IStatus mergeStatus = merger.performAutoMerge(configurationFacade.getTeamRepository(), commonAncestor, proposed, shareable, contentTypeForMerge, new Shed(((UpdateCurrentPatchDilemmaHandler)UpdateCurrentPortOperation.this.getDilemmaHandler()).getBackupDilemmaHandler()), (IProgressMonitor)progress.newChild(1));
                    if (mergeStatus.getCode() == 1002 || mergeStatus.getCode() == 1001) {
                        failedRequests.add(new FailedAutoResolveRequest(this, shareable, true));
                    }
                    if (mergeStatus.isOK()) {
                        IWorkspaceConnection.ICurrentPatchOperation markOperation = UpdateCurrentPortOperation.this.getConnection().getCurrentPatchOperationFactory().createMarkAsResolvedOp(this.versionableChange.getVersionable(), this.contentChangeDetail.getId(), true);
                        subsequentOperations.add(markOperation);
                        toCommit.add(shareable);
                        if (this.lineDelimiterChangeDetail != null) {
                            IChangePropertiesOperation ldOp = IOperationFactory.instance.getChangePropertiesOperation(null);
                            ldOp.setLineDelimiter(shareable, this.lineDelimiterChangeDetail.getAfterLineDelimiter());
                            ldOp.run((IProgressMonitor)progress.newChild(1));
                            markOperation = UpdateCurrentPortOperation.this.getConnection().getCurrentPatchOperationFactory().createMarkAsResolvedOp(this.versionableChange.getVersionable(), this.lineDelimiterChangeDetail.getId(), true);
                            subsequentOperations.add(markOperation);
                        }
                    } else if (!this.isBestEffort()) {
                        return mergeStatus;
                    }
                }
                catch (IOException e) {
                    return FileSystemStatusUtil.getStatusFor(e);
                }
            }
            return Status.OK_STATUS;
        }
    }

    private class FailedAutoResolveRequest
    implements IFailedAutoResolveRequest {
        private IShareable shareable;
        private boolean mergerUndetermined;
        private boolean retryMerge;
        private String contentType;
        private ClientAutoResolveOp failedOp;

        public FailedAutoResolveRequest(ClientAutoResolveOp clientAutoResolveOp, IShareable shareable, boolean mergerUndetermined) {
            this.failedOp = clientAutoResolveOp;
            this.shareable = shareable;
            this.mergerUndetermined = mergerUndetermined;
        }

        public ClientAutoResolveOp getFailedOp() {
            return this.failedOp;
        }

        @Override
        public IShareable getConflictedShareable() {
            return this.shareable;
        }

        @Override
        public boolean isStreamMergerUndetermined() {
            return this.mergerUndetermined;
        }

        @Override
        public void setRetryMerge(boolean retryMerge) {
            this.retryMerge = retryMerge;
        }

        public boolean isRetryMerge() {
            return this.retryMerge;
        }

        @Override
        public void defaultContentTypeMerger(String defaultContentType) {
            this.contentType = defaultContentType;
        }

        @Override
        public String getDefaultContentTypeMerger() {
            return this.contentType;
        }
    }
}

