/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.EclipseReadException;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.IWorkspaceUpdateReporter;
import com.ibm.team.filesystem.client.internal.operations.NullWorkspaceUpdateReporter;
import com.ibm.team.filesystem.client.internal.operations.UpdateCurrentPortOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateReport;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateRequest;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.ConnectionFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.IResumeOperation;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateReport;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IContentChangeDetail;
import com.ibm.team.filesystem.common.IEncodingChangeDetail;
import com.ibm.team.filesystem.common.ILineDelimiterChangeDetail;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.AcceptSuspendedChangeSetException;
import com.ibm.team.scm.common.ActiveChangeSetsException;
import com.ibm.team.scm.common.ActiveChangeSetsOverlapException;
import com.ibm.team.scm.common.ChangeSetAlreadyInHistoryException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.PatchInProgressException;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.dto.SyncTime;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class WorkspaceUpdateOperation
extends ChangeHistoryChangeSetsOperation
implements IWorkspaceUpdateOperation,
IResumeOperation {
    private static final int ACCEPT_CHANGE_SETS = 1;
    private static final int ACCEPT_COMBINED = 2;
    private static final int RESUME = 3;
    private int acceptFlags;
    protected HashMap<IWorkspaceConnection, List<WorkspaceUpdateRequest>> acceptRequests;
    private final WorkspaceUpdateDilemmaHandler problemHandler;
    private Set<ConfigurationFacade> componentsAdded;
    private Set<ConfigurationFacade> componentsRemoved;
    private List<IComponent> componentsCreated;
    private boolean redundantChangeSets;
    private boolean resumedChangeSets;
    private boolean problemsEncountered;
    private IDownloadListener downloadListener;
    private boolean populateUpdateReport = false;
    private IWorkspaceUpdateReporter changes;
    private boolean isEclipseMetadataReadFailure;
    private List<String> eclipseReadMessages;
    private EclipseReadException savedEclipseReadException;

    public WorkspaceUpdateOperation(WorkspaceUpdateDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? WorkspaceUpdateDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? WorkspaceUpdateDilemmaHandler.getDefault() : dilemmaHandler;
        this.acceptRequests = new HashMap();
        this.componentsAdded = new HashSet<ConfigurationFacade>();
        this.componentsRemoved = new HashSet<ConfigurationFacade>();
        this.componentsCreated = new ArrayList<IComponent>();
        this.redundantChangeSets = false;
        this.resumedChangeSets = false;
        this.acceptFlags = 0;
        this.problemsEncountered = false;
        this.isEclipseMetadataReadFailure = false;
        this.eclipseReadMessages = new ArrayList<String>();
    }

    public boolean isPreflightOnly() {
        return (this.acceptFlags & 1) == 1;
    }

    @Override
    public void setDownloadListener(IDownloadListener downloadListener) {
        this.downloadListener = downloadListener;
    }

    @Override
    public void acceptChangeSets(IWorkspaceConnection workspace, ITeamRepository sourceRepository, List<? extends IChangeSetHandle> changeSets) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (changeSets == null) {
            throw new IllegalArgumentException("Change sets to accept must not be null");
        }
        if (sourceRepository == null) {
            throw new IllegalArgumentException("Source repository must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (!request.isChangeSetContext() || !sourceRepository.equals(request.getSourceRepository())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest == null) {
            existingRequests.add(new WorkspaceUpdateRequest(workspace, sourceRepository, changeSets));
        } else {
            existingRequest.addChangeSets(changeSets);
        }
    }

    @Override
    public void accept(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IChangeHistorySyncReport syncReport, List<? extends IBaselineHandle> baselines, List<? extends IChangeSetHandle> changeSets, List<? extends IComponentHandle> components) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("Source workspace must not be null");
        }
        if (syncReport == null) {
            throw new IllegalArgumentException("Sync compare report must not be null");
        }
        if (baselines == null) {
            throw new IllegalArgumentException("Baselines to accept must not be null");
        }
        if (changeSets == null) {
            throw new IllegalArgumentException("Change sets to accept must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("Components to accept must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceWorkspace.equals((Object)request.getSourceWorkspace())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addBaselines(baselines);
            existingRequest.addChangeSets(changeSets);
            existingRequest.addComponents(components, false);
            existingRequest.updateSyncReport(syncReport);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, syncReport, baselines, changeSets, components);
            existingRequests.add(request);
        }
    }

    @Override
    public void accept(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IChangeHistorySyncReport syncReport) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("Source workspace must not be null");
        }
        if (syncReport == null) {
            throw new IllegalArgumentException("Sync compare report must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceWorkspace.equals((Object)request.getSourceWorkspace())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.setWorkspaceContext(false);
            existingRequest.updateSyncReport(syncReport);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, syncReport, false);
            existingRequests.add(request);
        }
    }

    @Override
    public void accept(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IChangeHistorySyncReport syncReport, List<? extends IComponentHandle> components) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("Source workspace must not be null");
        }
        if (syncReport == null) {
            throw new IllegalArgumentException("Sync compare report must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("Components must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceWorkspace.equals((Object)request.getSourceWorkspace())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addComponents(components, false);
            existingRequest.updateSyncReport(syncReport);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, syncReport, components, false);
            existingRequests.add(request);
        }
    }

    @Override
    public void resume(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> changeSets) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (changeSets == null) {
            throw new IllegalArgumentException("Change sets to accept must not be null");
        }
        ArrayList<? extends IChangeSetHandle> needAList = new ArrayList<IChangeSetHandle>();
        needAList.addAll(changeSets);
        this.acceptChangeSets(workspace, workspace.teamRepository(), needAList);
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IRepositoryResolver resolver, IProgressMonitor progress) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        IFlowTable flowTable = workspace.getFlowTable();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)flowTable.acceptSources().size());
        for (IFlowEntry flowEntry : flowTable.acceptSources()) {
            IFlowNodeHandle source = flowEntry.getFlowNode();
            if (!(source instanceof IWorkspaceHandle)) continue;
            ITeamRepository repository = resolver.getRepoFor(flowEntry.getRemoteRepositoryURI(), flowEntry.getRemoteRepositoryIdentifier());
            IWorkspaceConnection sourceWorkspace = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection((IWorkspaceHandle)source, (IProgressMonitor)monitor.newChild(1));
            ArrayList componentScopes = new ArrayList(flowTable.getComponentScopes(source));
            if (componentScopes.isEmpty()) {
                this.replace(workspace, sourceWorkspace);
                continue;
            }
            this.replace(workspace, sourceWorkspace, componentScopes);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, ITeamRepository sourceRepository, IBaselineSetHandle sourceSnapshot, List<? extends IComponentHandle> components) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceSnapshot == null) {
            throw new IllegalArgumentException("Source snapshot must not be null");
        }
        if (sourceRepository == null) {
            throw new IllegalArgumentException("Source repository must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("Components must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceSnapshot.sameItemId((IItemHandle)request.getSourceSnapshot())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addComponents(components, true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceRepository, sourceSnapshot, components);
            existingRequests.add(request);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("Source workspace must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || sourceWorkspace != request.getSourceWorkspace()) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.setWorkspaceContext(true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, null, true);
            existingRequests.add(request);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, List<? extends IComponentHandle> components) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("Source workspace must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("Components must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceWorkspace.equals((Object)request.getSourceWorkspace())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addComponents(components, true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, null, components, true);
            existingRequests.add(request);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IBaselineConnection sourceBaseline) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceBaseline == null) {
            throw new IllegalArgumentException("Source baseline must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || request.getSourceBaseline() == null || !sourceBaseline.getBaseline().sameItemId((IItemHandle)request.getSourceBaseline().getBaseline())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.setWorkspaceContext(true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceBaseline);
            existingRequests.add(request);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, ITeamRepository sourceRepository, IBaselineSetHandle sourceSnapshot) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceRepository == null) {
            throw new IllegalArgumentException("Source repository must not be null");
        }
        if (sourceSnapshot == null) {
            throw new IllegalArgumentException("Source snapshot must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceSnapshot.sameItemId((IItemHandle)request.getSourceSnapshot())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.setWorkspaceContext(true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceRepository, sourceSnapshot);
            existingRequests.add(request);
        }
    }

    @Override
    public void addComponent(IWorkspaceConnection workspace, String newComponentName) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (newComponentName == null) {
            throw new IllegalArgumentException("New Component name must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext()) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addNewComponent(newComponentName);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, newComponentName);
            existingRequests.add(request);
        }
    }

    @Override
    public void addComponent(IWorkspaceConnection workspace, ITeamRepository sourceRepository, IComponentHandle component) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceRepository.equals(request.getSourceRepository())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addNewComponent(sourceRepository, component);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceRepository, component);
            existingRequests.add(request);
        }
    }

    @Override
    public void removeComponent(IWorkspaceConnection workspace, IComponentHandle component) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext()) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.removeComponent(component);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, component);
            existingRequests.add(request);
        }
    }

    @Override
    protected void execute(IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        this.changes = this.populateUpdateReport ? new WorkspaceUpdateReport() : new NullWorkspaceUpdateReporter();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.WorkspaceUpdateOperation_5, (int)100);
        this.problemsEncountered = false;
        ArrayList determinants = new ArrayList();
        HashSet<IContextHandle> affectedContexts = new HashSet<IContextHandle>();
        final HashSet<ConfigurationFacade> affectedConfigurations = new HashSet<ConfigurationFacade>();
        final ArrayList<ICopyFileAreaLockRequest> cfaLockRequests = new ArrayList<ICopyFileAreaLockRequest>();
        this.getAffectedConfigurations(affectedContexts, affectedConfigurations, cfaLockRequests, (IProgressMonitor)monitor.newChild(2));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWriteForConfigurations(affectedConfigurations, affectedContexts, determinants, (IProgressMonitor)monitor.newChild(1));
        try {
            if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
                for (ConfigurationFacade configuration : affectedConfigurations) {
                    verifyOp.addToVerify(configuration.getConnection(null), configuration.getComponentHandle());
                }
                verifyOp.run((IProgressMonitor)monitor.newChild(2));
            }
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(cfaLockRequests, (IProgressMonitor)progress.newChild(1));
                        try {
                            WorkspaceUpdateOperation.this.doAccept(affectedConfigurations, (IProgressMonitor)progress.newChild(98));
                        }
                        finally {
                            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.WorkspaceUpdateOperation_6, (IProgressMonitor)monitor.newChild(95));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    @Override
    public void runPreConditionsOnly(IProgressMonitor progress) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.WorkspaceUpdateOperation_3, (int)100);
        ArrayList determinants = new ArrayList();
        HashSet<IContextHandle> affectedContexts = new HashSet<IContextHandle>();
        final HashSet<ConfigurationFacade> affectedConfigurations = new HashSet<ConfigurationFacade>();
        final ArrayList<ICopyFileAreaLockRequest> cfaLockRequests = new ArrayList<ICopyFileAreaLockRequest>();
        this.getAffectedConfigurations(affectedContexts, affectedConfigurations, cfaLockRequests, (IProgressMonitor)monitor.newChild(1));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWriteForConfigurations(affectedConfigurations, affectedContexts, determinants, (IProgressMonitor)monitor.newChild(1));
        try {
            try {
                if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                    IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
                    for (ConfigurationFacade configuration : affectedConfigurations) {
                        verifyOp.addToVerify(configuration.getConnection(null), configuration.getComponentHandle());
                    }
                    verifyOp.run((IProgressMonitor)monitor.newChild(3));
                }
                IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                    @Override
                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        try {
                            ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(cfaLockRequests, (IProgressMonitor)progress.newChild(1));
                            try {
                                WorkspaceUpdateOperation.this.runPreConditions(affectedConfigurations, (IProgressMonitor)progress.newChild(98));
                            }
                            finally {
                                copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
                            }
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                this.runWithinFileSystemLock(runnableWithProgress, Messages.WorkspaceUpdateOperation_7, (IProgressMonitor)monitor.newChild(95));
            }
            catch (FileSystemException e) {
                throw new TeamRepositoryException((Throwable)((Object)e));
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    @Override
    public Collection<ConfigurationFacade> getComponentsAdded() {
        return this.componentsAdded;
    }

    @Override
    public List<IComponent> getComponentsCreated() {
        return this.componentsCreated;
    }

    private void doAccept(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(100 + 100 * this.acceptRequests.size()));
        HashMap<IWorkspaceConnection, List<IUpdateReport>> updateReports = new HashMap<IWorkspaceConnection, List<IUpdateReport>>();
        this.runPreConditions(affectedConfigurations, (IProgressMonitor)monitor.newChild(8));
        for (Map.Entry<IWorkspaceConnection, List<WorkspaceUpdateRequest>> entry : this.acceptRequests.entrySet()) {
            SubMonitor iterProgress = monitor.newChild(100);
            IWorkspaceConnection workspace = entry.getKey();
            List<WorkspaceUpdateRequest> requests = entry.getValue();
            if (!this.isPreflightOnly()) {
                this.performComponentOperations(workspace, requests, updateReports, (IProgressMonitor)iterProgress.newChild(5));
            }
            ArrayList<IChangeSetHandle> resumedChangeSetsList = new ArrayList<IChangeSetHandle>();
            iterProgress.setWorkRemaining(20 + 10 * requests.size());
            for (WorkspaceUpdateRequest acceptRequest : requests) {
                this.performAcceptRequest(acceptRequest, updateReports, resumedChangeSetsList, (IProgressMonitor)iterProgress.newChild(10));
                if (this.problemsEncountered) break;
                this.checkCancelled((IProgressMonitor)monitor);
            }
            iterProgress.setWorkRemaining(10 + workspace.getComponents().size());
            if (!resumedChangeSetsList.isEmpty()) {
                Map<IComponentHandle, IChangeSetHandle> changeSetsToBeCurrent = WorkspaceUpdateOperation.shouldMakeResumedCurrent(workspace, resumedChangeSetsList, (IProgressMonitor)iterProgress.newChild(10));
                for (IChangeSetHandle toMakeCurrent : changeSetsToBeCurrent.values()) {
                    workspace.setCurrentChangeSet(toMakeCurrent, (IProgressMonitor)iterProgress.newChild(1));
                }
            }
            if (this.problemsEncountered) break;
        }
        if (!this.isPreflightOnly()) {
            SubMonitor iterMonitor = monitor.setWorkRemaining(10 + updateReports.size() * 10);
            if (!this.componentsRemoved.isEmpty()) {
                try {
                    IUnshareOperation op = this.getUnshareProjectsOperation(this.componentsRemoved);
                    op.run((IProgressMonitor)iterMonitor.newChild(10));
                }
                catch (TeamRepositoryException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                }
            }
            for (Map.Entry entry : updateReports.entrySet()) {
                UpdateOperation updateOperation = new UpdateOperation((IWorkspaceConnection)entry.getKey(), (List)entry.getValue(), 3, this.problemHandler, this.downloadListener);
                this.disableVerifyInSync(updateOperation);
                try {
                    updateOperation.run((IProgressMonitor)iterMonitor.newChild(10));
                }
                catch (EclipseReadException e) {
                    this.isEclipseMetadataReadFailure = true;
                    IStatus s = FileSystemStatusUtil.getStatusFor((Throwable)((Object)e));
                    this.saveRecursiveMessages(s, this.eclipseReadMessages);
                    this.savedEclipseReadException = e;
                }
                catch (FileSystemException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                }
                catch (TeamRepositoryException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                }
            }
        }
        boolean resolveContentChanges = !this.problemsEncountered;
        resolveContentChanges |= (this.acceptFlags & 8) != 0;
        if (resolveContentChanges |= (this.acceptFlags & 0xC) != 0) {
            for (IWorkspaceConnection workspace : this.acceptRequests.keySet()) {
                this.performContentChanges(workspace, this.getComponentsWithCurrentPort(workspace, updateReports, false), (IProgressMonitor)monitor.newChild(1));
            }
        }
    }

    private void saveRecursiveMessages(IStatus status, List<String> savedMessages) {
        IStatus[] sChildren;
        savedMessages.add(status.getMessage());
        IStatus[] iStatusArray = sChildren = status.getChildren();
        int n = sChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus sChild = iStatusArray[n2];
            this.saveRecursiveMessages(sChild, savedMessages);
            ++n2;
        }
    }

    private void performComponentOperations(IWorkspaceConnection workspace, List<WorkspaceUpdateRequest> requests, HashMap<IWorkspaceConnection, List<IUpdateReport>> updateReports, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(5 + 10 * requests.size()));
        ArrayList<IFlowNodeConnection.IComponentOp> componentOps = new ArrayList<IFlowNodeConnection.IComponentOp>();
        for (WorkspaceUpdateRequest acceptRequest : requests) {
            acceptRequest.createNewComponents((IProgressMonitor)monitor.newChild(1));
            componentOps.addAll(acceptRequest.getComponentOperations((IProgressMonitor)monitor.newChild(1)));
            componentOps.addAll(acceptRequest.getReplaceCandidates((IProgressMonitor)monitor.newChild(1)));
        }
        this.checkCancelled((IProgressMonitor)monitor);
        if (!componentOps.isEmpty()) {
            IUpdateReport updateReport = workspace.applyComponentOperations(componentOps, true, (IProgressMonitor)monitor.newChild(5));
            this.changes.recordComponentOps(workspace, componentOps);
            this.holdUpdateReport(workspace, updateReport, updateReports);
            for (WorkspaceUpdateRequest acceptRequest : requests) {
                Collection<IFlowNodeConnection.IComponentOp> componentOpsDone = acceptRequest.getComponentOperations((IProgressMonitor)monitor.newChild(1));
                SubMonitor iterProgress = monitor.newChild(6);
                iterProgress.setWorkRemaining(componentOpsDone.size());
                for (IFlowNodeConnection.IComponentOp componentOp : componentOpsDone) {
                    if (componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                        if (acceptRequest.getSourceWorkspace() != null && acceptRequest.getWorkspace().getFlowTable().getDeliverFlow((IFlowNodeHandle)acceptRequest.getSourceWorkspace().getResolvedWorkspace()) != null) {
                            FlowUtils.addComponentSyncState((IWorkspaceConnection)workspace, (IConnection)acceptRequest.getSourceWorkspace(), (IComponentHandle)componentOp.getComponent(), (IProgressMonitor)iterProgress.newChild(1));
                        }
                        this.componentsAdded.add(new ConfigurationFacade((IConnection)workspace, componentOp.getComponent()));
                        continue;
                    }
                    if (!(componentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                    if (acceptRequest.getSourceWorkspace() != null && acceptRequest.getWorkspace().getFlowTable().getDeliverFlow((IFlowNodeHandle)acceptRequest.getSourceWorkspace().getResolvedWorkspace()) != null) {
                        FlowUtils.removeComponentSyncState((IWorkspaceConnection)acceptRequest.getWorkspace(), (IConnection)acceptRequest.getSourceWorkspace(), (IComponentHandle)componentOp.getComponent(), (IProgressMonitor)iterProgress.newChild(1));
                    }
                    this.componentsRemoved.add(new ConfigurationFacade((IConnection)workspace, componentOp.getComponent()));
                }
                this.componentsCreated.addAll(acceptRequest.getCreatedComponents());
            }
        }
    }

    private void runPreConditions(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)50);
        this.verifyComponentFlowing((IProgressMonitor)monitor.newChild(10));
        this.checkinPendingChanges(affectedConfigurations, this.problemHandler, true, (IProgressMonitor)monitor.newChild(10));
        this.verifyReplaceComponents((IProgressMonitor)monitor.newChild(10));
        this.disconnectedComponents(affectedConfigurations, (IProgressMonitor)monitor.newChild(10));
        this.validateRequests((IProgressMonitor)monitor.newChild(10));
    }

    private void verifyReplaceComponents(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 + 10 * this.acceptRequests.size()));
        HashSet<ConfigurationFacade> replaceConfigurations = new HashSet<ConfigurationFacade>();
        HashMap replaces = new HashMap();
        for (List<WorkspaceUpdateRequest> requests : this.acceptRequests.values()) {
            SubMonitor iterProgress = SubMonitor.convert((IProgressMonitor)monitor.newChild(10), (int)(10 * requests.size()));
            for (WorkspaceUpdateRequest request : requests) {
                Collection<IFlowNodeConnection.IComponentReplacementOp> componentOps = request.getReplaceCandidates((IProgressMonitor)iterProgress.newChild(10));
                ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>();
                for (IFlowNodeConnection.IComponentReplacementOp op : componentOps) {
                    replaceConfigurations.add(new ConfigurationFacade((IConnection)request.getWorkspace(), op.getComponent()));
                    components.add(op.getComponent());
                }
                replaces.put(request, components);
            }
        }
        if (!replaceConfigurations.isEmpty()) {
            int direction = this.getAcceptDilemmaHandler().componentReplacementCandidates(replaceConfigurations);
            if (direction == 1) {
                throw new OperationCanceledException();
            }
            if (direction != 0) {
                if (direction == 3) {
                    SubMonitor iterProgress = SubMonitor.convert((IProgressMonitor)monitor.newChild(10), (int)replaces.size());
                    for (Map.Entry entry : replaces.entrySet()) {
                        WorkspaceUpdateRequest acceptRequest = (WorkspaceUpdateRequest)entry.getKey();
                        acceptRequest.excludeComponentOps((List)entry.getValue(), (IProgressMonitor)iterProgress.newChild(1));
                    }
                } else {
                    throw new FileSystemException(Messages.WorkspaceUpdateOperation_1);
                }
            }
        }
    }

    private void getAffectedConfigurations(Set<IContextHandle> workspacesToLock, Set<ConfigurationFacade> configurationsAffected, List<ICopyFileAreaLockRequest> cfaLockRequests, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.acceptRequests.size());
        HashSet<ConfigurationFacade> cfaConfigurationsAffected = new HashSet<ConfigurationFacade>();
        for (List<WorkspaceUpdateRequest> requests : this.acceptRequests.values()) {
            SubMonitor iterMonitor = monitor.newChild(1).setWorkRemaining(requests.size() * 2);
            for (WorkspaceUpdateRequest acceptRequest : requests) {
                configurationsAffected.addAll(acceptRequest.getAffectedConfigurations((IProgressMonitor)iterMonitor.newChild(1)));
                Collection<IFlowNodeConnection.IComponentOp> componentOps = acceptRequest.getComponentOperations((IProgressMonitor)iterMonitor.newChild(1));
                for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                    if (!(componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) && !(componentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                    workspacesToLock.add(acceptRequest.getWorkspace().getContextHandle());
                    break;
                }
                for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                    if (!(componentOp instanceof IFlowNodeConnection.IComponentAdditionOp)) continue;
                    cfaConfigurationsAffected.add(new ConfigurationFacade((IConnection)acceptRequest.getWorkspace(), componentOp.getComponent()));
                }
                if (acceptRequest.getNewComponentNames().isEmpty()) continue;
                workspacesToLock.add(acceptRequest.getWorkspace().getContextHandle());
            }
        }
        cfaConfigurationsAffected.addAll(configurationsAffected);
        ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(cfaConfigurationsAffected, true);
        cfaLockRequests.add(lockRequest);
    }

    private void disconnectedComponents(Set<ConfigurationFacade> configurationsAffected, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        HashSet<ConfigurationFacade> configurations = new HashSet<ConfigurationFacade>(configurationsAffected);
        Map<ISandbox, Set<ConfigurationFacade>> areasAffected = this.getCopyFileAreasAffected(configurationsAffected, (IProgressMonitor)monitor.newChild(10));
        for (Set<ConfigurationFacade> configurationsLoaded : areasAffected.values()) {
            configurations.removeAll(configurationsLoaded);
        }
        if (!configurations.isEmpty()) {
            int reaction = this.problemHandler.disconnectedComponents(configurations);
            if (reaction == 1) {
                throw new OperationCanceledException();
            }
            if (reaction != 0) {
                throw new FileSystemException(Messages.WorkspaceUpdateOperation_2);
            }
        }
    }

    private void validateRequests(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 * this.acceptRequests.size()));
        for (List<WorkspaceUpdateRequest> requests : this.acceptRequests.values()) {
            SubMonitor iterProgress = monitor.newChild(10).setWorkRemaining(requests.size() * 10);
            HashSet<ITeamRepository> repositoriesAffected = new HashSet<ITeamRepository>();
            HashSet<UUID> componentsAffected = new HashSet<UUID>();
            for (WorkspaceUpdateRequest request : requests) {
                ITeamRepository sourceRepository = request.getSourceRepository();
                repositoriesAffected.add(sourceRepository);
                HashSet<UUID> componentIds = new HashSet<UUID>();
                Collection<ConfigurationFacade> configurations = request.getAffectedConfigurations((IProgressMonitor)iterProgress.newChild(1));
                for (ConfigurationFacade configuration : configurations) {
                    componentIds.add(configuration.getComponentHandle().getItemId());
                }
                Collection<IFlowNodeConnection.IComponentOp> componentOps = request.getComponentOperations((IProgressMonitor)iterProgress.newChild(1));
                for (IFlowNodeConnection.IComponentOp op : componentOps) {
                    componentIds.add(op.getComponent().getItemId());
                    if (repositoriesAffected.size() <= 1) continue;
                    throw new FileSystemException(Messages.WorkspaceUpdateOperation_8);
                }
                for (UUID id : componentIds) {
                    if (componentsAffected.add(id) || request.isChangeSetContext()) continue;
                    IComponent component = (IComponent)request.getWorkspace().teamRepository().itemManager().fetchCompleteItem(IComponent.ITEM_TYPE.createItemHandle(id, null), 0, (IProgressMonitor)iterProgress.newChild(1));
                    throw new FileSystemException(NLS.bind((String)Messages.WorkspaceUpdateOperation_4, (Object)component.getName(), (Object[])new Object[]{request.getWorkspace().getResolvedWorkspace().getName()}));
                }
            }
        }
    }

    private void performAcceptRequest(WorkspaceUpdateRequest acceptRequest, HashMap<IWorkspaceConnection, List<IUpdateReport>> updateReports, List<IChangeSetHandle> resumedChangeSetsList, IProgressMonitor progress) throws TeamRepositoryException {
        int paranoiaCheck = 10;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 + 16 * paranoiaCheck));
        ArrayList<IChangeSetHandle> changeSetsToAccept = new ArrayList<IChangeSetHandle>(acceptRequest.getChangeSets((IProgressMonitor)monitor.newChild(1)));
        ArrayList<IBaselineHandle> baselinesToAccept = new ArrayList<IBaselineHandle>(acceptRequest.getBaselines((IProgressMonitor)monitor.newChild(1)));
        if (!changeSetsToAccept.isEmpty() || !baselinesToAccept.isEmpty()) {
            boolean retryAccept = true;
            int staleDataRetries = 0;
            ArrayList<IChangeSetHandle> toResume = new ArrayList<IChangeSetHandle>();
            int flagsForAccept = this.acceptFlags;
            while (retryAccept && !this.problemsEncountered && paranoiaCheck-- > 0) {
                this.checkCancelled((IProgressMonitor)monitor);
                retryAccept = false;
                int action = 0;
                try {
                    IUpdateReport updateReport;
                    if (acceptRequest.isChangeSetContext() && baselinesToAccept.isEmpty() && !changeSetsToAccept.isEmpty()) {
                        action = 1;
                        updateReport = acceptRequest.getWorkspace().accept(flagsForAccept, changeSetsToAccept, acceptRequest.getSourceRepository(), (IProgressMonitor)monitor.newChild(8));
                        this.changes.recordChangeSets(acceptRequest.getWorkspace(), changeSetsToAccept, (IProgressMonitor)monitor.newChild(1));
                        this.holdUpdateReport(acceptRequest.getWorkspace(), updateReport, updateReports);
                        changeSetsToAccept.clear();
                    } else if (!changeSetsToAccept.isEmpty() || !baselinesToAccept.isEmpty()) {
                        action = 2;
                        updateReport = acceptRequest.getWorkspace().accept(flagsForAccept, acceptRequest.getSourceWorkspace(), acceptRequest.getSyncReport((IProgressMonitor)monitor.newChild(1)), baselinesToAccept, changeSetsToAccept, (IProgressMonitor)monitor.newChild(7));
                        this.changes.recordChangeSets(acceptRequest.getWorkspace(), changeSetsToAccept, (IProgressMonitor)monitor.newChild(1));
                        this.changes.recordBaselines(acceptRequest.getWorkspace(), baselinesToAccept, (IProgressMonitor)monitor.newChild(1));
                        this.holdUpdateReport(acceptRequest.getWorkspace(), updateReport, updateReports);
                        changeSetsToAccept.clear();
                        baselinesToAccept.clear();
                    }
                    if (toResume.isEmpty()) continue;
                    action = 3;
                    updateReport = acceptRequest.getWorkspace().resume(flagsForAccept, toResume, (IProgressMonitor)monitor.newChild(4));
                    this.changes.recordChangeSets(acceptRequest.getWorkspace(), toResume, (IProgressMonitor)monitor.newChild(1));
                    this.holdUpdateReport(acceptRequest.getWorkspace(), updateReport, updateReports);
                    this.resumedChangeSets = true;
                    resumedChangeSetsList.addAll(toResume);
                    toResume.clear();
                }
                catch (ActiveChangeSetsOverlapException e) {
                    retryAccept = this.handleActiveChangeSetsOverlap(acceptRequest, toResume, e, (IProgressMonitor)monitor.newChild(3));
                }
                catch (PatchInProgressException e) {
                    if ((flagsForAccept & 2) == 0) {
                        int instructions = this.problemHandler.portInProgress(acceptRequest.getWorkspace(), changeSetsToAccept);
                        switch (instructions) {
                            case 1: {
                                throw new OperationCanceledException();
                            }
                            case 0: {
                                retryAccept = true;
                                break;
                            }
                            default: {
                                this.handleProblem((TeamRepositoryException)((Object)e));
                                break;
                            }
                        }
                    } else {
                        retryAccept = false;
                    }
                    if (retryAccept) {
                        flagsForAccept |= 2;
                        flagsForAccept |= 8;
                    }
                    if ((flagsForAccept & 2) == 0 || retryAccept) continue;
                    this.handleProblem((TeamRepositoryException)((Object)e));
                }
                catch (GapException e) {
                    if ((flagsForAccept & 2) == 0) {
                        retryAccept = this.handleGap(acceptRequest, action == 3 ? toResume : changeSetsToAccept, toResume, !toResume.isEmpty(), e, monitor.newChild(3));
                        if (retryAccept) {
                            flagsForAccept |= 2;
                            flagsForAccept |= 8;
                        }
                    } else {
                        retryAccept = false;
                    }
                    if ((flagsForAccept & 2) == 0 || retryAccept) continue;
                    this.handleProblem((TeamRepositoryException)((Object)e));
                }
                catch (ChangeSetAlreadyInHistoryException e) {
                    retryAccept = this.handleChangeSetAlreadyInHistory(acceptRequest, action == 3 ? toResume : changeSetsToAccept, (TeamRepositoryException)((Object)e), (IProgressMonitor)monitor.newChild(3));
                    if (retryAccept) continue;
                    this.handleProblem((TeamRepositoryException)((Object)e));
                }
                catch (ActiveChangeSetsException e) {
                    retryAccept = this.handleActiveChangeSets(acceptRequest, changeSetsToAccept, (TeamRepositoryException)((Object)e), (IProgressMonitor)monitor.newChild(3));
                }
                catch (AcceptSuspendedChangeSetException e) {
                    retryAccept = this.handleSuspendedChangeSets(acceptRequest, changeSetsToAccept, toResume, (IProgressMonitor)monitor.newChild(3));
                    if (retryAccept) continue;
                    this.handleProblem((TeamRepositoryException)((Object)e));
                }
                catch (StaleDataException e) {
                    retryAccept = this.handleStaleData(acceptRequest, staleDataRetries, e, (IProgressMonitor)monitor.newChild(3));
                    ++staleDataRetries;
                }
                catch (TeamRepositoryException e) {
                    retryAccept = this.handleChangeSetAlreadyInHistory(acceptRequest, changeSetsToAccept, e, (IProgressMonitor)monitor.newChild(1));
                    if (!retryAccept) {
                        retryAccept = this.handleSuspendedChangeSets(acceptRequest, changeSetsToAccept, toResume, (IProgressMonitor)monitor.newChild(1));
                    }
                    if (!retryAccept) {
                        retryAccept = this.handleActiveChangeSets(acceptRequest, changeSetsToAccept, e, (IProgressMonitor)monitor.newChild(1));
                    }
                    if (retryAccept) continue;
                    this.handleProblem(e);
                }
            }
            if (!this.problemsEncountered && (flagsForAccept & 2) != 0) {
                this.handleCurrentPorts(acceptRequest.getWorkspace(), this.getComponentsWithCurrentPort(acceptRequest.getWorkspace(), updateReports, true), (IProgressMonitor)monitor.newChild(1));
            }
        }
    }

    private List<IComponentHandle> getComponentsWithCurrentPort(IWorkspaceConnection workspace, HashMap<IWorkspaceConnection, List<IUpdateReport>> updateReports, boolean includeAcceptQueueChanges) {
        ArrayList<IComponentHandle> componentsWithCurrentPort = new ArrayList<IComponentHandle>();
        List<IUpdateReport> updateReportList = updateReports.get(workspace);
        if (updateReportList != null) {
            for (IUpdateReport ur : updateReportList) {
                for (IComponentHandle ch : ur.getModifiedComponents()) {
                    if (!this.mayHaveCurrentPortChange(ur, ch) && (!includeAcceptQueueChanges || !this.mayHaveAcceptQueueChange(ur, ch)) || workspace.getCurrentPatch(ch) == null) continue;
                    componentsWithCurrentPort.add(ch);
                }
            }
        }
        return componentsWithCurrentPort;
    }

    private boolean mayHaveCurrentPortChange(IUpdateReport updateReport, IComponentHandle componentHandle) {
        IComponentStateSummary componentSummaryBefore = updateReport.getComponentSummaryBefore(componentHandle);
        IComponentStateSummary componentSummaryAfter = updateReport.getComponentSummaryAfter(componentHandle);
        if (componentSummaryBefore == null) {
            return true;
        }
        if (componentSummaryAfter == null) {
            return false;
        }
        return ((SyncTime)componentSummaryBefore.getCurrentPortTime()).getValue() != ((SyncTime)componentSummaryAfter.getCurrentPortTime()).getValue();
    }

    private boolean mayHaveAcceptQueueChange(IUpdateReport updateReport, IComponentHandle componentHandle) {
        IComponentStateSummary componentSummaryBefore = updateReport.getComponentSummaryBefore(componentHandle);
        IComponentStateSummary componentSummaryAfter = updateReport.getComponentSummaryAfter(componentHandle);
        if (componentSummaryBefore == null) {
            return true;
        }
        if (componentSummaryAfter == null) {
            return false;
        }
        return ((SyncTime)componentSummaryBefore.getPendingPortsListTime()).getValue() != ((SyncTime)componentSummaryAfter.getPendingPortsListTime()).getValue();
    }

    private void performContentChanges(IWorkspaceConnection workspace, List<IComponentHandle> components, IProgressMonitor progress) {
        for (IComponentHandle component : components) {
            UpdateCurrentPortOperation updateOperation = (UpdateCurrentPortOperation)IOperationFactory.instance.getUpdateCurrentPortOperation(this.problemHandler.getUpdateCurrentPortDilemmaHandler());
            updateOperation.setContext(workspace, component);
            if (updateOperation.autoResolveChanges(IContentChangeDetail.class, true)) {
                try {
                    updateOperation.run(progress);
                }
                catch (TeamRepositoryException e) {
                    this.handleProblem(e);
                }
            }
            this.performPostContentChangeEncodingChanges(workspace, component, progress);
        }
    }

    private void performPostContentChangeEncodingChanges(IWorkspaceConnection workspace, IComponentHandle component, IProgressMonitor progress) {
        UpdateCurrentPortOperation updateOperation = (UpdateCurrentPortOperation)IOperationFactory.instance.getUpdateCurrentPortOperation(UpdateCurrentPatchDilemmaHandler.getDefault());
        updateOperation.setContext(workspace, component);
        boolean hasMoreChanges = updateOperation.autoResolveChanges(IEncodingChangeDetail.class, true);
        if (hasMoreChanges |= updateOperation.autoResolveChanges(ILineDelimiterChangeDetail.class, true)) {
            try {
                updateOperation.run(progress);
            }
            catch (TeamRepositoryException e) {
                this.handleProblem(e);
            }
        }
    }

    private void handleCurrentPorts(IWorkspaceConnection workspace, List<IComponentHandle> components, IProgressMonitor progress) {
        this.problemHandler.currentPortsPresent(workspace, components, progress);
    }

    private boolean handleStaleData(WorkspaceUpdateRequest acceptRequest, int staleDataRetries, StaleDataException exception, IProgressMonitor progress) {
        boolean retry = false;
        if (staleDataRetries > 0) {
            this.handleProblem((TeamRepositoryException)((Object)exception));
        } else {
            int reaction = this.problemHandler.staleData(acceptRequest.getWorkspace(), acceptRequest.getSourceWorkspace());
            if (reaction == 1) {
                throw new OperationCanceledException();
            }
            if (reaction == 0) {
                try {
                    acceptRequest.recomputeSyncReport(progress);
                    retry = true;
                }
                catch (TeamRepositoryException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                    this.handleProblem(e);
                }
            } else {
                this.handleProblem((TeamRepositoryException)((Object)exception));
            }
        }
        return retry;
    }

    private void handleProblem(TeamRepositoryException e) {
        this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
        this.problemsEncountered = true;
    }

    private boolean handleChangeSetAlreadyInHistory(WorkspaceUpdateRequest acceptRequest, List<IChangeSetHandle> changeSets, TeamRepositoryException exception, IProgressMonitor progress) {
        boolean retry = false;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        try {
            List changeSetsAlreadyInHistory = acceptRequest.getWorkspace().changeSetsInHistory(changeSets, (IProgressMonitor)monitor.newChild(2));
            if (!changeSetsAlreadyInHistory.isEmpty()) {
                HashSet<UUID> redundant = new HashSet<UUID>();
                for (IChangeSetHandle cs : changeSetsAlreadyInHistory) {
                    redundant.add(cs.getItemId());
                }
                Iterator<IChangeSetHandle> iChangeSets = changeSets.iterator();
                while (iChangeSets.hasNext()) {
                    IChangeSetHandle cs = iChangeSets.next();
                    if (!redundant.contains(cs.getItemId())) continue;
                    iChangeSets.remove();
                    this.redundantChangeSets = true;
                    retry = true;
                }
            }
        }
        catch (TeamRepositoryException failure) {
            this.collectStatus(FileSystemStatusUtil.getStatusFor(exception));
            this.handleProblem(failure);
        }
        return retry;
    }

    private boolean handleSuspendedChangeSets(WorkspaceUpdateRequest acceptRequest, List<IChangeSetHandle> changeSets, List<IChangeSetHandle> toResume, IProgressMonitor progress) {
        boolean retry = false;
        List suspendedCS = acceptRequest.getWorkspace().suspendedChangeSets();
        if (!suspendedCS.isEmpty()) {
            HashSet<UUID> suspended = new HashSet<UUID>();
            for (IChangeSetHandle cs : suspendedCS) {
                suspended.add(cs.getItemId());
            }
            Iterator<IChangeSetHandle> iChangeSets = changeSets.iterator();
            while (iChangeSets.hasNext()) {
                IChangeSetHandle cs = iChangeSets.next();
                if (!suspended.contains(cs.getItemId())) continue;
                iChangeSets.remove();
                toResume.add(cs);
                retry = true;
            }
        }
        return retry;
    }

    private boolean handleActiveChangeSets(WorkspaceUpdateRequest acceptRequest, List<IChangeSetHandle> changeSetsToAccept, TeamRepositoryException exception, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        boolean retry = false;
        HashSet<UUID> open = new HashSet<UUID>();
        ArrayList<IChangeSetHandle> activeChangeSets = new ArrayList<IChangeSetHandle>();
        try {
            if (acceptRequest.isChangeSetContext() || acceptRequest.getSourceWorkspace() == null) {
                List fullChangeSets = acceptRequest.getSourceRepository().itemManager().fetchCompleteItems(changeSetsToAccept, 0, (IProgressMonitor)monitor);
                for (IChangeSetHandle changeSet : fullChangeSets) {
                    if (changeSet == null || !changeSet.isActive()) continue;
                    open.add(changeSet.getItemId());
                }
            } else {
                List active = acceptRequest.getSourceWorkspace().activeChangeSets();
                for (IChangeSetHandle changeSet : active) {
                    open.add(changeSet.getItemId());
                }
            }
            if (!open.isEmpty()) {
                Iterator<IChangeSetHandle> iChangeSets = changeSetsToAccept.iterator();
                while (iChangeSets.hasNext()) {
                    IChangeSetHandle cs = iChangeSets.next();
                    if (!open.contains(cs.getItemId())) continue;
                    iChangeSets.remove();
                    activeChangeSets.add(cs);
                }
                if (!activeChangeSets.isEmpty()) {
                    int direction = this.problemHandler.activeChangeSets(acceptRequest.getWorkspace(), activeChangeSets);
                    if (direction == 0) {
                        retry = true;
                    } else if (direction != 3) {
                        if (direction == 1) {
                            throw new OperationCanceledException();
                        }
                        this.handleProblem(exception);
                    }
                }
            }
        }
        catch (TeamRepositoryException e) {
            this.collectStatus(FileSystemStatusUtil.getStatusFor(exception));
            this.handleProblem(e);
        }
        return retry;
    }

    private boolean handleActiveChangeSetsOverlap(WorkspaceUpdateRequest acceptRequest, List<IChangeSetHandle> toResume, ActiveChangeSetsOverlapException exception, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        boolean retry = false;
        try {
            List fullChangeSets = acceptRequest.getWorkspace().teamRepository().itemManager().fetchCompleteItems(toResume, 0, (IProgressMonitor)monitor.newChild(50));
            ArrayList<IChangeSet> activeChangeSets = new ArrayList<IChangeSet>();
            for (IChangeSet changeSet : fullChangeSets) {
                if (!changeSet.isActive()) continue;
                activeChangeSets.add(changeSet);
            }
            int instructions = this.problemHandler.activeChangeSetsOverlap(acceptRequest.getWorkspace(), activeChangeSets);
            if (instructions == 0) {
                acceptRequest.getWorkspace().closeChangeSets(activeChangeSets, (IProgressMonitor)monitor.newChild(50));
                retry = true;
            } else if (instructions != 3) {
                if (instructions == 1) {
                    throw new OperationCanceledException();
                }
                this.handleProblem((TeamRepositoryException)((Object)exception));
            }
        }
        catch (TeamRepositoryException e) {
            this.collectStatus(FileSystemStatusUtil.getStatusFor(exception));
            this.handleProblem(e);
        }
        return retry;
    }

    private boolean handleGap(WorkspaceUpdateRequest acceptRequest, List<IChangeSetHandle> changeSetsWithGap, List<IChangeSetHandle> toResume, boolean handlingSuspended, GapException exception, SubMonitor progress) {
        boolean retry = false;
        int instructions = this.problemHandler.gap(acceptRequest.getWorkspace(), changeSetsWithGap, handlingSuspended);
        if (instructions == 0) {
            retry = true;
        } else if (instructions != 3) {
            if (instructions == 1) {
                throw new OperationCanceledException();
            }
            this.handleProblem((TeamRepositoryException)((Object)exception));
        }
        return retry;
    }

    private void holdUpdateReport(IWorkspaceConnection workspace, IUpdateReport updateReport, HashMap<IWorkspaceConnection, List<IUpdateReport>> updateReports) {
        List<IUpdateReport> reports = updateReports.get(workspace);
        if (reports == null) {
            reports = new ArrayList<IUpdateReport>();
            updateReports.put(workspace, reports);
        }
        reports.add(updateReport);
    }

    private void verifyComponentFlowing(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 + this.acceptRequests.size() * 10));
        HashMap<WorkspaceUpdateRequest, ArrayList<IComponentHandle>> componentsFlowedForRequest = new HashMap<WorkspaceUpdateRequest, ArrayList<IComponentHandle>>();
        ArrayList<ConfigurationFacade> added = new ArrayList<ConfigurationFacade>();
        ArrayList<ConfigurationFacade> removed = new ArrayList<ConfigurationFacade>();
        for (List<WorkspaceUpdateRequest> requests : this.acceptRequests.values()) {
            SubMonitor iterMonitor = monitor.newChild(10).setWorkRemaining(requests.size());
            for (WorkspaceUpdateRequest acceptRequest : requests) {
                if (acceptRequest.isChangeSetContext()) continue;
                Collection<IFlowNodeConnection.IComponentOp> componentOps = acceptRequest.getComponentOperations((IProgressMonitor)iterMonitor.newChild(1));
                for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                    if (!(componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) && !(componentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                    if (componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                        added.add(new ConfigurationFacade((IConnection)acceptRequest.getWorkspace(), componentOp.getComponent()));
                    } else {
                        removed.add(new ConfigurationFacade((IConnection)acceptRequest.getWorkspace(), componentOp.getComponent()));
                    }
                    ArrayList<IComponentHandle> flowsForRequest = (ArrayList<IComponentHandle>)componentsFlowedForRequest.get(acceptRequest);
                    if (flowsForRequest == null) {
                        flowsForRequest = new ArrayList<IComponentHandle>();
                        componentsFlowedForRequest.put(acceptRequest, flowsForRequest);
                    }
                    flowsForRequest.add(componentOp.getComponent());
                }
            }
        }
        if (added.size() > 0 || removed.size() > 0) {
            int result = this.getAcceptDilemmaHandler().componentsToBeAddedOrRemoved(added, removed);
            if (result == 1) {
                throw new OperationCanceledException();
            }
            if (result == 3) {
                SubMonitor iterProgress = monitor.newChild(10);
                iterProgress.setWorkRemaining(componentsFlowedForRequest.entrySet().size());
                for (Map.Entry entry : componentsFlowedForRequest.entrySet()) {
                    WorkspaceUpdateRequest acceptRequest = (WorkspaceUpdateRequest)entry.getKey();
                    acceptRequest.excludeComponentOps((List)entry.getValue(), (IProgressMonitor)iterProgress.newChild(1));
                }
            } else if (result != 0) {
                throw new FileSystemException(Messages.WorkspaceUpdateOperation_0);
            }
        }
    }

    protected final WorkspaceUpdateDilemmaHandler getAcceptDilemmaHandler() {
        return this.problemHandler;
    }

    @Override
    public boolean changeSetsAlreadyInHistory() {
        return this.redundantChangeSets;
    }

    @Override
    public boolean acceptedSuspendedChangeSets() {
        return this.resumedChangeSets;
    }

    private IRepositoryResolver getRepositoryResolver(Set<ConfigurationFacade> componentsRemoved) {
        final HashMap<UUID, ITeamRepository> repos = new HashMap<UUID, ITeamRepository>();
        for (ConfigurationFacade configuration : componentsRemoved) {
            ITeamRepository teamRepository = null;
            try {
                teamRepository = configuration.getTeamRepository();
            }
            catch (TeamRepositoryException teamRepositoryException) {}
            if (teamRepository == null) continue;
            repos.put(configuration.getRepositoryId(), teamRepository);
        }
        return new IRepositoryResolver(){

            @Override
            public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                return (ITeamRepository)repos.get(id);
            }
        };
    }

    private IUnshareOperation getUnshareProjectsOperation(Set<ConfigurationFacade> componentsRemoved) {
        IUnshareOperation op = IOperationFactory.instance.getUnshareOperation(null, this.getRepositoryResolver(componentsRemoved));
        op.requestUnshare(componentsRemoved);
        op.setDeleteContent(true);
        return op;
    }

    @Override
    public IWorkspaceUpdateReport getUpdateReport() {
        if (this.changes == null) {
            throw new IllegalStateException();
        }
        return this.changes.getReport();
    }

    @Override
    public void setPopulateUpdateReport(boolean shouldPopulate) {
        if (this.changes != null) {
            throw new IllegalStateException();
        }
        this.populateUpdateReport = shouldPopulate;
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        int totalReqs = 0;
        for (Map.Entry<IWorkspaceConnection, List<WorkspaceUpdateRequest>> wsConnPair : this.acceptRequests.entrySet()) {
            totalReqs += wsConnPair.getValue().size();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)totalReqs);
        for (Map.Entry<IWorkspaceConnection, List<WorkspaceUpdateRequest>> wsConnPair : this.acceptRequests.entrySet()) {
            for (WorkspaceUpdateRequest req : wsConnPair.getValue()) {
                Collection<IFlowNodeConnection.IComponentOp> ops = req.getComponentOperations((IProgressMonitor)monitor.newChild(1));
                SubMonitor compMon = monitor.newChild(1);
                compMon.setWorkRemaining(ops.size() * 3);
                for (IFlowNodeConnection.IComponentOp op : ops) {
                    if (!(op instanceof IFlowNodeConnection.IComponentAdditionOp)) {
                        SubMonitor sbMon = compMon.newChild(1);
                        sbMon.setWorkRemaining(affectedAreas.size());
                        refresher.addToRefresh(affectedAreas.keySet(), wsConnPair.getKey().getContextHandle(), op.getComponent(), (IProgressMonitor)compMon.newChild(1));
                        continue;
                    }
                    compMon.worked(1);
                }
                compMon.setWorkRemaining(4);
                List<IBaselineHandle> baselines = req.getBaselines((IProgressMonitor)compMon.newChild(1));
                ArrayList<ConnectionFacade> baselineDescriptors = new ArrayList<ConnectionFacade>();
                for (IBaselineHandle baseline : baselines) {
                    ITeamRepository source = req.getSourceRepository();
                    ConnectionFacade baselineDescriptor = new ConnectionFacade(source, (IContextHandle)baseline);
                    baselineDescriptors.add(baselineDescriptor);
                }
                ChangeSetRefreshUtils.refreshForBaselineConnectionDescriptorChange(refresher, affectedAreas.keySet(), wsConnPair.getKey(), baselineDescriptors, (IProgressMonitor)compMon.newChild(1));
                List<IChangeSetHandle> cses = req.getChangeSets((IProgressMonitor)compMon.newChild(1));
                if (cses.isEmpty()) continue;
                ChangeSetRefreshUtils.refreshLocalForAddition(refresher, affectedAreas, req.getSourceRepository(), wsConnPair.getKey(), cses, (IProgressMonitor)compMon.newChild(1));
            }
        }
    }

    @Override
    public boolean isEclipseMetadataReadFailure() {
        return this.isEclipseMetadataReadFailure;
    }

    @Override
    public List<String> getEclipseMetadataReadFailureMessage() {
        return this.eclipseReadMessages;
    }

    @Override
    public EclipseReadException getSavedEclipseReadException() {
        return this.savedEclipseReadException;
    }

    public static Map<IComponentHandle, IChangeSetHandle> shouldMakeResumedCurrent(IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSetHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, ArrayList<IChangeSet>> groupedByComponent = new HashMap<UUID, ArrayList<IChangeSet>>();
        HashMap<IComponentHandle, IChangeSetHandle> changeSetsToMakeCurrent = new HashMap<IComponentHandle, IChangeSetHandle>();
        List changeSets = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(changeSetHandles, 0, monitor);
        for (IChangeSet changeSet : changeSets) {
            if (!changeSet.isActive()) continue;
            IComponentHandle component = changeSet.getComponent();
            ArrayList<IChangeSet> gCsets = (ArrayList<IChangeSet>)groupedByComponent.get(component.getItemId());
            if (gCsets == null) {
                gCsets = new ArrayList<IChangeSet>();
                groupedByComponent.put(component.getItemId(), gCsets);
            }
            gCsets.add(changeSet);
        }
        for (UUID componentUUID : groupedByComponent.keySet()) {
            IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentUUID, null);
            IChangeSetHandle currentChangeSetHandle = workspaceConnection.getCurrentChangeSet(componentHandle);
            List changeSetsInComponent = (List)groupedByComponent.get(componentUUID);
            if (currentChangeSetHandle != null || changeSetsInComponent.size() != 1) continue;
            changeSetsToMakeCurrent.put(componentHandle, (IChangeSetHandle)changeSetsInComponent.get(0));
        }
        return changeSetsToMakeCurrent;
    }
}

