/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SandboxUpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.UpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.ICreateBaselineOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRemoveBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineSetDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationWithUncheckedInChangesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.CommitDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.SandboxUpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.UpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.FilesystemRestClientDTOsyncFactory;
import com.ibm.team.filesystem.common.internal.rest.client.sync.GetBaselineSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.GetBaselinesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.CreateBaselineResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.CreateBaselineSetResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.FilesystemRestClientDTOworkspaceFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentInfo;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class BaselineUtil {
    public static CreateBaselineResultDTO createBaselines(ParmsCreateBaselines parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        CreateBaselineResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createCreateBaselineResultDTO();
        CreateBaselineDilemmaHandler dilemmaHandler = BaselineUtil.getCreateBaselineDilemmaHandler(parms, result.getConfigurationsWithConflicts(), result.getConfigurationsWithUncheckedInChanges(), result.getOutOfSyncShares(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), (IProgressMonitor)monitor.newChild(10));
        ICreateBaselineOperation op = BaselineUtil.prepareOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            op.run((IProgressMonitor)monitor.newChild(70));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        Collection<IBaselineConnection> baselinesCreated = op.getBaselinesCreated();
        SubMonitor subMonitor = monitor.newChild(10);
        subMonitor.setWorkRemaining(baselinesCreated.size());
        for (IBaselineConnection baselineConnection : baselinesCreated) {
            HashMap<UUID, IContributor> contributors = CoreUtil.fetchCreatorAndGetModifiedBy(baselineConnection.teamRepository(), Collections.singletonList(baselineConnection.getResolvedBaseline()), (IProgressMonitor)subMonitor.newChild(1));
            result.getBaselines().add(CoreUtil.translateBaseline(baselineConnection, contributors));
        }
        return result;
    }

    private static ICreateBaselineOperation prepareOperation(ParmsCreateBaselines parms, CreateBaselineDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(parms.requests.length * 10));
        ICreateBaselineOperation op = IOperationFactory.instance.getCreateBaselineOperation(dilemmaHandler);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        ParmsCreateBaselineRequest[] parmsCreateBaselineRequestArray = parms.requests;
        int n = parms.requests.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsCreateBaselineRequest request = parmsCreateBaselineRequestArray[n2];
            IWorkspaceConnection workspaceConnection = request.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
            IComponentHandle component = request.getComponentHandle();
            op.createBaselineRequest(workspaceConnection, component, request.name, request.comment);
            ++n2;
        }
        return op;
    }

    private static CreateBaselineDilemmaHandler getCreateBaselineDilemmaHandler(ParmsCreateBaselines parms, final List configurationsWithConflicts, final List<ConfigurationWithUncheckedInChangesDTO> configurationsWithUncheckedInChanges, List<ShareDTO> outOfSyncShares, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, IProgressMonitor progress) {
        final int pendingChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final int conflictedConfigurationsInstruction = BaselineUtil.getInstruction(parms.createBaselineDilemmaHandler);
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, updateDilemma);
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, progress);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        CreateBaselineDilemmaHandler dilemmaHandler = new CreateBaselineDilemmaHandler(){

            @Override
            public int conflictedConfigurations(List<ConfigurationFacade> conflictedConfigurations) {
                if (configurationsWithConflicts != null) {
                    for (ConfigurationFacade descriptor : conflictedConfigurations) {
                        configurationsWithConflicts.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
                return conflictedConfigurationsInstruction;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                    ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                    uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                    uncheckedInChanges.setChangeCount(entry.getValue().size());
                    configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                }
                return pendingChangesInstruction;
            }

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return dilemmaHandler;
    }

    private static int getInstruction(ParmsCreateBaselineDilemmaHandler createBaselineDilemmaHandler) {
        int uncheckedInChangesInstruction = 2;
        if (createBaselineDilemmaHandler != null) {
            String instruction = createBaselineDilemmaHandler.conflictedConfigurationsDirection;
            if ("continue".equals(instruction)) {
                uncheckedInChangesInstruction = 0;
            } else if (instruction == null) {
                uncheckedInChangesInstruction = 2;
            } else if ("cancel".equals(instruction)) {
                uncheckedInChangesInstruction = 1;
            } else if ("fail".equals(instruction)) {
                uncheckedInChangesInstruction = 2;
            } else {
                throw new IllegalArgumentException("The value of conflictedConfigurationsDirection must be one of cancel, continue or fail");
            }
        }
        return uncheckedInChangesInstruction;
    }

    public static void updateBaseline(ParmsUpdateBaseline parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IBaselineConnection baselineConnection = parms.baseline.getBaselineConnection((IProgressMonitor)monitor.newChild(10));
        if (parms.name != null) {
            baselineConnection.setName(parms.name, (IProgressMonitor)monitor.newChild(45));
        }
        if (parms.comment != null) {
            baselineConnection.setComment(parms.comment, (IProgressMonitor)monitor.newChild(45));
        }
    }

    public static CreateBaselineSetResultDTO createBaselineSet(ParmsCreateBaselineSet parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        CreateBaselineSetResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createCreateBaselineSetResultDTO();
        IWorkspaceConnection workspaceConnection = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        List<IComponentHandle> componentsToExclude = parms.getExcludedComponentHandles();
        int flags = 0;
        if (parms.createNewBaselines.booleanValue()) {
            flags |= 1;
        }
        if (parms.forceBaselineCreation.booleanValue()) {
            flags |= 2;
        }
        IBaselineSetHandle baselineSetHandle = workspaceConnection.createBaselineSet(componentsToExclude, parms.name, parms.comment, flags, (IProgressMonitor)monitor.newChild(90));
        IBaselineSet baselineSet = (IBaselineSet)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineSetHandle, 0, (IProgressMonitor)monitor.newChild(5));
        result.setBaselineSet(CoreUtil.translateBaselineSet(workspaceConnection.teamRepository(), baselineSet));
        return result;
    }

    public static void updateBaselineSet(ParmsUpdateBaselineSet parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.baselineSet.repositoryUrl);
        IBaselineSetHandle baselineSet = parms.baselineSet.getBaselineSetHandle();
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        if (parms.comment != null) {
            workspaceManager.setComment(baselineSet, parms.comment, (IProgressMonitor)monitor.newChild(30));
        }
        if (parms.name != null) {
            workspaceManager.setName(baselineSet, parms.name, (IProgressMonitor)monitor.newChild(30));
        }
        if (parms.promotionWorkspace != null) {
            IWorkspaceConnection workspaceConnection = parms.promotionWorkspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
            workspaceConnection.addBaselineSet(baselineSet, (IProgressMonitor)monitor.newChild(20));
        }
    }

    public static void removeBaselineSet(ParmsRemoveBaselineSet parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IBaselineSetHandle baselineSet = parms.baselineSet.getBaselineSetHandle();
        IWorkspaceConnection workspaceConnection = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        workspaceConnection.removeBaselineSet(baselineSet, (IProgressMonitor)monitor.newChild(85));
    }

    /*
     * Unable to fully structure code
     */
    public static GetBaselinesDTO getBaselines(ParmsGetBaselines parms, IProgressMonitor progress) throws TeamRepositoryException {
        block19: {
            block18: {
                block16: {
                    block17: {
                        monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
                        repo = CommonUtil.getTeamRepository(parms.repositoryUrl);
                        result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createGetBaselinesDTO();
                        if (parms.baselineItemIds != null && parms.baselineItemIds.length > 0) {
                            handles = new ArrayList<IBaselineHandle>();
                            var9_7 = parms.baselineItemIds;
                            var8_10 = parms.baselineItemIds.length;
                            var7_14 = 0;
                            while (var7_14 < var8_10) {
                                baselineItemId = var9_7[var7_14];
                                handles.add((IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)baselineItemId), null));
                                ++var7_14;
                            }
                            baselines = repo.itemManager().fetchCompleteItems(handles, 0, (IProgressMonitor)monitor.newChild(50));
                            contributors = CoreUtil.fetchCreatorAndGetModifiedBy(repo, baselines, (IProgressMonitor)monitor.newChild(50));
                            for (IBaseline baseline : baselines) {
                                if (baseline == null) continue;
                                result.getBaselinesInRepository().add(CoreUtil.translateBaseline(repo, baseline, contributors));
                            }
                            result.setTotalEntries((long)result.getBaselinesInRepository().size());
                            return result;
                        }
                        component = CommonUtil.createComponentHandle(repo, parms.componentItemId);
                        if (parms.workspaceItemId == null) break block18;
                        workspace = new ParmsWorkspace();
                        workspace.repositoryUrl = parms.repositoryUrl;
                        workspace.workspaceItemId = parms.workspaceItemId;
                        connection = workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
                        try {
                            numBasisInHistory = connection.getComponentInfo(component).numBasisInHistory();
                            break block16;
                        }
                        catch (TeamRepositoryException e) {
                            if (!(e instanceof ComponentNotInWorkspaceException)) break block17;
                            pastComponentInfos = connection.getPastComponentInfos((IProgressMonitor)monitor.newChild(5));
                            numBasisInHistory = 0L;
                            ** for (pastInfo : pastComponentInfos)
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (!pastInfo.component().sameItemId((IItemHandle)component)) continue;
                            numBasisInHistory = pastInfo.numBasisInHistory();
lbl40:
                            // 2 sources

                            break block16;
                        }
                    }
                    throw e;
                }
                result.setTotalEntries(numBasisInHistory);
                if (numBasisInHistory <= 0L) break block19;
                baselineHandles = new ArrayList<IBaselineHandle>(parms.max);
                trail = new ArrayList<E>(parms.max);
                max = Math.min((long)parms.max.intValue(), numBasisInHistory);
                if (parms.start == null) {
                    start = Math.max(0L, numBasisInHistory - max);
                    end = start + max;
                } else {
                    start = parms.start;
                    end = Math.min(start + max, numBasisInHistory);
                }
                if (end - start > 512L) {
                    numberOfLoops = (int)(max / 512L);
                    if (max % 512L != 0L) {
                        ++numberOfLoops;
                    }
                    fromIndex = start;
                    while (fromIndex + 512L <= end) {
                        infos = connection.getComponentAuditTrail(component, fromIndex, 512L, (IProgressMonitor)monitor.newChild(50 / numberOfLoops));
                        trail.addAll(infos);
                        fromIndex += 512L;
                    }
                    if (fromIndex <= end) {
                        infos = connection.getComponentAuditTrail(component, fromIndex, end - fromIndex, (IProgressMonitor)monitor.newChild(50 / numberOfLoops));
                        trail.addAll(infos);
                    }
                } else {
                    trail = connection.getComponentAuditTrail(component, start, max, (IProgressMonitor)monitor.newChild(50));
                }
                for (IComponentInfo info : trail) {
                    basis = info.basis();
                    if (basis == null) continue;
                    baselineHandles.add(basis);
                }
                baselines = repo.itemManager().fetchCompleteItems(baselineHandles, 0, (IProgressMonitor)monitor.newChild(25));
                contributors = CoreUtil.fetchCreatorAndGetModifiedBy(repo, baselines, (IProgressMonitor)monitor.newChild(25));
                iBaselines = baselines.iterator();
                for (IComponentInfo info : trail) {
                    baselineEntry = FilesystemRestClientDTOsyncFactory.eINSTANCE.createBaselineHistoryEntryDTO();
                    result.getBaselineHistoryEntriesInWorkspace().add(baselineEntry);
                    baselineEntry.setDeliveredByItemId(info.deliveredBy().getItemId().getUuidValue());
                    baselineEntry.setDeliveryDate(info.deliveryDate().getTime());
                    if (info.basis() == null) continue;
                    baseline = (IBaseline)iBaselines.next();
                    baselineEntry.setBaseline(CoreUtil.translateBaseline(repo, baseline, contributors));
                }
                break block19;
            }
            wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            baselineHandles = wm.findBaselines(IBaselineSearchCriteria.FACTORY.newInstance().setComponentRequired(component), 0x7FFFFFFF, (IProgressMonitor)monitor.newChild(50));
            result.setTotalEntries((long)baselineHandles.size());
            baselines = repo.itemManager().fetchCompleteItems(baselineHandles, 0, (IProgressMonitor)monitor.newChild(15));
            contributors = CoreUtil.fetchCreatorAndGetModifiedBy(repo, baselines, (IProgressMonitor)monitor.newChild(5));
            Collections.sort(baselines, new Comparator<IBaseline>(){

                @Override
                public int compare(IBaseline o1, IBaseline o2) {
                    return NullUtil.compare((Comparable)o1.getCreationDate(), (Comparable)o2.getCreationDate());
                }
            });
            for (IBaseline baseline : baselines) {
                if (baseline == null) continue;
                result.getBaselinesInRepository().add(CoreUtil.translateBaseline(repo, baseline, contributors));
            }
        }
        return result;
    }

    public static GetBaselineSetsDTO getBaselineSets(ParmsWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.repositoryUrl);
        IWorkspaceConnection wc = parms.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        List handles = wc.getBaselineSets((IProgressMonitor)monitor.newChild(75));
        List baselineSets = repo.itemManager().fetchCompleteItems(handles, 0, (IProgressMonitor)monitor.newChild(20));
        GetBaselineSetsDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createGetBaselineSetsDTO();
        for (IBaselineSet baselineSet : baselineSets) {
            BaselineSetDTO dto = CoreUtil.translateBaselineSet(repo, baselineSet);
            result.getBaselineSets().add(dto);
        }
        return result;
    }
}

