/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.repository.client.ILoginHandler2;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.login.IAliasChooser;
import com.ibm.team.repository.client.login.SSLCertificateLoginInfo;
import com.ibm.team.repository.client.login.SmartCardLoginInfo;
import com.ibm.team.repository.client.login.UsernameAndPasswordLoginInfo;
import java.util.List;

public class LoginUtil {

    private static abstract class AbstractLoginHandler {
        private ILoginInfo2 loginInfo;

        protected AbstractLoginHandler(ILoginInfo2 loginInfo) {
            this.setLoginInfo(loginInfo);
        }

        protected final ILoginInfo2 getLoginInfo() {
            return this.loginInfo;
        }

        private void setLoginInfo(ILoginInfo2 loginInfo) {
            this.loginInfo = loginInfo;
        }
    }

    private static abstract class AbstractLoginHandler2
    extends AbstractLoginHandler
    implements ILoginHandler2 {
        int count = 0;

        protected AbstractLoginHandler2(ILoginInfo2 loginInfo) {
            super(loginInfo);
        }

        public ILoginInfo2 challenge(ITeamRepository repository) {
            if (this.count > 0 && repository.getErrorState() == 2) {
                return null;
            }
            ++this.count;
            return this.getLoginInfo();
        }
    }

    public static class CertificateLoginHandler
    extends AbstractLoginHandler2 {
        public CertificateLoginHandler(String certificateFile, String password) {
            super((ILoginInfo2)new SSLCertificateLoginInfo(certificateFile, password));
        }
    }

    public static class LoginHandler
    extends AbstractLoginHandler
    implements ITeamRepository.ILoginHandler,
    ITeamRepository.ILoginHandler.ILoginInfo {
        int count = 0;

        public LoginHandler(String username, String password) {
            super((ILoginInfo2)new UsernameAndPasswordLoginInfo(username, password));
        }

        public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repository) {
            if (this.count > 0 && repository.getErrorState() == 2) {
                return null;
            }
            ++this.count;
            return this;
        }

        public String getPassword() {
            try {
                return this.getUsernameAndPasswordLoginInfo().getPassword();
            }
            catch (SavedPasswordNotObtainedException savedPasswordNotObtainedException) {
                return null;
            }
        }

        public String getUserId() {
            return this.getUsernameAndPasswordLoginInfo().getUsername();
        }

        private UsernameAndPasswordLoginInfo getUsernameAndPasswordLoginInfo() {
            return (UsernameAndPasswordLoginInfo)this.getLoginInfo();
        }
    }

    public static class SmartCardLoginHandler
    extends AbstractLoginHandler2 {
        private static IAliasChooser createAliasChooser(final String requestedAlias) {
            return new IAliasChooser(){

                public String chooseAlias(List<String> aliases) {
                    for (String alias : aliases) {
                        if (!alias.equals(requestedAlias)) continue;
                        return alias;
                    }
                    return null;
                }
            };
        }

        private static SmartCardLoginInfo createSmartCardLoginInfo(String requestedAlias) {
            IAliasChooser chooser = SmartCardLoginHandler.createAliasChooser(requestedAlias);
            return new SmartCardLoginInfo(chooser);
        }

        public SmartCardLoginHandler(String alias) {
            super((ILoginInfo2)SmartCardLoginHandler.createSmartCardLoginInfo(alias));
        }
    }
}

