/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPreOperationRefresh;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRecomputeLocalChanges;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class RefreshUtil {
    public static void recomputeLocalChanges(ParmsRecomputeLocalChanges parm, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)101);
        ISandbox sandbox = SharingManager.getInstance().getSandbox(new PathLocation((IPath)new Path(parm.sandboxPath)), true);
        if (sandbox == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.RefreshUtil_0, (Object)parm.sandboxPath));
        }
        if (parm.paths == null || parm.paths.length == 0) {
            LocalChangeManager.getInstance().refreshChanges(new ISandbox[]{sandbox}, ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN, (IProgressMonitor)monitor.newChild(100));
        } else {
            LocalChangeManager lcm = LocalChangeManager.getInstance();
            monitor.setWorkRemaining(10 * parm.paths.length);
            ArrayList<IShareable> shareables = new ArrayList<IShareable>(parm.paths.length);
            String[] stringArray = parm.paths;
            int n = parm.paths.length;
            int n2 = 0;
            while (n2 < n) {
                Shareable shareable;
                String relativePath = stringArray[n2];
                RelativeLocation relativeLocation = new RelativeLocation(new Path(relativePath).segments());
                ILocation path = sandbox.getRoot().append(relativeLocation);
                ResourceType resourceType = CommonUtil.getResourceType(path, (IProgressMonitor)monitor.newChild(1));
                if (resourceType == null) {
                    shareable = new Shareable(sandbox, (IRelativeLocation)relativeLocation, ResourceType.FOLDER);
                    FileItemInfo info = shareable.getFileItemInfo((IProgressMonitor)monitor.newChild(1));
                    if (info == null) break;
                    if (ResourceType.getResourceType(info.getVersionableHandle()) != ResourceType.FOLDER) {
                        shareable = new Shareable(sandbox, (IRelativeLocation)relativeLocation, ResourceType.getResourceType(info.getVersionableHandle()));
                    }
                } else {
                    shareable = new Shareable(sandbox, (IRelativeLocation)relativeLocation, resourceType);
                }
                shareables.add(shareable);
                ++n2;
            }
            SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareables, (IProgressMonitor)monitor.newChild(1));
            ArrayList<IShareable> unsharedItems = new ArrayList<IShareable>();
            ArrayList<IShareable> sharedItems = new ArrayList<IShareable>();
            for (IShareable shareable : shareables) {
                IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
                if (share == null) {
                    unsharedItems.add(shareable);
                    continue;
                }
                sharedItems.add(shareable);
            }
            lcm.refreshChanges(sharedItems, ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN, (IProgressMonitor)monitor.newChild(9));
            if (!unsharedItems.isEmpty()) {
                HashSet<IShare> sharesToRecompute = new HashSet<IShare>();
                HashSet<IShareable> shareableRoots = new HashSet<IShareable>();
                IShare[] shares = sandbox.allShares((IProgressMonitor)monitor.newChild(10));
                block2: for (IShareable shareable : unsharedItems) {
                    IShare[] iShareArray = shares;
                    int n3 = shares.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IShare share = iShareArray[n4];
                        if (shareable.getLocalPath().isPrefixOf(share.getPath(), sandbox.isCaseSensitive())) {
                            sharesToRecompute.add(share);
                            shareableRoots.add(share.getShareable());
                            continue block2;
                        }
                        ++n4;
                    }
                }
                if (!sharesToRecompute.isEmpty()) {
                    SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareableRoots, (IProgressMonitor)monitor.newChild(1));
                    IShare[] recompute = sharesToRecompute.toArray(new IShare[sharesToRecompute.size()]);
                    lcm.refreshChanges(recompute, ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN, (IProgressMonitor)monitor.newChild(90));
                }
            }
        }
    }

    public static void configureRefresh(ParmsPreOperationRefresh parms, IRefreshingOperation op) {
        if (op == null) {
            throw new IllegalArgumentException();
        }
        op.setRefreshBeforeRun(parms != null && "complete".equals(parms.refreshMode));
    }
}

