/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.ISyncViewProxy;
import com.ibm.team.filesystem.client.internal.rest.util.PortsDTOUtil;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SandboxUpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.UpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateReport;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAcceptChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceAccept;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceAcceptDetailed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceComponentReplaceWithBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceReplaceWithSnapshot;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceReplaceWithWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.GapChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StaleDataDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredBaselineUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredComponentUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationWithUncheckedInChangesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.CommitDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.SandboxUpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.UpdateDilemmaDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class WorkspaceUpdateUtil {
    private static final String request = "WorkspaceUpdate";

    public static WorkspaceUpdateResultDTO workspaceUpdate(ParmsWorkspaceUpdate parms, ISyncViewProxy syncViewProxy, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate(request, new Object[0]);
        WorkspaceUpdateResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createWorkspaceUpdateResultDTO();
        WorkspaceUpdateDilemmaHandler dilemmaHandler = WorkspaceUpdateUtil.getWorkspaceUpdateDilemmaHandler(parms.workspaceUpdateDilemmaHandler, parms.pendingChangesDilemmaHandler, result.getConfigurationsWithUncheckedInChanges(), result.getCommitDilemma(), parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), parms.updateDilemmaHandler, result.getUpdateDilemma(), result.getComponentFlowAdditions(), result.getComponentFlowDeletions(), result.getComponentReplacementCandidates(), result.getDisconnectedComponents(), result.getActiveChangeSets(), result.getActiveChangeSetsOverlap(), result.getGap(), result.getStaleData(), result.getChangeSetsBlockedByPortInProgress(), (IProgressMonitor)monitor.newChild(10));
        IWorkspaceUpdateOperation workspaceUpdateOperation = WorkspaceUpdateUtil.prepareWorkspaceUpdateOperation(parms, syncViewProxy, dilemmaHandler, (IProgressMonitor)monitor.newChild(9));
        try {
            if (parms.evaluateRequestOnly == null || !parms.evaluateRequestOnly.booleanValue()) {
                workspaceUpdateOperation.run((IProgressMonitor)monitor.newChild(80));
            } else {
                workspaceUpdateOperation.runPreConditionsOnly((IProgressMonitor)monitor.newChild(80));
            }
            result.setChangeSetsAlreadyInHistory(workspaceUpdateOperation.changeSetsAlreadyInHistory());
            result.setAcceptedSuspendedChanges(workspaceUpdateOperation.acceptedSuspendedChangeSets());
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setChangeSetsAlreadyInHistory(workspaceUpdateOperation.changeSetsAlreadyInHistory());
            result.setAcceptedSuspendedChanges(workspaceUpdateOperation.acceptedSuspendedChangeSets());
            result.setCancelled(true);
        }
        WorkspaceUpdateUtil.recordConfigurationDescriptors(workspaceUpdateOperation.getComponentsAdded(), result.getComponentsAdded());
        if (workspaceUpdateOperation.isEclipseMetadataReadFailure()) {
            result.getEclipseReadFailureMessage().addAll(workspaceUpdateOperation.getEclipseMetadataReadFailureMessage());
        }
        if (parms.structuredResultOptions != null) {
            WorkspaceUpdateUtil.populateWorkspaceUpdateResult(workspaceUpdateOperation.getUpdateReport(), result.getStructuredResult(), (IProgressMonitor)monitor.newChild(1));
        }
        return result;
    }

    public static void populateWorkspaceUpdateResult(IWorkspaceUpdateReport report, List<StructuredUpdateReportDTO> result, IProgressMonitor monitor) throws TeamRepositoryException {
        if (report == null) {
            return;
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.WorkspaceUpdateUtil_POPULATING_RESULT_OBJECT, (int)report.getConnections().size());
        for (IWorkspaceConnection wsConn : report.getConnections()) {
            SubMonitor wsMon = mon.newChild(1);
            wsMon.beginTask(NLS.bind((String)Messages.WorkspaceUpdateUtil_POPULATING_RESULT_FOR_REMOTE_WORKSPACE, (Object)wsConn.getName(), (Object[])new Object[0]), 3);
            StructuredUpdateReportDTO dto = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createStructuredUpdateReportDTO();
            result.add(dto);
            ITeamRepository teamRepository = wsConn.teamRepository();
            dto.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
            dto.setRepositoryUrl(teamRepository.getRepositoryURI());
            dto.setWorkspaceItemId(wsConn.getContextHandle().getItemId().getUuidValue());
            dto.setWorkspaceName(wsConn.getName());
            List<IComponentHandle> compHandles = report.getAffectedComponents(wsConn);
            List comps = teamRepository.itemManager().fetchCompleteItems(compHandles, 0, (IProgressMonitor)wsMon.newChild(1));
            wsMon.setWorkRemaining(comps.size());
            boolean hasConflicts = false;
            for (IComponent comp : comps) {
                SubMonitor compMon = wsMon.newChild(1);
                compMon.beginTask(NLS.bind((String)Messages.WorkspaceUpdateUtil_POPULATING_RESULT_FOR_REMOTE_WORKSPACE_AND_COMPONENT, (Object)wsConn.getName(), (Object[])new Object[]{comp.getName()}), report.getBaselines(wsConn, (IComponentHandle)comp).size() + 1);
                StructuredComponentUpdateReportDTO compDto = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createStructuredComponentUpdateReportDTO();
                dto.getComponents().add(compDto);
                compDto.setComponentItemId(comp.getItemId().getUuidValue());
                compDto.setComponentName(comp.getName());
                if (report.isRemovedComponent(wsConn, (IComponentHandle)comp)) continue;
                List changeSets = compDto.getChangeSetItemIds();
                for (IChangeSetHandle changeSet : report.getAcceptedChanges(wsConn, (IComponentHandle)comp)) {
                    changeSets.add(changeSet.getItemId().getUuidValue());
                }
                List<IBaselineHandle> baselineHandles = report.getBaselines(wsConn, (IComponentHandle)comp);
                List baselines = teamRepository.itemManager().fetchCompleteItems(baselineHandles, 0, (IProgressMonitor)compMon.newChild(1));
                compMon.setWorkRemaining(baselines.size());
                for (IBaseline baseline : baselines) {
                    StructuredBaselineUpdateReportDTO baselineDto = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createStructuredBaselineUpdateReportDTO();
                    compDto.getBaselines().add(baselineDto);
                    baselineDto.setBaselineItemId(baseline.getItemId().getUuidValue());
                    baselineDto.setBaselineId((long)baseline.getId());
                    baselineDto.setBaselineName(baseline.getName());
                }
                IUpdateReport update = wsConn.conflictReport((IComponentHandle)comp);
                SubMonitor.convert((IProgressMonitor)compMon.newChild(1), (int)update.getConflictsForComponent((IComponentHandle)comp).size());
                for (IItemConflictReport conflict : update.getConflictsForComponent((IComponentHandle)comp)) {
                    compDto.getConflictedItemIds().add(conflict.item().getItemId().getUuidValue());
                    hasConflicts = true;
                }
                ICurrentPatch currentPort = wsConn.getCurrentPatch((IComponentHandle)comp);
                if (currentPort == null) continue;
                compDto.setCurrentPatch(PortsDTOUtil.asCurrentPortDTO(currentPort));
            }
            dto.setHasConflicts(hasConflicts);
        }
    }

    private static IWorkspaceUpdateOperation prepareWorkspaceUpdateOperation(ParmsWorkspaceUpdate parms, ISyncViewProxy syncViewProxy, WorkspaceUpdateDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        IWorkspaceConnection sourceWorkspace;
        IWorkspaceConnection workspace;
        int n;
        int n2;
        Object[] objectArray;
        SubMonitor subMonitor;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)600);
        IWorkspaceUpdateOperation workspaceUpdateOperation = IOperationFactory.instance.getWorkspaceUpdateOperation(dilemmaHandler);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)workspaceUpdateOperation);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, workspaceUpdateOperation);
        workspaceUpdateOperation.setPopulateUpdateReport(parms.structuredResultOptions != null);
        if (parms.acceptChangeSets != null && parms.acceptChangeSets.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.acceptChangeSets.length * 10);
            objectArray = parms.acceptChangeSets;
            n2 = parms.acceptChangeSets.length;
            n = 0;
            while (n < n2) {
                Object acceptChangeSetsParm = objectArray[n];
                workspace = ((ParmsAcceptChangeSets)acceptChangeSetsParm).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                HashMap<ITeamRepository, ArrayList<IChangeSetHandle>> requests = new HashMap<ITeamRepository, ArrayList<IChangeSetHandle>>();
                ParmsChangeSet[] parmsChangeSetArray = ((ParmsAcceptChangeSets)acceptChangeSetsParm).changeSets;
                int n3 = ((ParmsAcceptChangeSets)acceptChangeSetsParm).changeSets.length;
                int n4 = 0;
                while (n4 < n3) {
                    ParmsChangeSet changeSet = parmsChangeSetArray[n4];
                    ITeamRepository repo = CommonUtil.getTeamRepository(changeSet.repositoryUrl);
                    ArrayList<IChangeSetHandle> changeSets = (ArrayList<IChangeSetHandle>)requests.get(repo);
                    if (changeSets == null) {
                        changeSets = new ArrayList<IChangeSetHandle>();
                        requests.put(repo, changeSets);
                    }
                    changeSets.add(CommonUtil.createChangeSetHandle(repo, changeSet.changeSetItemId));
                    ++n4;
                }
                for (ITeamRepository repo : requests.keySet()) {
                    List changeSets = (List)requests.get(repo);
                    workspaceUpdateOperation.acceptChangeSets(workspace, repo, changeSets);
                }
                ++n;
            }
        }
        if (parms.workspaceAcceptDetailed != null && parms.workspaceAcceptDetailed.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceAcceptDetailed.length * 30);
            objectArray = parms.workspaceAcceptDetailed;
            n2 = parms.workspaceAcceptDetailed.length;
            n = 0;
            while (n < n2) {
                Object workspaceAcceptDetailed = objectArray[n];
                workspace = ((ParmsWorkspaceAcceptDetailed)workspaceAcceptDetailed).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                ITeamRepository sourceRepo = CommonUtil.getTeamRepository(((ParmsWorkspaceAcceptDetailed)workspaceAcceptDetailed).sourceWorkspace.repositoryUrl);
                IWorkspaceConnection sourceWorkspace2 = ((ParmsWorkspaceAcceptDetailed)workspaceAcceptDetailed).sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                List<IBaselineHandle> baselines = ((ParmsWorkspaceAcceptDetailed)workspaceAcceptDetailed).getBaselineHandles();
                ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
                if (((ParmsWorkspaceAcceptDetailed)workspaceAcceptDetailed).changeSetItemIds != null) {
                    String[] stringArray = ((ParmsWorkspaceAcceptDetailed)workspaceAcceptDetailed).changeSetItemIds;
                    int n5 = ((ParmsWorkspaceAcceptDetailed)workspaceAcceptDetailed).changeSetItemIds.length;
                    int repo = 0;
                    while (repo < n5) {
                        String changeSetItemId = stringArray[repo];
                        changeSets.add(CommonUtil.createChangeSetHandle(sourceRepo, changeSetItemId));
                        ++repo;
                    }
                }
                ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>();
                if (((ParmsWorkspaceAcceptDetailed)workspaceAcceptDetailed).componentItemIds != null) {
                    String[] stringArray = ((ParmsWorkspaceAcceptDetailed)workspaceAcceptDetailed).componentItemIds;
                    int n6 = ((ParmsWorkspaceAcceptDetailed)workspaceAcceptDetailed).componentItemIds.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        String componentItemId = stringArray[n7];
                        components.add(CommonUtil.createComponentHandle(sourceRepo, componentItemId));
                        ++n7;
                    }
                }
                IChangeHistorySyncReport syncReport = syncViewProxy.getCompareReport(workspace, sourceWorkspace2, (IProgressMonitor)subMonitor.newChild(10));
                workspaceUpdateOperation.accept(workspace, sourceWorkspace2, syncReport, baselines, changeSets, components);
                ++n;
            }
        }
        if (parms.workspaceAccept != null && parms.workspaceAccept.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceAccept.length * 30);
            objectArray = parms.workspaceAccept;
            n2 = parms.workspaceAccept.length;
            n = 0;
            while (n < n2) {
                Object workspaceAccept = objectArray[n];
                workspace = ((ParmsWorkspaceAccept)workspaceAccept).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                sourceWorkspace = ((ParmsWorkspaceAccept)workspaceAccept).sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IChangeHistorySyncReport syncReport = syncViewProxy.getCompareReport(workspace, sourceWorkspace, (IProgressMonitor)subMonitor.newChild(10));
                workspaceUpdateOperation.accept(workspace, sourceWorkspace, syncReport);
                ++n;
            }
        }
        if (parms.workspaceReplaceWithBaseline != null && parms.workspaceReplaceWithBaseline.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceReplaceWithBaseline.length * 20);
            objectArray = parms.workspaceReplaceWithBaseline;
            n2 = parms.workspaceReplaceWithBaseline.length;
            n = 0;
            while (n < n2) {
                Object workspaceReplaceWithBaseline = objectArray[n];
                workspace = ((ParmsWorkspaceComponentReplaceWithBaseline)workspaceReplaceWithBaseline).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IBaselineConnection sourceBaseline = ((ParmsWorkspaceComponentReplaceWithBaseline)workspaceReplaceWithBaseline).baseline.getBaselineConnection((IProgressMonitor)subMonitor.newChild(10));
                workspaceUpdateOperation.replace(workspace, sourceBaseline);
                ++n;
            }
        }
        if (parms.workspaceReplaceWithSnapshot != null && parms.workspaceReplaceWithSnapshot.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceReplaceWithSnapshot.length * 10);
            objectArray = parms.workspaceReplaceWithSnapshot;
            n2 = parms.workspaceReplaceWithSnapshot.length;
            n = 0;
            while (n < n2) {
                Object workspaceReplaceWithSnapshot = objectArray[n];
                workspace = ((ParmsWorkspaceReplaceWithSnapshot)workspaceReplaceWithSnapshot).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                ITeamRepository baselineRepository = CommonUtil.getTeamRepository(((ParmsWorkspaceReplaceWithSnapshot)workspaceReplaceWithSnapshot).baselineSet.repositoryUrl);
                IBaselineSetHandle sourceBaselineSet = ((ParmsWorkspaceReplaceWithSnapshot)workspaceReplaceWithSnapshot).baselineSet.getBaselineSetHandle();
                List<IComponentHandle> components = ((ParmsWorkspaceReplaceWithSnapshot)workspaceReplaceWithSnapshot).getComponentHandles();
                if (components.isEmpty()) {
                    workspaceUpdateOperation.replace(workspace, baselineRepository, sourceBaselineSet);
                } else {
                    workspaceUpdateOperation.replace(workspace, baselineRepository, sourceBaselineSet, components);
                }
                ++n;
            }
        }
        if (parms.workspaceReplaceWithWorkspace != null && parms.workspaceReplaceWithWorkspace.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceReplaceWithWorkspace.length * 10);
            objectArray = parms.workspaceReplaceWithWorkspace;
            n2 = parms.workspaceReplaceWithWorkspace.length;
            n = 0;
            while (n < n2) {
                Object workspaceReplaceWithWorkspace = objectArray[n];
                workspace = ((ParmsWorkspaceReplaceWithWorkspace)workspaceReplaceWithWorkspace).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                sourceWorkspace = ((ParmsWorkspaceReplaceWithWorkspace)workspaceReplaceWithWorkspace).sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                List<IComponentHandle> components = ((ParmsWorkspaceReplaceWithWorkspace)workspaceReplaceWithWorkspace).getComponentHandles();
                if (components.isEmpty()) {
                    workspaceUpdateOperation.replace(workspace, sourceWorkspace);
                } else {
                    workspaceUpdateOperation.replace(workspace, sourceWorkspace, components);
                }
                ++n;
            }
        }
        return workspaceUpdateOperation;
    }

    public static WorkspaceUpdateDilemmaHandler getWorkspaceUpdateDilemmaHandler(ParmsWorkspaceUpdateDilemmaHandler workspaceUpdateDilemmaParms, ParmsPendingChangesDilemmaHandler pendingChangesDilemmaParms, final List<ConfigurationWithUncheckedInChangesDTO> configurationsWithUncheckedInChanges, CommitDilemmaDTO commitDilemma, ParmsOutOfSyncInstructions outOfSyncInstructions, List<ShareDTO> outOfSyncShares, ParmsSandboxUpdateDilemmaHandler sandboxUpdateDilemmaHandler, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, ParmsUpdateDilemmaHandler updateDilemmaHandler, UpdateDilemmaDTO updateDilemma, final List<ConfigurationDescriptorDTO> componentFlowAdditions, final List<ConfigurationDescriptorDTO> componentFlowDeletions, final List<ConfigurationDescriptorDTO> componentReplacementCandidates, final List<ConfigurationDescriptorDTO> disconnectedComponents, final List<ProblemChangeSetsDTO> activeChangeSetsEncountered, final List<ProblemChangeSetsDTO> activeChangeSetsOverlapEncountered, final List<GapChangeSetsDTO> gapEncountered, final List<StaleDataDTO> staleDataEncountered, final List<ProblemChangeSetsDTO> changeSetsBlockedByPortInProgress, IProgressMonitor progress) throws TeamRepositoryException {
        int portInProgressInstruction;
        int gapInstruction;
        int activeChangeSetsOverlapInstruction;
        int activeChangeSetsInstruction;
        int staleDataInstruction;
        int disconnectedComponentsInstruction;
        int componentFlowInstruction;
        int replaceComponentsInstruction;
        if (workspaceUpdateDilemmaParms == null) {
            replaceComponentsInstruction = 2;
            componentFlowInstruction = 2;
            disconnectedComponentsInstruction = 2;
            staleDataInstruction = 2;
            activeChangeSetsInstruction = 2;
            activeChangeSetsOverlapInstruction = 2;
            gapInstruction = 2;
            portInProgressInstruction = 2;
        } else {
            replaceComponentsInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.componentReplacementCandidatesDirection, true, "workspaceUpdateDilemmaHandler.componentReplacementCandidatesDirection");
            componentFlowInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.componentFlowDirection, true, "workspaceUpdateDilemmaHandler.componentFlowDirection");
            disconnectedComponentsInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.disconnectedComponentsDirection, false, "workspaceUpdateDilemmaHandler.disconnectedComponentsDirection");
            staleDataInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.staleDataDirection, false, "workspaceUpdateDilemmaHandler.staleDataDirection");
            activeChangeSetsInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.activeChangeSetsDirection, true, "activeChangeSetsDirection");
            activeChangeSetsOverlapInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.activeChangeSetsOverlapDirection, true, "activeChangeSetsOverlapDirection");
            gapInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.gapDirection, true, "gapDirection");
            portInProgressInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.portInProgressDirection, true, "portInProgressDirection");
        }
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(pendingChangesDilemmaParms);
        WorkspaceUpdateDilemmaHandler workspaceUpdateDilemmaHandler = new WorkspaceUpdateDilemmaHandler(sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, updateDilemmaHandler, updateDilemma, outOfSyncInstructions, outOfSyncShares, progress, pendingChangesDilemmaParms, commitDilemma){
            final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil;
            final UpdateDilemmaUtil updateDilemmaUtil;
            final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler;
            final CommitDilemmaHandler commitDilemmaHandler;
            {
                this.sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parmsSandboxUpdateDilemmaHandler, sandboxUpdateDilemmaDTO);
                this.updateDilemmaUtil = new UpdateDilemmaUtil(parmsUpdateDilemmaHandler, updateDilemmaDTO);
                this.outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parmsOutOfSyncInstructions, list, parmsSandboxUpdateDilemmaHandler, sandboxUpdateDilemmaDTO, iProgressMonitor);
                this.commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parmsPendingChangesDilemmaHandler, commitDilemmaDTO, parmsSandboxUpdateDilemmaHandler, sandboxUpdateDilemmaDTO, parmsUpdateDilemmaHandler, updateDilemmaDTO, this.outOfSyncDilemmaHandler);
            }

            @Override
            public int componentReplacementCandidates(Collection<ConfigurationFacade> replaceConfigurations) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(replaceConfigurations, componentReplacementCandidates);
                return replaceComponentsInstruction;
            }

            @Override
            public int componentsToBeAddedOrRemoved(Collection<ConfigurationFacade> added, Collection<ConfigurationFacade> removed) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(added, componentFlowAdditions);
                WorkspaceUpdateUtil.recordConfigurationDescriptors(removed, componentFlowDeletions);
                return componentFlowInstruction;
            }

            @Override
            public int disconnectedComponents(Collection<ConfigurationFacade> configurations) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(configurations, disconnectedComponents);
                return disconnectedComponentsInstruction;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return this.commitDilemmaHandler;
            }

            @Override
            public int staleData(IWorkspaceConnection workspaceConnection, IWorkspaceConnection sourceWorkspaceConnection) {
                if (staleDataEncountered != null) {
                    StaleDataDTO staleDataDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createStaleDataDTO();
                    ITeamRepository teamRepository = workspaceConnection.teamRepository();
                    staleDataDTO.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
                    staleDataDTO.setRepositoryURL(teamRepository.getRepositoryURI());
                    staleDataDTO.setWorkspaceItemId(workspaceConnection.getContextHandle().getItemId().getUuidValue());
                    ITeamRepository sourceTeamRepository = sourceWorkspaceConnection.teamRepository();
                    staleDataDTO.setSourceRepositoryId(CoreUtil.translateRepositoryId(sourceTeamRepository));
                    staleDataDTO.setSourceRepositoryURL(sourceTeamRepository.getRepositoryURI());
                    staleDataDTO.setSourceWorkspaceItemId(sourceWorkspaceConnection.getContextHandle().getItemId().getUuidValue());
                    staleDataEncountered.add(staleDataDTO);
                }
                return staleDataInstruction;
            }

            @Override
            public int portInProgress(IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSets) {
                if (changeSetsBlockedByPortInProgress != null) {
                    changeSetsBlockedByPortInProgress.add(CoreUtil.translateProblemChangeSetsDTO(workspaceConnection, changeSets));
                }
                return portInProgressInstruction;
            }

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                if (configurationsWithUncheckedInChanges != null) {
                    for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                        ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                        uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                        uncheckedInChanges.setChangeCount(entry.getValue().size());
                        configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                    }
                }
                return uncheckedInChangesInstruction;
            }

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return this.outOfSyncDilemmaHandler;
            }

            @Override
            public int activeChangeSets(IWorkspaceConnection workspace, Collection<IChangeSetHandle> activeChangeSets) {
                if (activeChangeSets != null) {
                    activeChangeSetsEncountered.add(CoreUtil.translateProblemChangeSetsDTO(workspace, activeChangeSets));
                }
                return activeChangeSetsInstruction;
            }

            @Override
            public int activeChangeSetsOverlap(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> activeChangeSets) {
                if (activeChangeSetsOverlapEncountered != null) {
                    activeChangeSetsOverlapEncountered.add(CoreUtil.translateProblemChangeSetsDTO(workspace, activeChangeSets));
                }
                return activeChangeSetsOverlapInstruction;
            }

            @Override
            public int gap(IWorkspaceConnection workspace, List<IChangeSetHandle> changeSetsWithGap, boolean handlingSuspended) {
                if (gapEncountered != null) {
                    gapEncountered.add(CoreUtil.translateGapProblemChangeSetsDTO(workspace, changeSetsWithGap, handlingSuspended));
                }
                return gapInstruction;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return this.sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return this.sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return this.updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return this.updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return workspaceUpdateDilemmaHandler;
    }

    private static void recordConfigurationDescriptors(Collection<ConfigurationFacade> configurationDescriptors, List<ConfigurationDescriptorDTO> configurationDescriptorDTOs) {
        if (configurationDescriptorDTOs != null) {
            for (ConfigurationFacade descriptor : configurationDescriptors) {
                configurationDescriptorDTOs.add(CoreUtil.translateConfigurationDescriptor(descriptor));
            }
        }
    }

    public static int getInstruction(String direction, boolean noIsValidDirection, String field) {
        int uncheckedInChangesInstruction = 2;
        if ("continue".equals(direction)) {
            uncheckedInChangesInstruction = 0;
        } else if (direction == null) {
            uncheckedInChangesInstruction = 2;
        } else if ("cancel".equals(direction)) {
            uncheckedInChangesInstruction = 1;
        } else if ("fail".equals(direction)) {
            uncheckedInChangesInstruction = 2;
        } else if ("no".equals(direction)) {
            uncheckedInChangesInstruction = 3;
        } else {
            if (noIsValidDirection) {
                throw new IllegalArgumentException(NLS.bind((String)"Invalid value {0} of {1} must be one of {2}, {3}, {4} or {5}", (Object[])new Object[]{direction, field, "cancel", "continue", "no", "fail"}, (Object[])new Object[0]));
            }
            throw new IllegalArgumentException(NLS.bind((String)"Invalid value {0} of {1} must be one of {2}, {3}, or {4}", (Object[])new Object[]{direction, field, "cancel", "continue", "fail"}, (Object[])new Object[0]));
        }
        return uncheckedInChangesInstruction;
    }
}

