/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetContext;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class NamespaceSetId
extends SnapshotId {
    private Set<ItemNamespace> namespaces;
    private ITeamRepository repository;

    private NamespaceSetId(ITeamRepository repository, Set<ItemNamespace> namespaces) {
        this.repository = repository;
        this.namespaces = namespaces;
    }

    public static NamespaceSetId create(ItemNamespace namespace) {
        return new NamespaceSetId(namespace.getRepository(), Collections.singleton(namespace));
    }

    public static NamespaceSetId create(ITeamRepository repository, Set<ItemNamespace> namespaces) {
        return new NamespaceSetId(repository, namespaces);
    }

    public Set<ItemNamespace> getNamespaces() {
        return Collections.unmodifiableSet(this.namespaces);
    }

    @Override
    public boolean isEmpty() {
        return this.namespaces.isEmpty();
    }

    @Override
    public IItemHandle getIdentifyingHandle() {
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.namespaces == null ? 0 : this.namespaces.hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceSetId other = (NamespaceSetId)obj;
        if (this.namespaces == null ? other.namespaces != null : !this.namespaces.equals(other.namespaces)) {
            return false;
        }
        return !(this.repository == null ? other.repository != null : !this.repository.equals(other.repository));
    }

    @Override
    public ISnapshot createSnapshot(IProgressMonitor progress) throws TeamRepositoryException {
        return NamespaceSetContext.create(this.repository, this.namespaces, progress);
    }

    @Override
    public IConnection getConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.namespaces.size() == 1) {
            return this.namespaces.iterator().next().getConnection(monitor);
        }
        return null;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repository;
    }
}

