/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;

public class RationalizingTree<PathElement, Content>
implements Iterable<Content> {
    private final TreeNode root = new TreeNode(null);

    public void put(PathElement[] path, Content data) {
        TreeNode node = this.root;
        int i = 0;
        while (i < path.length) {
            if (node.hasData) {
                return;
            }
            TreeNode nextNode = node.children.get(path[i]);
            if (nextNode == null) {
                this.extendTree(path, i, node, data);
                return;
            }
            node = nextNode;
            ++i;
        }
        node.children.clear();
        node.hasData = true;
        node.data = data;
        this.addUpToRoot(node, -1 * (node.descendents - 1));
    }

    private void extendTree(PathElement[] path, int i, TreeNode node, Content data) {
        while (i < path.length) {
            TreeNode newNode = new TreeNode(node);
            node.children.put(path[i], newNode);
            node = newNode;
            ++i;
        }
        node.hasData = true;
        node.data = data;
        this.addUpToRoot(node, 1);
    }

    private void addUpToRoot(TreeNode node, int i) {
        do {
            node.descendents += i;
        } while ((node = node.parent) != null);
    }

    public int size() {
        if (this.root == null) {
            return 0;
        }
        return this.root.descendents;
    }

    @Override
    public Iterator<Content> iterator() {
        return new TreeIterator();
    }

    public String toString() {
        TreeIterator i = new TreeIterator();
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        while (i.hasNext()) {
            buf.append(i.currentPath());
            i.next();
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    private class TreeIterator
    implements Iterator<Content> {
        Stack<Iterator<TreeNode>> iterators = new Stack();
        TreeNode current;

        public TreeIterator() {
            this.current = RationalizingTree.this.root;
            this.iterators.push(((RationalizingTree)RationalizingTree.this).root.children.values().iterator());
            if (!((RationalizingTree)RationalizingTree.this).root.hasData) {
                this.walkToNextValue();
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Content next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object toReturn = this.current.data;
            this.walkToNextValue();
            return toReturn;
        }

        private void walkToNextValue() {
            TreeNode nextNode = null;
            while (true) {
                if (this.iterators.isEmpty()) {
                    this.current = null;
                    break;
                }
                if (this.iterators.peek().hasNext()) {
                    nextNode = this.iterators.peek().next();
                    if (nextNode.hasData) {
                        assert (nextNode.children.size() == 0);
                        this.current = nextNode;
                        break;
                    }
                    this.iterators.push(nextNode.children.values().iterator());
                    continue;
                }
                this.iterators.pop();
            }
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }

        public String currentPath() {
            LinkedList<String> l = new LinkedList<String>();
            TreeNode node = this.current;
            while (node != null && node.parent != null) {
                boolean matched = false;
                for (Map.Entry entry : node.parent.children.entrySet()) {
                    if (entry.getValue() != node) continue;
                    l.add(entry.getKey().toString());
                    node = node.parent;
                    matched = true;
                    break;
                }
                if (matched) continue;
                throw new IllegalStateException();
            }
            Collections.reverse(l);
            return String.valueOf(l.toString()) + " => " + this.current.data;
        }
    }

    private class TreeNode {
        final HashMap<PathElement, TreeNode> children = new HashMap();
        Content data;
        boolean hasData = false;
        int descendents = 0;
        final TreeNode parent;

        TreeNode(TreeNode parent) {
            this.parent = parent;
        }
    }
}

