/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.CommitPathEntry;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Immutable;
import org.hibernate.validator.constraints.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="vc_commit")
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY, region="vcCache")
@Immutable
public class Commit
implements Comparable<Commit> {
    @Id
    @Column(name="id")
    private Long id;
    @Column(name="commit_time")
    private Long time;
    @NotNull
    @Column(name="commit_user")
    @Length(min=1, max=255)
    private String user;
    @Column(name="commit_comment")
    @Length(max=1000)
    private String comment;
    @OneToMany(mappedBy="commit")
    @Cascade(value={CascadeType.ALL})
    private List<CommitPathEntry> pathEntries = new ArrayList<CommitPathEntry>();

    private Commit() {
    }

    Commit(Long id, String user, String comment) {
        this.id = id;
        this.time = System.currentTimeMillis();
        this.user = user;
        this.comment = comment;
    }

    void addPathModified(String path) {
        this.pathEntries.add(new CommitPathEntry(this, path, CommitPathEntry.EntryType.MODIFIED));
    }

    void addPathDeleted(String path) {
        this.pathEntries.add(new CommitPathEntry(this, path, CommitPathEntry.EntryType.DELETED));
    }

    public long getId() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    public String getUser() {
        return this.user;
    }

    public String getComment() {
        return this.comment;
    }

    public List<String> getPathModifiedList() {
        ArrayList<String> result = new ArrayList<String>();
        for (CommitPathEntry entry : this.pathEntries) {
            if (entry.getType() != CommitPathEntry.EntryType.MODIFIED) continue;
            result.add(entry.getPath());
        }
        return result;
    }

    public List<String> getPathDeletedList() {
        ArrayList<String> result = new ArrayList<String>();
        for (CommitPathEntry entry : this.pathEntries) {
            if (entry.getType() != CommitPathEntry.EntryType.DELETED) continue;
            result.add(entry.getPath());
        }
        return result;
    }

    @Override
    public int compareTo(Commit other) {
        Long thisId = (long)this.id;
        Long otherId = other.getId();
        return thisId.compareTo(otherId);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Commit) {
            Commit other = (Commit)obj;
            result = other.getId() == this.getId();
        }
        return result;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getClass().hashCode();
        hash = hash * 31 + Long.valueOf(this.id).hashCode();
        return hash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "#" + this.getId();
    }
}

