/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.metadata.RecordMetadata;
import com.urbancode.commons.path.PathUtils;
import com.urbancode.persistence.IDGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="vc_persistent_record")
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY, region="vcCache")
@Immutable
public class PersistentRecord
implements Serializable {
    private static final long serialVersionUID = -8478218118264738328L;
    @Id
    @Column(name="id")
    @Type(type="uuid-char")
    private UUID id = IDGenerator.createID();
    @NotNull
    @Column(name="path")
    @Length(min=1, max=255)
    private String path;
    @NotNull
    @Column(name="commit_id")
    private Long commit;
    @NotNull
    @Column(name="relative_version")
    private Integer relativeVersion;
    @NotNull
    @Column(name="directory")
    @Length(min=1, max=255)
    private String directory;
    @Lob
    @Column(name="persistent_data")
    private String data;
    @NotNull
    @Column(name="deleted")
    @Type(type="yes_no")
    private Boolean deleted = false;
    @OneToMany(mappedBy="record")
    @Cascade(value={CascadeType.ALL})
    private List<RecordMetadata> metadataList = new ArrayList<RecordMetadata>();

    private PersistentRecord() {
    }

    PersistentRecord(String path, Long commit, Integer relativeVersion, String data, boolean deleted) {
        this.path = path;
        this.commit = commit;
        this.relativeVersion = relativeVersion;
        this.data = data;
        this.directory = PathUtils.splitIntoHeadAndTail((String)path).getHead();
        this.deleted = deleted;
    }

    public Long getCommit() {
        return this.commit;
    }

    Integer getRelativeVersion() {
        return this.relativeVersion;
    }

    public String getPath() {
        return this.path;
    }

    String getData() {
        return this.data;
    }

    Boolean isDeleted() {
        return this.deleted;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof PersistentRecord) {
            PersistentRecord other = (PersistentRecord)obj;
            result = other.path.equals(this.path) && other.commit == this.commit;
        }
        return result;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getClass().hashCode();
        hash = hash * 31 + this.path.hashCode();
        hash = hash * 31 + this.commit.hashCode();
        return hash;
    }
}

