/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.Persistent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VCCacheKey
implements Comparable<VCCacheKey> {
    final Persistent persistent;
    final String path;
    final Integer version;

    public VCCacheKey(Persistent pers) {
        this.persistent = pers;
        this.path = null;
        this.version = null;
    }

    public VCCacheKey(String path, Integer version) {
        if (path == null) {
            throw new IllegalArgumentException("Path must be non-null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Version must be non-null");
        }
        this.path = path;
        this.version = version;
        this.persistent = null;
    }

    public Integer getVersion() {
        if (this.persistent != null) {
            return this.persistent.getPersistenceData().getRelativeVersion();
        }
        return this.version;
    }

    public String getPath() {
        if (this.persistent != null) {
            return this.persistent.getPersistenceData().getPath();
        }
        return this.path;
    }

    public boolean equals(Object other) {
        if (other instanceof VCCacheKey) {
            VCCacheKey otherPersistent = (VCCacheKey)other;
            return this.getVersion() == otherPersistent.getVersion() && this.getPath() == otherPersistent.getPath();
        }
        return false;
    }

    public boolean isDirectChildOf(String path) {
        String thisPath = this.getPath();
        return thisPath.length() > path.length() && thisPath.startsWith(path) && thisPath.substring(path.length() + 1).indexOf("/") == -1;
    }

    public int hashCode() {
        int hashCode = 47;
        hashCode = 7 * hashCode + this.getVersion().hashCode();
        hashCode = 7 * hashCode + this.getPath().hashCode();
        return hashCode;
    }

    @Override
    public int compareTo(VCCacheKey o) {
        int stringComp = this.getPath().compareTo(o.getPath());
        if (stringComp == 0) {
            return this.getVersion().compareTo(o.getVersion());
        }
        return stringComp;
    }
}

