/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc.metadata;

import com.urbancode.air.vc.metadata.RecordMetadataGenerator;
import com.urbancode.persistence.IDGenerator;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="vc_persistent_meta_gen_state")
public class RecordMetadataGeneratorState {
    @Id
    @Column(name="id")
    @Type(type="uuid-char")
    private UUID id = IDGenerator.createID();
    @NotNull
    @Column(name="metadata_generator")
    @Length(min=1, max=255)
    private String metadataGeneratorName;
    @NotNull
    @Column(name="metadata_generator_version")
    private int metadataGeneratorVersion;
    @NotNull
    @Column(name="scan_end_commit")
    private long scanEndCommit;
    @NotNull
    @Column(name="newest_scanned_commit")
    private long newestScannedCommit;
    @NotNull
    @Column(name="locked")
    @Type(type="yes_no")
    private Boolean locked = false;

    private RecordMetadataGeneratorState() {
    }

    public RecordMetadataGeneratorState(RecordMetadataGenerator generator, long endCommit) {
        this.metadataGeneratorName = generator.getClass().getName();
        this.metadataGeneratorVersion = generator.getGeneratorVersion();
        this.scanEndCommit = endCommit;
        this.newestScannedCommit = 0L;
    }

    public UUID getId() {
        return this.id;
    }

    public String getMetadataGeneratorName() {
        return this.metadataGeneratorName;
    }

    public int getMetadataGeneratorVersion() {
        return this.metadataGeneratorVersion;
    }

    void setMetadataGeneratorVersion(RecordMetadataGenerator generator) {
        this.metadataGeneratorVersion = generator.getGeneratorVersion();
    }

    public long getNewestScannedCommit() {
        return this.newestScannedCommit;
    }

    public void setNewestScannedCommit(long newestScannedCommit) {
        this.newestScannedCommit = newestScannedCommit;
    }

    public long getScanEndCommit() {
        return this.scanEndCommit;
    }

    public void setScanEndCommit(long scanEndCommit) {
        this.scanEndCommit = scanEndCommit;
    }

    public Boolean isLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }
}

