/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.common.internal.rest.debug.core.DebugRestClientDTOFactory;
import com.ibm.team.filesystem.common.internal.rest.debug.core.MetronomeMethodDTO;
import com.ibm.team.filesystem.common.internal.rest.debug.core.MetronomeRepoDTO;
import com.ibm.team.filesystem.common.internal.rest.debug.core.MetronomeRootDTO;
import com.ibm.team.filesystem.common.internal.rest.debug.core.MetronomeServiceDTO;
import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.UUID;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class MetronomeEventModel
implements IListener {
    private static MetronomeEventModel instance;
    public static String ENV_VAR;
    private static final boolean enabled;
    public static UUID UNKNOWN;
    private final ConcurrentHashMap<UUID, RepoNode> repos = new ConcurrentHashMap();

    static {
        ENV_VAR = "SCM_METRONOME_EVENTS";
        enabled = System.getenv().containsKey(ENV_VAR);
        UNKNOWN = UUID.valueOf((String)"_0000000000000000000000");
    }

    public static synchronized MetronomeEventModel getInstance() {
        if (enabled && instance == null) {
            instance = new MetronomeEventModel();
        }
        return instance;
    }

    public static void addRepositoryToInstance(ITeamRepository repo) {
        MetronomeEventModel inst = MetronomeEventModel.getInstance();
        if (inst == null) {
            return;
        }
        inst.addedRepository(repo);
    }

    public void addedRepository(ITeamRepository repo) {
        repo.statistics().addGenericListener((Object)"com.ibm.team.repository.statistics.serviceMethod", (IListener)this);
        repo.statistics().addGenericListener((Object)"serviceMethodCallCount", (IListener)this);
    }

    public void removedRepository(ITeamRepository repo) {
    }

    public void handleEvents(List events) {
        for (IEvent event : events) {
            ServiceNode svcNode;
            Method m;
            IPropertyChangeEvent pce;
            if (!(event instanceof IPropertyChangeEvent) || !"com.ibm.team.repository.PropertySet".equals((pce = (IPropertyChangeEvent)event).getEventType())) continue;
            Object ctx = pce.getObject();
            String prop = (String)pce.getProperty();
            Object newValue = pce.getNewValue();
            RepoNode rn = this.findRepo(((IStatistics)pce.getEventSource()).teamRepository());
            if ("serviceMethodElapsedTime".equals(prop)) {
                m = (Method)ctx;
                svcNode = rn.findServiceNode(m);
                svcNode.setMethodElapsedTime(m, (Long)newValue);
                continue;
            }
            if (!"serviceMethodCallCount".equals(prop)) continue;
            m = (Method)ctx;
            svcNode = rn.findServiceNode(m);
            svcNode.setMethodCallCount(m, (Long)newValue);
        }
    }

    private RepoNode findRepo(ITeamRepository teamRepository) {
        RepoNode old;
        RepoNode rn;
        UUID id = teamRepository.getId();
        if (id == null) {
            id = UNKNOWN;
        }
        if ((rn = this.repos.get(id)) == null && (old = this.repos.putIfAbsent(id, rn = new RepoNode(teamRepository.getRepositoryURI(), id))) != null) {
            rn = old;
        }
        return rn;
    }

    public MetronomeRootDTO getStats() {
        MetronomeRootDTO result = DebugRestClientDTOFactory.eINSTANCE.createMetronomeRootDTO();
        for (RepoNode rn : this.repos.values()) {
            MetronomeRepoDTO repoDto = DebugRestClientDTOFactory.eINSTANCE.createMetronomeRepoDTO();
            result.getRepos().add(repoDto);
            repoDto.setUri(rn.uri);
            repoDto.setRepoId(rn.uuid.getUuidValue());
            for (ServiceNode svc : rn.services.values()) {
                MetronomeServiceDTO svcDto = DebugRestClientDTOFactory.eINSTANCE.createMetronomeServiceDTO();
                repoDto.getServices().add(svcDto);
                svcDto.setName(svc.name);
                svcDto.setCallCount(svc.getCallCount());
                svcDto.setElapsedTime(svc.getElapsedTime());
                for (MethodNode mn : svc.methods.values()) {
                    MetronomeMethodDTO methodDto = DebugRestClientDTOFactory.eINSTANCE.createMetronomeMethodDTO();
                    svcDto.getMethods().add(methodDto);
                    methodDto.setName(mn.name);
                    methodDto.setCallCount(mn.ct);
                    methodDto.setElapsedTime(mn.time);
                }
            }
        }
        return result;
    }

    private static class MethodNode {
        final String name;
        volatile long ct = 0L;
        volatile long time = 0L;

        public MethodNode(String name) {
            this.name = name;
        }
    }

    private static class RepoNode {
        final String uri;
        final UUID uuid;
        final ConcurrentHashMap<String, ServiceNode> services = new ConcurrentHashMap();

        public RepoNode(String uri, UUID uuid) {
            this.uri = uri;
            this.uuid = uuid;
        }

        public ServiceNode findServiceNode(Method m) {
            Class<?> svc = m.getDeclaringClass();
            String svcName = svc.getName();
            return this.findServiceNode(svcName);
        }

        public ServiceNode findServiceNode(String svcName) {
            ServiceNode old;
            ServiceNode sn = this.services.get(svcName);
            if (sn == null && (old = this.services.putIfAbsent(svcName, sn = new ServiceNode(svcName))) != null) {
                sn = old;
            }
            return sn;
        }
    }

    private static class ServiceNode {
        final String name;
        final ConcurrentHashMap<Method, MethodNode> methods = new ConcurrentHashMap();

        public ServiceNode(String svcName) {
            this.name = svcName;
        }

        private MethodNode findMethod(Method m) {
            MethodNode old;
            MethodNode mn = this.methods.get(m.getName());
            if (mn == null && (old = this.methods.putIfAbsent(m, mn = new MethodNode(m.getName()))) != null) {
                mn = old;
            }
            return mn;
        }

        public void setMethodElapsedTime(Method m, Long newValue) {
            MethodNode mNode = this.findMethod(m);
            mNode.time = newValue;
        }

        public void setMethodCallCount(Method m, Long newValue) {
            MethodNode mNode = this.findMethod(m);
            mNode.ct = newValue;
        }

        public long getCallCount() {
            long r = 0L;
            for (MethodNode mn : this.methods.values()) {
                r += mn.ct;
            }
            return r;
        }

        public long getElapsedTime() {
            long r = 0L;
            for (MethodNode mn : this.methods.values()) {
                r += mn.time;
            }
            return r;
        }
    }
}

