/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileSystemCoreActivator;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class PlatformDetector {
    private static final String INTERNAL_OS_SUNOS = "SunOS";
    private static final String INTERNAL_OS_LINUX = "Linux";
    private static final String INTERNAL_OS_MACOSX = "Mac OS";
    private static final String INTERNAL_OS_AIX = "AIX";
    private static final String INTERNAL_OS_HPUX = "HP-UX";
    private static final String INTERNAL_OS_QNX = "QNX";
    private static final String INTERNAL_OS_OS400 = "OS/400";
    private static final String INTERNAL_OS_OS390 = "OS/390";
    private static final String INTERNAL_OS_ZOS = "z/OS";
    private static final String INTERNAL_OS_WIN32 = "win32";
    private static volatile Platform platform = null;

    public static Platform getPlatform() {
        if (platform != null) {
            return platform;
        }
        String osName = System.getProperty("os.name");
        if (osName == null) {
            platform = Platform.UNKNOWN;
            return platform;
        }
        if (osName.regionMatches(true, 0, INTERNAL_OS_WIN32, 0, 3)) {
            platform = Platform.WINDOWS;
            return platform;
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_SUNOS)) {
            platform = Platform.UNIX;
            return platform;
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_LINUX)) {
            platform = Platform.UNIX;
            return platform;
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_QNX)) {
            platform = Platform.UNIX;
            return platform;
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_AIX)) {
            platform = Platform.UNIX;
            return platform;
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_HPUX)) {
            platform = Platform.UNIX;
            return platform;
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_OS400)) {
            platform = Platform.I;
            return platform;
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_OS390)) {
            platform = Platform.Z;
            return platform;
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_ZOS) || osName.equalsIgnoreCase("zos")) {
            platform = Platform.Z;
            return platform;
        }
        if (osName.regionMatches(true, 0, INTERNAL_OS_MACOSX, 0, INTERNAL_OS_MACOSX.length())) {
            platform = Platform.UNIX;
            return platform;
        }
        platform = Platform.UNKNOWN;
        return platform;
    }

    public static enum LauncherType {
        CLI,
        ECLIPSE;

    }

    public static enum Platform {
        UNKNOWN(null, null, RequireScriptOnPlatform.SCRIPT_OPTIONAL),
        UNIX("unix/", "", RequireScriptOnPlatform.SCRIPT_MUST_RUN),
        WINDOWS("windows/", ".bat", RequireScriptOnPlatform.SCRIPT_OPTIONAL),
        Z("z/", "", RequireScriptOnPlatform.SCRIPT_OPTIONAL),
        I("i/", "", RequireScriptOnPlatform.SCRIPT_OPTIONAL);

        private final String scriptPath;
        private final String scriptSuffix;
        private final RequireScriptOnPlatform scriptMode;
        public static final String PRGPATH = "PRGPATH";
        public static final String RTC_SCRIPT_BASE = "RTC_SCRIPT_BASE";

        private Platform(String scriptPath, String scriptSuffix, RequireScriptOnPlatform scriptMode) {
            this.scriptPath = scriptPath;
            this.scriptSuffix = scriptSuffix;
            this.scriptMode = scriptMode;
        }

        public IPath getScript(LauncherType launcher, Map<String, String> env, String name) {
            if (this.scriptPath == null) {
                if (FileSystemCoreActivator.TRACE_PERMISSION_UTIL) {
                    System.err.println("Platform " + platform.name() + " has no script path.");
                }
                return null;
            }
            Path basePath = null;
            String fromEnv = env.get(RTC_SCRIPT_BASE);
            if (fromEnv != null && fromEnv.trim().length() > 0) {
                basePath = new Path(env.get(RTC_SCRIPT_BASE));
            } else {
                String execRoot = System.getProperty("eclipse.launcher");
                if (execRoot == null) {
                    if (env != null) {
                        String prgPath = env.get(PRGPATH);
                        if (prgPath != null) {
                            basePath = new Path(prgPath);
                        } else if (FileSystemCoreActivator.TRACE_PERMISSION_UTIL) {
                            System.err.println("No PRGPATH.");
                        }
                    } else if (FileSystemCoreActivator.TRACE_PERMISSION_UTIL) {
                        System.err.println("Missing environment. Can't use PRGPATH.");
                    }
                } else {
                    if (FileSystemCoreActivator.TRACE_PERMISSION_UTIL) {
                        System.err.println("Launcher: " + (Object)((Object)launcher));
                    }
                    switch (launcher) {
                        case CLI: {
                            basePath = new Path(execRoot).removeLastSegments(1);
                            break;
                        }
                        case ECLIPSE: {
                            basePath = new Path(execRoot).removeLastSegments(3).append("scmtools").append("eclipse");
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown Context: " + (Object)((Object)launcher));
                        }
                    }
                }
                if (basePath != null) {
                    basePath = basePath.append("scripts");
                }
            }
            if (FileSystemCoreActivator.TRACE_PERMISSION_UTIL) {
                System.err.println("basePath: " + basePath);
            }
            if (basePath == null) {
                return null;
            }
            basePath = basePath.append(this.scriptPath);
            IPath path = basePath.append(String.valueOf(name) + this.scriptSuffix);
            if (FileSystemCoreActivator.TRACE_PERMISSION_UTIL) {
                System.err.println("full path: \"" + path + '\"');
            }
            return path;
        }

        public boolean isScriptRequired() {
            return this.scriptMode == RequireScriptOnPlatform.SCRIPT_MUST_RUN;
        }
    }

    static enum RequireScriptOnPlatform {
        SCRIPT_MUST_RUN,
        SCRIPT_OPTIONAL;

    }
}

