/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;

public class PathPair {
    private final ILocation root;
    private final IRelativeLocation innerPath;
    private final int hash;

    public PathPair(IgnoreRule rule) {
        this.root = rule.getFile().getSandbox().getRoot();
        this.innerPath = rule.getRootShareableLocalPath();
        this.hash = this.root.hashCode() + this.innerPath.hashCode();
    }

    public PathPair(IShareable shareable) {
        this.root = shareable.getSandbox().getRoot();
        this.innerPath = shareable.getLocalPath();
        this.hash = this.root.hashCode() + this.innerPath.hashCode();
    }

    public PathPair(ILocation root, IRelativeLocation innerPath) {
        this.root = root;
        this.innerPath = innerPath;
        this.hash = root.hashCode() + innerPath.hashCode();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o instanceof PathPair) {
            PathPair other = (PathPair)o;
            if (this.hash == other.hash) {
                return this.getRoot().equals(other.getRoot()) && this.getInnerPath().equals(other.getInnerPath());
            }
        }
        return false;
    }

    public ILocation getRoot() {
        return this.root;
    }

    public IRelativeLocation getInnerPath() {
        return this.innerPath;
    }

    public PathPair append(String segment) {
        return new PathPair(this.getRoot(), this.getInnerPath().append(segment));
    }

    public boolean isPrefixOf(PathPair other) {
        return this.root.equals(other.getRoot()) && this.innerPath.isPrefixOf(other.getInnerPath());
    }

    public String toString() {
        return this.root + " -> " + this.innerPath;
    }
}

