/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules.builders;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.load.loadRules.ItemLoadRequest;
import com.ibm.team.filesystem.client.internal.load.loadRules.LoadRequest;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ComponentBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ILoadRuleBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.RuleBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.SandboxPathBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.VersionableBuilder;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import org.xml.sax.Attributes;

public class ItemLoadBuilder
extends RuleBuilder {
    private String alternateName;

    @Override
    public ILoadRuleBuilder startElement(String eName, Attributes attrs) throws TeamRepositoryException {
        ILoadRuleBuilder builder = this;
        if (eName.equals("itemLoadRule")) {
            builder = this;
            int i = 0;
            while (i < attrs.getLength()) {
                String attrName = attrs.getQName(i);
                String value = attrs.getValue(i);
                if (!"alternateName".equals(attrName)) {
                    throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_6, (Object)attrName, (Object[])new Object[]{value}));
                }
                this.alternateName = value;
                ++i;
            }
        } else if (eName.equals("component")) {
            builder = new ComponentBuilder(this);
            builder.startElement(eName, attrs);
        } else if (eName.equals("item")) {
            builder = new VersionableBuilder(this);
            builder.startElement(eName, attrs);
        } else if (eName.equals("sandboxRelativePath")) {
            builder = new SandboxPathBuilder(this);
            builder.startElement(eName, attrs);
        } else {
            throw new FileSystemException(NLS.bind((String)Messages.ItemLoadBuilder_0, (Object)eName, (Object[])new Object[0]));
        }
        return builder;
    }

    @Override
    public LoadRequest getRequest(IConnection connection, IComponent component) {
        ItemLoadRequest request = this.getVersionableHandle() != null ? new ItemLoadRequest(connection, component, this.getRelativeLoadLocation(), this.getVersionableHandle(), this.alternateName) : new ItemLoadRequest(connection, component, this.getRelativeLoadLocation(), this.getRepositoryPath(), this.alternateName);
        return request;
    }

    @Override
    public String getRequestBuilderType() {
        return "itemLoadRule";
    }
}

