/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules.builders;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.load.loadRules.RelativeLoadLocation;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ILoadRuleBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.RuleBuilder;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;

public class SandboxPathBuilder
implements ILoadRuleBuilder {
    private RuleBuilder ruleBuilder;
    private RelativeLoadLocation relativeLoadLocation;

    public SandboxPathBuilder(RuleBuilder ruleBuilder) {
        this.ruleBuilder = ruleBuilder;
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws TeamRepositoryException {
    }

    @Override
    public void endElement(String eName) throws TeamRepositoryException {
        this.ruleBuilder.setRelativeLoadLocation(this.relativeLoadLocation);
    }

    @Override
    public ILoadRuleBuilder startElement(String eName, Attributes attrs) throws TeamRepositoryException {
        RelativeLocation relativePath = RelativeLocation.EMPTY_LOCATION;
        boolean includeComponentName = false;
        boolean includeRepositoryPath = false;
        if (eName.equals("sandboxRelativePath")) {
            int i = 0;
            while (i < attrs.getLength()) {
                String attrName = attrs.getQName(i);
                String value = attrs.getValue(i);
                if ("pathPrefix".equals(attrName)) {
                    relativePath = new RelativeLocation(new Path(value).segments());
                } else if ("includeComponentName".equals(attrName)) {
                    includeComponentName = Boolean.valueOf(value);
                } else if ("includeRepositoryPath".equals(attrName)) {
                    includeRepositoryPath = Boolean.valueOf(value);
                }
                ++i;
            }
        } else {
            throw new FileSystemException(NLS.bind((String)Messages.SandboxPathBuilder_0, (Object)eName, (Object[])new Object[0]));
        }
        this.relativeLoadLocation = new RelativeLoadLocation(relativePath, includeComponentName, includeRepositoryPath);
        return this;
    }
}

