/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IVersionableHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractCurrentPortOperation
extends ChangeHistoryChangeSetsOperation {
    private IWorkspaceConnection connection;
    private IComponentHandle component;

    protected AbstractCurrentPortOperation(ChangeHistoryChangeSetsDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
    }

    protected void setContext(IWorkspaceConnection connection, IComponentHandle component) {
        this.connection = connection;
        this.component = component;
    }

    protected IWorkspaceConnection getConnection() {
        return this.connection;
    }

    protected IComponentHandle getComponent() {
        return this.component;
    }

    @Override
    protected final void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (this.connection == null || this.component == null) {
            throw new IllegalStateException("Caller must configure the connection and component that has the current port");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.getOutOfSyncDilemmaHandler());
        final HashSet<ConfigurationFacade> configurationsToLock = new HashSet<ConfigurationFacade>();
        verifyOp.addToVerify((IConnection)this.connection, this.component);
        configurationsToLock.add(new ConfigurationFacade((IConnection)this.connection, this.component));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(configurationsToLock, (IProgressMonitor)progress.newChild(1));
        try {
            if (this.verifyInSyncEnabled() && !this.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                verifyOp.run((IProgressMonitor)progress.newChild(5));
            }
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(configurationsToLock, true);
                    try {
                        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            AbstractCurrentPortOperation.this.checkinPendingChanges(configurationsToLock, (ChangeHistoryChangeSetsDilemmaHandler)AbstractCurrentPortOperation.this.getDilemmaHandler(), true, (IProgressMonitor)progress.newChild(10));
                            AbstractCurrentPortOperation.this.doExecute(configurationsToLock, (IProgressMonitor)progress.newChild(98));
                        }
                        finally {
                            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, this.getOperationLabel(), (IProgressMonitor)progress);
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)1);
        IWorkspaceConnection workspaceConnection = this.getConnection();
        ICurrentPatch currentPort = workspaceConnection.getCurrentPatch(this.getComponent());
        if (currentPort != null) {
            ChangeSetRefreshUtils.refreshLocalForAddition(refresher, affectedAreas, workspaceConnection, Collections.singletonList(currentPort.getTargetChangeSet()), (IProgressMonitor)monitor.newChild(1));
        }
    }

    protected abstract String getOperationLabel();

    protected abstract void doExecute(HashSet<ConfigurationFacade> var1, IProgressMonitor var2) throws TeamRepositoryException, FileSystemException;

    private OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
        return ((ChangeHistoryChangeSetsDilemmaHandler)this.getDilemmaHandler()).getOutOfSyncDilemmaHandler();
    }

    protected UpdateDilemmaHandler getUpdateDilemmaHandler() {
        return (ChangeHistoryChangeSetsDilemmaHandler)this.getDilemmaHandler();
    }

    protected IShareable findShareable(ConfigurationFacade configurationFacade, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemException {
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        Collection<ISandbox> sandboxes = sharingManager.getSandboxes(configurationFacade, monitor);
        if (sandboxes.isEmpty()) {
            return null;
        }
        if (sandboxes.size() == 1) {
            sandboxes.iterator().next().findShareable(configurationFacade.getConnectionHandle(), configurationFacade.getComponentHandle(), versionable, monitor);
        }
        for (ISandbox sandbox : sandboxes) {
            IShareable shareable = sandbox.findShareable(configurationFacade.getConnectionHandle(), configurationFacade.getComponentHandle(), versionable, monitor);
            if (shareable == null) continue;
            return shareable;
        }
        return null;
    }
}

