/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetIgnoredResourcesPaths;
import com.ibm.team.filesystem.client.rest.parameters.ParmsIgnoreRuleList;
import com.ibm.team.filesystem.client.rest.parameters.ParmsJazzIgnoreRule;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.ignores.FilesystemRestClientDTOignoresFactory;
import com.ibm.team.filesystem.common.internal.rest.client.ignores.IgnoreRuleDTO;
import com.ibm.team.filesystem.common.internal.rest.client.ignores.IgnoredResourcesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.ignores.JazzIgnoreRuleDTO;
import com.ibm.team.filesystem.common.internal.rest.client.ignores.UnknownIgnoreRuleDTO;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public abstract class IgnoresUtil {
    public static ValidatedIgnoreRuleList validateIgnoreRuleList(ParmsIgnoreRuleList parms, String requestName, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(50));
        IComponentHandle componentHandle = null;
        ArrayList<IShareable> dirs = new ArrayList<IShareable>(parms.rules.length);
        monitor.setWorkRemaining(parms.rules.length + 1);
        int i = 0;
        while (i < parms.rules.length) {
            ParmsJazzIgnoreRule rule = parms.rules[i];
            Shareable dir = SharingManager.getInstance().findShareable(SharingManager.getInstance().getSandbox(new PathLocation((IPath)new Path(rule.sandboxRoot)), false), new RelativeLocation(new Path(rule.directoryPath).segments()), ResourceType.FOLDER);
            dirs.add(IgnoresUtil.findIgnoreRoot(dir));
            IShare share = dir.getShare((IProgressMonitor)monitor.newChild(1));
            if (share == null) {
                throw new IllegalArgumentException(NLS.bind((String)"Rule directory[{0}] is not shared: {1}", (Object)i, (Object[])new Object[]{rule.directoryPath}));
            }
            IComponentHandle ruleCompHandle = share.getSharingDescriptor().getComponent();
            if (componentHandle == null) {
                componentHandle = ruleCompHandle;
            } else if (!ruleCompHandle.sameItemId((IItemHandle)componentHandle)) {
                throw new IllegalArgumentException(NLS.bind((String)"Component containing directory [{0}] ({1}) component containing directory [{2}] ({3}). ", (Object[])new Object[]{i - 1, parms.rules[i - 1].directoryPath, i, parms.rules[i].directoryPath}, (Object[])new Object[0]));
            }
            ++i;
        }
        DefaultIgnoreProvider dip = DefaultIgnoreProvider.getDefault((IProgressMonitor)monitor.newChild(1));
        ArrayList<IgnoreRule> rules = new ArrayList<IgnoreRule>(parms.rules.length);
        int i2 = 0;
        while (i2 < parms.rules.length) {
            rules.addAll(dip.getIgnoreRulesFor(parms.rules[i2].pattern, Collections.singletonList((IShareable)dirs.get(i2)), "directory-recursive".equals(parms.rules[i2].scope) || "project-global".equals(parms.rules[i2].scope)));
            ++i2;
        }
        monitor.done();
        return new ValidatedIgnoreRuleList(wc, componentHandle, rules);
    }

    public static ValidatedIgnoreRuleList validateIgnoreRuleList(IWorkspaceConnection wc, IComponentHandle componentHandle, DefaultIgnoreProvider dip, ParmsJazzIgnoreRule[] unverifiedRules, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)unverifiedRules.length);
        ArrayList<IShareable> dirs = new ArrayList<IShareable>(unverifiedRules.length);
        int i = 0;
        while (i < unverifiedRules.length) {
            IComponentHandle ruleCompHandle;
            ParmsJazzIgnoreRule rule = unverifiedRules[i];
            Shareable dir = SharingManager.getInstance().findShareable(SharingManager.getInstance().getSandbox(new PathLocation((IPath)new Path(rule.sandboxRoot)), false), new RelativeLocation(new Path(rule.directoryPath).segments()), ResourceType.FOLDER);
            dirs.add(IgnoresUtil.findIgnoreRoot(dir));
            IShare share = dir.getShare((IProgressMonitor)monitor.newChild(1));
            if (share != null && componentHandle != null && !(ruleCompHandle = share.getSharingDescriptor().getComponent()).sameItemId((IItemHandle)componentHandle)) {
                throw new IllegalArgumentException(NLS.bind((String)"Component containing directory [{0}] ({1}) component containing directory [{2}] ({3}). ", (Object[])new Object[]{i - 1, unverifiedRules[i - 1].directoryPath, i, unverifiedRules[i].directoryPath}, (Object[])new Object[0]));
            }
            ++i;
        }
        ArrayList<IgnoreRule> rules = new ArrayList<IgnoreRule>(unverifiedRules.length);
        int i2 = 0;
        while (i2 < unverifiedRules.length) {
            rules.addAll(dip.getIgnoreRulesFor(unverifiedRules[i2].pattern, Collections.singletonList((IShareable)dirs.get(i2)), "directory-recursive".equals(unverifiedRules[i2].scope) || "project-global".equals(unverifiedRules[i2].scope)));
            ++i2;
        }
        monitor.done();
        return new ValidatedIgnoreRuleList(wc, componentHandle, rules);
    }

    public static IShareable findIgnoreRoot(IShareable dir) {
        return dir.getSandbox().findShareable(dir.getLocalPath(), ResourceType.FILE);
    }

    public static <T extends IIgnoreProvider.IIgnoreRule> IgnoreRuleDTO translateRule(T rule) {
        if (rule.getProvider() instanceof DefaultIgnoreProvider) {
            IgnoreRule dipRule = (IgnoreRule)rule;
            JazzIgnoreRuleDTO jir = FilesystemRestClientDTOignoresFactory.eINSTANCE.createJazzIgnoreRuleDTO();
            jir.setRuleType("jazzignore");
            jir.setPath(CoreUtil.translatePath(dipRule.getRootShareableLocalPath()));
            jir.setPattern(dipRule.getMatcher().getPattern());
            jir.setScope(dipRule.isLocal() ? "directory-local" : "directory-recursive");
            return jir;
        }
        UnknownIgnoreRuleDTO uir = FilesystemRestClientDTOignoresFactory.eINSTANCE.createUnknownIgnoreRuleDTO();
        uir.setRuleType("unknown");
        uir.setProviderType(rule.getProvider().getClass().getName());
        uir.setDescription(rule.getShortDescription());
        return uir;
    }

    public static IgnoredResourcesDTO getIgnoredResources(final ParmsGetIgnoredResourcesPaths parms, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(parms.roots.length * 3 + 1));
        IgnoredResourcesDTO dto = FilesystemRestClientDTOignoresFactory.eINSTANCE.createIgnoredResourcesDTO();
        final List ignoredFiles = dto.getIgnoredFiles();
        final List ignoredFolders = dto.getIgnoredFolders();
        final List ignoredSymbolicLinks = dto.getIgnoredSymbolicLinks();
        ISandbox sandbox = SharingManager.getInstance().getSandbox(new PathLocation((IPath)new Path(parms.sandboxRoot)), false);
        ArrayList<IShareable> roots = new ArrayList<IShareable>(parms.roots.length);
        String[] stringArray = parms.roots;
        int n = parms.roots.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            IShareable shareable = sandbox.findShareable(new RelativeLocation(new Path(path).segments()), ResourceType.FOLDER);
            if (!shareable.exists((IProgressMonitor)monitor.newChild(1))) {
                dto.getUnknownPaths().add(path);
            } else {
                roots.add(shareable);
            }
            ++n2;
        }
        SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(roots, (IProgressMonitor)monitor.newChild(1));
        IDepthVisitor visitor = new IDepthVisitor(){

            @Override
            public boolean visit(IShareable shareable, int currentDepth, IProgressMonitor progress) {
                if (currentDepth > parms.depth && parms.depth != -1) {
                    return false;
                }
                try {
                    if (shareable.shouldBeIgnored(progress)) {
                        PathDTO path = CoreUtil.translatePath(shareable);
                        ResourceType type = shareable.getResourceType(progress);
                        if (type == ResourceType.FOLDER) {
                            ignoredFolders.add(path);
                        } else if (type == ResourceType.FILE) {
                            ignoredFiles.add(path);
                        } else if (type == ResourceType.SYMBOLIC_LINK) {
                            ignoredSymbolicLinks.add(path);
                        }
                        return false;
                    }
                }
                catch (FileSystemException fileSystemException) {
                    return true;
                }
                return true;
            }
        };
        int i = 0;
        for (IShareable root : roots) {
            SubMonitor pathMonitor = monitor.newChild(1);
            pathMonitor.beginTask(NLS.bind((String)Messages.IgnoresUtil_PROGRESS_MESSAGE, (Object[])new Object[]{root.getLocalPath().toString(), ++i, parms.roots.length}, (Object[])new Object[0]), 100);
            ISchedulingRule rule = SharingManager.getInstance().makeSchedulingRuleForIDE(Collections.singleton(root));
            try {
                try {
                    Job.getJobManager().beginRule(rule, (IProgressMonitor)pathMonitor.newChild(1));
                    IgnoresUtil.visit(root, visitor, 0, (IProgressMonitor)pathMonitor.newChild(99));
                }
                catch (FileSystemException e) {
                    throw new TeamRepositoryException("Exception while traversing " + root.getFullPath().toString(), (Throwable)((Object)e));
                }
            }
            finally {
                Job.getJobManager().endRule(rule);
            }
            pathMonitor.done();
        }
        return dto;
    }

    private static void visit(IShareable shareable, IDepthVisitor depthVisitor, int depth, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.IgnoresUtil_LOOKING_FOR_IGNORED_FILES_OR_FOLDERS_ON_LOCAL_DISK, (int)100);
        if (!depthVisitor.visit(shareable, depth, (IProgressMonitor)monitor.newChild(20))) {
            return;
        }
        if (shareable.getResourceType((IProgressMonitor)monitor.newChild(20)) == ResourceType.FOLDER) {
            IFileStorage storage = ((Shareable)shareable).getFileStorage();
            Collection<IFileStorage> children = storage.getChildren(true, (IProgressMonitor)monitor.newChild(20));
            monitor.setWorkRemaining(children.size());
            for (IFileStorage child : children) {
                IgnoresUtil.visit(child.getShareable(), depthVisitor, depth + 1, (IProgressMonitor)monitor.newChild(1));
            }
        }
    }

    private static interface IDepthVisitor {
        public boolean visit(IShareable var1, int var2, IProgressMonitor var3);
    }

    public static class ValidatedIgnoreRuleList {
        public final IWorkspaceConnection wc;
        public final IComponentHandle compHandle;
        public final List<IgnoreRule> rules;

        public ValidatedIgnoreRuleList(IWorkspaceConnection wc2, IComponentHandle compHandle2, ArrayList<IgnoreRule> rules2) {
            this.wc = wc2;
            this.compHandle = compHandle2;
            this.rules = rules2;
        }
    }
}

