/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetronomeModel;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.RepositoryUtil;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IRepositoryRoot;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;

public class RepositoryUtils {
    private RepositoryUtils() {
    }

    public static ITeamRepository getTeamRepository(ISharingDescriptor descriptor) throws TeamRepositoryException {
        ITeamRepository repo = RepositoryUtils.getTeamRepositoryById(descriptor.getRepositoryId());
        if (repo == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.RepositoryUtils_2, (Object)descriptor.getConnectionName(), (Object[])new Object[0]));
        }
        return repo;
    }

    public static ITeamRepository getTeamRepository(String repositoryURI) {
        return RepositoryUtils.getTeamRepository(repositoryURI, 0);
    }

    public static ITeamRepository getTeamRepository(String repositoryURI, int flags) {
        return MetronomeModel.watch(TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURI, flags));
    }

    public static ITeamRepository getTeamRepository(String repositoryURI, UUID id) {
        return RepositoryUtils.getTeamRepository(repositoryURI, 0, id);
    }

    public static ITeamRepository getTeamRepository(String repositoryURI, int flags, UUID id) {
        ITeamRepository repo;
        if (repositoryURI == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if ((flags & 1) != 1) {
            ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int i = 0;
            while (i < repos.length) {
                if (id.equals((Object)repos[i].getId())) {
                    return repos[i];
                }
                ++i;
            }
        }
        if ((repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURI, flags)) != null && repo.getId() == null) {
            try {
                repo.setId(id);
            }
            catch (Exception exception) {}
        }
        return MetronomeModel.watch(repo);
    }

    public static ITeamRepository getTeamRepository(UUID id, String repositoryURI, int flags) throws TeamRepositoryException {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if ((flags & 1) != 1) {
            ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int i = 0;
            while (i < repos.length) {
                if (id.equals((Object)repos[i].getId())) {
                    return repos[i];
                }
                ++i;
            }
        }
        if (repositoryURI == null || repositoryURI.length() == 0) {
            throw new TeamRepositoryException(Messages.RepositoryUtils_0);
        }
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURI, flags);
        if (repo == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.RepositoryUtils_3, (Object)repositoryURI, (Object[])new Object[0]));
        }
        if (repo.getId() == null) {
            try {
                repo.setId(id);
            }
            catch (Exception exception) {}
        } else if (!id.equals((Object)repo.getId())) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.RepositoryUtils_1, (Object)repositoryURI, (Object[])new Object[0]));
        }
        return MetronomeModel.watch(repo);
    }

    public static ITeamRepository getTeamRepositoryById(UUID repoId) {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repo = iTeamRepositoryArray[n2];
            if (repoId.equals((Object)repo.getId())) {
                return repo;
            }
            IRepositoryRoot root = repo.root();
            if (root != null && root.getItemId().equals((Object)repoId)) {
                return repo;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isRepositoryLoggedIn(ITeamRepository repo) {
        if (repo == null) {
            return false;
        }
        return repo.loggedIn() && repo.getErrorState() == 0;
    }

    public static void throwAppropriateException(String msg, IStatus[] statuses) throws FileSystemException {
        MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, statuses, msg, null);
        RepositoryUtils.throwAppropriateException(msg, (IStatus)multi);
    }

    public static void throwAppropriateException(String msg, IStatus status) throws FileSystemException {
        IStatus multi;
        Object object = multi = status.isMultiStatus() ? status : new MultiStatus("com.ibm.team.filesystem.client", 0, new IStatus[]{status}, msg, null);
        if (multi.isOK()) {
            return;
        }
        if (multi.matches(4)) {
            throw new FileSystemStatusException(multi);
        }
        if (multi.matches(8)) {
            throw new OperationCanceledException();
        }
        throw new FileSystemStatusException(multi);
    }

    public static IContributorHandle getLoggedInContributor(ITeamRepository repo) throws NotLoggedInException {
        IContributor contributor = repo.loggedInContributor();
        if (contributor == null) {
            NotLoggedInException e = new NotLoggedInException(repo.getRepositoryURI());
            e.setOrigin((Object)repo);
            throw e;
        }
        return contributor;
    }

    public static UUID getRepositoryId(ITeamRepository repository) {
        UUID id = repository.getId();
        if (id == null && (id = RepositoryUtil.getRepositoryId((String)repository.getRepositoryURI())) != null) {
            repository.setId(id);
        }
        return id;
    }
}

