/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.RepositoryFactory;
import com.ibm.team.repository.common.model.ServerVersionCheckExceptionDTO;

public class ServerVersionCheckException
extends TeamRepositoryException {
    private String uri;
    private final String serverVersion;
    private final String clientVersion;

    public ServerVersionCheckException(String message, String uri, String serverVersion, String clientVersion, Object origin, Throwable cause) {
        super(origin, message, cause);
        this.uri = uri;
        this.serverVersion = serverVersion;
        this.clientVersion = clientVersion;
        this.createMarshalData(uri, serverVersion, clientVersion);
    }

    public ServerVersionCheckException(String message, String uri, String serverVersion, String clientVersion, Object origin) {
        super(origin, message);
        this.uri = uri;
        this.serverVersion = serverVersion;
        this.clientVersion = clientVersion;
        this.createMarshalData(uri, serverVersion, clientVersion);
    }

    public ServerVersionCheckException(String message) {
        super(message);
        this.serverVersion = null;
        this.clientVersion = null;
    }

    private void createMarshalData(String uriString, String serverVersionString, String clientVersionString) {
        ServerVersionCheckExceptionDTO dto = RepositoryFactory.eINSTANCE.createServerVersionCheckExceptionDTO();
        dto.setUri(uriString);
        dto.setServerVersion(serverVersionString);
        dto.setClientVersion(clientVersionString);
        this.setData(dto);
    }

    public String getUri() {
        return this.uri;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }
}

