/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.content.util;

import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.internal.content.util.RAFWrapper;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;

public class FileChannelUtil {
    private FileChannelUtil() {
    }

    public static void readFully(byte[] buf, long position, RAFWrapper raf, boolean allowInterrupts) throws IOException {
        FileChannelUtil.readFully(buf, 0, buf.length, position, raf, allowInterrupts);
    }

    public static void readFully(byte[] buf, int off, int len, long position, RAFWrapper raf, boolean allowInterrupts) throws IOException {
        ByteBuffer byteBuf = ByteBuffer.wrap(buf, off, len);
        FileChannelUtil.readFully(byteBuf, position, raf, allowInterrupts);
    }

    private static void ensureOpen(RAFWrapper raf) throws IOException {
        if (!raf.getFile().getChannel().isOpen()) {
            Throwable t = new Throwable();
            t.fillInStackTrace();
            LogFactory.getLog(FileChannelUtil.class.getName()).warn((Object)"Channel unexpectedly closed, suspect being interrupted", t);
            raf.reopen();
        }
    }

    public static void readFully(ByteBuffer buf, long position, RAFWrapper raf, boolean allowInterrupts) throws IOException {
        boolean interrupted = false;
        long posOffset = position - (long)buf.position();
        FileChannelUtil.ensureOpen(raf);
        FileChannel fc = raf.getFile().getChannel();
        try {
            do {
                try {
                    int bytesRead = fc.read(buf, position);
                    if (bytesRead < 0) {
                        throw new EOFException();
                    }
                    position += (long)bytesRead;
                }
                catch (ClosedByInterruptException e) {
                    if (allowInterrupts) {
                        throw e;
                    }
                    LogFactory.getLog(FileChannelUtil.class.getName()).warn((Object)"We were interrupted", (Throwable)e);
                    Thread.interrupted();
                    interrupted = true;
                    buf.position((int)(position - posOffset));
                    fc = raf.reopen().getChannel();
                }
            } while (buf.hasRemaining());
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void writeFully(ByteBuffer buf, long position, RAFWrapper raf, boolean allowInterrupts) throws IOException {
        long posOffset = position - (long)buf.position();
        boolean interrupted = false;
        FileChannelUtil.ensureOpen(raf);
        FileChannel fc = raf.getFile().getChannel();
        try {
            do {
                try {
                    position += (long)fc.write(buf, position);
                }
                catch (ClosedByInterruptException e) {
                    if (allowInterrupts) {
                        throw e;
                    }
                    LogFactory.getLog(FileChannelUtil.class.getName()).warn((Object)"We were interrupted", (Throwable)e);
                    Thread.interrupted();
                    interrupted = true;
                    buf.position((int)(position - posOffset));
                    fc = raf.reopen().getChannel();
                }
            } while (buf.hasRemaining());
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void writeFully(byte[] buf, long position, RAFWrapper raf, boolean allowInterrupts) throws IOException {
        FileChannelUtil.writeFully(buf, 0, buf.length, position, raf, allowInterrupts);
    }

    public static void writeFully(byte[] buf, int off, int len, long position, RAFWrapper raf, boolean allowInterrupts) throws IOException {
        ByteBuffer byteBuf = ByteBuffer.wrap(buf, off, len);
        FileChannelUtil.writeFully(byteBuf, position, raf, allowInterrupts);
    }

    public static void setLengthUninterrupted(RAFWrapper raf, long length) throws IOException {
        boolean interrupted = false;
        FileChannelUtil.ensureOpen(raf);
        try {
            RandomAccessFile f = raf.getFile();
            while (true) {
                try {
                    f.setLength(length);
                }
                catch (ClosedByInterruptException e) {
                    LogFactory.getLog(FileChannelUtil.class.getName()).warn((Object)"We were interrupted", (Throwable)e);
                    Thread.interrupted();
                    interrupted = true;
                    f = raf.reopen();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static long getLengthUninterrupted(RAFWrapper raf) throws IOException {
        long length;
        boolean interrupted = false;
        FileChannelUtil.ensureOpen(raf);
        try {
            RandomAccessFile f = raf.getFile();
            while (true) {
                try {
                    length = f.length();
                }
                catch (ClosedByInterruptException e) {
                    LogFactory.getLog(FileChannelUtil.class.getName()).warn((Object)"We were interrupted", (Throwable)e);
                    Thread.interrupted();
                    interrupted = true;
                    f = raf.reopen();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return length;
    }

    public static int readUninterrupted(ByteBuffer buf, long readOffset, RAFWrapper raf) throws IOException {
        int bytesRead;
        int off = buf.position();
        boolean interrupted = false;
        FileChannelUtil.ensureOpen(raf);
        FileChannel fc = raf.getFile().getChannel();
        try {
            while (true) {
                try {
                    bytesRead = fc.read(buf, readOffset);
                }
                catch (ClosedByInterruptException e) {
                    LogFactory.getLog(FileChannelUtil.class.getName()).warn((Object)"We were interrupted", (Throwable)e);
                    Thread.interrupted();
                    interrupted = true;
                    buf.position(off);
                    fc = raf.reopen().getChannel();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return bytesRead;
    }
}

