/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.queryast.impl;

import com.ibm.team.repository.common.internal.queryast.AbstractQueryElement;
import com.ibm.team.repository.common.internal.queryast.QueryastPackage;
import com.ibm.team.repository.common.internal.queryast.util.StringReader;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.EObjectImpl;

public abstract class AbstractQueryElementImpl
extends EObjectImpl
implements AbstractQueryElement {
    static final String[] RESERVED_WORD_LIST = new String[]{"all", "as", "distinct", "empty", "false", "from", "group", "having", "in", "is", "like", "select", "true", "union", "where", "key"};
    static final String DOT = ".";
    static final String DOUBLE_QUOTE = "\"";
    static final String HASH = "#";
    static HashSet fReservedWords;

    protected AbstractQueryElementImpl() {
    }

    protected EClass eStaticClass() {
        return QueryastPackage.Literals.ABSTRACT_QUERY_ELEMENT;
    }

    public static HashSet reservedWords() {
        if (fReservedWords == null) {
            HashSet<String> temp = new HashSet<String>();
            temp.addAll(Arrays.asList(RESERVED_WORD_LIST));
            fReservedWords = temp;
        }
        return fReservedWords;
    }

    @Override
    public void allPathsOn(List l, boolean forURIAttribute) {
    }

    @Override
    public List allPaths() {
        ArrayList l = new ArrayList();
        this.allPathsOn(l, false);
        return l;
    }

    @Override
    public List allPathsForURIAttrubute() {
        ArrayList l = new ArrayList();
        this.allPathsOn(l, true);
        return l;
    }

    public static String pathStepName(String aPathStep) {
        if (aPathStep.charAt(0) == '(') {
            return aPathStep.substring(aPathStep.indexOf(")") + 1);
        }
        return aPathStep;
    }

    public static EClass pathStepClassCast(String aPathStep) {
        if (!aPathStep.startsWith("(")) {
            return null;
        }
        String aClassName = aPathStep.substring(aPathStep.indexOf("(") + 1, aPathStep.indexOf(")"));
        try {
            int i = aClassName.indexOf(HASH);
            return ItemUtil.getEClass(aClassName.substring(i + 1), aClassName.substring(0, i));
        }
        catch (Exception exception) {
            String msg = NLS.bind("Unable retrieve class from path step: {0}", aPathStep, new Object[0]);
            throw new IllegalStateException(msg);
        }
    }

    public static List<String> parsePath(String aString) {
        StringReader r = new StringReader(aString);
        ArrayList<String> aList = new ArrayList<String>();
        StringBuffer b = new StringBuffer();
        while (r.hasNext()) {
            String pathStep;
            if (r.peek() == '(') {
                String cast = r.gatherUntil(')');
                b.append(cast).append(r.gatherUntil('.'));
                pathStep = b.toString();
                b.setLength(0);
            } else {
                pathStep = r.gatherUntil('.');
            }
            aList.add(pathStep);
            if (!r.hasNext()) continue;
            r.skip();
        }
        return aList;
    }
}

