/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.validation;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.internal.validation.IInternalItemValidator;
import com.ibm.team.repository.common.internal.validation.IValidationMessages;
import com.ibm.team.repository.common.internal.validation.PropertyConstraintErrorStatus;
import com.ibm.team.repository.common.internal.validation.StringSizeConstraintErrorStatus;
import com.ibm.team.repository.common.internal.validation.ValidationContext;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.Type;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.repository.common.validation.IPropertyConstraintErrorStatus;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class GenericItemValidator
implements IItemValidator,
IInternalItemValidator {
    private static final EAttribute INTERNAL_ID_FEATURE = RepositoryPackage.eINSTANCE.getHelper_InternalId();
    private static final EAttribute ITEM_ID_FEATURE = RepositoryPackage.eINSTANCE.getItemHandle_ItemId();
    private static final EDataType ESTRING = EcorePackage.eINSTANCE.getEString();
    private static final String EMPTY_STRING = "";
    private static final boolean TOLERANT = Boolean.getBoolean("com.ibm.team.repository.service.internal.adoptions.tolerantMode");
    public static final GenericItemValidator INSTANCE = new GenericItemValidator();
    private static final Set<EStructuralFeature> ignoreFeatures = new HashSet<EStructuralFeature>(5);

    static {
        ignoreFeatures.add((EStructuralFeature)RepositoryPackage.eINSTANCE.getItemHandle_StateId());
        ignoreFeatures.add((EStructuralFeature)RepositoryPackage.eINSTANCE.getItem_ModifiedBy());
        ignoreFeatures.add((EStructuralFeature)RepositoryPackage.eINSTANCE.getItem_Modified());
        ignoreFeatures.add((EStructuralFeature)INTERNAL_ID_FEATURE);
    }

    @Override
    public IStatus validateConstraints(IItem item, EStructuralFeature topLevelFeatureToIgnore) {
        ValidationContext ctx = new ValidationContext(item);
        this.validatePersistentFeatures(ctx, topLevelFeatureToIgnore);
        IStatus result = ctx.getResult();
        return result == null ? Status.OK_STATUS : result;
    }

    private void validatePersistentFeatures(ValidationContext ctx, EStructuralFeature featureToIgnore) {
        List<EStructuralFeature> features = ItemUtil.getPersistentStructuralFeatures(ctx.getCurrentEObject().eClass());
        for (EStructuralFeature feature : features) {
            if (feature.equals(featureToIgnore)) continue;
            ctx.pushFeature(feature);
            try {
                this.validateFeature(ctx, VALIDATE_ALL_FEATURES);
            }
            finally {
                ctx.popFeature();
            }
        }
    }

    @Override
    public IStatus validateConstraints(IItem item) {
        return this.validateConstraintsForFeatures(item, VALIDATE_ALL_FEATURES);
    }

    @Override
    public IStatus validateConstraintsForFeatures(IItem item, String[] featurePathsToValidate) {
        ValidationContext ctx = new ValidationContext(item);
        this.validatePersistentFeatures(ctx, featurePathsToValidate);
        IStatus result = ctx.getResult();
        return result == null ? Status.OK_STATUS : result;
    }

    private void validatePersistentFeatures(ValidationContext ctx, String[] featurePathsToValidate) {
        List<EStructuralFeature> features = ItemUtil.getPersistentStructuralFeatures(ctx.getCurrentEObject().eClass());
        for (EStructuralFeature feature : features) {
            ctx.pushFeature(feature);
            try {
                this.validateFeature(ctx, featurePathsToValidate);
            }
            finally {
                ctx.popFeature();
            }
        }
    }

    private void validateFeature(ValidationContext ctx, String[] featurePathsToValidate) {
        EObject obj;
        EStructuralFeature feature = ctx.getCurrentFeature();
        if (this.shouldValidate(feature, obj = ctx.getCurrentEObject(), featurePathsToValidate, ctx)) {
            Object value = obj.eGet(feature);
            boolean isPresentInFeaturePathsToValidate = this.isPresentInFeaturePathsToValidate(featurePathsToValidate, ctx);
            if (isPresentInFeaturePathsToValidate && this.violatesNonNullConstraint(feature, value)) {
                this.addNonNullConstraintViolationError(ctx);
            } else if (feature instanceof EAttribute) {
                if (isPresentInFeaturePathsToValidate) {
                    this.validateAttribute(ctx, value);
                }
            } else {
                this.validateReference(ctx, value, featurePathsToValidate);
            }
        }
    }

    private boolean shouldValidate(EStructuralFeature feature, EObject obj, String[] featurePathsToValidate, ValidationContext ctx) {
        if (TOLERANT) {
            return obj.eIsSet(feature) && !ignoreFeatures.contains(feature);
        }
        return (obj.eIsSet(feature) || ctx.isCurrentHelperType()) && !ignoreFeatures.contains(feature);
    }

    private boolean isPresentInFeaturePathsToValidate(String[] featurePathsToValidate, ValidationContext ctx) {
        if (featurePathsToValidate == VALIDATE_ALL_FEATURES) {
            return true;
        }
        String featurePath = ctx.computeFeaturePathLabel();
        String[] stringArray = featurePathsToValidate;
        int n = featurePathsToValidate.length;
        int n2 = 0;
        while (n2 < n) {
            String featureToValidate = stringArray[n2];
            if (featurePath.equals(featureToValidate)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean violatesNonNullConstraint(EStructuralFeature feature, Object value) {
        return feature.isRequired() && value == null;
    }

    private void addNonNullConstraintViolationError(ValidationContext ctx) {
        IPropertyConstraintErrorStatus status = this.createNonNullConstraintViolationError(ctx.computeFeaturePathLabel(), ctx.computeFeaturePath(), ctx.getRootType(), ctx.getCurrentType());
        ctx.appendStatus(status);
    }

    private IPropertyConstraintErrorStatus createNonNullConstraintViolationError(String feature, String[] featurePath, IItemType rootType, IType ownerType) {
        String msg = NLS.bind(IValidationMessages.PROPERTY_MUST_NOT_BE_NULL, feature, new Object[0]);
        return new PropertyConstraintErrorStatus(-2, msg, rootType, ownerType, featurePath);
    }

    private IPropertyConstraintErrorStatus createEmptyStringViolationError(String feature, String[] featurePath, IItemType rootType, IType ownerType) {
        String msg = NLS.bind(IValidationMessages.STRING_PROPERTY_MUST_NOT_BE_EMPTY, feature, new Object[0]);
        return new PropertyConstraintErrorStatus(-4, msg, rootType, ownerType, featurePath);
    }

    private void validateAttribute(ValidationContext ctx, Object value) {
        if (value != null && this.isString(ctx.getCurrentFeature())) {
            this.validateEmptyString(ctx, (String)value);
            this.validateStringSize(ctx, (String)value);
        }
    }

    private boolean isString(EStructuralFeature feature) {
        return feature.getEType() == ESTRING;
    }

    private boolean violatesEmptyStringConstraint(EStructuralFeature feature, String value) {
        return feature.isRequired() && EMPTY_STRING.equals(value);
    }

    private void validateEmptyString(ValidationContext ctx, String value) {
        if (this.violatesEmptyStringConstraint(ctx.getCurrentFeature(), value)) {
            IPropertyConstraintErrorStatus status = this.createEmptyStringViolationError(ctx.computeFeaturePathLabel(), ctx.computeFeaturePath(), ctx.getRootType(), ctx.getCurrentType());
            ctx.appendStatus(status);
        }
    }

    private void validateStringSize(ValidationContext ctx, String value) {
        EStructuralFeature feature = ctx.getCurrentFeature();
        ItemUtil.StringLengthViolation error = ItemUtil.validateStringPropertySize(feature, value);
        if (error != null) {
            String msg = this.buildTooBigErrorString(ctx.computeFeaturePathLabel(), error.getActualSize(), error.getMaxSize());
            StringSizeConstraintErrorStatus status = new StringSizeConstraintErrorStatus(msg, ctx.getRootType(), ctx.getCurrentType(), ctx.computeFeaturePath(), error.getActualSize(), error.getMaxSize());
            ctx.appendStatus(status);
        }
    }

    private void validateReference(ValidationContext ctx, Object value, String[] featurePathsToValidate) {
        EReference ref = (EReference)ctx.getCurrentFeature();
        if (value != null) {
            if (ref.isContainment()) {
                if (ref.isMany()) {
                    this.validateManyContainmentReference(ctx, (List)value, featurePathsToValidate);
                } else {
                    this.validateReferencedContainmentObject(ctx, (EObject)value, featurePathsToValidate);
                }
            } else if (ref.isMany()) {
                this.validateManySharedReference(ctx, (List)value);
            }
        }
    }

    private void validateNoDuplicateIds(ValidationContext ctx, List<? extends EObject> handles, String errorMessage, int errorId, EAttribute uuidAttribute) {
        HashSet<UUID> uuids = new HashSet<UUID>((int)((double)handles.size() * 1.5));
        UUID uuid = null;
        for (EObject eObject : handles) {
            boolean added;
            uuid = (UUID)eObject.eGet((EStructuralFeature)uuidAttribute);
            if (uuid == null || (added = uuids.add(uuid))) continue;
            String msg = NLS.bind(errorMessage, ctx.computeFeaturePathLabel(), new Object[0]);
            PropertyConstraintErrorStatus status = new PropertyConstraintErrorStatus(errorId, msg, ctx.getRootType(), ctx.getCurrentType(), ctx.computeFeaturePath());
            ctx.appendStatus(status);
            return;
        }
    }

    private void validateManySharedReference(ValidationContext ctx, List<? extends EObject> handles) {
        this.validateItemIdNotNull(ctx, handles);
        this.validateNoDuplicateIds(ctx, handles, IValidationMessages.DUPLICATE_ITEM_REFERENCE, -5, ITEM_ID_FEATURE);
    }

    private void validateItemIdNotNull(ValidationContext ctx, List<? extends EObject> handles) {
        for (EObject eObject : handles) {
            ctx.pushEObject(eObject);
            ctx.pushFeature((EStructuralFeature)ITEM_ID_FEATURE);
            try {
                this.validateFeature(ctx, null);
            }
            finally {
                ctx.popEObject();
                ctx.popFeature();
            }
        }
    }

    private void validateReferencedContainmentObject(ValidationContext ctx, EObject value, String[] featurePathsToValidate) {
        ctx.pushEObject(value);
        try {
            this.validatePersistentFeatures(ctx, featurePathsToValidate);
        }
        finally {
            ctx.popEObject();
        }
    }

    private void validateManyContainmentReference(ValidationContext ctx, List<EObject> values, String[] featurePathsToValidate) {
        for (EObject object : values) {
            this.validateReferencedContainmentObject(ctx, object, featurePathsToValidate);
        }
        this.validateNoDuplicateIds(ctx, values, IValidationMessages.DUPLICATE_HELPER_REFERENCE, -6, INTERNAL_ID_FEATURE);
    }

    @Override
    public IStatus validateAttribute(IType type, String propertyName, Object value) {
        if (type == null) {
            throw new IllegalArgumentException("type should not be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName should not be null");
        }
        EClass eClass = ItemUtil.getTypeEClass((Type)type);
        if (eClass == null) {
            String msg = String.format("Could not find metaclass for type \"%s\"", ItemUtil.itemType2String(type));
            throw new IllegalArgumentException(msg);
        }
        EStructuralFeature feature = eClass.getEStructuralFeature(propertyName);
        if (feature == null) {
            String msg = String.format("Unknown property \"%s\" for type \"%s\"", propertyName, ItemUtil.itemType2String(type));
            throw new IllegalArgumentException(msg);
        }
        if (!(feature instanceof EAttribute)) {
            String msg = String.format("Property \"%s\" for type \"%s\" must be an attribute", propertyName, ItemUtil.itemType2String(type));
            throw new IllegalArgumentException(msg);
        }
        if (this.violatesNonNullConstraint(feature, value)) {
            return this.createNonNullConstraintViolationError(propertyName, new String[]{propertyName}, null, type);
        }
        if (value != null && this.isString(feature)) {
            if (this.violatesEmptyStringConstraint(feature, (String)value)) {
                return this.createEmptyStringViolationError(propertyName, new String[]{propertyName}, null, type);
            }
            ItemUtil.StringLengthViolation error = ItemUtil.validateStringPropertySize(feature, (String)value);
            if (error != null) {
                String msg = this.buildTooBigErrorString(propertyName, error.getActualSize(), error.getMaxSize());
                StringSizeConstraintErrorStatus status = new StringSizeConstraintErrorStatus(msg, null, type, new String[]{propertyName}, error.getActualSize(), error.getMaxSize());
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    private String buildTooBigErrorString(String propertyName, long actualSize, long maxSize) {
        String actualSizeString = String.format("%d", actualSize);
        String maxSizeString = String.format("%d", maxSize);
        String msg = NLS.bind(IValidationMessages.STRING_TOO_BIG, propertyName, actualSizeString, maxSizeString);
        return msg;
    }
}

