/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.query;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.query.IDataField;
import com.ibm.team.repository.common.query.IDataRow;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class DataRow
implements IDataRow {
    static final String ILLEGAL_DATATYPE_MSG = "Illegal Data Type Code specified in data query.";
    private final List<? extends IDataField> dataFields;
    private final Map<? extends String, ? extends Integer> namesToPositions;
    private final List<? extends String> rawData;
    private final int startIndex;

    public DataRow(List<? extends IDataField> fields, Map<? extends String, ? extends Integer> namesToPositions, List<? extends String> data, int startIndex) {
        this.dataFields = fields;
        this.namesToPositions = namesToPositions;
        this.rawData = data;
        this.startIndex = startIndex;
    }

    @Override
    public boolean getBoolean(String fieldName) {
        return this.getBoolean(this.namesToPositions.get(fieldName));
    }

    private Boolean getBooleanForPosition(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return Boolean.FALSE;
        }
        if ("1".equals(aValue)) {
            return Boolean.TRUE;
        }
        return (boolean)Boolean.valueOf(aValue);
    }

    @Override
    public boolean getBoolean(int fieldPosition) {
        return this.getBooleanForPosition(fieldPosition);
    }

    @Override
    public BigDecimal getDecimal(String fieldName) {
        return this.getDecimal(this.namesToPositions.get(fieldName));
    }

    @Override
    public BigDecimal getDecimal(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return null;
        }
        return new BigDecimal(aValue);
    }

    @Override
    public int getInt(String fieldName) {
        return this.getInt(this.namesToPositions.get(fieldName));
    }

    @Override
    public int getInt(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return 0;
        }
        return Integer.parseInt(aValue);
    }

    @Override
    public long getLong(String fieldName) {
        return this.getLong(this.namesToPositions.get(fieldName));
    }

    @Override
    public long getLong(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return 0L;
        }
        return Long.parseLong(aValue);
    }

    @Override
    public Object getObject(String fieldName) {
        return this.getObject(this.namesToPositions.get(fieldName));
    }

    @Override
    public Object getObject(int fieldPosition) {
        String objectAsString = this.rawData.get(this.startIndex + fieldPosition);
        if (objectAsString == null) {
            return null;
        }
        int typeCode = this.dataFields.get(fieldPosition).getFieldType();
        Object object = null;
        switch (typeCode) {
            case 1: {
                object = this.getBooleanForPosition(fieldPosition);
                break;
            }
            case 5: {
                object = this.getDecimal(fieldPosition);
                break;
            }
            case 0: {
                object = this.getInt(fieldPosition);
                break;
            }
            case 6: {
                object = this.getLong(fieldPosition);
                break;
            }
            case 8: {
                object = Float.valueOf(this.getFloat(fieldPosition));
                break;
            }
            case 9: {
                object = this.getDouble(fieldPosition);
                break;
            }
            case 2: {
                object = objectAsString;
                break;
            }
            case 3: {
                object = this.getTimestamp(fieldPosition);
                break;
            }
            case 4: {
                object = UUID.valueOf(objectAsString);
                break;
            }
            case 7: {
                object = this.getItemType(fieldPosition);
                break;
            }
            default: {
                throw new IllegalArgumentException(ILLEGAL_DATATYPE_MSG);
            }
        }
        return object;
    }

    @Override
    public String getString(String fieldName) {
        return this.getString(this.namesToPositions.get(fieldName));
    }

    @Override
    public String getString(int fieldPosition) {
        return this.rawData.get(this.startIndex + fieldPosition);
    }

    @Override
    public Timestamp getTimestamp(String fieldName) {
        return this.getTimestamp(this.namesToPositions.get(fieldName));
    }

    @Override
    public Timestamp getTimestamp(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return null;
        }
        if (!aValue.contains(String.valueOf(':'))) {
            return new Timestamp(Long.valueOf(aValue));
        }
        return Timestamp.valueOf(aValue);
    }

    @Override
    public UUID getUUID(String fieldName) {
        return this.getUUID(this.namesToPositions.get(fieldName));
    }

    @Override
    public UUID getUUID(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return null;
        }
        return UUID.valueOf(aValue);
    }

    @Override
    public IItemType getItemType(String fieldName) {
        return this.getItemType(this.namesToPositions.get(fieldName));
    }

    @Override
    public IItemType getItemType(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return null;
        }
        return ItemUtil.string2ItemType(aValue);
    }

    @Override
    public double getDouble(String fieldName) {
        return this.getDouble(this.namesToPositions.get(fieldName));
    }

    @Override
    public double getDouble(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return 0.0;
        }
        return Double.parseDouble(aValue);
    }

    @Override
    public float getFloat(String fieldName) {
        return this.getFloat(this.namesToPositions.get(fieldName));
    }

    @Override
    public float getFloat(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return 0.0f;
        }
        return Float.parseFloat(aValue);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName()).append('[');
        if (this.rawData != null) {
            Iterator<? extends String> it = this.rawData.iterator();
            while (it.hasNext()) {
                b.append('\"').append((Object)it.next()).append('\"');
                if (!it.hasNext()) continue;
                b.append(',').append(' ');
            }
        }
        b.append(']');
        return b.toString();
    }
}

