/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.reports.client.internal;

import com.ibm.team.datawarehouse.common.ISnapshotDescriptor;
import com.ibm.team.datawarehouse.common.internal.DatawarehousePackage;
import com.ibm.team.datawarehouse.common.service.IDataWarehouseService;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.reports.client.IReportManager;
import com.ibm.team.reports.client.internal.nls.Messages;
import com.ibm.team.reports.common.IFolderDescriptor;
import com.ibm.team.reports.common.IFolderDescriptorHandle;
import com.ibm.team.reports.common.IReportDescriptor;
import com.ibm.team.reports.common.IReportDescriptorHandle;
import com.ibm.team.reports.common.IReportQueryDescriptor;
import com.ibm.team.reports.common.IReportQueryDescriptorHandle;
import com.ibm.team.reports.common.internal.ReportsPackage;
import com.ibm.team.reports.common.internal.dto.DtoPackage;
import com.ibm.team.reports.common.service.IReportImageService;
import com.ibm.team.reports.common.service.IReportService;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.transport.TeamContent;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ReportManager
implements IReportManager {
    private final IClientLibraryContext context;

    public ReportManager(IClientLibraryContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        if (ReportsPackage.eINSTANCE == null) {
            throw new IllegalStateException();
        }
        if (DatawarehousePackage.eINSTANCE == null) {
            throw new IllegalStateException();
        }
        if (DtoPackage.eINSTANCE == null) {
            throw new IllegalStateException();
        }
        this.context = context;
    }

    @Override
    public ITeamRepository teamRepository() {
        return this.context.teamRepository();
    }

    @Override
    public void deleteFolderDescriptor(final IFolderDescriptorHandle descriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask("", 100);
                IProcessClientService processClient = (IProcessClientService)this.context.teamRepository().getClientLibrary(IProcessClientService.class);
                final ArrayList deleted = new ArrayList();
                processClient.execute(new ProcessRunnable(){

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        ReportManager.this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                                deleted.addAll(Arrays.asList(ReportManager.this.getReportService().deleteFolderDescriptor(descriptor)));
                                return null;
                            }
                        }, monitor);
                        return null;
                    }
                }, Messages.getString("ReportManager.1"), (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                this.teamRepository().itemManager().applyItemDeletes(deleted);
            }
            catch (TeamOperationCanceledException teamOperationCanceledException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void deleteQueryDescriptor(final IReportQueryDescriptorHandle descriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask("", 100);
                IProcessClientService processClient = (IProcessClientService)this.context.teamRepository().getClientLibrary(IProcessClientService.class);
                processClient.execute(new ProcessRunnable(){

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        ReportManager.this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                                ReportManager.this.getReportService().deleteQueryDescriptor(descriptor);
                                return null;
                            }
                        }, monitor);
                        return null;
                    }
                }, Messages.getString("ReportManager.3"), (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                this.teamRepository().itemManager().applyItemDeletes(Collections.singletonList(descriptor));
            }
            catch (TeamOperationCanceledException teamOperationCanceledException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void deleteReportDescriptor(final IReportDescriptorHandle descriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask("", 100);
                IProcessClientService processClient = (IProcessClientService)this.context.teamRepository().getClientLibrary(IProcessClientService.class);
                final ArrayList deleted = new ArrayList();
                processClient.execute(new ProcessRunnable(){

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        ReportManager.this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                                deleted.addAll(Arrays.asList(ReportManager.this.getReportService().deleteReportDescriptor(descriptor)));
                                return null;
                            }
                        }, monitor);
                        return null;
                    }
                }, Messages.getString("ReportManager.5"), (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                this.teamRepository().itemManager().applyItemDeletes(deleted);
            }
            catch (TeamOperationCanceledException teamOperationCanceledException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public boolean doesReportDescriptorExist(final IProjectAreaHandle projectArea, final String reportId, IProgressMonitor monitor) throws TeamRepositoryException {
        if (projectArea == null) {
            throw new IllegalArgumentException();
        }
        if (reportId == null) {
            throw new IllegalArgumentException();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 100);
            boolean bl = (Boolean)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Boolean>(){

                public Boolean run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().doesReportDescriptorExist(projectArea, reportId);
                }
            }, monitor);
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<String> fetchAllSnapshotNames(IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 100);
            List list = (List)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<List<String>>(){

                public List<String> run(IProgressMonitor monitor) throws TeamRepositoryException {
                    String[] names = ReportManager.this.getDataWarehouseService().fetchAllSnapshotNames();
                    return Arrays.asList(names);
                }
            }, monitor);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IFolderDescriptor> fetchFolderDescriptors(final IContributorHandle owner, final IProjectAreaHandle projectArea, final List<IProcessAreaHandle> processAreas, final IFolderDescriptorHandle parent, final int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 200);
            IFolderDescriptor[] descriptors = (IFolderDescriptor[])this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IFolderDescriptor[]>(){

                public IFolderDescriptor[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().fetchFolderDescriptors(owner, projectArea, processAreas == null ? null : processAreas.toArray(new IProcessAreaHandle[processAreas.size()]), parent, flags);
                }
            }, monitor);
            monitor.worked(100);
            List list = this.teamRepository().itemManager().applyItemUpdatesOrRefresh(Arrays.asList(descriptors), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IReportQueryDescriptor> fetchQueryDescriptors(final IContributorHandle owner, final IProjectAreaHandle projectArea, final List<IProcessAreaHandle> processAreas, final IReportDescriptorHandle report, final IFolderDescriptorHandle folder, final int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 200);
            IReportQueryDescriptor[] descriptors = (IReportQueryDescriptor[])this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IReportQueryDescriptor[]>(){

                public IReportQueryDescriptor[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().fetchQueryDescriptors(owner, projectArea, processAreas == null ? null : processAreas.toArray(new IProcessAreaHandle[processAreas.size()]), report, folder, flags | 0x10);
                }
            }, monitor);
            monitor.worked(100);
            List list = this.teamRepository().itemManager().applyItemUpdatesOrRefresh(Arrays.asList(descriptors), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IReportDescriptor fetchReportDescriptor(final String projectAreaId, final String reportId, IProgressMonitor monitor) throws TeamRepositoryException {
        if (reportId == null) {
            throw new IllegalArgumentException(Messages.getString("ReportManager.10"));
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 200);
            IReportDescriptor descriptor = (IReportDescriptor)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IReportDescriptor>(){

                public IReportDescriptor run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().fetchReportDescriptor(projectAreaId, reportId);
                }
            }, monitor);
            monitor.worked(100);
            IReportDescriptor iReportDescriptor = (IReportDescriptor)this.teamRepository().itemManager().applyItemUpdatesOrRefresh(Collections.singletonList(descriptor), (IProgressMonitor)new SubProgressMonitor(monitor, 100)).get(0);
            return iReportDescriptor;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IReportDescriptor> fetchReportDescriptors(final IContributorHandle owner, final IProjectAreaHandle projectArea, final List<IProcessAreaHandle> processAreas, final List<String> parameters, final int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 200);
            IReportDescriptor[] descriptors = (IReportDescriptor[])this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IReportDescriptor[]>(){

                public IReportDescriptor[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().fetchReportDescriptors(owner, projectArea, processAreas == null ? null : processAreas.toArray(new IProcessAreaHandle[processAreas.size()]), null, parameters == null ? null : parameters.toArray(new String[parameters.size()]), flags);
                }
            }, monitor);
            monitor.worked(100);
            List list = this.teamRepository().itemManager().applyItemUpdatesOrRefresh(Arrays.asList(descriptors), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IReportDescriptor> fetchMissingSharedReportDescriptors(final IProcessAreaHandle processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (processArea == null) {
            throw new IllegalArgumentException();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 200);
            IReportDescriptor[] descriptors = (IReportDescriptor[])this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IReportDescriptor[]>(){

                public IReportDescriptor[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().fetchMissingSharedReportDescriptors(processArea);
                }
            }, monitor);
            monitor.worked(100);
            List<IReportDescriptor> list = Arrays.asList(descriptors);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IFolderDescriptor> fetchRootFolderDescriptors(final IContributorHandle owner, final IProjectAreaHandle projectArea, final List<IProcessAreaHandle> processAreas, final int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 200);
            IFolderDescriptor[] descriptors = (IFolderDescriptor[])this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IFolderDescriptor[]>(){

                public IFolderDescriptor[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().fetchRootFolderDescriptors(owner, projectArea, processAreas == null ? null : processAreas.toArray(new IProcessAreaHandle[processAreas.size()]), flags);
                }
            }, monitor);
            monitor.worked(100);
            List list = this.teamRepository().itemManager().applyItemUpdatesOrRefresh(Arrays.asList(descriptors), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ISnapshotDescriptor fetchSnapshotDescriptorByName(final String snapshotName, IProgressMonitor monitor) throws TeamRepositoryException {
        if (snapshotName == null || snapshotName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 100);
            ISnapshotDescriptor descriptor = (ISnapshotDescriptor)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ISnapshotDescriptor>(){

                public ISnapshotDescriptor run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getDataWarehouseService().fetchSnapshotDescriptorByName(snapshotName);
                }
            }, monitor);
            if (descriptor == null) {
                throw new ItemNotFoundException(String.valueOf(Messages.getString("ReportManager.15")) + ' ' + snapshotName);
            }
            ISnapshotDescriptor iSnapshotDescriptor = descriptor;
            return iSnapshotDescriptor;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IReportQueryDescriptorHandle getDefaultQueryDescriptor(final IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (projectArea == null) {
            throw new IllegalArgumentException();
        }
        try {
            monitor.beginTask("", 100);
            IReportQueryDescriptorHandle iReportQueryDescriptorHandle = (IReportQueryDescriptorHandle)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IReportQueryDescriptorHandle>(){

                public IReportQueryDescriptorHandle run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().getDefaultQueryDescriptor((IContributorHandle)ReportManager.this.teamRepository().loggedInContributor(), projectArea);
                }
            }, monitor);
            return iReportQueryDescriptorHandle;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IReportDescriptorHandle getDefaultReportDescriptor(final IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (projectArea == null) {
            throw new IllegalArgumentException();
        }
        try {
            monitor.beginTask("", 100);
            IReportDescriptorHandle iReportDescriptorHandle = (IReportDescriptorHandle)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IReportDescriptorHandle>(){

                public IReportDescriptorHandle run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().getDefaultReportDescriptor(projectArea);
                }
            }, monitor);
            return iReportDescriptorHandle;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IProcessAreaHandle getDefaultProcessArea(final IProjectAreaHandle projectArea, final IContributorHandle contributor, IProgressMonitor monitor) throws TeamRepositoryException {
        if (projectArea == null) {
            throw new IllegalArgumentException();
        }
        try {
            monitor.beginTask("", 100);
            IProcessAreaHandle iProcessAreaHandle = (IProcessAreaHandle)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IProcessAreaHandle>(){

                public IProcessAreaHandle run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().getDefaultProcessArea(projectArea, contributor);
                }
            }, monitor);
            return iProcessAreaHandle;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void saveFolderDescriptor(final IFolderDescriptor descriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (!descriptor.isWorkingCopy()) {
            throw new IllegalArgumentException(Messages.getString("ReportManager.18"));
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask("", 100);
                IProcessClientService processClient = (IProcessClientService)this.context.teamRepository().getClientLibrary(IProcessClientService.class);
                final ArrayList modified = new ArrayList();
                processClient.execute(new ProcessRunnable(){

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        ReportManager.this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                                modified.addAll(Arrays.asList(ReportManager.this.getReportService().saveFolderDescriptor(descriptor)));
                                return null;
                            }
                        }, monitor);
                        return null;
                    }
                }, Messages.getString("ReportManager.20"), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                this.teamRepository().itemManager().fetchCompleteItems(modified, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
            catch (TeamOperationCanceledException teamOperationCanceledException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void saveQueryDescriptor(final IReportQueryDescriptor descriptor, final boolean sharedIfNullFolder, IProgressMonitor monitor) throws TeamRepositoryException {
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (!descriptor.isWorkingCopy()) {
            throw new IllegalArgumentException(Messages.getString("ReportManager.21"));
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask("", 100);
                IProcessClientService processClient = (IProcessClientService)this.context.teamRepository().getClientLibrary(IProcessClientService.class);
                final IFolderDescriptorHandle[] folder = new IFolderDescriptorHandle[1];
                processClient.execute(new ProcessRunnable(){

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        ReportManager.this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                                folder[0] = ReportManager.this.getReportService().saveQueryDescriptor(descriptor, sharedIfNullFolder);
                                return null;
                            }
                        }, monitor);
                        return null;
                    }
                }, Messages.getString("ReportManager.23"), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                ArrayList<Object> itemsToRefresh = new ArrayList<Object>(2);
                itemsToRefresh.add(descriptor);
                if (folder[0] != null) {
                    itemsToRefresh.add(folder[0]);
                }
                this.teamRepository().itemManager().fetchCompleteItems(itemsToRefresh, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
            catch (TeamOperationCanceledException teamOperationCanceledException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void saveReportDescriptor(final IReportDescriptor descriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (!descriptor.isWorkingCopy()) {
            throw new IllegalArgumentException(Messages.getString("ReportManager.24"));
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask("", 100);
                IProcessClientService processClient = (IProcessClientService)this.context.teamRepository().getClientLibrary(IProcessClientService.class);
                processClient.execute(new ProcessRunnable(){

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        ReportManager.this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                                ReportManager.this.getReportService().saveReportDescriptor(descriptor);
                                return null;
                            }
                        }, monitor);
                        return null;
                    }
                }, Messages.getString("ReportManager.26"), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)descriptor, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
            catch (TeamOperationCanceledException teamOperationCanceledException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void resetReportDescriptor(final IReportDescriptor descriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (!descriptor.isWorkingCopy()) {
            throw new IllegalArgumentException(Messages.getString("ReportManager.24"));
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask("", 100);
                IProcessClientService processClient = (IProcessClientService)this.context.teamRepository().getClientLibrary(IProcessClientService.class);
                processClient.execute(new ProcessRunnable(){

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        ReportManager.this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                                ReportManager.this.getReportService().resetReportDescriptor(descriptor);
                                return null;
                            }
                        }, monitor);
                        return null;
                    }
                }, Messages.getString("ReportManager.26"), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)descriptor, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
            catch (TeamOperationCanceledException teamOperationCanceledException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void clearReportQueryParameters(final IReportQueryDescriptor descriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (!descriptor.isWorkingCopy()) {
            throw new IllegalArgumentException(Messages.getString("ReportManager.21"));
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask("", 100);
                IProcessClientService processClient = (IProcessClientService)this.context.teamRepository().getClientLibrary(IProcessClientService.class);
                final IFolderDescriptorHandle[] folder = new IFolderDescriptorHandle[1];
                processClient.execute(new ProcessRunnable(){

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        descriptor.getParameters().clear();
                        ReportManager.this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                                folder[0] = ReportManager.this.getReportService().saveQueryDescriptor(descriptor, false);
                                return null;
                            }
                        }, monitor);
                        return null;
                    }
                }, Messages.getString("ReportManager.23"), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                ArrayList<Object> itemsToRefresh = new ArrayList<Object>(2);
                itemsToRefresh.add(descriptor);
                if (folder[0] != null) {
                    itemsToRefresh.add(folder[0]);
                }
                this.teamRepository().itemManager().fetchCompleteItems(itemsToRefresh, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
            catch (TeamOperationCanceledException teamOperationCanceledException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setDefaultQueryDescriptor(final IReportQueryDescriptorHandle query, IProgressMonitor monitor) throws TeamRepositoryException {
        if (query == null) {
            throw new IllegalArgumentException();
        }
        try {
            monitor.beginTask("", 100);
            this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    ReportManager.this.getReportService().setDefaultQueryDescriptor((IContributorHandle)ReportManager.this.teamRepository().loggedInContributor(), query);
                    return null;
                }
            }, monitor);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setDefaultQueryDescriptor(final IProcessAreaHandle processArea, final IReportQueryDescriptorHandle query, IProgressMonitor monitor) throws TeamRepositoryException {
        if (processArea == null) {
            throw new IllegalArgumentException();
        }
        if (query == null) {
            throw new IllegalArgumentException();
        }
        try {
            monitor.beginTask("", 100);
            this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    ReportManager.this.getReportService().setDefaultTeamQueryDescriptor(processArea, query);
                    return null;
                }
            }, monitor);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setDefaultReportDescriptor(final IProjectAreaHandle projectArea, final IReportDescriptorHandle report, IProgressMonitor monitor) throws TeamRepositoryException {
        if (projectArea == null) {
            throw new IllegalArgumentException();
        }
        if (report == null) {
            throw new IllegalArgumentException();
        }
        try {
            monitor.beginTask("", 100);
            this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    ReportManager.this.getReportService().setDefaultReportDescriptor(projectArea, report);
                    return null;
                }
            }, monitor);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IReportDescriptor getReportDescriptor(final String reportId, final IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (reportId == null) {
            throw new IllegalArgumentException(Messages.getString("ReportManager.29"));
        }
        try {
            monitor.beginTask("", 100);
            IReportDescriptor descriptor = (IReportDescriptor)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IReportDescriptor>(){

                public IReportDescriptor run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().fetchReportDescriptor(projectArea.getItemId().getUuidValue(), reportId);
                }
            }, monitor);
            IReportDescriptor iReportDescriptor = (IReportDescriptor)this.teamRepository().itemManager().applyItemUpdatesOrRefresh(Collections.singletonList(descriptor), (IProgressMonitor)new SubProgressMonitor(monitor, 100)).get(0);
            return iReportDescriptor;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public TeamContent getReportImage(IReportDescriptorHandle reportHandle, String imageBookmark, Map<String, String> parameters, IProgressMonitor monitor) throws TeamRepositoryException {
        if (reportHandle == null) {
            throw new IllegalArgumentException();
        }
        if (imageBookmark == null) {
            throw new IllegalArgumentException();
        }
        if (parameters == null) {
            parameters = Collections.EMPTY_MAP;
        }
        IReportDescriptor report = (IReportDescriptor)this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)reportHandle, 0, monitor);
        IProjectAreaHandle projectArea = report.getProjectArea();
        String query = "__projectAreaUUID=" + projectArea.getItemId().getUuidValue() + "&__reportUUID=" + report.getItemId().getUuidValue() + "&__imageBookmark=" + imageBookmark;
        for (String key : parameters.keySet()) {
            String value = (String)parameters.get(key);
            query = String.valueOf(query) + "&" + key + "=" + value;
        }
        ITeamRestServiceClient restClient = (ITeamRestServiceClient)this.context.getServiceInterface(IReportImageService.class);
        final ITeamRestServiceClient.IRestClientConnection connection = restClient.getConnection(Location.serviceLocation((String)this.teamRepository().getRepositoryURI(), IReportImageService.class, null, (String)query));
        ITeamRestServiceClient.IRestClientConnection.Response response = (ITeamRestServiceClient.IRestClientConnection.Response)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ITeamRestServiceClient.IRestClientConnection.Response>(){

            public ITeamRestServiceClient.IRestClientConnection.Response run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                try {
                    progressMonitor.beginTask("", -1);
                    ITeamRestServiceClient.IRestClientConnection.Response response = connection.doGet();
                    return response;
                }
                finally {
                    progressMonitor.done();
                }
            }
        }, monitor);
        InputStream stream = response.getResponseStream();
        TeamContent result = new TeamContent();
        result.setContentType(response.getResponseHeader("Content-Type"));
        result.setInputStream(stream);
        return result;
    }

    @Override
    public String[] resolveVariables(final IProjectAreaHandle projectArea, final int flags, final String[] values, IProgressMonitor monitor) throws TeamRepositoryException {
        if (projectArea == null) {
            throw new IllegalArgumentException("project area must not be null");
        }
        if (values == null) {
            throw new IllegalArgumentException(Messages.getString("ReportManager.38"));
        }
        try {
            monitor.beginTask("", 100);
            String[] stringArray = (String[])this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<String[]>(){

                public String[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().resolveVariables(projectArea, flags, values);
                }
            }, monitor);
            return stringArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public UUID[] getTeamAreaItemIds(final String[] projectAreaNames, final String[] teamAreaNames, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.beginTask("", 100);
            UUID[] uUIDArray = (UUID[])this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<UUID[]>(){

                public UUID[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().getTeamAreaItemIds(projectAreaNames, teamAreaNames);
                }
            }, monitor);
            return uUIDArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<String> fetchAllSupportedFileExtensions(IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.beginTask("", 100);
            List<String> list = Arrays.asList((String[])this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<String[]>(){

                public String[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ReportManager.this.getReportService().fetchAllSupportedFileExtensions();
                }
            }, monitor));
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IQueryService getQueryService() throws TeamRepositoryException {
        return (IQueryService)this.context.getServiceInterface(IQueryService.class);
    }

    private IDataWarehouseService getDataWarehouseService() {
        return (IDataWarehouseService)this.context.getServiceInterface(IDataWarehouseService.class);
    }

    private IReportService getReportService() {
        return (IReportService)this.context.getServiceInterface(IReportService.class);
    }
}

