/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.process;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.internal.Activator;
import com.ibm.team.scm.common.internal.process.DeserializationOrigin;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AdvisorDataMarshaller {
    public static final String CLASS_NULL = "null";
    public static final String CLASS_INTEGER = "int";
    public static final String CLASS_STRING = "string";
    public static final String CLASS_BOOLEAN = "bool";
    public static final String CLASS_UUID = "uuid";
    public static final String CLASS_HANDLE = "handle";
    public static final String CLASS_LIST = "list";
    public static final String ATTR_INTERNALLY_HANDLED_TYPE = "isa";
    private static final String ATTR_CLASSNAME = "class";
    private static final String ATTR_BUNDLE = "bundle";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_ORIGIN_HINT = "origin-hint";
    public static final String ATTR_ENUM_NAME = "enum-name";
    public static final String VALUE_TRUE = "true";
    private static final String COMMENT_INTERRED_ROOT = "jazzscm-reflective-serialization";

    public static void marshallInto(IScmAdvisorMarshallable m, Document doc, Element root, UUID repo) throws MarshallerException {
        if (root == null) {
            root = doc.createElement("root");
            doc.appendChild(root);
        }
        Node parent = root.getParentNode();
        parent.insertBefore(doc.createComment(COMMENT_INTERRED_ROOT), root);
        SerializationContext ctx = new SerializationContext();
        ctx.admin = AdvisorDataMarshaller.getPackageAdmin();
        if (repo != null) {
            root.setAttribute(ATTR_ORIGIN_HINT, "uuid " + repo.getUuidValue());
        }
        AdvisorDataMarshaller.serializeInto(m, root, doc, ctx);
    }

    private static void serializeInto(Object obj, Element el, Document doc, SerializationContext ctx) throws MarshallerException {
        Bundle bundle;
        if (obj == null) {
            el.setAttribute(ATTR_INTERNALLY_HANDLED_TYPE, CLASS_NULL);
            return;
        }
        Class<?> type = obj.getClass();
        if (AdvisorDataMarshaller.serializeIntoElement(obj, doc, el, ctx)) {
            return;
        }
        el.setAttribute(ATTR_CLASSNAME, type.getName());
        boolean pushedBundle = false;
        if (ctx.admin != null && (bundle = ctx.admin.getBundle(type)) != null && (ctx.bundles.empty() || bundle.getBundleId() != ctx.bundles.peek().getBundleId())) {
            el.setAttribute(ATTR_BUNDLE, bundle.getSymbolicName());
            ctx.bundles.push(bundle);
            pushedBundle = true;
        }
        try {
            if (type.isEnum()) {
                el.setAttribute(ATTR_ENUM_NAME, ((Enum)obj).name());
            }
            Field[] fieldArray = type.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (!AdvisorDataMarshaller.shouldSkipField(f)) {
                    Object value;
                    try {
                        value = f.get(obj);
                    }
                    catch (IllegalArgumentException e) {
                        throw new MarshallerException("Could not serialize " + obj.getClass().getSimpleName() + "." + f.getName(), e);
                    }
                    catch (IllegalAccessException e) {
                        throw new MarshallerException("Could not serialize " + obj.getClass().getSimpleName() + "." + f.getName(), e);
                    }
                    if (value != null) {
                        Element fieldEl = doc.createElement(f.getName());
                        try {
                            AdvisorDataMarshaller.serializeInto(value, fieldEl, doc, ctx);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new MarshallerException("Don't know how to serialize " + value.getClass().getSimpleName() + " in " + obj.getClass().getSimpleName() + "." + f.getName());
                        }
                        if (f.isAnnotationPresent(DeserializationOrigin.class)) {
                            fieldEl.setAttribute(ATTR_ORIGIN_HINT, VALUE_TRUE);
                        }
                        el.appendChild(fieldEl);
                    }
                }
                ++n2;
            }
        }
        finally {
            if (pushedBundle) {
                ctx.bundles.pop();
            }
        }
    }

    private static PackageAdmin getPackageAdmin() {
        ServiceTracker bundleTracker = new ServiceTracker(Activator.getBundleContext(), PackageAdmin.class.getName(), null);
        bundleTracker.open();
        return (PackageAdmin)bundleTracker.getService();
    }

    private static boolean serializeIntoElement(Object value, Document doc, Element el, SerializationContext ctx) throws MarshallerException {
        String serialized;
        String typeString;
        if (value == null) {
            el.setAttribute(ATTR_INTERNALLY_HANDLED_TYPE, CLASS_NULL);
            return true;
        }
        if (List.class.isAssignableFrom(value.getClass())) {
            el.setAttribute(ATTR_INTERNALLY_HANDLED_TYPE, CLASS_LIST);
            for (Object item : (List)value) {
                Element itemEl = doc.createElement("item");
                AdvisorDataMarshaller.serializeInto(item, itemEl, doc, ctx);
                el.appendChild(itemEl);
            }
            return true;
        }
        if (value instanceof String) {
            typeString = CLASS_STRING;
            serialized = (String)value;
        } else if (value instanceof Boolean) {
            typeString = CLASS_BOOLEAN;
            serialized = Boolean.toString((Boolean)value);
        } else if (value instanceof UUID) {
            typeString = CLASS_UUID;
            serialized = ((UUID)value).getUuidValue();
        } else if (value instanceof IItemHandle) {
            typeString = CLASS_HANDLE;
            IItemHandle itemHandle = (IItemHandle)value;
            IItemType itemType = itemHandle.getItemType();
            String eUri = itemType.getNamespaceURI();
            String eName = itemType.getName();
            StringBuffer buf = new StringBuffer(eUri);
            buf.append(' ');
            buf.append(eName);
            buf.append(' ');
            buf.append(itemHandle.getItemId().getUuidValue());
            if (itemHandle.getStateId() != null) {
                buf.append(' ');
                buf.append(itemHandle.getStateId().getUuidValue());
            }
            serialized = buf.toString();
        } else if (value instanceof Integer) {
            typeString = CLASS_INTEGER;
            serialized = Integer.toString((Integer)value);
        } else {
            return false;
        }
        el.setAttribute(ATTR_INTERNALLY_HANDLED_TYPE, typeString);
        el.setAttribute(ATTR_VALUE, serialized);
        return true;
    }

    public static <T extends IScmAdvisorMarshallable> T demarshall(String s, ClassInstantiator ci) throws MarshallerException {
        return AdvisorDataMarshaller.demarshall(s, ci, new DemarshallingInstructions());
    }

    public static <T extends IScmAdvisorMarshallable> T demarshall(String s, ClassInstantiator ci, DemarshallingInstructions inst) throws MarshallerException {
        Document doc;
        if (s == null || "".equals(s)) {
            return null;
        }
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(s)));
        }
        catch (SAXException e) {
            throw new MarshallerException("Parse failure for:\n" + s, e);
        }
        catch (IOException e) {
            throw new MarshallerException("Parse failure for:\n" + s, e);
        }
        catch (ParserConfigurationException e) {
            throw new MarshallerException("Parse failure for:\n" + s, e);
        }
        Element root = inst.findDemarshallRoot(doc);
        if (root == null) {
            throw new MarshallerException("Couldn't find serialization root in: \n" + s);
        }
        SerializationContext ctx = new SerializationContext();
        ctx.admin = AdvisorDataMarshaller.getPackageAdmin();
        return (T)((IScmAdvisorMarshallable)AdvisorDataMarshaller.deserialize(root, ci, inst, ctx));
    }

    private static Object deserialize(Element el, ClassInstantiator ci, DemarshallingInstructions inst, SerializationContext ctx) throws MarshallerException {
        boolean pushedOrigin = false;
        if (el.hasAttribute(ATTR_ORIGIN_HINT)) {
            ctx.origins.push(ci.createOrigin(el.getAttribute(ATTR_ORIGIN_HINT)));
        }
        try {
            Object object;
            block35: {
                Object instance;
                boolean pushedBundle;
                block32: {
                    block33: {
                        Bundle bundle;
                        Object r = AdvisorDataMarshaller.demarshallFromElement(el, ci, inst, ctx);
                        if (r != null) {
                            Object object2 = r;
                            return object2;
                        }
                        String className = el.getAttribute(ATTR_CLASSNAME);
                        if ("".equals(className) && (className = inst.handleMissingClassName(el)) == null) {
                            return null;
                        }
                        pushedBundle = false;
                        if (el.hasAttribute(ATTR_BUNDLE) && ctx.admin != null) {
                            String bundleName = el.getAttribute(ATTR_BUNDLE);
                            if (bundleName.length() == 0) {
                                bundle = null;
                            } else {
                                Bundle[] bundles = ctx.admin.getBundles(bundleName, null);
                                if (bundles == null || bundles.length < 1) {
                                    throw new MarshallerException("Can't find bundle named " + bundleName);
                                }
                                bundle = bundles[0];
                            }
                            ctx.bundles.push(bundle);
                            pushedBundle = true;
                        }
                        try {
                            String enumName;
                            bundle = ctx.bundles.isEmpty() ? null : ctx.bundles.peek();
                            Class<?> type = ci.loadClass(bundle, className);
                            instance = type.isEnum() ? ("".equals(enumName = el.getAttribute(ATTR_ENUM_NAME)) ? inst.handleMissingEnumerationValue(el) : Enum.valueOf(type, enumName)) : type.newInstance();
                        }
                        catch (ClassNotFoundException e) {
                            instance = inst.handleInstantiateFailed(e, className, el, ci);
                        }
                        catch (IllegalAccessException e) {
                            instance = inst.handleInstantiateFailed(e, className, el, ci);
                        }
                        catch (InstantiationException e) {
                            instance = inst.handleInstantiateFailed(e, className, el, ci);
                        }
                        if (instance != null) break block32;
                        if (!pushedBundle) break block33;
                        ctx.bundles.pop();
                    }
                    return null;
                }
                try {
                    Map<String, Element> elements = AdvisorDataMarshaller.makeChildElementMap(el);
                    Field[] fieldArray = instance.getClass().getFields();
                    int n = fieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Element fieldEl;
                        Field field = fieldArray[n2];
                        if (!AdvisorDataMarshaller.shouldSkipField(field) && (fieldEl = elements.get(field.getName())) != null) {
                            Object value;
                            try {
                                value = AdvisorDataMarshaller.deserialize(fieldEl, ci, inst, ctx);
                            }
                            finally {
                                if (pushedOrigin) {
                                    ctx.origins.pop();
                                }
                            }
                            try {
                                field.set(instance, value);
                            }
                            catch (IllegalArgumentException e) {
                                inst.handleFieldSetFailed(e, field, fieldEl, value, ci);
                            }
                            catch (IllegalAccessException e) {
                                inst.handleFieldSetFailed(e, field, fieldEl, value, ci);
                            }
                        }
                        ++n2;
                    }
                    object = instance;
                    if (!pushedBundle) break block35;
                    ctx.bundles.pop();
                }
                catch (Throwable throwable) {
                    if (pushedBundle) {
                        ctx.bundles.pop();
                    }
                    throw throwable;
                }
            }
            return object;
        }
        finally {
            if (pushedOrigin) {
                ctx.bundles.pop();
            }
        }
    }

    private static boolean shouldSkipField(Field f) {
        return Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers());
    }

    private static Object demarshallFromElement(Element el, ClassInstantiator ci, DemarshallingInstructions inst, SerializationContext ctx) throws MarshallerException {
        String className = el.getAttribute(ATTR_INTERNALLY_HANDLED_TYPE);
        if ("".equals(className)) {
            return null;
        }
        String serialized = el.getAttribute(ATTR_VALUE);
        if (CLASS_NULL.equals(className)) {
            return null;
        }
        if (CLASS_STRING.equals(className)) {
            return serialized;
        }
        if (CLASS_BOOLEAN.equals(className)) {
            return Boolean.parseBoolean(serialized);
        }
        if (CLASS_UUID.equals(className)) {
            return UUID.valueOf((String)serialized);
        }
        if (CLASS_HANDLE.equals(className)) {
            String[] split = serialized.split(" ");
            if (split.length < 3) {
                return null;
            }
            String eUri = split[0];
            String eName = split[1];
            String itemId = split[2];
            UUID stateId = null;
            if (split.length > 3) {
                String id = split[3];
                stateId = UUID.valueOf((String)id);
            }
            IItemType itemType = IItemType.IRegistry.INSTANCE.getItemType(eName, eUri);
            Object origin = ctx.getCurrentOrigin();
            if (origin == null) {
                return itemType.createItemHandle(UUID.valueOf((String)itemId), stateId);
            }
            return itemType.createItemHandle(origin, UUID.valueOf((String)itemId), stateId);
        }
        if (CLASS_LIST.equals(className)) {
            NodeList nodes = el.getChildNodes();
            ArrayList<Object> list = new ArrayList<Object>(nodes.getLength());
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1) {
                    Object item = AdvisorDataMarshaller.deserialize((Element)node, ci, inst, ctx);
                    list.add(item);
                }
                ++i;
            }
            return list;
        }
        if (CLASS_INTEGER.equals(className)) {
            return Integer.valueOf(serialized);
        }
        return inst.handleUnknownInternallyHandledType(className, el, ci, inst);
    }

    private static Map<String, Element> makeChildElementMap(Element el) {
        NodeList children = el.getChildNodes();
        HashMap<String, Element> map = new HashMap<String, Element>(children.getLength());
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                Element child = (Element)node;
                map.put(child.getTagName(), child);
            }
            ++i;
        }
        return map;
    }

    public static class AdvisorData<DataType extends IScmAdvisorMarshallable>
    implements IScmAdvisorMarshallable {
        public int text_version = 1;
        public int data_version = 1;
        public String text;
        public DataType data;

        public AdvisorData(String desc, DataType data) {
            this.text = desc;
            this.data = data;
        }

        public AdvisorData() {
        }
    }

    public static class ClassInstantiator {
        protected ClassLoader cl;

        public ClassInstantiator(ClassLoader cl) {
            this.cl = cl;
        }

        public Class<?> loadClass(Bundle bundle, String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, MarshallerException {
            if (bundle == null) {
                return this.cl.loadClass(className);
            }
            return bundle.loadClass(className);
        }

        public Object createOrigin(String desc) {
            return null;
        }
    }

    public static class DemarshallingInstructions {
        public Element findDemarshallRoot(Document doc) {
            return this.findDemarshallRoot((Node)doc);
        }

        protected Element findDemarshallRoot(Node node) {
            NodeList childNodes = node.getChildNodes();
            boolean state = false;
            int i = 0;
            while (i < childNodes.getLength()) {
                String str;
                Node child = childNodes.item(i);
                if (!state && child.getNodeType() == 8 && (str = child.getNodeValue()).startsWith(AdvisorDataMarshaller.COMMENT_INTERRED_ROOT)) {
                    state = true;
                } else if (child.getNodeType() == 1) {
                    Element el = (Element)child;
                    if (state) {
                        return el;
                    }
                    if ((el = this.findDemarshallRoot(el)) != null) {
                        return el;
                    }
                }
                ++i;
            }
            return null;
        }

        public String handleMissingClassName(Element el) {
            return null;
        }

        public String handleMissingEnumerationValue(Element el) {
            return null;
        }

        public Object handleUnknownInternallyHandledType(String className, Element el, ClassInstantiator ci, DemarshallingInstructions inst) {
            return null;
        }

        public Object handleInstantiateFailed(Exception e, String className, Element el, ClassInstantiator ci) {
            return null;
        }

        public void handleFieldSetFailed(Exception e, Field field, Element fieldEl, Object value, ClassInstantiator ci) {
        }
    }

    public static interface IScmAdvisorMarshallable {
    }

    public static class MarshallerException
    extends Exception {
        public MarshallerException(String s) {
            super(s);
        }

        public MarshallerException(String s, Throwable t) {
            super(s, t);
        }

        public MarshallerException(Throwable t) {
            super(t);
        }
    }

    private static class SerializationContext {
        final Stack<Bundle> bundles = new Stack();
        final Stack<Object> origins = new Stack();
        PackageAdmin admin;

        private SerializationContext() {
        }

        public Object getCurrentOrigin() {
            if (this.origins.empty()) {
                return null;
            }
            return this.origins.peek();
        }
    }
}

