/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.process;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.process.UnifiedProcessDescriptionUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AdvisorDetailConstants {
    public static final String EL_DESCRIPTION = "description";
    public static final String EL_LIST = "list";
    public static final String EL_LIST_ITEM = "item";
    public static final String EL_PARAGRAPH = "paragraph";
    public static final String EL_EMPHASIZE = "em";
    public static final String EL_BOLD = "b";
    public static final String EL_VERSIONABLE_LINK = "versionable-link";
    public static final String ATTR_REPO = "repository";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_ETYPE = "etype";
    public static final String VAL_TYPE_FILE = "file";
    public static final String VAL_TYPE_DIRECTORY = "directory";
    public static final String VAL_TYPE_SYMLINK = "symlink";
    public static final String ATTR_UUID = "uuid";
    public static final String ATTR_UUIDS = "uuids";
    public static final String ATTR_STATE = "state";
    public static final String ATTR_MAKE_CONTENT = "make-content";
    public static final String ATTR_CONTEXT_TYPE = "context-type";
    public static final String VAL_CONTEXT_TYPE_WORKSPACE = "workspace";
    public static final String VAL_CONTEXT_TYPE_BASELINE = "baseline";
    public static final String ATTR_CONTEXT_UUID = "context-uuid";
    public static final String ATTR_COMPONENT_UUID = "component-uuid";
    public static final String ATTR_NAME = "name";
    public static final String VAL_LIST_TYPE_BULLETS = "bullets";
    public static final String VAL_LIST_TYPE_NUMERIC = "numbers";
    public static final String EL_CHANGESET_LINK = "changeset-link";
    public static final String EL_COMPONENT_LINK = "component-link";
    public static final String EL_PROCESS_AREA_LINK = "process-area-link";
    public static final String ATTR_PROCESS_AREA_UUID = "process-area-uuid";
    public static final String ATTR_PROCESS_AREA_TYPE = "process-area-type";
    public static final String VAL_PROCESS_AREA_TYPE_TEAM = "team";
    public static final String VAL_PROCESS_AREA_TYPE_PROJECT = "project";
    public static final String EL_WORKSPACE_LINK = "workspace-link";
    public static final String ATTR_WORKSPACE_UUID = "workspace-uuid";
    public static final String EL_CONTRIBUTOR_LINK = "contrib-link";
    public static final String EL_MONOSPACE = "mono";

    public static Element makeList(Document doc, ListType t) {
        Element list = doc.createElement(EL_LIST);
        list.setAttribute(ATTR_TYPE, t.getType());
        return list;
    }

    public static Element makeMono(Document doc, String s) {
        Element mono = doc.createElement(EL_MONOSPACE);
        mono.setTextContent(s);
        return mono;
    }

    public static void appendToList(Document doc, Element list, Element itemContent) {
        Element item = doc.createElement(EL_LIST_ITEM);
        item.appendChild(itemContent);
        list.appendChild(item);
    }

    public static Element makeDescAndAppend(Document doc) {
        Element el = doc.createElement(EL_DESCRIPTION);
        doc.appendChild(el);
        return el;
    }

    public static Element makeParaAndAppend(Document doc, Element parent) {
        Element el = doc.createElement(EL_PARAGRAPH);
        parent.appendChild(el);
        return el;
    }

    public static Element makeChangeSetLink(Document doc, String linkText, UUID repoUuid, IContextHandle ctx, IComponentHandle comp, IChangeSetHandle ... csHandles) {
        if (csHandles == null) {
            throw new IllegalArgumentException("null handles");
        }
        if (csHandles.length == 0) {
            throw new IllegalArgumentException("no cses");
        }
        Element link = doc.createElement(EL_CHANGESET_LINK);
        link.setAttribute(ATTR_REPO, repoUuid.getUuidValue());
        if (comp != null) {
            link.setAttribute(ATTR_COMPONENT_UUID, comp.getItemId().getUuidValue());
        }
        if (ctx != null) {
            link.setAttribute(ATTR_CONTEXT_UUID, ctx.getItemId().getUuidValue());
            if (ctx instanceof IWorkspaceHandle) {
                link.setAttribute(ATTR_CONTEXT_TYPE, VAL_CONTEXT_TYPE_WORKSPACE);
            } else {
                link.setAttribute(ATTR_CONTEXT_TYPE, VAL_CONTEXT_TYPE_BASELINE);
            }
        }
        link.setAttribute(ATTR_UUIDS, UnifiedProcessDescriptionUtil.joinUuids((IItemHandle[])csHandles));
        link.setTextContent(linkText);
        return link;
    }

    public static Element makeComponentLink(Document doc, String linkText, UUID repoUuid, IComponentHandle comp, String componentName, IContextHandle ctx) {
        UUID ctxUuid = null;
        String ctxType = null;
        if (ctx != null) {
            ctxUuid = ctx.getItemId();
            ctxType = ctx instanceof IWorkspaceHandle ? VAL_CONTEXT_TYPE_WORKSPACE : VAL_CONTEXT_TYPE_BASELINE;
        }
        return AdvisorDetailConstants.makeComponentLink(doc, linkText, repoUuid, comp.getItemId(), componentName, ctxUuid, ctxType);
    }

    public static Element makeComponentLink(Document doc, String linkText, UUID repoUuid, UUID compUuid, String componentName, UUID ctxUuid, String ctxType) {
        Element link = doc.createElement(EL_COMPONENT_LINK);
        link.setAttribute(ATTR_REPO, repoUuid.getUuidValue());
        link.setAttribute(ATTR_COMPONENT_UUID, compUuid.getUuidValue());
        link.setAttribute(ATTR_NAME, componentName);
        if (ctxUuid != null) {
            link.setAttribute(ATTR_CONTEXT_UUID, ctxUuid.getUuidValue());
            link.setAttribute(ATTR_CONTEXT_TYPE, ctxType);
        }
        link.setTextContent(linkText);
        return link;
    }

    public static Element makeWorkspaceLink(Document doc, String linkText, UUID repoUuid, UUID wsUuid, String workspaceName) {
        Element link = doc.createElement(EL_WORKSPACE_LINK);
        link.setAttribute(ATTR_REPO, repoUuid.getUuidValue());
        link.setAttribute(ATTR_WORKSPACE_UUID, wsUuid.getUuidValue());
        link.setAttribute(ATTR_NAME, workspaceName);
        link.setTextContent(linkText);
        return link;
    }

    public static Element makeProcessAreaLink(Document doc, String linkText, UUID repoUuid, IProcessAreaHandle paHandle, String paName) {
        Element link = doc.createElement(EL_PROCESS_AREA_LINK);
        link.setAttribute(ATTR_REPO, repoUuid.getUuidValue());
        link.setAttribute(ATTR_PROCESS_AREA_UUID, paHandle.getItemId().getUuidValue());
        link.setAttribute(ATTR_NAME, paName);
        if (paHandle instanceof ITeamAreaHandle) {
            link.setAttribute(ATTR_PROCESS_AREA_TYPE, VAL_PROCESS_AREA_TYPE_TEAM);
        } else if (paHandle instanceof IProjectAreaHandle) {
            link.setAttribute(ATTR_PROCESS_AREA_TYPE, VAL_PROCESS_AREA_TYPE_PROJECT);
        }
        link.setTextContent(linkText);
        return link;
    }

    public static Element makeVersionableLink(Document doc, UUID repoUuid, IContextHandle ctx, IComponentHandle comp, String name, IVersionableHandle handle, String type) {
        return AdvisorDetailConstants.makeVersionableLink(doc, repoUuid, ctx, comp, name, handle, type, false);
    }

    public static Element makeVersionableLink(Document doc, UUID repoUuid, IContextHandle ctx, IComponentHandle comp, String name, IVersionableHandle handle, String type, boolean requestOverwrite) {
        Element link = doc.createElement(EL_VERSIONABLE_LINK);
        link.setTextContent(name);
        link.setAttribute(ATTR_REPO, repoUuid.getUuidValue());
        link.setAttribute(ATTR_UUID, handle.getItemId().getUuidValue());
        if (handle.getStateId() != null) {
            link.setAttribute(ATTR_STATE, handle.getStateId().getUuidValue());
        }
        if (type == null) {
            if (handle instanceof IItemHandle) {
                IVersionableHandle itemHandle = handle;
                IItemType itemType = itemHandle.getItemType();
                String eUri = itemType.getNamespaceURI();
                String eName = itemType.getName();
                link.setAttribute(ATTR_ETYPE, String.valueOf(eUri) + " " + eName);
            }
        } else {
            link.setAttribute(ATTR_TYPE, type);
        }
        if (ctx != null) {
            if (ctx instanceof IBaselineHandle) {
                link.setAttribute(ATTR_CONTEXT_TYPE, VAL_CONTEXT_TYPE_BASELINE);
            } else if (ctx instanceof IWorkspaceHandle) {
                link.setAttribute(ATTR_CONTEXT_TYPE, VAL_CONTEXT_TYPE_WORKSPACE);
            }
            link.setAttribute(ATTR_CONTEXT_UUID, ctx.getItemId().getUuidValue());
        }
        link.setAttribute(ATTR_COMPONENT_UUID, comp.getItemId().getUuidValue());
        if (requestOverwrite) {
            link.setAttribute(ATTR_MAKE_CONTENT, "local-name");
        }
        return link;
    }

    public static Element makeContributorLink(Document doc, UUID repoUuid, String linkText, UUID contribId) {
        Element link = doc.createElement(EL_CONTRIBUTOR_LINK);
        link.setTextContent(linkText);
        link.setAttribute(ATTR_REPO, repoUuid.getUuidValue());
        link.setAttribute(ATTR_UUID, contribId.getUuidValue());
        return link;
    }

    public static Element makeEm(Document doc, String string) {
        Element mono = doc.createElement(EL_EMPHASIZE);
        mono.setTextContent(string);
        return mono;
    }

    public static enum ListType {
        NUMBERS("numbers"),
        BULLETS("bullets");

        private final String type;

        private ListType(String t) {
            this.type = t;
        }

        protected String getType() {
            return this.type;
        }
    }
}

