/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IManagedItem;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.model.ManagedItemHandle;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.Baseline;
import com.ibm.team.scm.common.internal.Change;
import com.ibm.team.scm.common.internal.ChangeHistory;
import com.ibm.team.scm.common.internal.ChangeHistoryEntry;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.ChangeSet;
import com.ibm.team.scm.common.internal.ChangeSetHandle;
import com.ibm.team.scm.common.internal.Component;
import com.ibm.team.scm.common.internal.ComponentEntry;
import com.ibm.team.scm.common.internal.ComponentEntryHandle;
import com.ibm.team.scm.common.internal.ConfigurationHandle;
import com.ibm.team.scm.common.internal.Conflict;
import com.ibm.team.scm.common.internal.MergeState;
import com.ibm.team.scm.common.internal.ScmFactory;
import com.ibm.team.scm.common.internal.ScmPackage;
import com.ibm.team.scm.common.internal.StateSelection;
import com.ibm.team.scm.common.internal.Workspace;
import com.ibm.team.scm.common.providers.InTransactionItemProvider;
import com.ibm.team.scm.common.providers.ItemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EClass;

public class ChangeHistoryValidator {
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    private static final boolean DO_DEBUG = false;

    private ChangeHistoryValidator() {
    }

    public static String validateWorkspace(ItemProvider provider, Workspace workspace, String owner, boolean ignnoreKnownErrors, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName("Validating workspace " + workspace.getName());
        int ticks = 1000;
        monitor.beginTask("", ticks);
        StringBuilder errors = new StringBuilder();
        Collection<ComponentEntry> components = provider.fetchComponentEntriesFor(workspace, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        ticks -= 100;
        int numComponents = components.size();
        if (numComponents == 0) {
            return errors.toString();
        }
        Iterator<ComponentEntry> it = components.iterator();
        int i = 0;
        while (i < numComponents) {
            int work = ticks - 1000 + 1000 * (i + 1) / numComponents;
            ticks -= work;
            int subWork = work / 10;
            ComponentEntry e = it.next();
            IComponent component = (IComponent)ChangeHistoryValidator.fetchItem((IManagedItemHandle)e.getComponent(), provider, (IProgressMonitor)new SubProgressMonitor(monitor, subWork));
            ChangeHistoryValidator.validateHistory(provider, workspace, component, e, owner, ignnoreKnownErrors, errors, (IProgressMonitor)new SubProgressMonitor(monitor, work - subWork));
            ++i;
        }
        monitor.done();
        return errors.toString();
    }

    public static String validateHistory(ItemProvider provider, Workspace workspace, IComponent component, String owner, boolean ignoreKnownErrors, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        StringBuilder errors = new StringBuilder();
        ChangeHistoryValidator.validateHistory(provider, workspace, component, owner, ignoreKnownErrors, errors, monitor);
        return errors.toString();
    }

    public static void validateHistory(ItemProvider provider, ChangeHistoryHandle history, boolean ignoreKnownErrors, StringBuilder errors, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 100);
        ChangeHistory ch = (ChangeHistory)ChangeHistoryValidator.fetchItem((IManagedItemHandle)history, provider, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IComponent component = (IComponent)ChangeHistoryValidator.fetchItem((IManagedItemHandle)ch.getComponent(), provider, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ChangeHistoryValidator.validateAllChangeHistories(provider, ch, component, Collections.EMPTY_LIST, ignoreKnownErrors, errors, (IProgressMonitor)new SubProgressMonitor(monitor, 98));
        monitor.done();
    }

    public static void validateHistory(ItemProvider provider, Workspace workspace, IComponent component, String owner, boolean ignoreKnownErrors, StringBuilder errors, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<ComponentEntry> entries = provider.fetchComponentEntriesFor(workspace, (IProgressMonitor)progress.newChild(5));
        ComponentEntry entry = null;
        for (ComponentEntry e : entries) {
            if (!e.getComponent().sameItemId((IItemHandle)component)) continue;
            entry = e;
        }
        entries = null;
        if (entry == null) {
            errors.append("The workspace " + workspace.getName() + " does not contain entry for component " + component.getName() + "\n");
        } else {
            ChangeHistoryValidator.validateHistory(provider, workspace, component, entry, owner, ignoreKnownErrors, errors, (IProgressMonitor)progress.newChild(95));
        }
        progress.done();
    }

    public static void validateHistory(ItemProvider provider, Workspace workspace, IComponent component, ComponentEntry entry, String owner, boolean ignoreKnownErrors, StringBuilder errors, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (entry == null || !entry.getComponent().sameItemId((IItemHandle)component) || !entry.getWorkspace().sameItemId((IItemHandle)workspace)) {
            throw new IllegalArgumentException();
        }
        monitor.beginTask("", 100);
        monitor.setTaskName("Validating change history for " + workspace.getName() + " (" + owner + ") - " + component.getName());
        workspace = (Workspace)ChangeHistoryValidator.fetchItem(workspace, provider, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (workspace.isStream() && !entry.getConflicts().isEmpty()) {
            errors.append("The workspace " + workspace.getName() + " is a stream, but contains conflicts\n");
        }
        ChangeHistoryHandle hist = entry.getChangehistory();
        ChangeHistory ch = (ChangeHistory)ChangeHistoryValidator.fetchItem((IManagedItemHandle)hist, provider, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (workspace.isStream() && ch.getActiveCount() != 0) {
            errors.append("The workspace " + workspace.getName() + " is a stream but contains active change sets for component " + component.getName() + "\n");
        }
        if (provider.getConfiguration(ch, (IProgressMonitor)new SubProgressMonitor(monitor, 1)) == null) {
            errors.append("The workspace " + workspace.getName() + " does not have a cached configuration\n");
        }
        ChangeHistoryValidator.validateAllChangeHistories(provider, ch, component, entry.getConflicts(), ignoreKnownErrors, errors, (IProgressMonitor)new SubProgressMonitor(monitor, 97));
        monitor.done();
    }

    public static void validateEraStructure(ItemProvider provider, Workspace workspace, IComponent component, String owner, StringBuilder errors, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName("Validating era structure for " + workspace.getName() + " (" + owner + ") - " + component.getName());
        monitor.beginTask("", 100);
        Collection<ComponentEntry> entries = provider.fetchComponentEntriesFor(workspace, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
        ComponentEntry entry = null;
        for (ComponentEntry e : entries) {
            if (!e.getComponent().sameItemId((IItemHandle)component)) continue;
            entry = e;
        }
        if (entry == null) {
            errors.append("The workspace " + workspace.getName() + " does not contain entry for component " + component.getName() + "\n");
        } else {
            ChangeHistoryHandle hist = entry.getChangehistory();
            ChangeHistory ch = (ChangeHistory)ChangeHistoryValidator.fetchItem((IManagedItemHandle)hist, provider, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (provider.getConfiguration(ch, (IProgressMonitor)new SubProgressMonitor(monitor, 1)) == null) {
                errors.append("The workspace " + workspace.getName() + " does not have a cached configuration\n");
            }
            ChangeHistoryValidator.validateEras(provider, ch, component, errors, (IProgressMonitor)new SubProgressMonitor(monitor, 98));
        }
        monitor.done();
    }

    private static List<IManagedItem> fetchItems(List<? extends IManagedItemHandle> items, ItemProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        int increment = provider.maxItemsPerRequest();
        if (increment >= items.size()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            return provider.fetchItems(items, monitor);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)items.size());
        ArrayList<IManagedItem> result = new ArrayList<IManagedItem>(items.size());
        int i = 0;
        while (i < items.size()) {
            int size = Math.min(items.size() - i, increment);
            List<? extends IManagedItemHandle> subList = items.subList(i, i + size);
            i += size;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            List<IManagedItem> part = provider.fetchItems(subList, (IProgressMonitor)progress.newChild(size));
            result.addAll(part);
        }
        return result;
    }

    private static IManagedItem fetchItem(IManagedItemHandle item, ItemProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        return ChangeHistoryValidator.fetchItems(Collections.singletonList(item), provider, monitor).get(0);
    }

    private static Map<UUID, Conflict> getConflictMap(Collection<Conflict> conflicts) {
        HashMap<UUID, Conflict> result = new HashMap<UUID, Conflict>((int)((double)conflicts.size() / 0.75));
        for (Conflict c : conflicts) {
            result.put(c.getVersionable().getItemId(), c);
        }
        return result;
    }

    private static void validateAllChangeHistories(ItemProvider provider, ChangeHistory hist, IComponent component, Collection<Conflict> allConflicts, boolean ignoreKnownErrors, StringBuilder errors, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 100);
        ArrayList<ChangeHistory> changeHistories = new ArrayList<ChangeHistory>();
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>(allConflicts);
        Set<UUID> statesInConflict = ChangeHistoryValidator.getStatesInConflict(conflicts);
        SubProgressMonitor subProgress = new SubProgressMonitor(monitor, 10);
        int ticks = 1000;
        subProgress.beginTask("", ticks);
        while (true) {
            changeHistories.add(hist);
            if (hist.getPrevious() == null) break;
            ChangeHistoryHandle ch = hist.getPrevious();
            int work = ticks / 3;
            ticks -= work;
            hist = (ChangeHistory)ChangeHistoryValidator.fetchItem((IManagedItemHandle)ch, provider, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgress, work));
        }
        subProgress.done();
        subProgress = new SubProgressMonitor(monitor, 90);
        ticks = 1000;
        subProgress.beginTask("", ticks);
        HashMap<UUID, IChange> activeChanges = new HashMap<UUID, IChange>();
        Map<UUID, ItemProvider.VRecord> stateCache = Collections.EMPTY_MAP;
        HashMap<UUID, Set<UUID>> latestStates = new HashMap<UUID, Set<UUID>>();
        HashSet<UUID> unresolvedItems = new HashSet<UUID>();
        HashMap<UUID, UUID> finalStates = new HashMap<UUID, UUID>();
        HashMap<UUID, IVersionableHandle> items = new HashMap<UUID, IVersionableHandle>();
        HashSet<UUID> resolvedStates = new HashSet<UUID>();
        Map<UUID, Conflict> conflictMap = ChangeHistoryValidator.getConflictMap(conflicts);
        HashSet<UUID> ambiguous = new HashSet<UUID>();
        int eraNum = changeHistories.size() - 1;
        while (eraNum >= 0) {
            int work = 1000 * (changeHistories.size() - eraNum) / changeHistories.size() - 1000 + ticks;
            SubProgressMonitor subSubProgress = new SubProgressMonitor((IProgressMonitor)subProgress, work);
            ticks -= work;
            int subTicks = 100;
            subSubProgress.beginTask("", subTicks);
            ChangeHistory ch = (ChangeHistory)changeHistories.get(eraNum);
            List recent = ch.getRecentEntries();
            ArrayList<IChangeSetHandle> toFetch = new ArrayList<IChangeSetHandle>(recent.size());
            HashSet<UUID> forThisEra = new HashSet<UUID>(recent.size() * 4 / 3);
            for (ChangeHistoryEntry entry : recent) {
                IChangeSetHandle iChangeSetHandle = entry.getChangeSet();
                toFetch.add(iChangeSetHandle);
                if (forThisEra.add(iChangeSetHandle.getItemId())) continue;
                errors.append("era #" + eraNum + " contains multiple references to change set " + iChangeSetHandle.getItemId().getUuidValue() + "\n");
            }
            if (eraNum != 0 && ch.getActiveCount() != 0) {
                errors.append("era #" + eraNum + " claims to contain " + ch.getActiveCount() + " active changesets but isn't live\n");
            }
            if (eraNum == 0 && ch.getCachedAllPrevious().isEmpty()) {
                errors.append("era #" + eraNum + " is live but has no cached previous list\n");
            }
            if (!ch.getComponent().sameItemId((IItemHandle)component)) {
                work = subTicks / 20;
                IComponent otherComponent = (IComponent)ChangeHistoryValidator.fetchItem((IManagedItemHandle)ch.getComponent(), provider, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subSubProgress, work));
                subTicks -= work;
                String name = otherComponent == null ? ch.getComponent().getItemId().getUuidValue() : String.valueOf(otherComponent.getName()) + " (" + otherComponent.getItemId().getUuidValue() + ")";
                errors.append("era #" + eraNum + " is from component " + name + " which doesn't match the current component " + component.getName() + " (" + component.getItemId().getUuidValue() + ")\n");
            }
            if (!ch.getCachedAllPrevious().isEmpty()) {
                if (eraNum != 0) {
                    errors.append("era #" + eraNum + " has cached previous list but isn't live\n");
                }
                if (ch.getCachedAllPrevious().size() != changeHistories.size() - eraNum) {
                    errors.append("era #" + eraNum + " has " + ch.getCachedAllPrevious().size() + " cached previous handles but should have " + (changeHistories.size() - eraNum) + "\n");
                }
                int i = eraNum;
                for (ChangeHistoryHandle h : ch.getCachedAllPrevious()) {
                    if (i < changeHistories.size()) {
                        ChangeHistory correspondingHistory = (ChangeHistory)changeHistories.get(i);
                        if (!correspondingHistory.sameItemId((IItemHandle)h)) {
                            errors.append("era #" + eraNum + " has " + h.getItemId().getUuidValue() + " cached previous at position " + (i - eraNum) + " but should have " + correspondingHistory.getItemId().getUuidValue() + "\n");
                        }
                    } else {
                        errors.append("era #" + eraNum + " has " + h.getItemId().getUuidValue() + " cached previous at position " + (i - eraNum) + " but has no corresponding position in actual change history\n");
                    }
                    ++i;
                }
            }
            work = subTicks * 3 / 10;
            List<IManagedItem> recentCS = ChangeHistoryValidator.fetchItems(toFetch, provider, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subSubProgress, work));
            subTicks -= work;
            toFetch = null;
            int numActive = 0;
            for (IChangeSet iChangeSet : recentCS) {
                if (iChangeSet.isActive()) {
                    ++numActive;
                    if (eraNum != 0) {
                        errors.append("The change set " + iChangeSet.getItemId().getUuidValue() + " is active in era #" + eraNum + " which isn't live\n");
                    }
                } else if (numActive != 0) {
                    errors.append("The change set " + iChangeSet.getItemId().getUuidValue() + " is closed in era #" + eraNum + " but is preceded by active change sets\n");
                }
                if (!iChangeSet.getComponent().sameItemId((IItemHandle)component)) {
                    work = subTicks / 20;
                    IComponent iComponent = (IComponent)ChangeHistoryValidator.fetchItem((IManagedItemHandle)iChangeSet.getComponent(), provider, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subSubProgress, work));
                    subTicks -= work;
                    String name = iComponent == null ? iChangeSet.getComponent().getItemId().getUuidValue() : String.valueOf(iComponent.getName()) + " (" + iComponent.getItemId().getUuidValue() + ")";
                    errors.append("The change set " + iChangeSet.getItemId().getUuidValue() + " in era #" + eraNum + " is in component " + component.getName() + " (" + component.getItemId().getUuidValue() + ") but claims to be in " + name + "\n");
                }
                HashSet<UUID> hashSet = new HashSet<UUID>();
                for (IChange chg : iChangeSet.changes()) {
                    HashSet<UUID> latest;
                    items.put(chg.item().getItemId(), chg.item());
                    statesInConflict.remove(chg.item().getItemId());
                    if (!hashSet.add(chg.item().getItemId())) {
                        errors.append("The " + chg.item().getItemType().getName() + " " + chg.item().getItemId().getUuidValue() + " is modified in more than 1 change in change set " + iChangeSet.getItemId().getUuidValue() + " in era #" + eraNum + "\n");
                    }
                    if (iChangeSet.isActive() && activeChanges.put(chg.item().getItemId(), chg) != null) {
                        errors.append("The " + chg.item().getItemType().getName() + " " + chg.item().getItemId().getUuidValue() + " is modified in multiple active change sets\n");
                    }
                    if ((latest = (HashSet<UUID>)latestStates.get(chg.item().getItemId())) == null) {
                        latest = new HashSet<UUID>();
                        latestStates.put(chg.item().getItemId(), latest);
                    }
                    UUID before = ChangeHistoryValidator.getState(chg.beforeState(), chg.item());
                    if (chg.beforeState() != null && !resolvedStates.contains(before)) {
                        errors.append("Gap detected: before state " + before.getUuidValue() + " of " + chg.item().getItemType().getName() + " " + chg.item().getItemId().getUuidValue() + " in change set " + iChangeSet.getItemId().getUuidValue() + " in era #" + eraNum + " does not appear as an after state in any previous change set\n");
                    }
                    latest.remove(before);
                    for (IVersionableHandle h : chg.mergeStates()) {
                        before = ChangeHistoryValidator.getState(h, chg.item());
                        if (h != null && !resolvedStates.contains(before)) {
                            errors.append("Gap detected: merge state " + before.getUuidValue() + " of " + chg.item().getItemType().getName() + " " + chg.item().getItemId().getUuidValue() + " in changeset " + iChangeSet.getItemId().getUuidValue() + " in era #" + eraNum + " does not appear as an after state in any previous change set\n");
                        }
                        latest.remove(before);
                    }
                    if (!latest.isEmpty() && iChangeSet.isActive()) {
                        ambiguous.add(chg.item().getItemId());
                        Conflict c = conflictMap.get(chg.item().getItemId());
                        HashSet<UUID> unresolved = null;
                        if (c == null) {
                            unresolved = latest;
                        } else {
                            UUID proposed;
                            unresolved = new HashSet(latest);
                            UUID selected = ChangeHistoryValidator.getState(c.getSelectedContributorStateId(), c.getVersionable());
                            if (selected.equals((Object)(proposed = ChangeHistoryValidator.getState(ChangeHistoryValidator.getProposed(c, chg, null), c.getVersionable())))) {
                                unresolved.remove(selected);
                            } else {
                                UUID after = ChangeHistoryValidator.getState(chg.afterState(), chg.item());
                                if (!after.equals((Object)selected)) {
                                    unresolved.remove(selected);
                                }
                                if (!after.equals((Object)proposed)) {
                                    unresolved.remove(proposed);
                                }
                            }
                            if (unresolved.isEmpty()) {
                                unresolved = null;
                            }
                        }
                        if (unresolved != null) {
                            IVersionableHandle item = chg.item();
                            errors.append("The " + item.getItemType().getName() + " " + item.getItemId().getUuidValue() + " is not resolved due to active changes in era #" + eraNum + " (Unresolved states: ");
                            boolean first = true;
                            for (UUID id : unresolved) {
                                if (!first) {
                                    errors.append(", ");
                                }
                                errors.append(id.equals((Object)item.getItemId()) ? "null" : id.getUuidValue());
                                first = false;
                            }
                            errors.append(")\n");
                        }
                    }
                    UUID after = ChangeHistoryValidator.getState(chg.afterState(), chg.item());
                    resolvedStates.add(after);
                    statesInConflict.remove(after);
                    latest.add(after);
                    if (latest.size() != 1) {
                        finalStates.put(chg.item().getItemId(), after);
                        unresolvedItems.add(chg.item().getItemId());
                        continue;
                    }
                    unresolvedItems.remove(chg.item().getItemId());
                }
            }
            if (ch.getActiveCount() != numActive) {
                errors.append("era #" + eraNum + " claims to contain " + ch.getActiveCount() + " active change sets but actually contains " + numActive + "\n");
            }
            if (eraNum == 0) {
                for (Conflict conflict : conflicts) {
                    IVersionableHandle iVersionableHandle = conflict.getVersionable();
                    UUID itemId = iVersionableHandle.getItemId();
                    UUID trueProposed = ChangeHistoryValidator.getState(ChangeHistoryValidator.getProposed(conflict, (IChange)activeChanges.get(itemId), errors), iVersionableHandle);
                    UUID selected = ChangeHistoryValidator.getState(conflict.getSelectedContributorStateId(), iVersionableHandle);
                    HashSet<UUID> latest = (HashSet<UUID>)latestStates.get(itemId);
                    if (latest == null) {
                        latest = new HashSet<UUID>();
                        latestStates.put(itemId, latest);
                    }
                    if (selected.equals((Object)trueProposed)) {
                        if (!ambiguous.contains(itemId)) {
                            errors.append(" The " + iVersionableHandle.getItemType().getName() + " " + iVersionableHandle.getItemId().getUuidValue() + " is not conflicted, but is marked as " + (conflict.isIncidental() ? "incidentally" : "truely") + " conflicted.\n");
                        }
                    } else if (!(ambiguous.contains(itemId) || unresolvedItems.contains(itemId) || latest.contains(trueProposed))) {
                        errors.append(" The " + iVersionableHandle.getItemType().getName() + " " + iVersionableHandle.getItemId().getUuidValue() + " is not conflicted, but is marked as " + (conflict.isIncidental() ? "incidentally" : "truely") + " conflicted.\n");
                    }
                    if (conflict.isIncidental()) {
                        if (unresolvedItems.contains(itemId) || ambiguous.contains(itemId)) {
                            errors.append(" The " + iVersionableHandle.getItemType().getName() + " " + iVersionableHandle.getItemId().getUuidValue() + " is truely conflicted, but is marked as incidentally conflicted.\n");
                        }
                    } else if (!unresolvedItems.contains(itemId) && !ambiguous.contains(itemId) && latest.contains(trueProposed)) {
                        errors.append(" The " + iVersionableHandle.getItemType().getName() + " " + iVersionableHandle.getItemId().getUuidValue() + " is incidentally conflicted, but is marked as truely conflicted.\n");
                    }
                    items.put(itemId, iVersionableHandle);
                    latest.remove(trueProposed);
                    latest.add(selected);
                    if (latest.size() != 1) {
                        finalStates.put(itemId, selected);
                        unresolvedItems.add(itemId);
                        continue;
                    }
                    unresolvedItems.remove(itemId);
                }
            }
            if (!unresolvedItems.isEmpty()) {
                ChangeHistoryValidator.processUnresolved(unresolvedItems, items, latestStates, eraNum, errors);
            }
            Map<UUID, ItemProvider.VRecord> map = stateCache;
            HashMap<UUID, IVersionableHandle> toFetchMap = new HashMap<UUID, IVersionableHandle>();
            stateCache = ChangeHistoryValidator.updateStateCacheWithCS(recentCS, map, toFetchMap);
            work = subTicks / 2;
            subTicks -= work;
            ChangeHistoryValidator.validateFinalStates(ch, eraNum, component, latestStates, finalStates, items, map, stateCache, toFetchMap, provider, errors, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subSubProgress, work));
            if (!toFetchMap.isEmpty()) {
                ChangeHistoryValidator.fetchStatesForCache(stateCache, toFetchMap, provider, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subSubProgress, subTicks));
                toFetchMap = null;
            }
            Object var31_35 = null;
            for (IChangeSet iChangeSet : recentCS) {
                ChangeHistoryValidator.validateChangeSet(iChangeSet, eraNum, component, stateCache, ignoreKnownErrors, errors);
            }
            subSubProgress.done();
            --eraNum;
        }
        subProgress.done();
        if (!statesInConflict.isEmpty()) {
            ChangeHistoryValidator.processStatesInConflict(statesInConflict, conflicts, activeChanges, errors);
        }
        monitor.done();
    }

    private static void validateEras(ItemProvider provider, ChangeHistory hist, IComponent component, StringBuilder errors, IProgressMonitor monitor) throws TeamRepositoryException {
        int work;
        monitor.beginTask("", 100);
        ArrayList<ChangeHistory> changeHistories = new ArrayList<ChangeHistory>();
        SubProgressMonitor subProgress = new SubProgressMonitor(monitor, 10);
        int ticks = 1000;
        subProgress.beginTask("", ticks);
        while (true) {
            changeHistories.add(hist);
            if (hist.getPrevious() == null) break;
            ChangeHistoryHandle ch = hist.getPrevious();
            work = ticks / 3;
            ticks -= work;
            hist = (ChangeHistory)ChangeHistoryValidator.fetchItem((IManagedItemHandle)ch, provider, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgress, work));
        }
        subProgress.done();
        subProgress = new SubProgressMonitor(monitor, 90);
        ticks = 1000;
        subProgress.beginTask("", ticks);
        int eraNum = changeHistories.size() - 1;
        while (eraNum >= 0) {
            work = 1000 * (changeHistories.size() - eraNum) / changeHistories.size() - 1000 + ticks;
            SubProgressMonitor subSubProgress = new SubProgressMonitor((IProgressMonitor)subProgress, work);
            ticks -= work;
            int subTicks = 100;
            subSubProgress.beginTask("", subTicks);
            ChangeHistory ch = (ChangeHistory)changeHistories.get(eraNum);
            List recent = ch.getRecentEntries();
            ArrayList<IChangeSetHandle> toFetch = new ArrayList<IChangeSetHandle>(recent.size());
            for (ChangeHistoryEntry entry : recent) {
                toFetch.add(entry.getChangeSet());
            }
            if (eraNum != 0 && ch.getActiveCount() != 0) {
                errors.append("era #" + eraNum + " claims to contain " + ch.getActiveCount() + " active change sets but isn't live\n");
            }
            if (eraNum == 0 && ch.getCachedAllPrevious().isEmpty()) {
                errors.append("era #" + eraNum + " is live but has no cached previous list\n");
            }
            if (!ch.getCachedAllPrevious().isEmpty()) {
                if (eraNum != 0) {
                    errors.append("era #" + eraNum + " has cached previous list but isn't live\n");
                }
                if (ch.getCachedAllPrevious().size() != changeHistories.size() - eraNum) {
                    errors.append("era #" + eraNum + " has " + ch.getCachedAllPrevious().size() + " cached previous handles but should have " + (changeHistories.size() - eraNum) + "\n");
                }
                int i = eraNum;
                for (ChangeHistoryHandle h : ch.getCachedAllPrevious()) {
                    if (i < changeHistories.size()) {
                        ChangeHistory correspondingHistory = (ChangeHistory)changeHistories.get(i);
                        if (!correspondingHistory.sameItemId((IItemHandle)h)) {
                            errors.append("era #" + eraNum + " has " + h.getItemId().getUuidValue() + " cached previous at position " + (i - eraNum) + " but should have " + correspondingHistory.getItemId().getUuidValue() + "\n");
                        }
                    } else {
                        errors.append("era #" + eraNum + " has " + h.getItemId().getUuidValue() + " cached previous at position " + (i - eraNum) + " but has no corresponding position in actual change history\n");
                    }
                    ++i;
                }
            }
            subSubProgress.done();
            --eraNum;
        }
        monitor.done();
    }

    public static void validateChangeSet(IChangeSet cs, IComponent component, StringBuilder errors, ItemProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        Map<UUID, ItemProvider.VRecord> cache = new HashMap<UUID, ItemProvider.VRecord>();
        HashMap<UUID, IVersionableHandle> toFetch = new HashMap<UUID, IVersionableHandle>();
        cache = ChangeHistoryValidator.updateStateCacheWithCS(Collections.singletonList(cs), cache, toFetch);
        ChangeHistoryValidator.fetchStatesForCache(cache, toFetch, provider, monitor);
        ChangeHistoryValidator.validateChangeSet(cs, 0, component, cache, false, errors);
    }

    private static void validateChangeSet(IChangeSet cs, int eraNum, IComponent component, Map<UUID, ItemProvider.VRecord> cache, boolean ignoreKnownErrors, StringBuilder errors) throws TeamRepositoryException {
        UUID itemId;
        if (cs.getAuthor() == null) {
            errors.append("The change set " + cs.getItemId().getUuidValue() + " has a null author in era #" + eraNum + "\n");
        }
        IFolderHandle rootFolder = component.getRootFolder();
        HashSet<UUID> deleted = new HashSet<UUID>();
        HashMap<UUID, UUID> newParents = new HashMap<UUID, UUID>();
        HashMap<UUID, HashSet<String>> oldMappings = new HashMap<UUID, HashSet<String>>();
        HashMap<UUID, HashSet<String>> newMappings = new HashMap<UUID, HashSet<String>>();
        HashMap<UUID, IVersionableHandle> handleMap = new HashMap<UUID, IVersionableHandle>();
        Iterator iterator = cs.changes().iterator();
        while (iterator.hasNext()) {
            Set<String> children;
            ItemProvider.VRecord v;
            IVersionableHandle afterState;
            IChange chg;
            ChangeHistoryValidator.validateChange(cs, chg, (chg = (Change)iterator.next()).beforeState() == null ? null : chg.beforeState().getStateId(), chg.kind(), false, eraNum, errors);
            for (MergeState ms : chg.getMerges()) {
                ChangeHistoryValidator.validateChange(cs, chg, ms.getState(), ms.getKind(), true, eraNum, errors);
            }
            itemId = chg.item().getItemId();
            handleMap.put(itemId, chg.item());
            if (chg.afterState() == null) {
                deleted.add(itemId);
            } else if (!rootFolder.sameItemId((IItemHandle)chg.item())) {
                afterState = chg.afterState();
                v = cache.get(afterState.getStateId());
                newParents.put(itemId, v.parentId);
            }
            if (chg.beforeState() != null) {
                IVersionableHandle beforeState = chg.beforeState();
                v = cache.get(beforeState.getStateId());
                if (v.parentId != null) {
                    children = (HashSet<String>)oldMappings.get(v.parentId);
                    if (children == null) {
                        children = new HashSet<String>();
                        oldMappings.put(v.parentId, (HashSet<String>)children);
                    }
                    if (!children.add(v.name)) {
                        errors.append("The " + chg.item().getItemType().getName() + itemId + " has a before state whose parentage & name conflicts with another item's before state in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + "\n");
                    }
                }
            }
            if (chg.afterState() != null) {
                afterState = chg.afterState();
                v = cache.get(afterState.getStateId());
                if (v.parentId != null) {
                    children = (Set)newMappings.get(v.parentId);
                    if (children == null) {
                        children = new HashSet();
                        newMappings.put(v.parentId, (HashSet<String>)children);
                    }
                    if (!children.add(v.name)) {
                        errors.append("The " + chg.item().getItemType().getName() + itemId + " has an after state whose parentage & name conflicts with another item's after state in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + "\n");
                    }
                }
            }
            if (!rootFolder.sameItemId((IItemHandle)chg.item())) continue;
            if (chg.beforeState() != null && chg.afterState() == null) {
                errors.append("The root folder " + rootFolder.getItemId() + " is deleted in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + "\n");
                continue;
            }
            if (chg.beforeState() == null || chg.afterState() == null) continue;
            ItemProvider.VRecord before = cache.get(chg.beforeState().getStateId());
            ItemProvider.VRecord after = cache.get(chg.afterState().getStateId());
            if (before.parentId != null && after.parentId == null) {
                errors.append("The root folder " + rootFolder.getItemId() + " initially had a parent in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + "\n");
                continue;
            }
            if (before.parentId == null && after.parentId != null) {
                errors.append("The root folder " + rootFolder.getItemId() + " had a parent set in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + "\n");
                continue;
            }
            if (before.parentId == null || after.parentId == null) continue;
            errors.append("The root folder " + rootFolder.getItemId() + " has parents in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + "\n");
        }
        for (IChange chg : cs.changes()) {
            itemId = chg.item().getItemId();
            UUID newParent = (UUID)newParents.get(itemId);
            if (!deleted.contains(newParent)) continue;
            IVersionableHandle vh = (IVersionableHandle)handleMap.get(itemId);
            errors.append("The " + vh.getItemType().getName() + itemId + " has an after state with a parent deleted in this change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + "\n");
        }
    }

    private static void validateChange(IChangeSet cs, IChange chg, UUID beforeState, int kind, boolean isMerge, int eraNum, StringBuilder errors) {
        UUID afterState = chg.afterState() == null ? null : chg.afterState().getStateId();
        switch (kind) {
            case 1: {
                if (beforeState != null) {
                    errors.append("The " + (isMerge ? "merge state " + beforeState.getUuidValue() + " of " : "") + "change for " + chg.item().getItemType().getName() + " " + chg.item().getItemId().getUuidValue() + " in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + " is of type ADD but has before state " + beforeState.getUuidValue() + "\n");
                }
                if (afterState != null) break;
                errors.append("The " + (isMerge ? "merge state " + (beforeState == null ? "null" : beforeState.getUuidValue()) + " of " : "") + "change for " + chg.item().getItemType().getName() + " " + chg.item().getItemId().getUuidValue() + " in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + " is of type ADD but has null after state\n");
                break;
            }
            case 16: {
                if (afterState != null) {
                    errors.append("The " + (isMerge ? "merge state " + (beforeState == null ? "null" : beforeState.getUuidValue()) + " of " : "") + "change for " + chg.item().getItemType().getName() + " " + chg.item().getItemId().getUuidValue() + " in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + " is of type DELETE but has after state " + afterState.getUuidValue() + "\n");
                }
                if (beforeState != null) break;
                errors.append("The " + (isMerge ? "merge state null of " : "") + "change for " + chg.item().getItemType().getName() + " " + chg.item().getItemId().getUuidValue() + " in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + " is of type DELETE but has null before state\n");
                break;
            }
            case 0: {
                if (beforeState == null && afterState != null) {
                    errors.append("The " + (isMerge ? "merge state null of " : "") + "change for " + chg.item().getItemType().getName() + " " + chg.item().getItemId().getUuidValue() + " in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + " is of type NONE but has null before state and non-null after state\n");
                    break;
                }
                if (beforeState == null || beforeState.equals((Object)afterState)) break;
                errors.append("The " + (isMerge ? "merge state " + beforeState.getUuidValue() + " of " : "") + "change for " + chg.item().getItemType().getName() + " " + chg.item().getItemId().getUuidValue() + " in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + " is of type NONE but has non-equivalent before state " + beforeState.getUuidValue() + " and after state " + (afterState == null ? "null" : afterState.getUuidValue()) + "\n");
                break;
            }
            default: {
                if ((kind & 0xFFFFFFF1) == 0) {
                    if (beforeState == null) {
                        errors.append("The " + (isMerge ? "merge state null of " : "") + "change for " + chg.item().getItemType().getName() + " " + chg.item().getItemId().getUuidValue() + " in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + " is of type " + ChangeHistoryValidator.getKindStr(kind) + " but has null before state\n");
                    }
                    if (afterState != null) break;
                    errors.append("The " + (isMerge ? "merge state " + (beforeState == null ? "null" : beforeState.getUuidValue()) + " of " : "") + "change for " + chg.item().getItemType().getName() + " " + chg.item().getItemId().getUuidValue() + " in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + " is of type " + ChangeHistoryValidator.getKindStr(kind) + " but has null after state\n");
                    break;
                }
                errors.append("Unknown change type " + kind + " for " + (isMerge ? "merge state " + (beforeState == null ? "null" : beforeState.getUuidValue()) + " of " : "") + chg.item().getItemType().getName() + " " + chg.item().getItemId().getUuidValue() + " in change set " + cs.getItemId().getUuidValue() + " in era #" + eraNum + "\n");
            }
        }
    }

    private static String getKindStr(int kind) {
        switch (kind) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "ADD";
            }
            case 16: {
                return "DELETE";
            }
            case 2: {
                return "MODIFY";
            }
            case 4: {
                return "RENAME";
            }
            case 8: {
                return "REPARENT";
            }
            case 10: {
                return "MODIFY/REPARENT";
            }
            case 6: {
                return "MODIFY/RENAME";
            }
            case 14: {
                return "MODIFY/RENAME/REPARENT";
            }
            case 12: {
                return "RENAME/REPARENT";
            }
        }
        return "UNKNOWN";
    }

    private static Set<UUID> getStatesInConflict(Collection<Conflict> conflicts) {
        HashSet<UUID> statesInConflict = new HashSet<UUID>();
        for (Conflict conflict : conflicts) {
            statesInConflict.add(conflict.getVersionable().getItemId());
            if (conflict.getCommonAncestorStateId() != null) {
                statesInConflict.add(conflict.getCommonAncestorStateId());
            }
            if (conflict.getSelectedContributorStateId() != null) {
                statesInConflict.add(conflict.getSelectedContributorStateId());
            }
            if (conflict.getProposedContributorStateId() != null) {
                statesInConflict.add(conflict.getProposedContributorStateId());
            }
            if (conflict.getMergeStateId() == null) continue;
            statesInConflict.add(conflict.getMergeStateId());
        }
        return statesInConflict;
    }

    private static void processStatesInConflict(Set<UUID> unseenStates, Collection<Conflict> conflicts, Map<UUID, IChange> activeChanges, StringBuilder errors) {
        for (Conflict conflict : conflicts) {
            UUID proposed;
            if (unseenStates.contains(conflict.getVersionable().getItemId())) {
                errors.append("The " + conflict.getVersionable().getItemType().getName() + " " + conflict.getVersionable().getItemId().getUuidValue() + " has not been found in any change set\n");
            }
            if (conflict.getCommonAncestorStateId() != null && unseenStates.contains(conflict.getCommonAncestorStateId())) {
                errors.append("The common ancestor state (" + conflict.getCommonAncestorStateId().getUuidValue() + ") of " + conflict.getVersionable().getItemType().getName() + " " + conflict.getVersionable().getItemId().getUuidValue() + " has not been found in any change set\n");
            }
            if (conflict.getSelectedContributorStateId() != null && unseenStates.contains(conflict.getSelectedContributorStateId())) {
                errors.append("The selected state (" + conflict.getSelectedContributorStateId().getUuidValue() + ") of " + conflict.getVersionable().getItemType().getName() + " " + conflict.getVersionable().getItemId().getUuidValue() + " has not been found in any change set\n");
            }
            if ((proposed = ChangeHistoryValidator.getProposed(conflict, activeChanges.get(conflict.getVersionable().getItemId()), null)) == null || !unseenStates.contains(proposed)) continue;
            errors.append("The proposed merge state (" + proposed.getUuidValue() + ") of " + conflict.getVersionable().getItemType().getName() + " " + conflict.getVersionable().getItemId().getUuidValue() + " has not been found in any change set\n");
        }
    }

    private static void processUnresolved(Set<UUID> unresolvedItems, Map<UUID, IVersionableHandle> items, Map<UUID, Set<UUID>> selectedStates, int eraNum, StringBuilder errors) {
        for (UUID itemId : unresolvedItems) {
            IVersionableHandle item = items.get(itemId);
            errors.append("The " + item.getItemType().getName() + " " + item.getItemId().getUuidValue() + " is not resolved in era #" + eraNum + " (Proposed states: ");
            boolean first = true;
            for (UUID id : selectedStates.get(itemId)) {
                if (!first) {
                    errors.append(", ");
                }
                errors.append(id.equals((Object)itemId) ? "null" : id.getUuidValue());
                first = false;
            }
            errors.append(")\n");
        }
    }

    private static UUID getSelectedState(UUID id, Map<UUID, Set<UUID>> selectedStates, Map<UUID, UUID> finalStates) {
        Set<UUID> selected = selectedStates.get(id);
        if (selected == null) {
            return null;
        }
        if (selected.size() == 1) {
            UUID stateId = selected.iterator().next();
            return id.equals((Object)stateId) ? null : stateId;
        }
        if (selected.isEmpty()) {
            return null;
        }
        UUID stateId = finalStates.get(id);
        return stateId == null || stateId.equals((Object)id) ? null : stateId;
    }

    private static Map<UUID, ItemProvider.VRecord> updateStateCacheWithCS(List<IChangeSet> cs, Map<UUID, ItemProvider.VRecord> cache, Map<UUID, IVersionableHandle> toFetch) throws TeamRepositoryException {
        HashMap<UUID, ItemProvider.VRecord> stateCache = new HashMap<UUID, ItemProvider.VRecord>();
        for (IChangeSet c : cs) {
            for (IChange ch : c.changes()) {
                if (ch.beforeState() != null) {
                    ChangeHistoryValidator.addToCacheOrFetch(ch.beforeState(), stateCache, toFetch, cache);
                }
                if (ch.afterState() == null) continue;
                ChangeHistoryValidator.addToCacheOrFetch(ch.afterState(), stateCache, toFetch, cache);
            }
        }
        return stateCache;
    }

    private static void addToCacheOrFetch(IVersionableHandle h, Map<UUID, ItemProvider.VRecord> stateCache, Map<UUID, IVersionableHandle> toFetch, Map<UUID, ItemProvider.VRecord> cache) {
        ItemProvider.VRecord existing = cache.get(h.getStateId());
        if (existing != null) {
            stateCache.put(h.getStateId(), existing);
        } else {
            toFetch.put(h.getStateId(), h);
        }
    }

    private static ItemProvider.VRecord getCachedRecord(UUID stateId, Map<UUID, ItemProvider.VRecord> oldCache, Map<UUID, ItemProvider.VRecord> stateCache) {
        ItemProvider.VRecord existing = stateCache.get(stateId);
        if (existing != null) {
            return existing;
        }
        existing = oldCache.get(stateId);
        if (existing != null) {
            stateCache.put(stateId, existing);
        }
        return existing;
    }

    private static void validateFinalStates(ChangeHistory ch, int eraNum, IComponent component, Map<UUID, Set<UUID>> selectedStates, Map<UUID, UUID> finalStates, Map<UUID, IVersionableHandle> items, Map<UUID, ItemProvider.VRecord> oldCache, Map<UUID, ItemProvider.VRecord> stateCache, Map<UUID, IVersionableHandle> toFetchMap, ItemProvider provider, StringBuilder errors, IProgressMonitor monitor) throws TeamRepositoryException {
        Collection<UUID> kids;
        UUID parent;
        int ticks = 100;
        monitor.beginTask("", ticks);
        HashMap<UUID, UUID> stateSelections = new HashMap<UUID, UUID>();
        HashMap<UUID, UUID> parentMap = new HashMap<UUID, UUID>();
        HashMap kidsTable = new HashMap();
        HashMap<UUID, String> nameTable = new HashMap<UUID, String>();
        HashMap<UUID, IItemType> itemToItemType = new HashMap<UUID, IItemType>();
        ConfigurationHandle config = provider.getConfiguration(ch, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        --ticks;
        if (config != null) {
            HashSet<UUID> missingItems = new HashSet<UUID>(selectedStates.keySet());
            int work = ticks * 2 / 5;
            Iterator selections = provider.fetchStateSelections(config, (IProgressMonitor)new SubProgressMonitor(monitor, work));
            ticks -= work;
            Iterator<Object> iterator = selections.iterator();
            while (iterator.hasNext()) {
                StateSelection stateSelection = (StateSelection)iterator.next();
                itemToItemType.put(stateSelection.getItem().getItemId(), stateSelection.getItem().getItemType());
                if (stateSelection.getState() == null) continue;
                stateSelections.put(stateSelection.getItem().getItemId(), stateSelection.getState());
                parent = stateSelection.getParent();
                parentMap.put(stateSelection.getItem().getItemId(), parent);
                if (parent != null) {
                    kids = (Collection)kidsTable.get(parent);
                    if (kids == null) {
                        kids = new ArrayList();
                        kidsTable.put(parent, kids);
                    }
                    kids.add(stateSelection.getItem().getItemId());
                }
                nameTable.put(stateSelection.getItem().getItemId(), stateSelection.getName());
                Set<UUID> states = selectedStates.get(stateSelection.getItem().getItemId());
                if (states == null || !states.contains(stateSelection.getState())) {
                    if (states == null) {
                        items.put(stateSelection.getItem().getItemId(), stateSelection.getItem());
                    }
                    UUID correct = ChangeHistoryValidator.getSelectedState(stateSelection.getItem().getItemId(), selectedStates, finalStates);
                    errors.append("The state selection for " + stateSelection.getItem().getItemType().getName() + " " + stateSelection.getItem().getItemId().getUuidValue() + " in era #" + eraNum + " is " + stateSelection.getState().getUuidValue() + " but should be " + (correct == null ? "null" : correct.getUuidValue()) + "\n");
                }
                missingItems.remove(stateSelection.getItem().getItemId());
            }
            for (Map.Entry entry : kidsTable.entrySet()) {
                Collection kids2;
                UUID parentId = (UUID)entry.getKey();
                UUID parentState = (UUID)stateSelections.get(parentId);
                if (parentState != null || (kids2 = (Collection)entry.getValue()) == null) continue;
                for (Object kid : kids2) {
                    errors.append("The " + ((IItemType)itemToItemType.get(kid)).getName() + " " + kid.getUuidValue() + " is present in the configuration in era #" + eraNum + " but has a parent " + parentId + " that is not present in the configuration\n");
                }
            }
            for (UUID uUID : missingItems) {
                UUID selected = ChangeHistoryValidator.getSelectedState(uUID, selectedStates, finalStates);
                if (selected == null) continue;
                IVersionableHandle item = items.get(uUID);
                errors.append("The " + item.getItemType().getName() + " " + uUID.getUuidValue() + " is not present in the configuration in era #" + eraNum + " but change history produces " + selected.getUuidValue() + " as its state\n");
            }
        } else {
            ItemProvider.VRecord v;
            boolean mustFetch = false;
            for (UUID id : selectedStates.keySet()) {
                UUID uUID = ChangeHistoryValidator.getSelectedState(id, selectedStates, finalStates);
                if (uUID == null) continue;
                stateSelections.put(id, uUID);
                v = ChangeHistoryValidator.getCachedRecord(uUID, oldCache, stateCache);
                if (v != null) continue;
                IVersionableHandle stateHandle = (IVersionableHandle)items.get(id).getItemType().createItemHandle(id, uUID);
                toFetchMap.put(id, stateHandle);
                mustFetch = true;
            }
            if (mustFetch) {
                int work = ticks / 2;
                ticks -= work;
                ChangeHistoryValidator.fetchStatesForCache(stateCache, toFetchMap, provider, (IProgressMonitor)new SubProgressMonitor(monitor, work));
                toFetchMap.clear();
            }
            for (UUID id : selectedStates.keySet()) {
                UUID uUID = ChangeHistoryValidator.getSelectedState(id, selectedStates, finalStates);
                if (uUID == null) continue;
                v = stateCache.get(uUID);
                parent = v.parentId;
                parentMap.put(id, parent);
                if (parent != null) {
                    if (stateSelections.get(parent) == null) {
                        errors.append("The item " + id.getUuidValue() + " is present in the configuration in era #" + eraNum + " but has a parent " + parent + " that is not present in the configuration\n");
                    }
                    if ((kids = (ArrayList<UUID>)kidsTable.get(parent)) == null) {
                        kids = new ArrayList<UUID>();
                        kidsTable.put(parent, kids);
                    }
                    kids.add(id);
                }
                nameTable.put(id, v.name);
            }
        }
        ChangeHistoryValidator.checkForCycles(stateSelections, parentMap, component.getRootFolder().getItemId(), itemToItemType, errors, eraNum);
        if (stateSelections.get(component.getRootFolder().getItemId()) == null) {
            errors.append("The root folder " + component.getRootFolder().getItemId().getUuidValue() + " is not present in the configuration of era #" + eraNum + "\n");
        }
        ArrayList<IFolderHandle> folders = new ArrayList<IFolderHandle>();
        for (Map.Entry entry : stateSelections.entrySet()) {
            IVersionableHandle iVersionableHandle = items.get(entry.getKey());
            if (!(iVersionableHandle instanceof IFolderHandle)) continue;
            IFolderHandle folder = (IFolderHandle)iVersionableHandle.getItemType().createItemHandle((UUID)entry.getKey(), (UUID)entry.getValue());
            folders.add(folder);
        }
        HashMap<UUID, UUID> seenItems = new HashMap<UUID, UUID>();
        HashMap multipleReferences = new HashMap();
        for (IFolderHandle iFolderHandle : folders) {
            Collection kids3 = (Collection)kidsTable.get(iFolderHandle.getItemId());
            if (kids3 == null) continue;
            HashSet<String> childNames = new HashSet<String>(kids3.size());
            for (UUID childId : kids3) {
                String name = (String)nameTable.get(childId);
                if (name == null || name.equals("")) {
                    errors.append("The " + ((IItemType)itemToItemType.get(childId)).getName() + " " + childId.getUuidValue() + " is a child of " + iFolderHandle.getItemType().getName() + " " + iFolderHandle.getItemId().getUuidValue() + "but has no name in era #" + eraNum + "\n");
                }
                if (!childNames.add(name)) {
                    errors.append("The " + iFolderHandle.getItemType().getName() + " " + iFolderHandle.getItemId().getUuidValue() + " has multiple children with the name \"" + name + "\" in era #" + eraNum + "\n");
                }
                if (stateSelections.remove(childId) != null) {
                    seenItems.put(childId, iFolderHandle.getItemId());
                    if (!childId.equals((Object)component.getRootFolder().getItemId())) continue;
                    errors.append("The root folder " + childId.getUuidValue() + " is a child of " + iFolderHandle.getItemType().getName() + " " + iFolderHandle.getItemId().getUuidValue() + "in the configuration of era #" + eraNum + "\n");
                    continue;
                }
                UUID otherParent = (UUID)seenItems.get(childId);
                if (otherParent != null) {
                    ArrayList<UUID> parents = (ArrayList<UUID>)multipleReferences.get(childId);
                    if (parents == null) {
                        parents = new ArrayList<UUID>();
                        parents.add(otherParent);
                    }
                    parents.add(iFolderHandle.getItemId());
                    continue;
                }
                errors.append("The " + ((IItemType)itemToItemType.get(childId)).getName() + " " + childId.getUuidValue() + " is a child of " + iFolderHandle.getItemType().getName() + " " + iFolderHandle.getItemId().getUuidValue() + "but is missing from the configuration in era #" + eraNum + "\n");
            }
        }
        for (Map.Entry entry : multipleReferences.entrySet()) {
            IVersionableHandle child = items.get(entry.getKey());
            List parents = (List)entry.getValue();
            errors.append("The " + child.getItemType().getName() + " " + child.getItemId().getUuidValue() + " in era #" + eraNum + " is referenced " + parents.size() + " times in the configuration. Parents: ");
            boolean first = true;
            for (UUID id : parents) {
                if (!first) {
                    errors.append(", ");
                }
                errors.append(id.getUuidValue());
                first = false;
            }
            errors.append("\n");
        }
        for (UUID uUID : stateSelections.keySet()) {
            if (uUID.equals((Object)component.getRootFolder().getItemId())) continue;
            IVersionableHandle item = items.get(uUID);
            errors.append("The " + item.getItemType().getName() + " " + item.getItemId().getUuidValue() + " is orphaned in era #" + eraNum + "\n");
        }
        monitor.done();
    }

    private static void checkForCycles(Map<UUID, UUID> stateSelections, Map<UUID, UUID> parentMap, UUID rootFolderId, Map<UUID, IItemType> itemToItemType, StringBuilder errors, int eraNum) {
        HashSet itemsWhichLeadToRoot = new HashSet(stateSelections.size());
        block0: for (UUID id : stateSelections.keySet()) {
            UUID parent;
            if (id.equals((Object)rootFolderId) || itemsWhichLeadToRoot.contains(id)) continue;
            HashSet<UUID> routeToRoot = new HashSet<UUID>();
            routeToRoot.add(id);
            while ((parent = parentMap.get(id)) != null) {
                if (routeToRoot.contains(parent)) {
                    errors.append("The " + itemToItemType.get(id).getName() + " " + id + " is part of a cycle in era #" + eraNum + "\n");
                    continue block0;
                }
                routeToRoot.add(parent);
                if (parent.equals((Object)rootFolderId) || itemsWhichLeadToRoot.contains(parent)) {
                    itemsWhichLeadToRoot.addAll(routeToRoot);
                    continue block0;
                }
                id = parent;
            }
        }
    }

    private static void fetchStatesForCache(Map<UUID, ItemProvider.VRecord> stateCache, Map<UUID, IVersionableHandle> toFetchMap, ItemProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        if (toFetchMap.isEmpty()) {
            return;
        }
        int increment = provider.maxVersionablesPerRequest();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)toFetchMap.size());
        ArrayList<IVersionableHandle> handles = new ArrayList<IVersionableHandle>(toFetchMap.values());
        int i = 0;
        while (i < handles.size()) {
            int size = Math.min(handles.size() - i, increment);
            List subList = handles.subList(i, i + size);
            i += size;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            List<ItemProvider.VRecord> part = provider.fetchVersionables(subList, (IProgressMonitor)progress.newChild(size));
            for (ItemProvider.VRecord v : part) {
                stateCache.put(v.stateId, v);
            }
        }
    }

    private static UUID getState(IVersionableHandle state, IVersionableHandle item) {
        if (state == null) {
            return item.getItemId();
        }
        if (state.getStateId() == null) {
            throw new IllegalArgumentException("State must not have null stateid");
        }
        return state.getStateId();
    }

    private static UUID getState(UUID stateId, IVersionableHandle item) {
        if (stateId == null) {
            return item.getItemId();
        }
        return stateId;
    }

    public static String validateModifiedChangesets(InTransactionItemProvider provider) throws TeamRepositoryException {
        StringBuilder errors = new StringBuilder();
        ChangeHistoryValidator.validateModifiedChangesets(errors, provider);
        return errors.toString();
    }

    public static String validateModifiedNewChangeSet(InTransactionItemProvider itemProvider, IChangeSet changeSet) throws TeamRepositoryException {
        if (!changeSet.isNewItem() && !changeSet.isActive()) {
            throw new IllegalArgumentException();
        }
        StringBuilder errors = new StringBuilder();
        ChangeHistoryValidator.validateChangeSet(changeSet, (IComponent)itemProvider.fetchItem((IManagedItemHandle)changeSet.getComponent(), NULL_MONITOR), errors, itemProvider, NULL_MONITOR);
        Collection<IItemHandle> modifiedItemsForType = itemProvider.getModifiedItemsForType((IItemType)ItemUtil.itemTypeFor((EClass)ScmPackage.eINSTANCE.getChangeHistory()));
        ArrayList<ChangeHistoryHandle> arrayList = new ArrayList<ChangeHistoryHandle>();
        for (IItemHandle modified : modifiedItemsForType) {
            arrayList.add((ChangeHistoryHandle)modified);
        }
        List<IManagedItem> histories = itemProvider.fetchItems(arrayList, NULL_MONITOR);
        ArrayList<ChangeHistory> found = new ArrayList<ChangeHistory>(histories.size());
        block1: for (IManagedItem item : histories) {
            ChangeHistory history = (ChangeHistory)item;
            if (history.getActiveCount() <= 0) continue;
            List changeSetHandles = history.getRecentEntries();
            int total = changeSetHandles.size();
            int activeCount = history.getActiveCount();
            List subList = changeSetHandles.subList(total - activeCount, total);
            int i = 0;
            while (i < subList.size()) {
                ChangeHistoryEntry entry = (ChangeHistoryEntry)subList.get(i);
                ChangeSetHandle cs = (ChangeSetHandle)entry.getChangeSet();
                if (changeSet.sameItemId((IItemHandle)cs)) {
                    found.add(history);
                    continue block1;
                }
                ++i;
            }
        }
        if (found.size() == 0) {
            errors.append("New active change set " + changeSet.getItemId().getUuidValue() + " is not referenced from any modified change history.\n");
        } else if (found.size() > 1) {
            errors.append("New active change set " + changeSet.getItemId().getUuidValue() + " is referenced from multiple (" + found.size() + ") change-histories: \n");
            for (ChangeHistory ch : found) {
                errors.append("\t " + ch.getItemId() + "\n");
            }
        }
        return errors.toString();
    }

    public static String validateModifiedItems(InTransactionItemProvider provider) throws TeamRepositoryException {
        StringBuilder errors = new StringBuilder();
        ChangeHistoryValidator.validateModifiedComponents(errors, provider);
        ChangeHistoryValidator.validateModifiedChangesets(errors, provider);
        ChangeHistoryValidator.validateModifiedChangeHistories(errors, provider);
        return errors.toString();
    }

    private static void debugValidateModified(StringBuilder errors, InTransactionItemProvider provider) throws TeamRepositoryException {
        Map modifiedComponents = ChangeHistoryValidator.getModifiedMap((IItemType)ItemUtil.itemTypeFor((EClass)ScmPackage.eINSTANCE.getComponentEntry()), provider);
        HashSet<UUID> fetching = new HashSet<UUID>();
        ArrayList<Object> toFetch = new ArrayList<Object>();
        for (ComponentEntry e : modifiedComponents.values()) {
            if (e == null) continue;
            if (fetching.add(e.getComponent().getItemId())) {
                toFetch.add(e.getComponent());
            }
            if (!fetching.add(e.getWorkspace().getItemId())) continue;
            toFetch.add(e.getWorkspace());
        }
        List<IManagedItem> fetched = ChangeHistoryValidator.fetchItems(toFetch, provider, NULL_MONITOR);
        toFetch = null;
        HashMap<UUID, IManagedItem> items = new HashMap<UUID, IManagedItem>();
        for (IManagedItem i : fetched) {
            items.put(i.getItemId(), i);
        }
        fetched = null;
        for (ComponentEntry e : modifiedComponents.values()) {
            if (e == null) continue;
            Workspace workspace = (Workspace)items.get(e.getWorkspace().getItemId());
            Component component = (Component)items.get(e.getComponent().getItemId());
            ChangeHistoryValidator.validateHistory(provider, workspace, component, e, "", false, errors, NULL_MONITOR);
        }
    }

    private static void validateModifiedComponents(StringBuilder errors, InTransactionItemProvider provider) throws TeamRepositoryException {
        Collection<IItemHandle> comps = provider.getModifiedItemsForType(IComponent.ITEM_TYPE);
        if (comps.isEmpty()) {
            return;
        }
        ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>();
        components.addAll(comps);
        List<IAuditableHandle> owners = provider.getComponentOwners(components, null);
        if (owners.size() != components.size()) {
            errors.append("Missing a component ownership record");
        }
        int i = 0;
        while (i < components.size()) {
            IComponentHandle comp = (IComponentHandle)components.get(i);
            IAuditableHandle owner = owners.get(i);
            if (owner == null) {
                errors.append("Missing component ownership record for IComponent " + comp.getItemId().getUuidValue());
            }
            ++i;
        }
    }

    private static void validateModifiedChangesets(StringBuilder errors, InTransactionItemProvider provider) throws TeamRepositoryException {
        Collection<IItemHandle> modified = provider.getModifiedItemsForType(IChangeSet.ITEM_TYPE);
        ArrayList<IItemHandle> modifiedL = new ArrayList<IItemHandle>(modified);
        List<IManagedItem> items = ChangeHistoryValidator.fetchItems(modifiedL, provider, NULL_MONITOR);
        ArrayList<IChangeSet> cs = new ArrayList<IChangeSet>();
        HashMap<UUID, IComponentHandle> components = new HashMap<UUID, IComponentHandle>();
        for (IManagedItem i : items) {
            if (i == null) continue;
            IChangeSet c = (IChangeSet)i;
            cs.add(c);
            IComponentHandle cmp = c.getComponent();
            components.put(cmp.getItemId(), cmp);
        }
        List<IManagedItem> fComponents = ChangeHistoryValidator.fetchItems(new ArrayList(components.values()), provider, NULL_MONITOR);
        components = null;
        HashMap<UUID, IComponent> comp = new HashMap<UUID, IComponent>((int)((double)fComponents.size() / 0.75));
        for (IManagedItem i : fComponents) {
            comp.put(i.getItemId(), (IComponent)i);
        }
        Map<UUID, ItemProvider.VRecord> cache = new HashMap<UUID, ItemProvider.VRecord>();
        HashMap<UUID, IVersionableHandle> toFetch = new HashMap<UUID, IVersionableHandle>();
        cache = ChangeHistoryValidator.updateStateCacheWithCS(cs, cache, toFetch);
        ChangeHistoryValidator.fetchStatesForCache(cache, toFetch, provider, NULL_MONITOR);
        for (IChangeSet c : cs) {
            ChangeHistoryValidator.validateChangeSet(c, 0, (IComponent)comp.get(c.getComponent().getItemId()), cache, false, errors);
        }
    }

    private static void validateModifiedChangeHistories(StringBuilder errors, InTransactionItemProvider provider) throws TeamRepositoryException {
        Map<UUID, ChangeSet> modifiedChangeSets = ChangeHistoryValidator.getModifiedMap(IChangeSet.ITEM_TYPE, provider);
        Map<UUID, ChangeSet> committedChangeSets = ChangeHistoryValidator.getCommittedChangeSets(modifiedChangeSets, errors, provider);
        modifiedChangeSets = null;
        Map<UUID, ChangeHistory> modifiedChangeHistories = ChangeHistoryValidator.getModifiedMap((IItemType)ItemUtil.itemTypeFor((EClass)ScmPackage.eINSTANCE.getChangeHistory()), provider);
        Map<UUID, ComponentEntry> modifiedComponents = ChangeHistoryValidator.getModifiedMap((IItemType)ItemUtil.itemTypeFor((EClass)ScmPackage.eINSTANCE.getComponentEntry()), provider);
        Map<UUID, ChangeHistory> committedChangeHistories = ChangeHistoryValidator.getCommittedChangeHistories(modifiedChangeHistories, committedChangeSets, modifiedComponents, provider);
        Set<UUID> recentInContext = ChangeHistoryValidator.computeAllowedChanges(modifiedChangeHistories, modifiedComponents, provider);
        ChangeHistoryValidator.validateOnlyRecentChanged(modifiedChangeHistories, committedChangeHistories, recentInContext, modifiedComponents, errors, provider);
        Map<UUID, Boolean> historiesToValidate = ChangeHistoryValidator.getChangeHistoriesToValidate(modifiedComponents, errors, provider);
        ItemType cfgType = ItemUtil.itemTypeFor((EClass)ScmPackage.eINSTANCE.getConfiguration());
        HashSet<UUID> modifiedConfigs = new HashSet<UUID>();
        for (IItemHandle cfg : provider.getModifiedItemsForType((IItemType)cfgType)) {
            modifiedConfigs.add(cfg.getItemId());
        }
        ChangeHistoryValidator.validateHistoriesWithUnchangedConfigurations(modifiedComponents, committedChangeHistories, committedChangeSets, historiesToValidate, modifiedConfigs, provider);
        committedChangeSets = null;
        Map<UUID, List<Conflict>> conflicts = ChangeHistoryValidator.getConflictsInHistories(modifiedComponents);
        Map<UUID, List<Conflict>> previousConflicts = ChangeHistoryValidator.getPreviousConflictsInHistories(modifiedComponents, provider);
        modifiedComponents = null;
        HashSet<UUID> validated = new HashSet<UUID>((int)((double)modifiedChangeHistories.size() / 0.75));
        ScmFactory f = ScmFactory.eINSTANCE;
        while (!historiesToValidate.isEmpty()) {
            List<Conflict> oldConflicts;
            Iterator<Map.Entry<UUID, Boolean>> it = historiesToValidate.entrySet().iterator();
            Map.Entry<UUID, Boolean> nextId = it.next();
            it.remove();
            ChangeHistoryHandle h = f.createChangeHistoryHandle();
            h.setItemId(nextId.getKey());
            List<Conflict> conflictsList = conflicts.get(h.getItemId());
            if (conflictsList == null) {
                conflictsList = Collections.emptyList();
            }
            if ((oldConflicts = previousConflicts.get(h.getItemId())) == null) {
                oldConflicts = Collections.emptyList();
            }
            ChangeHistoryValidator.validateChangeHistory(h, nextId.getValue(), conflictsList, oldConflicts, validated, historiesToValidate, committedChangeHistories.keySet(), modifiedChangeHistories.keySet(), modifiedConfigs, errors, provider);
            validated.add(h.getItemId());
        }
        for (ChangeHistory h : modifiedChangeHistories.values()) {
            if (h == null || validated.contains(h.getItemId()) || recentInContext.contains(h.getItemId())) continue;
            ChangeHistoryValidator.validateConfigurationIfAdded(h, errors, provider);
        }
    }

    private static void validateHistoriesWithUnchangedConfigurations(Map<UUID, ComponentEntry> modifiedComponents, Map<UUID, ChangeHistory> committedChangeHistories, Map<UUID, ChangeSet> committedChangeSets, Map<UUID, Boolean> historiesToValidate, Set<UUID> modifiedConfigs, InTransactionItemProvider provider) throws TeamRepositoryException {
        ArrayList<ManagedItemHandle> toFetch = new ArrayList<ManagedItemHandle>(modifiedComponents.size());
        for (ComponentEntry ce : modifiedComponents.values()) {
            if (ce == null) continue;
            toFetch.add((ManagedItemHandle)ce.getItemHandle());
        }
        Map entries = ChangeHistoryValidator.getBaseStates(toFetch, provider);
        toFetch = null;
        for (ComponentEntry ce : modifiedComponents.values()) {
            ComponentEntry base;
            if (ce == null || (base = (ComponentEntry)entries.get(ce.getItemId())) == null || !ChangeHistoryValidator.sameConflicts(base, ce)) continue;
            if (committedChangeHistories.containsKey(ce.getChangehistory().getItemId())) {
                ChangeHistoryValidator.checkSameHistoricSequence(base.getChangehistory(), ce.getChangehistory(), committedChangeHistories, committedChangeSets, modifiedConfigs, historiesToValidate, provider);
                continue;
            }
            historiesToValidate.remove(ce.getChangehistory().getItemId());
        }
    }

    private static void checkSameHistoricSequence(ChangeHistoryHandle baseHistoryHandle, ChangeHistoryHandle newHistoryHandle, Map<UUID, ChangeHistory> committedChangeHistories, Map<UUID, ChangeSet> committedChangeSets, Set<UUID> modifiedConfigs, Map<UUID, Boolean> historiesToValidate, InTransactionItemProvider provider) throws TeamRepositoryException {
        ChangeHistory newHistory = (ChangeHistory)ChangeHistoryValidator.fetchItem((IManagedItemHandle)newHistoryHandle, provider, NULL_MONITOR);
        if (newHistory.getCachedAllPrevious().isEmpty()) {
            return;
        }
        ChangeHistory baseHistory = (ChangeHistory)provider.fetchBaseItemStates(Collections.singletonList(baseHistoryHandle)).iterator().next();
        ListIterator oldIt = baseHistory.getCachedAllPrevious().listIterator(baseHistory.getCachedAllPrevious().size());
        ListIterator newIt = newHistory.getCachedAllPrevious().listIterator(newHistory.getCachedAllPrevious().size());
        while (oldIt.hasPrevious() && newIt.hasPrevious()) {
            ChangeHistoryHandle nh;
            ChangeHistoryHandle old = (ChangeHistoryHandle)oldIt.previous();
            if (old.sameItemId((IItemHandle)(nh = (ChangeHistoryHandle)newIt.previous())) && !committedChangeHistories.containsKey(old.getItemId())) continue;
            oldIt.next();
            newIt.next();
            break;
        }
        List oldSequence = baseHistory.getCachedAllPrevious().subList(0, oldIt.nextIndex());
        oldIt = null;
        Map oldChangeHistories = ChangeHistoryValidator.getBaseStates(oldSequence, provider);
        ArrayList oldChangeSets = new ArrayList(oldSequence.size());
        for (ChangeHistoryHandle h : oldSequence) {
            ChangeHistory hist = (ChangeHistory)oldChangeHistories.get(h.getItemId());
            if (hist.getRecentEntries().isEmpty()) continue;
            ArrayList<IChangeSetHandle> csList = new ArrayList<IChangeSetHandle>(hist.getRecentEntries().size());
            for (ChangeHistoryEntry che : hist.getRecentEntries()) {
                csList.add(che.getChangeSet());
            }
            oldChangeSets.add(csList);
        }
        oldChangeHistories = null;
        oldSequence = null;
        List newSequence = newHistory.getCachedAllPrevious().subList(0, newIt.nextIndex());
        newIt = null;
        List<IManagedItem> newChangeHistories = ChangeHistoryValidator.fetchItems(newSequence, provider, NULL_MONITOR);
        newSequence = null;
        int j = oldChangeSets.size() - 1;
        ListIterator<IManagedItem> it = newChangeHistories.listIterator(newChangeHistories.size());
        while (it.hasPrevious()) {
            if (j == -1) {
                ChangeHistoryValidator.removeFromValidateIfEmpty(newChangeHistories.subList(0, it.nextIndex()), modifiedConfigs, historiesToValidate, provider);
                break;
            }
            if (!ChangeHistoryValidator.removeEquivalentEras(it, historiesToValidate, committedChangeSets, (List)oldChangeSets.get(j), modifiedConfigs, provider)) break;
            --j;
        }
    }

    private static boolean removeEquivalentEras(ListIterator<ChangeHistory> it, Map<UUID, Boolean> historiesToValidate, Map<UUID, ChangeSet> committedChangeSets, List<IChangeSetHandle> oldChangesets, Set<UUID> modifiedConfigs, InTransactionItemProvider provider) throws TeamRepositoryException {
        while (it.hasPrevious()) {
            ChangeHistory ch = it.previous();
            ConfigurationHandle configuration = provider.getConfiguration(ch, NULL_MONITOR);
            if (ch.getRecentEntries().isEmpty()) {
                if (configuration != null && modifiedConfigs.contains(configuration.getItemId())) continue;
                historiesToValidate.remove(ch.getItemId());
                continue;
            }
            if (ch.getRecentEntries().size() < oldChangesets.size()) {
                return false;
            }
            ListIterator enIt = ch.getRecentEntries().listIterator();
            for (IChangeSetHandle cs : oldChangesets) {
                ChangeHistoryEntry changeHistoryEntry = (ChangeHistoryEntry)enIt.next();
                if (changeHistoryEntry.getChangeSet().sameItemId((IItemHandle)cs) && !committedChangeSets.containsKey(cs.getItemId())) continue;
                return false;
            }
            ArrayList<IChangeSetHandle> toFetch = new ArrayList<IChangeSetHandle>(ch.getRecentEntries().size() - enIt.nextIndex());
            while (enIt.hasNext()) {
                toFetch.add(((ChangeHistoryEntry)enIt.next()).getChangeSet());
            }
            List<IManagedItem> csList = ChangeHistoryValidator.fetchItems(toFetch, provider, NULL_MONITOR);
            for (IChangeSet iChangeSet : csList) {
                if (iChangeSet.changes().isEmpty()) continue;
                return false;
            }
            if (configuration == null || !modifiedConfigs.contains(configuration.getItemId())) {
                historiesToValidate.remove(ch.getItemId());
            }
            return true;
        }
        return true;
    }

    private static void removeFromValidateIfEmpty(List<ChangeHistory> histories, Set<UUID> modifiedConfigs, Map<UUID, Boolean> historiesToValidate, InTransactionItemProvider provider) throws TeamRepositoryException {
        ArrayList<IChangeSetHandle> toFetch = new ArrayList<IChangeSetHandle>();
        for (ChangeHistory hist : histories) {
            for (ChangeHistoryEntry entry : hist.getRecentEntries()) {
                toFetch.add(entry.getChangeSet());
            }
        }
        List<IManagedItem> csList = ChangeHistoryValidator.fetchItems(toFetch, provider, NULL_MONITOR);
        int i = csList.size();
        ListIterator<ChangeHistory> it = histories.listIterator(histories.size());
        while (it.hasPrevious()) {
            ChangeHistory hist = it.previous();
            int bottom = i - hist.getRecentEntries().size();
            while (i != bottom) {
                IChangeSet cs;
                if ((cs = (IChangeSet)csList.get(--i)).changes().isEmpty()) continue;
                return;
            }
            ConfigurationHandle configuration = provider.getConfiguration(hist, NULL_MONITOR);
            if (configuration != null && modifiedConfigs.contains(configuration.getItemId())) continue;
            historiesToValidate.remove(hist.getItemId());
        }
    }

    private static boolean sameConflicts(ComponentEntry base, ComponentEntry ce) {
        Map<UUID, Conflict> conflictMap = ChangeHistoryValidator.getConflictMap(base.getConflicts());
        for (Conflict c : ce.getConflicts()) {
            Conflict c2 = conflictMap.remove(c.getVersionable().getItemId());
            if (c2 != null && c2.isIncidental() == c.isIncidental() && ChangeHistoryValidator.equal(c2.getSelectedContributorStateId(), c.getSelectedContributorStateId()) && ChangeHistoryValidator.equal(c2.getMergeStateId(), c.getMergeStateId()) && ChangeHistoryValidator.equal(c2.getProposedContributorStateId(), c.getProposedContributorStateId())) continue;
            return false;
        }
        return conflictMap.isEmpty();
    }

    protected static void validateConfigurationIfAdded(ChangeHistory h, StringBuilder errors, InTransactionItemProvider provider) throws TeamRepositoryException {
        block5: {
            ConfigurationHandle histConfig;
            ConfigurationHandle config = provider.getConfiguration(h, NULL_MONITOR);
            if (config == null) {
                return;
            }
            Collection<IItemHandle> modifiedConfigs = provider.getModifiedItemsForType((IItemType)ItemUtil.itemTypeFor((EClass)ScmPackage.eINSTANCE.getConfiguration()));
            boolean found = false;
            for (IItemHandle i : modifiedConfigs) {
                ConfigurationHandle ci = (ConfigurationHandle)i;
                if (!ci.sameItemId((IItemHandle)config)) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
            HashMap<UUID, UUID> selections = new HashMap<UUID, UUID>();
            HashMap<UUID, IItemType> itemTypes = new HashMap<UUID, IItemType>();
            ChangeHistory hist = h;
            do {
                ArrayList<IChangeSetHandle> toFetch = new ArrayList<IChangeSetHandle>(hist.getRecentEntries().size());
                for (ChangeHistoryEntry che : hist.getRecentEntries()) {
                    toFetch.add(che.getChangeSet());
                }
                List<IManagedItem> changeSets = ChangeHistoryValidator.fetchItems(toFetch, provider, NULL_MONITOR);
                toFetch = null;
                ChangeHistoryValidator.updateOverrides(selections, itemTypes, Collections.<Conflict>emptyList(), changeSets, provider);
                if (hist.getPrevious() != null) continue;
                ChangeHistoryValidator.validateConfiguration(config, null, selections, itemTypes, h, errors, provider);
                break block5;
            } while ((histConfig = provider.getConfiguration(hist = (ChangeHistory)ChangeHistoryValidator.fetchItem((IManagedItemHandle)hist.getPrevious(), provider, NULL_MONITOR), NULL_MONITOR)) == null);
            ChangeHistoryValidator.validateConfiguration(config, histConfig, selections, itemTypes, h, errors, provider);
        }
    }

    private static void validateChangeHistory(ChangeHistoryHandle chh, boolean isRecent, Collection<Conflict> conflicts, Collection<Conflict> oldConflicts, Set<UUID> validated, Map<UUID, Boolean> toValidate, Set<UUID> comittedChangeHistories, Set<UUID> modifiedChangeHistories, Set<UUID> modifiedConfigs, StringBuilder errors, InTransactionItemProvider provider) throws TeamRepositoryException {
        ChangeHistoryHandle orig = chh;
        ChangeHistory hist = (ChangeHistory)ChangeHistoryValidator.fetchItem((IManagedItemHandle)chh, provider, NULL_MONITOR);
        HashMap<UUID, GapCandidate> candidates = new HashMap<UUID, GapCandidate>();
        HashSet<UUID> potentialForks = new HashSet<UUID>();
        HashMap<UUID, Set<UUID>> unresolved = new HashMap<UUID, Set<UUID>>();
        HashMap<UUID, UUID> overrides = new HashMap<UUID, UUID>();
        HashMap<UUID, IItemType> itemTypes = new HashMap<UUID, IItemType>();
        ChangeHistory resolvingConfig = null;
        IComponentHandle cmp = hist.getComponent();
        HashMap<UUID, IChange> activeChanges = new HashMap<UUID, IChange>();
        HashMap<UUID, Conflict> conflictMap = new HashMap<UUID, Conflict>((int)((double)conflicts.size() / 0.75));
        HashMap predecessorsOfProposed = new HashMap((int)((double)conflicts.size() / 0.75));
        HashMap predecessorsOfSelected = new HashMap((int)((double)conflicts.size() / 0.75));
        while (true) {
            UUID state;
            Conflict conf;
            Set acceptable;
            ChangeSet cs;
            Set acceptable2;
            Map.Entry e;
            Iterator<Object> it;
            ChangeHistory base = (ChangeHistory)ChangeHistoryValidator.getBaseStates(Collections.singleton(hist), provider).values().iterator().next();
            ArrayList<IChangeSetHandle> toFetch = new ArrayList<IChangeSetHandle>(hist.getRecentEntries().size());
            HashSet<UUID> forThisEra = new HashSet<UUID>(hist.getRecentEntries().size() * 4 / 3);
            for (ChangeHistoryEntry che : hist.getRecentEntries()) {
                IChangeSetHandle cs2 = che.getChangeSet();
                toFetch.add(cs2);
                if (forThisEra.add(cs2.getItemId())) continue;
                errors.append("era " + hist.getItemId().getUuidValue() + " contains multiple references to change set " + cs2.getItemId().getUuidValue() + "\n");
            }
            if (hist.getActiveCount() != 0 && !orig.sameItemId((IItemHandle)hist)) {
                errors.append("The non recent history " + hist.getItemId().getUuidValue() + " has " + hist.getActiveCount() + " active changesets\n");
            }
            List<IManagedItem> changeSets = ChangeHistoryValidator.fetchItems(toFetch, provider, NULL_MONITOR);
            toFetch = null;
            int numActive = 0;
            boolean seenActive = false;
            for (ChangeSet changeSet : changeSets) {
                if (changeSet.isActive()) {
                    for (Change c : changeSet.changes()) {
                        if (activeChanges.put(c.item().getItemId(), c) == null) continue;
                        errors.append("The " + c.getItem().getItemType().getName() + " " + c.getItem().getItemId().getUuidValue() + " is modified in 2 different active changesets in history " + hist.getItemId().getUuidValue() + "\n");
                    }
                    seenActive = true;
                    ++numActive;
                    if (!isRecent || !hist.sameItemId((IItemHandle)orig)) {
                        errors.append("The changeset " + changeSet.getItemId().getUuidValue() + " is active in a non recent history " + hist.getItemId().getUuidValue() + "\n");
                    }
                } else if (seenActive) {
                    errors.append("The closed changeset " + changeSet.getItemId().getUuidValue() + " in change history " + hist.getItemId().getUuidValue() + " is preceded by active changesets\n");
                }
                if (changeSet.getComponent().sameItemId((IItemHandle)hist.getComponent())) continue;
                errors.append("The component " + changeSet.getComponent().getItemId().getUuidValue() + " of changeset " + changeSet.getItemId().getUuidValue() + " does not match the component " + hist.getComponent().getItemId().getUuidValue() + " of change history " + hist.getItemId().getUuidValue() + "\n");
            }
            if (numActive != hist.getActiveCount()) {
                errors.append("The change history " + hist.getItemId().getUuidValue() + " claims to contain " + hist.getActiveCount() + " active changesets but in fact contains " + numActive + "\n");
            }
            if (comittedChangeHistories.contains(hist.getItemId()) || hist.getPrevious() == null && base.getPrevious() != null || hist.getPrevious() != null && !hist.getPrevious().sameItemId((IItemHandle)base.getPrevious())) {
                if (hist.sameItemId((IItemHandle)orig)) {
                    for (Conflict conflict : conflicts) {
                        HashSet<UUID> states = new HashSet<UUID>();
                        Change chg = (Change)activeChanges.get(conflict.getVersionable().getItemId());
                        UUID proposed = ChangeHistoryValidator.getProposed(conflict, chg, null);
                        states.add(proposed);
                        predecessorsOfProposed.put(conflict.getVersionable().getItemId(), states);
                        states = new HashSet<UUID>();
                        states.add(conflict.getSelectedContributorStateId());
                        predecessorsOfSelected.put(conflict.getVersionable().getItemId(), states);
                        conflictMap.put(conflict.getVersionable().getItemId(), conflict);
                    }
                }
                ChangeHistoryValidator.appendUnresolved(hist, base, candidates, potentialForks, unresolved, conflicts, activeChanges, oldConflicts, changeSets, errors, provider);
            } else {
                ChangeHistoryValidator.resolve(candidates, potentialForks, unresolved, conflicts, activeChanges, changeSets, hist, errors);
            }
            ConfigurationHandle configurationHandle = provider.getConfiguration(hist, NULL_MONITOR);
            if (configurationHandle != null) {
                if (!(hist.sameItemId((IItemHandle)orig) || predecessorsOfProposed.isEmpty() && predecessorsOfSelected.isEmpty())) {
                    for (StateSelection sel : provider.fetchStateSelections(configurationHandle, NULL_MONITOR)) {
                        UUID itemId = sel.getItem().getItemId();
                        Set acceptable3 = (Set)predecessorsOfProposed.remove(itemId);
                        if (acceptable3 != null) {
                            boolean isIncidental = acceptable3.contains(sel.getState());
                            Conflict c = (Conflict)conflictMap.get(itemId);
                            if (c.isIncidental() != isIncidental) {
                                ChangeHistoryValidator.logConflictTypeError(c, orig, true, errors);
                            }
                        }
                        if ((acceptable3 = (Set)predecessorsOfSelected.remove(itemId)) == null || !acceptable3.contains(sel.getState())) continue;
                        ChangeHistoryValidator.logConflictTypeError((Conflict)conflictMap.get(itemId), orig, false, errors);
                    }
                    it = predecessorsOfProposed.entrySet().iterator();
                    while (it.hasNext()) {
                        Conflict c;
                        e = (Map.Entry)it.next();
                        Set acceptable22 = (Set)e.getValue();
                        boolean isIncidental = acceptable22.contains(null);
                        if (isIncidental != (c = (Conflict)conflictMap.get(e.getKey())).isIncidental()) {
                            ChangeHistoryValidator.logConflictTypeError(c, orig, true, errors);
                        }
                        it.remove();
                    }
                    it = predecessorsOfSelected.entrySet().iterator();
                    while (it.hasNext()) {
                        e = (Map.Entry)it.next();
                        acceptable2 = (Set)e.getValue();
                        if (acceptable2.contains(null)) {
                            UUID itemId = (UUID)e.getKey();
                            ChangeHistoryValidator.logConflictTypeError((Conflict)conflictMap.get(itemId), orig, false, errors);
                        }
                        it.remove();
                    }
                }
                if (resolvingConfig != null) {
                    ChangeHistoryValidator.validateConfiguration(provider.getConfiguration(resolvingConfig, NULL_MONITOR), configurationHandle, overrides, itemTypes, resolvingConfig, errors, provider);
                }
                resolvingConfig = comittedChangeHistories.contains(hist.getItemId()) || modifiedConfigs.contains(configurationHandle.getItemId()) || base == null || !configurationHandle.sameItemId((IItemHandle)provider.getConfiguration(base, NULL_MONITOR)) ? hist : null;
                overrides.clear();
                itemTypes.clear();
            }
            if (!predecessorsOfProposed.isEmpty()) {
                it = changeSets.listIterator(changeSets.size());
                block8: while (it.hasPrevious()) {
                    cs = (ChangeSet)it.previous();
                    block9: for (Change c : cs.getChanges()) {
                        UUID itemId = c.getItem().getItemId();
                        acceptable = (Set)predecessorsOfProposed.get(itemId);
                        if (acceptable == null) continue;
                        conf = (Conflict)conflictMap.get(itemId);
                        if (!acceptable.contains(c.getAfter())) {
                            predecessorsOfProposed.remove(itemId);
                            if (conf.isIncidental()) {
                                ChangeHistoryValidator.logConflictTypeError(conf, orig, true, errors);
                            }
                            if (!predecessorsOfProposed.isEmpty()) continue;
                            break block8;
                        }
                        if (cs.isActive() && ChangeHistoryValidator.equal(conf.getSelectedContributorStateId(), c.getAfter())) {
                            predecessorsOfProposed.remove(itemId);
                            if (conf.isIncidental()) {
                                ChangeHistoryValidator.logConflictTypeError(conf, orig, true, errors);
                            }
                            if (!predecessorsOfProposed.isEmpty()) continue;
                            break block8;
                        }
                        state = c.getBefore();
                        if (ChangeHistoryValidator.equal(conf.getSelectedContributorStateId(), state)) {
                            predecessorsOfProposed.remove(itemId);
                            if (!conf.isIncidental()) {
                                ChangeHistoryValidator.logConflictTypeError(conf, orig, true, errors);
                            }
                            if (!predecessorsOfProposed.isEmpty()) continue;
                            break block8;
                        }
                        if (cs.isActive()) {
                            acceptable.remove(c.getAfter());
                        }
                        acceptable.add(state);
                        for (MergeState ms : c.getMerges()) {
                            state = ms.getState();
                            if (ChangeHistoryValidator.equal(conf.getSelectedContributorStateId(), state)) {
                                predecessorsOfProposed.remove(itemId);
                                if (!conf.isIncidental()) {
                                    ChangeHistoryValidator.logConflictTypeError(conf, orig, true, errors);
                                }
                                if (!predecessorsOfProposed.isEmpty()) continue block9;
                                break block8;
                            }
                            acceptable.add(state);
                        }
                    }
                }
            }
            if (!predecessorsOfSelected.isEmpty()) {
                it = changeSets.listIterator(changeSets.size());
                block11: while (it.hasPrevious()) {
                    cs = (ChangeSet)it.previous();
                    block12: for (Change c : cs.getChanges()) {
                        UUID itemId = c.getItem().getItemId();
                        acceptable = (Set)predecessorsOfSelected.get(itemId);
                        if (acceptable == null) continue;
                        if (!acceptable.contains(c.getAfter())) {
                            predecessorsOfSelected.remove(itemId);
                            if (!predecessorsOfSelected.isEmpty()) continue;
                            break block11;
                        }
                        conf = (Conflict)conflictMap.get(itemId);
                        state = c.getBefore();
                        UUID proposed = ChangeHistoryValidator.getProposed(conf, (IChange)activeChanges.get(itemId), null);
                        if (ChangeHistoryValidator.equal(proposed, state)) {
                            predecessorsOfSelected.remove(itemId);
                            ChangeHistoryValidator.logConflictTypeError(conf, orig, false, errors);
                            if (!predecessorsOfSelected.isEmpty()) continue;
                            break block11;
                        }
                        if (cs.isActive()) {
                            acceptable.remove(c.getAfter());
                        }
                        acceptable.add(state);
                        for (MergeState ms : c.getMerges()) {
                            state = ms.getState();
                            if (ChangeHistoryValidator.equal(proposed, state)) {
                                predecessorsOfSelected.remove(itemId);
                                ChangeHistoryValidator.logConflictTypeError(conf, orig, false, errors);
                                if (!predecessorsOfSelected.isEmpty()) continue block12;
                                break block11;
                            }
                            acceptable.add(state);
                        }
                    }
                }
            }
            if (resolvingConfig != null) {
                ChangeHistoryValidator.updateOverrides(overrides, itemTypes, conflicts, changeSets, provider);
            }
            if ((chh = hist.getPrevious()) == null) {
                ChangeHistoryValidator.logUnresolved(candidates, errors);
                if (resolvingConfig != null) {
                    ChangeHistoryValidator.validateConfiguration(provider.getConfiguration(resolvingConfig, NULL_MONITOR), null, overrides, itemTypes, resolvingConfig, errors, provider);
                }
                it = predecessorsOfProposed.entrySet().iterator();
                while (it.hasNext()) {
                    Conflict c;
                    e = (Map.Entry)it.next();
                    acceptable2 = (Set)e.getValue();
                    boolean isIncidental = acceptable2.contains(null);
                    if (isIncidental != (c = (Conflict)conflictMap.get(e.getKey())).isIncidental()) {
                        ChangeHistoryValidator.logConflictTypeError(c, orig, true, errors);
                    }
                    it.remove();
                }
                it = predecessorsOfSelected.entrySet().iterator();
                while (it.hasNext()) {
                    e = (Map.Entry)it.next();
                    acceptable2 = (Set)e.getValue();
                    if (acceptable2.contains(null)) {
                        UUID itemId = (UUID)e.getKey();
                        ChangeHistoryValidator.logConflictTypeError((Conflict)conflictMap.get(itemId), orig, false, errors);
                    }
                    it.remove();
                }
                break;
            }
            hist = (ChangeHistory)ChangeHistoryValidator.fetchItem((IManagedItemHandle)chh, provider, NULL_MONITOR);
            conflicts = Collections.emptyList();
            oldConflicts = conflicts;
            if (!hist.getComponent().sameItemId((IItemHandle)cmp)) {
                errors.append("The component of " + hist.getItemId().getUuidValue() + " is " + hist.getComponent().getItemId().getUuidValue() + " which is different from the component of the next change history which is " + cmp.getItemId().getUuidValue() + "\n");
            }
            if (!modifiedChangeHistories.contains(hist.getItemId()) && candidates.isEmpty() && resolvingConfig == null && potentialForks.isEmpty() && predecessorsOfProposed.isEmpty() && predecessorsOfSelected.isEmpty()) break;
            Boolean old = toValidate.remove(chh.getItemId());
            if (old != null && old.booleanValue()) {
                errors.append("The history " + chh.getItemId().getUuidValue() + " is recent but also previous.\n");
            }
            validated.add(chh.getItemId());
        }
    }

    private static void logConflictTypeError(Conflict c, ChangeHistoryHandle ch, boolean exists, StringBuilder errors) {
        errors.append("The conflict on " + c.getVersionable().getItemType().getName() + " " + c.getVersionable().getItemId().getUuidValue() + " in change history " + ch.getItemId().getUuidValue() + " is marked as " + (c.isIncidental() ? "incidental" : "real") + " but is actually " + (exists ? (c.isIncidental() ? "real\n" : "incidental\n") : "non existant\n"));
    }

    private static void validateConfiguration(ConfigurationHandle target, ConfigurationHandle base, Map<UUID, UUID> overrides, Map<UUID, IItemType> itemTypes, ChangeHistory hist, StringBuilder errors, InTransactionItemProvider provider) throws TeamRepositoryException {
        HashMap<UUID, UUID> configuration = new HashMap<UUID, UUID>((int)((double)overrides.size() / 0.75));
        if (base != null) {
            for (StateSelection sel : provider.fetchStateSelections(base, NULL_MONITOR)) {
                configuration.put(sel.getItem().getItemId(), sel.getState());
                itemTypes.put(sel.getItem().getItemId(), sel.getItem().getItemType());
            }
        }
        configuration.putAll(overrides);
        IComponent c = (IComponent)ChangeHistoryValidator.fetchItem((IManagedItemHandle)hist.getComponent(), provider, NULL_MONITOR);
        if (configuration.get(c.getRootFolder().getItemId()) == null) {
            errors.append("The root folder " + c.getRootFolder().getItemId().getUuidValue() + " is not present in the configuration of change history " + hist.getItemId().getUuidValue() + "\n");
        }
        HashMap<UUID, UUID> selections = new HashMap<UUID, UUID>();
        HashMap<UUID, UUID> parentMap = new HashMap<UUID, UUID>();
        for (StateSelection stateSelection : provider.fetchStateSelections(target, NULL_MONITOR)) {
            UUID correct;
            selections.put(stateSelection.getItem().getItemId(), stateSelection.getState());
            parentMap.put(stateSelection.getItem().getItemId(), stateSelection.getParent());
            if (stateSelection.getState() != null && stateSelection.getParent() == null && !stateSelection.getItem().sameItemId((IItemHandle)c.getRootFolder())) {
                errors.append("The " + stateSelection.getItem().getItemType().getName() + " " + stateSelection.getItem().getItemId().getUuidValue() + " in change history " + hist.getItemId().getUuidValue() + " has null parent in state selections\n");
            }
            if ((correct = (UUID)configuration.remove(stateSelection.getItem().getItemId())) == null && stateSelection.getState() != null) {
                errors.append("The state selection for " + stateSelection.getItem().getItemType().getName() + " " + stateSelection.getItem().getItemId().getUuidValue() + " in change history " + hist.getItemId().getUuidValue() + " is " + stateSelection.getState().getUuidValue() + " but should be null\n");
                continue;
            }
            if (correct == null || correct.equals((Object)stateSelection.getState())) continue;
            errors.append("The state selection for " + stateSelection.getItem().getItemType().getName() + " " + stateSelection.getItem().getItemId().getUuidValue() + " in change history " + hist.getItemId().getUuidValue() + " is " + (stateSelection.getState() == null ? "null" : stateSelection.getState().getUuidValue()) + " but should be " + correct.getUuidValue() + "\n");
        }
        for (Map.Entry entry : configuration.entrySet()) {
            UUID state = (UUID)entry.getValue();
            if (state == null) continue;
            UUID id = (UUID)entry.getKey();
            errors.append("The state selection for " + itemTypes.get(id).getName() + " " + id.getUuidValue() + " in change history " + hist.getItemId().getUuidValue() + " is null but should be " + state.getUuidValue() + "\n");
        }
        configuration = null;
        ChangeHistoryValidator.checkForCycles(selections, parentMap, c.getRootFolder().getItemId(), itemTypes, errors, 0);
    }

    private static void logUnresolved(Map<UUID, GapCandidate> candidates, StringBuilder errors) {
        for (GapCandidate c : candidates.values()) {
            errors.append("GAP: the " + c.item.getItemType().getName() + " " + c.item.getItemId().getUuidValue() + " state " + c.state.getUuidValue() + " is a " + (c.cs == null ? String.valueOf(c.isBefore ? "selected" : "proposed") + " state" : String.valueOf(c.isBefore ? "before" : "merge") + " state of changeset " + c.cs.getItemId().getUuidValue()) + " but does not appear as an after state in any earlier changeset\n");
        }
    }

    private static UUID getUniqueEndStateOfPrevHistory(Conflict c, Collection<ChangeSet> changeSets, IChange activeChange) {
        UUID proposed;
        if (c.isIncidental()) {
            return null;
        }
        IVersionableHandle v = c.getVersionable();
        UUID selected = ChangeHistoryValidator.getState(c.getSelectedContributorStateId(), v);
        if (!selected.equals((Object)(proposed = ChangeHistoryValidator.getState(ChangeHistoryValidator.getProposed(c, activeChange, null), v)))) {
            boolean foundSelected = false;
            boolean foundProposed = false;
            for (ChangeSet cs : changeSets) {
                for (Change ch : cs.changes()) {
                    if (!ch.item().sameItemId((IItemHandle)v)) continue;
                    UUID state = ChangeHistoryValidator.getState(ch.afterState(), ch.item());
                    if (state.equals((Object)selected)) {
                        if (foundProposed) {
                            return null;
                        }
                        foundSelected = true;
                    }
                    if (!state.equals((Object)proposed)) continue;
                    if (foundSelected) {
                        return null;
                    }
                    foundProposed = true;
                }
            }
            if (foundProposed) {
                return selected;
            }
            return proposed;
        }
        for (ChangeSet cs : changeSets) {
            if (cs.isActive()) continue;
            for (Change ch : cs.changes()) {
                UUID state;
                if (!ch.item().sameItemId((IItemHandle)v) || !(state = ChangeHistoryValidator.getState(ch.afterState(), ch.item())).equals((Object)selected)) continue;
                return null;
            }
        }
        return selected;
    }

    private static void appendUnresolved(ChangeHistory hist, ChangeHistory base, Map<UUID, GapCandidate> candidates, Set<UUID> potentialForks, Map<UUID, Set<UUID>> unresolved, Collection<Conflict> conflicts, Map<UUID, IChange> activeChanges, Collection<Conflict> oldConflits, List<ChangeSet> changeSets, StringBuilder errors, InTransactionItemProvider provider) throws TeamRepositoryException {
        HashSet<Object> knownResolvedInHistory = new HashSet<Object>();
        HashMap<Object, IVersionableHandle> potentialEndStatesForPreviousHistory = new HashMap<Object, IVersionableHandle>();
        if (base != null && hist.getPrevious() != null && hist.getPrevious().sameItemId((IItemHandle)base.getPrevious())) {
            ArrayList<IChangeSetHandle> toFetch = new ArrayList<IChangeSetHandle>(base.getRecentEntries().size());
            for (ChangeHistoryEntry che : base.getRecentEntries()) {
                toFetch.add(che.getChangeSet());
            }
            Map baseChangesets = ChangeHistoryValidator.getBaseStates(toFetch, provider);
            HashMap<UUID, Object> oldActiveChanges = new HashMap<UUID, Object>();
            for (ChangeSet cs : baseChangesets.values()) {
                if (!cs.isActive()) continue;
                for (Object c : cs.changes()) {
                    oldActiveChanges.put(c.item().getItemId(), c);
                }
            }
            HashMap<UUID, Object> noNeedToCheck = new HashMap<UUID, Object>();
            for (Conflict c : oldConflits) {
                IChange activeChange = (IChange)oldActiveChanges.get(c.getVersionable().getItemId());
                Object id = ChangeHistoryValidator.getUniqueEndStateOfPrevHistory(c, baseChangesets.values(), activeChange);
                if (id != null) {
                    noNeedToCheck.put(c.getVersionable().getItemId(), id);
                    potentialEndStatesForPreviousHistory.put(id, c.getVersionable());
                    continue;
                }
                id = ChangeHistoryValidator.getState(c.getSelectedContributorStateId(), c.getVersionable());
                potentialEndStatesForPreviousHistory.put(id, c.getVersionable());
                id = ChangeHistoryValidator.getState(ChangeHistoryValidator.getProposed(c, activeChange, null), c.getVersionable());
                potentialEndStatesForPreviousHistory.put(id, c.getVersionable());
            }
            ListIterator it = toFetch.listIterator(toFetch.size());
            while (it.hasPrevious()) {
                ChangeSet cs = (ChangeSet)baseChangesets.get(((IChangeSetHandle)it.previous()).getItemId());
                for (Change c : cs.getChanges()) {
                    boolean needToCheck = !noNeedToCheck.containsKey(c.getItem().getItemId());
                    UUID id = ChangeHistoryValidator.getState(c.getAfter(), c.getItem());
                    knownResolvedInHistory.remove(id);
                    if (needToCheck && !cs.isActive()) {
                        potentialEndStatesForPreviousHistory.put(id, c.getItem());
                    }
                    id = ChangeHistoryValidator.getState(c.getBefore(), c.getItem());
                    knownResolvedInHistory.add(id);
                    if (needToCheck) {
                        potentialEndStatesForPreviousHistory.put(id, c.getItem());
                    }
                    for (MergeState ms : c.getMerges()) {
                        id = ChangeHistoryValidator.getState(ms.getState(), c.getItem());
                        knownResolvedInHistory.add(id);
                        if (!needToCheck) continue;
                        potentialEndStatesForPreviousHistory.put(id, c.getItem());
                    }
                }
            }
            knownResolvedInHistory.addAll(noNeedToCheck.values());
        }
        for (Conflict c : conflicts) {
            UUID proposed;
            UUID id = ChangeHistoryValidator.getState(c.getSelectedContributorStateId(), c.getVersionable());
            potentialEndStatesForPreviousHistory.remove(id);
            if (c.getSelectedContributorStateId() != null && !knownResolvedInHistory.contains(c.getSelectedContributorStateId())) {
                candidates.put(c.getSelectedContributorStateId(), new GapCandidate(hist, null, (IItemHandle)c.getVersionable(), c.getSelectedContributorStateId(), true));
            }
            if ((proposed = ChangeHistoryValidator.getProposed(c, activeChanges.get(c.getVersionable().getItemId()), null)) != null && !knownResolvedInHistory.contains(proposed)) {
                candidates.put(proposed, new GapCandidate(hist, null, (IItemHandle)c.getVersionable(), proposed, false));
            }
            id = ChangeHistoryValidator.getState(proposed, c.getVersionable());
            potentialEndStatesForPreviousHistory.remove(id);
        }
        ChangeHistoryValidator.resolve(candidates, Collections.<UUID>emptySet(), unresolved, conflicts, activeChanges, changeSets, hist, errors);
        for (ChangeSet cs : changeSets) {
            for (Change c : cs.getChanges()) {
                UUID before = c.getBefore();
                potentialEndStatesForPreviousHistory.remove(ChangeHistoryValidator.getState(before, c.getItem()));
                if (before != null && !knownResolvedInHistory.contains(before)) {
                    candidates.put(before, new GapCandidate(hist, cs, (IItemHandle)c.getItem(), before, true));
                    knownResolvedInHistory.add(before);
                }
                for (MergeState ms : c.getMerges()) {
                    UUID state = ms.getState();
                    potentialEndStatesForPreviousHistory.remove(ChangeHistoryValidator.getState(state, c.getItem()));
                    if (state == null || knownResolvedInHistory.contains(state)) continue;
                    candidates.put(state, new GapCandidate(hist, cs, (IItemHandle)c.getItem(), state, false));
                    knownResolvedInHistory.add(state);
                }
                UUID after = c.getAfter();
                if (after != null) {
                    knownResolvedInHistory.add(after);
                }
                if (cs.isActive()) continue;
                potentialEndStatesForPreviousHistory.remove(ChangeHistoryValidator.getState(after, c.getItem()));
            }
        }
        for (IVersionableHandle v : potentialEndStatesForPreviousHistory.values()) {
            potentialForks.add(v.getItemId());
        }
    }

    private static void resolve(Map<UUID, GapCandidate> candidates, Set<UUID> potentialForks, Map<UUID, Set<UUID>> unresolved, Collection<Conflict> conflicts, Map<UUID, IChange> activeChanges, List<ChangeSet> changeSets, ChangeHistory history, StringBuilder errors) {
        HashMap unresolvedInHistory = new HashMap();
        if (!conflicts.isEmpty() && !unresolved.isEmpty()) {
            throw new IllegalStateException();
        }
        HashMap<UUID, Conflict> conflictMap = new HashMap<UUID, Conflict>();
        for (Conflict c : conflicts) {
            if (unresolved.containsKey(c.getVersionable().getItemId())) {
                errors.append("The conflicts list contains the " + c.getVersionable().getItemType().getName() + " " + c.getVersionable().getItemId().getUuidValue() + " more than once\n");
            }
            conflictMap.put(c.getVersionable().getItemId(), c);
            HashSet<UUID> validInHistory = new HashSet<UUID>();
            HashSet<UUID> valid = new HashSet<UUID>();
            unresolved.put(c.getVersionable().getItemId(), valid);
            unresolvedInHistory.put(c.getVersionable().getItemId(), validInHistory);
            UUID selected = ChangeHistoryValidator.getState(c.getSelectedContributorStateId(), c.getVersionable());
            validInHistory.add(selected);
            valid.add(selected);
            UUID proposed = ChangeHistoryValidator.getState(ChangeHistoryValidator.getProposed(c, activeChanges.get(c.getVersionable().getItemId()), errors), c.getVersionable());
            validInHistory.add(proposed);
            valid.add(proposed);
        }
        ListIterator<ChangeSet> it = changeSets.listIterator(changeSets.size());
        while (it.hasPrevious()) {
            ChangeSet cs = it.previous();
            for (Change c : cs.getChanges()) {
                boolean first;
                HashSet<UUID> validInHistory;
                Set<UUID> valid;
                potentialForks.remove(c.getItem().getItemId());
                UUID id = ChangeHistoryValidator.getState(c.getAfter(), c.getItem());
                if (!unresolvedInHistory.containsKey(c.getItem().getItemId()) && (valid = unresolved.remove(c.getItem().getItemId())) != null && !valid.contains(id)) {
                    errors.append("The " + c.getItem().getItemType().getName() + " " + c.getItem().getItemId().getUuidValue() + " state " + (id.equals((Object)c.getItem().getItemId()) ? "null" : id.getUuidValue()) + " in change set " + cs.getItemId().getUuidValue() + " change history " + history.getItemId().getUuidValue() + " is not resolved in later histories\n");
                }
                if ((valid = unresolved.get(c.getItem().getItemId())) == null) {
                    valid = new HashSet<UUID>();
                    unresolved.put(c.getItem().getItemId(), valid);
                }
                if ((validInHistory = (HashSet<UUID>)unresolvedInHistory.get(c.getItem().getItemId())) == null) {
                    validInHistory = new HashSet<UUID>();
                    unresolvedInHistory.put(c.getItem().getItemId(), validInHistory);
                    first = true;
                } else {
                    first = false;
                }
                candidates.remove(id);
                if (cs.isActive()) {
                    Conflict conf;
                    if (!validInHistory.contains(id) && !first) {
                        errors.append("The " + c.getItem().getItemType().getName() + " " + c.getItem().getItemId().getUuidValue() + " state " + (id.equals((Object)c.getItem().getItemId()) ? "null" : id.getUuidValue()) + " in change set " + cs.getItemId().getUuidValue() + " is not resolved in change history " + history.getItemId().getUuidValue() + "\n");
                    }
                    if ((conf = (Conflict)conflictMap.get(c.getItem().getItemId())) != null) {
                        UUID selected = ChangeHistoryValidator.getState(conf.getSelectedContributorStateId(), conf.getVersionable());
                        UUID proposed = ChangeHistoryValidator.getState(ChangeHistoryValidator.getProposed(conf, activeChanges.get(conf.getVersionable().getItemId()), null), conf.getVersionable());
                        if (!selected.equals((Object)id) || !proposed.equals((Object)id)) {
                            valid.remove(id);
                            validInHistory.remove(id);
                        }
                    }
                } else {
                    valid.add(id);
                    if (validInHistory.add(id) && !first) {
                        errors.append("The " + c.getItem().getItemType().getName() + " " + c.getItem().getItemId().getUuidValue() + " state " + (id.equals((Object)c.getItem().getItemId()) ? "null" : id.getUuidValue()) + " in change set " + cs.getItemId().getUuidValue() + " is not resolved in change history " + history.getItemId().getUuidValue() + "\n");
                    }
                }
                id = ChangeHistoryValidator.getState(c.getBefore(), c.getItem());
                candidates.remove(id);
                valid.add(id);
                validInHistory.add(id);
                for (MergeState ms : c.getMerges()) {
                    id = ChangeHistoryValidator.getState(ms.getState(), c.getItem());
                    candidates.remove(id);
                    valid.add(id);
                    validInHistory.add(id);
                }
            }
        }
    }

    private static UUID getProposed(Conflict c, IChange activeChange, StringBuilder errors) {
        Change change = (Change)activeChange;
        if (change != null && !c.getVersionable().sameItemId((IItemHandle)change.getItem())) {
            throw new IllegalArgumentException("Change and conflict must be for the same item");
        }
        if (errors != null && c.isIncidental() && ChangeHistoryValidator.equal(c.getSelectedContributorStateId(), c.getMergeStateId()) && ChangeHistoryValidator.equal(c.getSelectedContributorStateId(), c.getProposedContributorStateId())) {
            errors.append("Cannot have incidental conflict on " + c.getVersionable().getItemType().getName() + " " + c.getVersionable().getItemId().getUuidValue() + " with all states " + (c.getSelectedContributorStateId() == null ? "null" : c.getSelectedContributorStateId().getUuidValue()) + "\n");
        }
        if (change == null) {
            if (errors != null && ChangeHistoryValidator.equal(c.getSelectedContributorStateId(), c.getMergeStateId())) {
                errors.append(String.valueOf(c.isIncidental() ? "Incidental" : "Real") + " conflict on " + c.getVersionable().getItemType().getName() + " " + c.getVersionable().getItemId().getUuidValue() + " cannot exist with no active change and selected == merge == " + (c.getSelectedContributorStateId() == null ? "null" : c.getSelectedContributorStateId().getUuidValue()) + "\n");
            }
            return c.getMergeStateId();
        }
        if (ChangeHistoryValidator.equal(change.getAfter(), c.getSelectedContributorStateId())) {
            if (errors != null && c.isIncidental()) {
                errors.append("Incidental conflict on " + c.getVersionable().getItemType().getName() + " " + c.getVersionable().getItemId().getUuidValue() + " cannot exist with selected == after state == " + (c.getSelectedContributorStateId() == null ? "null" : c.getSelectedContributorStateId().getUuidValue()) + "\n");
            }
            return c.getMergeStateId();
        }
        if (errors != null) {
            if (!ChangeHistoryValidator.equal(c.getSelectedContributorStateId(), c.getMergeStateId())) {
                errors.append("Active conflict on " + c.getVersionable().getItemType().getName() + " " + c.getVersionable().getItemId().getUuidValue() + " with after state " + (change.getAfter() == null ? "null" : change.getAfter().getUuidValue()) + " but merge " + (c.getMergeStateId() == null ? "null" : c.getMergeStateId().getUuidValue()) + " doesn't equal selected " + (c.getSelectedContributorStateId() == null ? "null" : c.getSelectedContributorStateId().getUuidValue()) + "\n");
            }
            if (!ChangeHistoryValidator.equal(change.getAfter(), c.getProposedContributorStateId())) {
                errors.append("Active conflict on " + c.getVersionable().getItemType().getName() + " " + c.getVersionable().getItemId().getUuidValue() + " with after state " + (change.getAfter() == null ? "null" : change.getAfter().getUuidValue()) + " but proposed is " + (c.getProposedContributorStateId() == null ? "null" : c.getProposedContributorStateId().getUuidValue()) + "\n");
            }
        }
        return change.getAfter();
    }

    private static void updateOverrides(Map<UUID, UUID> overrides, Map<UUID, IItemType> itemTypes, Collection<Conflict> conflicts, List<ChangeSet> changeSets, InTransactionItemProvider provider) throws TeamRepositoryException {
        for (Conflict c : conflicts) {
            overrides.put(c.getVersionable().getItemId(), c.getSelectedContributorStateId());
            itemTypes.put(c.getVersionable().getItemId(), c.getVersionable().getItemType());
        }
        ListIterator<ChangeSet> it = changeSets.listIterator(changeSets.size());
        while (it.hasPrevious()) {
            ChangeSet cs = it.previous();
            for (Change c : cs.getChanges()) {
                if (overrides.containsKey(c.getItem().getItemId())) continue;
                overrides.put(c.getItem().getItemId(), c.getAfter());
                itemTypes.put(c.getItem().getItemId(), c.getItem().getItemType());
            }
        }
    }

    private static Map<UUID, List<Conflict>> getConflictsInHistories(Map<UUID, ComponentEntry> modifiedComponents) throws TeamRepositoryException {
        HashMap<UUID, List<Conflict>> result = new HashMap<UUID, List<Conflict>>((int)((double)modifiedComponents.size() / 0.75));
        for (ComponentEntry e : modifiedComponents.values()) {
            if (e == null) continue;
            result.put(e.getChangehistory().getItemId(), e.getConflicts());
        }
        return result;
    }

    private static Map<UUID, List<Conflict>> getPreviousConflictsInHistories(Map<UUID, ComponentEntry> modifiedComponents, InTransactionItemProvider provider) throws TeamRepositoryException {
        ArrayList<ComponentEntryHandle> toFetch = new ArrayList<ComponentEntryHandle>(modifiedComponents.size());
        ScmFactory f = ScmFactory.eINSTANCE;
        for (UUID id : modifiedComponents.keySet()) {
            ComponentEntryHandle h = f.createComponentEntryHandle();
            h.setItemId(id);
            toFetch.add(h);
        }
        Map components = ChangeHistoryValidator.getBaseStates(toFetch, provider);
        toFetch = null;
        HashMap<UUID, List<Conflict>> result = new HashMap<UUID, List<Conflict>>((int)((double)modifiedComponents.size() / 0.75));
        for (ComponentEntry e : components.values()) {
            if (e == null || e.getConflicts().isEmpty()) continue;
            result.put(e.getChangehistory().getItemId(), e.getConflicts());
        }
        return result;
    }

    private static Map<UUID, Boolean> getChangeHistoriesToValidate(Map<UUID, ComponentEntry> modifiedComponents, StringBuilder errors, InTransactionItemProvider provider) throws TeamRepositoryException {
        LinkedHashMap<UUID, Boolean> id = new LinkedHashMap<UUID, Boolean>((int)((double)modifiedComponents.size() / 0.75));
        for (ComponentEntry e : modifiedComponents.values()) {
            if (e == null || id.put(e.getChangehistory().getItemId(), true) == null) continue;
            errors.append("The change history " + e.getChangehistory().getItemId() + " is referenced in multiple component entries\n");
        }
        Map modified = ChangeHistoryValidator.getModifiedMap(IBaseline.ITEM_TYPE, provider);
        for (Baseline b : modified.values()) {
            Boolean old;
            if (b == null || (old = id.put(b.getHistory().getItemId(), false)) == null || !old.booleanValue()) continue;
            errors.append("The change history " + b.getHistory().getItemId() + " is recent but referenced by a baseline\n");
        }
        return id;
    }

    private static Map<UUID, ChangeHistory> getCommittedChangeHistories(Map<UUID, ChangeHistory> modified, Map<UUID, ChangeSet> committedChangesets, Map<UUID, ComponentEntry> modifiedComponents, InTransactionItemProvider provider) throws TeamRepositoryException {
        ArrayList<Object> toFetch = new ArrayList<Object>(modifiedComponents.size());
        ScmFactory f = ScmFactory.eINSTANCE;
        for (UUID id : modifiedComponents.keySet()) {
            Iterator<UUID> ceh = f.createComponentEntryHandle();
            ceh.setItemId(id);
            toFetch.add(ceh);
        }
        Map entries = ChangeHistoryValidator.getBaseStates(toFetch, provider);
        toFetch = new ArrayList(modified.size());
        for (ComponentEntry e : entries.values()) {
            if (e == null || modified.containsKey(e.getChangehistory().getItemId())) continue;
            toFetch.add(e.getChangehistory());
        }
        entries = null;
        for (UUID id : modified.keySet()) {
            ChangeHistoryHandle h = f.createChangeHistoryHandle();
            h.setItemId(id);
            toFetch.add(h);
        }
        Map histories = ChangeHistoryValidator.getBaseStates(toFetch, provider);
        toFetch = null;
        HashMap<UUID, ChangeHistory> committed = new HashMap<UUID, ChangeHistory>((int)((double)modified.size() / 0.75));
        block3: for (Map.Entry e : histories.entrySet()) {
            UUID id = e.getKey();
            ChangeHistory after = modified.get(id);
            if (after == null && !modified.containsKey(id)) {
                for (ChangeHistoryEntry en : ((ChangeHistory)e.getValue()).getRecentEntries()) {
                    if (!committedChangesets.containsKey(en.getChangeSet().getItemId())) continue;
                    committed.put(id, (ChangeHistory)e.getValue());
                    continue block3;
                }
                continue;
            }
            if (ChangeHistoryValidator.isModified((ChangeHistory)e.getValue(), after)) {
                committed.put(id, after);
                continue;
            }
            if (after == null) continue;
            for (ChangeHistoryEntry en : after.getRecentEntries()) {
                if (!committedChangesets.containsKey(en.getChangeSet().getItemId())) continue;
                committed.put(id, after);
                continue block3;
            }
        }
        return committed;
    }

    private static boolean isModified(ChangeHistory before, ChangeHistory after) {
        if (before == null) {
            return after.getPrevious() != null || !after.getRecentEntries().isEmpty();
        }
        if (after == null) {
            return before.getPrevious() != null || !before.getRecentEntries().isEmpty();
        }
        if (before.getRecentEntries().size() != after.getRecentEntries().size()) {
            return true;
        }
        if (before.getPrevious() == null ? after.getPrevious() != null : !before.getPrevious().sameItemId((IItemHandle)after.getPrevious())) {
            return true;
        }
        if (before.getActiveCount() != after.getActiveCount()) {
            return true;
        }
        List beforeEntries = before.getRecentEntries();
        List afterEntries = after.getRecentEntries();
        int i = beforeEntries.size() - 1;
        while (i >= 0) {
            if (!((ChangeHistoryEntry)beforeEntries.get(i)).getChangeSet().sameItemId((IItemHandle)((ChangeHistoryEntry)afterEntries.get(i)).getChangeSet())) {
                return true;
            }
            --i;
        }
        return false;
    }

    private static void validateOnlyRecentChanged(Map<UUID, ChangeHistory> modifiedHistories, Map<UUID, ChangeHistory> committedHistories, Set<UUID> allowed, Map<UUID, ComponentEntry> modifiedComponents, StringBuilder errors, InTransactionItemProvider provider) throws TeamRepositoryException {
        HashSet<UUID> newRecent = new HashSet<UUID>((int)((double)modifiedComponents.size() / 0.75));
        for (ComponentEntry componentEntry : modifiedComponents.values()) {
            if (componentEntry == null) continue;
            newRecent.add(componentEntry.getChangehistory().getItemId());
        }
        for (Map.Entry entry : modifiedHistories.entrySet()) {
            UUID id = (UUID)entry.getKey();
            if (!allowed.contains(id) && committedHistories.containsKey(id)) {
                errors.append("The change history entries for change history " + id.getUuidValue() + " have been modified but it was not a recent\n");
            }
            ChangeHistory h = (ChangeHistory)entry.getValue();
            if (newRecent.contains(id)) {
                if (h != null && !h.getCachedAllPrevious().isEmpty()) continue;
                errors.append("The recent history " + id.getUuidValue() + " does not contain a cached all previous value\n");
                continue;
            }
            if (h == null || h.getCachedAllPrevious().isEmpty()) continue;
            errors.append("The history " + id.getUuidValue() + " contains a cached all previous value but is not recent\n");
        }
    }

    private static Set<UUID> computeAllowedChanges(Map<UUID, ChangeHistory> modifiedHistories, Map<UUID, ComponentEntry> modifiedComponents, InTransactionItemProvider provider) throws TeamRepositoryException {
        Set<UUID> allowed = ChangeHistoryValidator.getOldRecentHistories(modifiedComponents, provider);
        ArrayList<ChangeHistoryHandle> toFetch = new ArrayList<ChangeHistoryHandle>(modifiedHistories.size());
        ScmFactory f = ScmFactory.eINSTANCE;
        for (UUID id : modifiedHistories.keySet()) {
            ChangeHistoryHandle h = f.createChangeHistoryHandle();
            h.setItemId(id);
            toFetch.add(h);
        }
        Map histories = ChangeHistoryValidator.getBaseStates(toFetch, provider);
        toFetch = null;
        for (Map.Entry e : histories.entrySet()) {
            if (e.getValue() != null) continue;
            allowed.add(e.getKey());
        }
        return allowed;
    }

    private static Set<UUID> getOldRecentHistories(Map<UUID, ComponentEntry> modifiedComponents, InTransactionItemProvider provider) throws TeamRepositoryException {
        ArrayList<ComponentEntryHandle> toFetch = new ArrayList<ComponentEntryHandle>(modifiedComponents.size());
        ScmFactory f = ScmFactory.eINSTANCE;
        for (UUID id : modifiedComponents.keySet()) {
            ComponentEntryHandle h = f.createComponentEntryHandle();
            h.setItemId(id);
            toFetch.add(h);
        }
        Map components = ChangeHistoryValidator.getBaseStates(toFetch, provider);
        toFetch = null;
        HashSet<UUID> result = new HashSet<UUID>((int)((double)modifiedComponents.size() / 0.75));
        for (ComponentEntry e : components.values()) {
            if (e == null) continue;
            result.add(e.getChangehistory().getItemId());
        }
        return result;
    }

    private static Map<UUID, ChangeSet> getCommittedChangeSets(Map<UUID, ChangeSet> modified, StringBuilder errors, InTransactionItemProvider provider) throws TeamRepositoryException {
        ArrayList<ChangeSetHandle> toFetch = new ArrayList<ChangeSetHandle>();
        ScmFactory f = ScmFactory.eINSTANCE;
        for (Map.Entry<UUID, ChangeSet> e : modified.entrySet()) {
            ChangeSet c = e.getValue();
            if (c == null) {
                ChangeSetHandle csh = f.createChangeSetHandle();
                csh.setItemId(e.getKey());
                toFetch.add(csh);
                continue;
            }
            toFetch.add(c);
        }
        Map base = ChangeHistoryValidator.getBaseStates(toFetch, provider);
        toFetch = null;
        HashMap<UUID, ChangeSet> result = new HashMap<UUID, ChangeSet>((int)((double)base.size() / 0.75));
        for (Map.Entry e : base.entrySet()) {
            ChangeSet baseCS = (ChangeSet)e.getValue();
            ChangeSet modCS = modified.get(e.getKey());
            if (baseCS != null && !baseCS.isActive()) {
                if (modCS == null) {
                    errors.append("Deleted changeset " + baseCS.getItemId() + " which was not active\n");
                } else if (modCS.isActive()) {
                    errors.append("Reopened changeset " + baseCS.getItemId() + "\n");
                }
            }
            if (!ChangeHistoryValidator.isCommitted(baseCS, modCS)) continue;
            result.put(modCS.getItemId(), modCS);
            if (baseCS == null || baseCS.isActive()) continue;
            errors.append("Committed to changeset " + baseCS.getItemId() + " which was not active\n");
        }
        return result;
    }

    private static boolean isCommitted(ChangeSet baseCS, ChangeSet modCS) {
        if (baseCS == null) {
            return !modCS.getChanges().isEmpty();
        }
        if (modCS == null) {
            return !baseCS.getChanges().isEmpty();
        }
        HashMap<UUID, Change> changes = new HashMap<UUID, Change>((int)((double)baseCS.getChanges().size() / 0.75));
        for (Change c : baseCS.getChanges()) {
            changes.put(c.item().getItemId(), c);
        }
        for (Change c : modCS.getChanges()) {
            Change base = (Change)changes.remove(c.item().getItemId());
            if (base == null) {
                return true;
            }
            if (!ChangeHistoryValidator.sameState(base.afterState(), c.afterState())) {
                return true;
            }
            if (!ChangeHistoryValidator.sameState(base.beforeState(), c.beforeState())) {
                return true;
            }
            HashSet<UUID> merges = new HashSet<UUID>((int)((double)base.getMerges().size() / 0.75));
            for (MergeState ms : base.getMerges()) {
                merges.add(ms.getState());
            }
            for (MergeState ms : c.getMerges()) {
                if (merges.remove(ms.getState())) continue;
                return true;
            }
            if (merges.isEmpty()) continue;
            return true;
        }
        return !changes.isEmpty();
    }

    private static boolean sameState(IVersionableHandle state1, IVersionableHandle state2) {
        if (state1 == null) {
            return state2 == null;
        }
        return state1.sameStateId((IItemHandle)state2);
    }

    private static <T extends IManagedItem> Map<UUID, T> getBaseStates(Collection<? extends IManagedItemHandle> items, InTransactionItemProvider provider) throws TeamRepositoryException {
        HashMap<UUID, IManagedItem> result = new HashMap<UUID, IManagedItem>((int)((double)items.size() / 0.75));
        ArrayList<? extends IManagedItemHandle> toFetch = new ArrayList<IManagedItemHandle>(items);
        int increment = provider.maxItemsPerRequest();
        int i = 0;
        while (i < toFetch.size()) {
            int size = Math.min(toFetch.size() - i, increment);
            List subList = toFetch.subList(i, i + size);
            i += size;
            List<IManagedItem> part = provider.fetchBaseItemStates(subList);
            Iterator it = subList.iterator();
            for (IManagedItem item : part) {
                if (item == null) {
                    IManagedItemHandle h = (IManagedItemHandle)it.next();
                    result.put(h.getItemId(), null);
                    continue;
                }
                it.next();
                result.put(item.getItemId(), item);
            }
        }
        return result;
    }

    private static <T> Map<UUID, T> getModifiedMap(IItemType type, InTransactionItemProvider provider) throws TeamRepositoryException {
        ArrayList<IItemHandle> modified = new ArrayList<IItemHandle>(provider.getModifiedItemsForType(type));
        List<IManagedItem> modifiedItems = ChangeHistoryValidator.fetchItems(new ArrayList<IItemHandle>(modified), provider, NULL_MONITOR);
        HashMap<UUID, IManagedItem> result = new HashMap<UUID, IManagedItem>();
        Iterator it = modified.iterator();
        for (IManagedItem modifiedItem : modifiedItems) {
            if (modifiedItem == null) {
                IManagedItemHandle h = (IManagedItemHandle)it.next();
                result.put(h.getItemId(), null);
                continue;
            }
            it.next();
            result.put(modifiedItem.getItemId(), modifiedItem);
        }
        return result;
    }

    private static boolean equal(UUID id1, UUID id2) {
        return id1 == null ? id2 == null : id1.equals((Object)id2);
    }

    private static class GapCandidate {
        ChangeHistoryHandle history;
        ChangeSet cs;
        IItemHandle item;
        UUID state;
        boolean isBefore;

        public GapCandidate(ChangeHistoryHandle history, ChangeSet cs, IItemHandle item, UUID state, boolean isBefore) {
            this.history = history;
            this.cs = cs;
            this.item = item;
            this.state = state;
            this.isBefore = isBefore;
        }
    }
}

