/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.links;

import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.internal.links.LinksPackage;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IHelperType;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.Messages;
import com.ibm.team.scm.common.internal.rest.ScmRestService2PathHelper;
import com.ibm.team.scm.common.internal.util.ValidationUtils;
import com.ibm.team.scm.common.providers.ItemProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChangeSetLocationFactory {
    private static DateFormat getFormat() {
        return DateFormat.getDateTimeInstance(2, 3);
    }

    public static boolean useOslcScmUris() {
        String useOslcScmUris = System.getProperty("scm.common.useOslcScmUris");
        return Boolean.parseBoolean(useOslcScmUris);
    }

    public static URI createChangeSetWebURL(IChangeSetHandle changeSetHandle, IWorkspaceHandle optionalWorkspace, String repoURI, String queryFragment) throws TeamRepositoryException {
        if (!ChangeSetLocationFactory.useOslcScmUris()) {
            return ChangeSetLocationFactory.createItemLocationURI(changeSetHandle, optionalWorkspace, false, repoURI);
        }
        ScmRestService2PathHelper pathHelper = new ScmRestService2PathHelper();
        StringBuffer buf = new StringBuffer(repoURI);
        if (!repoURI.endsWith("/")) {
            buf.append("/");
        }
        buf.append("oslc-scm").append("/");
        buf.append(pathHelper.computeUriPath(new IItemHandle[]{optionalWorkspace, changeSetHandle}));
        String uriString = buf.toString();
        String query = queryFragment == null ? null : queryFragment;
        try {
            URI result = new URI(null, null, uriString, query, null);
            return result;
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(String.format("Unexpected error constructing absolute URI: %s", e.getMessage()));
        }
    }

    public static IReference createChangeSetURIReference(ItemProvider provider, IChangeSetHandle changeSetHandle, IWorkspaceHandle optionalWorkspace, boolean deliverSet, IProgressMonitor monitor) throws TeamRepositoryException {
        String repositoryURI = provider.getRepositoryURI();
        URI uri = ChangeSetLocationFactory.createItemLocationURI(changeSetHandle, optionalWorkspace, deliverSet, repositoryURI);
        IChangeSet changeSet = (IChangeSet)provider.fetchItem((IManagedItemHandle)changeSetHandle, monitor);
        String comment = ChangeSetLocationFactory.getInterimComment(provider, changeSet, monitor);
        return IReferenceFactory.INSTANCE.createReferenceFromURI(uri, comment);
    }

    private static URI createItemLocationURI(IChangeSetHandle changeSetHandle, IWorkspaceHandle optionalWorkspace, boolean deliverSet, String repositoryURI) {
        String query;
        String string = query = optionalWorkspace == null ? "" : ChangeSetLocationFactory.getChangeSetURIContext(optionalWorkspace);
        if (deliverSet) {
            String queryFragment = "com.ibm.team.scm.eventCategory.delivery=true";
            query = query != null ? String.valueOf(query) + "&" + queryFragment : queryFragment;
        }
        Location location = Location.itemLocation((IItemHandle)changeSetHandle, (String)repositoryURI, (String)query, null);
        URI uri = location.toAbsoluteUri();
        return uri;
    }

    public static IReference createChangeSetItemReference(ItemProvider provider, IChangeSetHandle changeSetHandle, IWorkspaceHandle optionalWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
        IChangeSet changeSet = (IChangeSet)provider.fetchItem((IManagedItemHandle)changeSetHandle, monitor);
        String extraInfo = null;
        if (optionalWorkspace != null) {
            extraInfo = ChangeSetLocationFactory.getChangeSetURIContext(optionalWorkspace);
        }
        String comment = ChangeSetLocationFactory.getInterimComment(provider, changeSet, monitor);
        IHelperType ITEM_TYPE = IHelperType.IRegistry.INSTANCE.getHelperType(LinksPackage.eINSTANCE.getReference().getName(), "com.ibm.team.links");
        String COMMENT_PROPERTY = LinksPackage.eINSTANCE.getReference_Comment().getName();
        comment = ValidationUtils.truncate((IType)ITEM_TYPE, COMMENT_PROPERTY, comment);
        return IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)changeSet, comment, extraInfo);
    }

    public static String getChangeSetURIContext(IWorkspaceHandle optionalWorkspace) {
        return String.valueOf(IWorkspace.ITEM_TYPE.getName()) + "=" + optionalWorkspace.getItemId().getUuidValue();
    }

    public static IReference createAnonymousChangeSetURI(String repoURL, IChangeSetHandle changeSetHandle) {
        Location location = Location.itemLocation((IItemHandle)changeSetHandle, (String)repoURL, null, null);
        return IReferenceFactory.INSTANCE.createReferenceFromURI(location.toRelativeUri(), "");
    }

    private static String getInterimComment(ItemProvider provider, IChangeSet cs, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributor contributor = (IContributor)provider.fetchItem((IManagedItemHandle)cs.getAuthor(), monitor);
        IComponent component = (IComponent)provider.fetchItem((IManagedItemHandle)cs.getComponent(), monitor);
        return ChangeSetLocationFactory.getDescription(cs, component, contributor);
    }

    public static String getDescription(IChangeSet cs, IComponent component, IContributor contributor) {
        String componentName = Messages.getString("ChangeSetLocationFactory.UNKNOWN_COMPONENT_LABEL");
        String whoName = Messages.getString("ChangeSetLocationFactory.UNKNOWN_COMPONENT_LABEL");
        if (contributor != null) {
            whoName = contributor.getName();
        }
        if (component != null) {
            componentName = component.getName();
        }
        Date when = cs.getLastChangeDate();
        StringBuilder builder = new StringBuilder();
        String comment = ChangeSetLocationFactory.getFullContextLabel(cs, " ");
        builder.append(NLS.bind((String)Messages.getString("ChangeSetLocationFactory.DEFAULT_CHANGESET_LABEL"), (Object)componentName, (Object[])new Object[]{comment, whoName, ChangeSetLocationFactory.getFormat().format(when)}));
        return builder.toString();
    }

    public static String getFullContextLabel(IChangeSet changeSet) {
        if (changeSet == null || changeSet.getComment().length() == 0) {
            return Messages.getString("ChangeSetLocationFactory.NO_COMMENT_LABEL").trim();
        }
        return changeSet.getComment().trim();
    }

    public static String getFullContextLabel(IChangeSet changeSet, String lineEnding) {
        String comment = ChangeSetLocationFactory.getFullContextLabel(changeSet);
        if (lineEnding != null) {
            return ChangeSetLocationFactory.replaceLineEnding(comment, lineEnding);
        }
        return comment;
    }

    public static String replaceLineEnding(String original, String lineEnding) {
        return original.replace("\r\n", lineEnding).replace("\r", lineEnding).replace("\n", lineEnding);
    }
}

