/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet_group;

import com.urbancode.air.property.persistence.AbstractPropertyFactory;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet.PropSheetFactoryRegistry;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefFactoryRegistry;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroup;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroupFactory;
import com.urbancode.air.vc.Handle;
import com.urbancode.air.vc.Persistent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropSheetGroupFactoryImpl
extends AbstractPropertyFactory<PropSheetGroup>
implements PropSheetGroupFactory {
    @Override
    public PropSheetGroup createPropSheetGroup() {
        PropSheetGroup result = new PropSheetGroup();
        this.getDBSession().save((Object)result);
        return result;
    }

    @Override
    public PropSheetGroup createVersionedPropSheetGroup(String path) {
        PropSheetGroup result = new PropSheetGroup();
        path = path.replace("{id}", result.getId().toString());
        result.getPersistenceData().setPath(path);
        this.getVCSession().saveOrUpdate((Persistent)result);
        return result;
    }

    @Override
    public PropSheetGroup getPropSheetGroupForId(UUID id) {
        return (PropSheetGroup)((Object)this.getEntityForId(PropSheetGroup.class, id, "PropSheetGroup"));
    }

    @Override
    public PropSheetGroup getPropSheetGroupForHandle(Handle handle) {
        return (PropSheetGroup)((Object)this.restore(handle));
    }

    @Override
    public List<PropSheetGroup> getPropSheetGroupsForPaths(List<String> paths, boolean skipVersionCount) {
        PropSheetGroup psg;
        List<PropSheetGroup> groups = this.restoreLatestWithPaths(paths, skipVersionCount);
        ArrayList<String> psPaths = new ArrayList<String>();
        HashMap<String, PropSheetGroup> psPathToPSG = new HashMap<String, PropSheetGroup>();
        ArrayList<String> psdPaths = new ArrayList<String>();
        HashMap<String, PropSheetGroup> psdPathToPSG = new HashMap<String, PropSheetGroup>();
        for (PropSheetGroup psg2 : groups) {
            String path;
            for (Handle hand : psg2.propSheetDefHandles) {
                path = hand.getPath();
                psdPaths.add(path);
                psdPathToPSG.put(path, psg2);
            }
            for (Handle hand : psg2.propSheetHandles) {
                path = hand.getPath();
                psPaths.add(path);
                psPathToPSG.put(path, psg2);
            }
        }
        List<PropSheetDef> psds = PropSheetDefFactoryRegistry.getFactory().getPropSheetDefsForPaths(psdPaths, skipVersionCount);
        List<PropSheet> propSheets = PropSheetFactoryRegistry.getFactory().getPropSheetsForPaths(psPaths, skipVersionCount);
        HashMap<PropSheetGroup, HashSet<PropSheetDef>> psgToPsd = new HashMap<PropSheetGroup, HashSet<PropSheetDef>>();
        HashMap<PropSheetGroup, HashSet<PropSheet>> psgToPs = new HashMap<PropSheetGroup, HashSet<PropSheet>>();
        for (PropSheetDef psd : psds) {
            psg = (PropSheetGroup)((Object)psdPathToPSG.get(psd.getPersistenceData().getPath()));
            HashSet<PropSheetDef> psdList = (HashSet<PropSheetDef>)psgToPsd.get((Object)psg);
            if (psdList == null) {
                psdList = new HashSet<PropSheetDef>();
                psgToPsd.put(psg, psdList);
            }
            psdList.add(psd);
        }
        for (PropSheet ps : propSheets) {
            psg = (PropSheetGroup)((Object)psPathToPSG.get(ps.getPersistenceData().getPath()));
            HashSet<PropSheet> psList = (HashSet<PropSheet>)psgToPs.get((Object)psg);
            if (psList == null) {
                psList = new HashSet<PropSheet>();
                psgToPs.put(psg, psList);
            }
            psList.add(ps);
        }
        for (PropSheetGroup psg3 : psgToPsd.keySet()) {
            psg3.cachedPropSheetDefs = (Set)psgToPsd.get((Object)psg3);
        }
        for (PropSheetGroup psg3 : psgToPs.keySet()) {
            psg3.cachedPropSheets = (Set)psgToPs.get((Object)psg3);
        }
        return groups;
    }

    @Override
    public void deletePropSheetGroup(PropSheetGroup propSheetGroup) {
        if (propSheetGroup.isVersioned()) {
            propSheetGroup.getPersistenceData().setDeleted(true);
        } else {
            this.getDBSession().delete((Object)propSheetGroup);
        }
    }
}

