/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command;

import com.urbancode.air.plugin.ant.org.apache.commons.io.FilenameUtils;
import com.urbancode.air.plugin.ant.org.apache.commons.lang.StringUtils;
import com.urbancode.air.plugin.ant.org.apache.commons.lang.builder.EqualsBuilder;
import com.urbancode.air.plugin_command.Arg;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine {
    private String program;
    private List<Arg> args;

    public CommandLine(String program, List<Arg> args) {
        this.program = FilenameUtils.separatorsToSystem(program);
        this.args = args;
    }

    public String[] getExecuteCommand() {
        ArrayList<String> argList = new ArrayList<String>(this.args.size() + 1);
        argList.add(0, this.program);
        int index = 1;
        for (Arg a : this.args) {
            String str = a.getValue().trim();
            if (str.equals("null") || str.equals("")) continue;
            argList.add(index, str);
            ++index;
        }
        return argList.toArray(new String[0]);
    }

    public String getProgram() {
        return this.program;
    }

    public List<Arg> getArgs() {
        return this.args;
    }

    public String toString() {
        return this.program + " " + StringUtils.join(this.args, " ");
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals(this, o);
    }
}

